/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.awt.Container;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import utils.Funzioni;
import utils.MyTrace;

public class EffettoFade {
    Window caller_window;
    private final int showMax = 800;
    private final int hideMax = 600;
    private final int showRate = 43;
    private final int hideRate = 43;
    private final Timer show;
    private final Timer hide;
    private long stato = 0L;
    boolean trasparenza;

    public EffettoFade(JInternalFrame jiframe) {
        this((Window)SwingUtilities.getAncestorOfClass(Container.class, jiframe));
        System.out.println("Istanziato 'Effetto Fade' su JFrame  (Sperimentale)");
    }

    public EffettoFade(Window window) {
        System.out.println("Istanziato <Effetto Fade>");
        this.caller_window = window;
        try {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            this.trasparenza = gs.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT);
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE:  eccezione di istanziazione della configurazione (PROBABILE PROBLEMA CON LA VERSIONE DI JAVA)");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE: errore di avvio o di linkaggio(PROBABILE PROBLEMA CON LA VERSIONE DI JAVA)");
            err.printStackTrace();
        }
        if (this.trasparenza) {
            this.caller_window.setOpacity(0.0f);
        } else {
            MyTrace.log.severe("ATT!  EFFETTO FADE NON ABILITATO");
        }
        this.show = new Timer(43, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EffettoFade.this.stato++;
                if (EffettoFade.this.trasparenza && EffettoFade.this.stato * 43L < 800L) {
                    float gamma = (float)EffettoFade.this.stato * 43.0f / 800.0f;
                    gamma = (double)gamma > 0.9 ? 1.0f : gamma;
                    EffettoFade.this.caller_window.setOpacity(gamma);
                }
            }
        });
        this.hide = new Timer(43, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EffettoFade.this.stato++;
                if (EffettoFade.this.stato * 43L > 600L) {
                    EffettoFade.this.fermaTutto();
                } else if (EffettoFade.this.trasparenza) {
                    float gamma = (600.0f - (float)(EffettoFade.this.stato * 43L)) / 600.0f;
                    EffettoFade.this.caller_window.setOpacity(gamma);
                }
            }
        });
    }

    private void visualizza() {
        System.out.println("visualizzo la finestra");
        if (this.trasparenza) {
            this.caller_window.setOpacity(0.0f);
        }
    }

    private void fermaTutto() {
        System.out.println("nascondo Finestra (fermo tutto)");
        this.show.stop();
        this.hide.stop();
        this.stato = 0L;
        this.caller_window.dispose();
    }

    public void start() {
        System.out.println("Effetto Fade => START");
        if (!this.show.isRunning()) {
            this.visualizza();
            this.show.start();
        }
    }

    public void stop() {
        if (this.show.isRunning()) {
            this.show.stop();
        }
        if (!this.hide.isRunning()) {
            this.stato = 0L;
            this.hide.start();
        }
    }
}

