/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import utils.DateField;
import utils.Funzioni;
import utils.MyTrace;
import utils.TimeFormatter;

public class DataCellRenderer
extends DefaultTableCellRenderer {
    DateField dateField;

    private void tfFocusLost(FocusEvent evt) {
        this.dateField.setText(this.getText());
        this.dateField.setForeground(new Color(0, 0, 0));
        this.dateField.setBackground(new Color(150, 100, 200));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String testo = "";
        try {
            testo = value.toString();
        }
        catch (Exception err) {
            MyTrace.log.severe("ECCEZIONE in getTableCellRendererComponent() valore non presente");
            err.printStackTrace();
            Funzioni.inviaBugPerEmail(err);
            Funzioni.LogStackTrace(err);
        }
        TimeFormatter mf = new TimeFormatter();
        this.dateField = new DateField(mf);
        this.dateField.setOpaque(true);
        this.dateField.setPreferredSize(new Dimension(100, 25));
        this.dateField.setForeground(new Color(100, 100, 100));
        this.dateField.setText(testo);
        this.dateField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                DataCellRenderer.this.tfFocusLost(evt);
            }
        });
        return this.dateField;
    }
}

