/*
 * Decompiled with CFR 0.152.
 */
package utils;

import gestionale.configurazioni.Configurazioni;
import gestionale.configurazioni.Eccezioni;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import utils.BannerAttesa;
import utils.Funzioni;
import utils.MyTrace;

public class Connessione
implements Runnable {
    public String nomeDB;
    public String nomeUtente;
    private String pwdUtente;
    private String errore = "";
    public Connection connssl;
    private boolean connesso;
    private HashMap campi;
    public String server;
    private String porta;
    private Eccezioni eccezione;
    private DatabaseMetaData databaseMetaData;
    public String databaseProductVersion = null;
    private long attesa_per_ciclo_su_thread = 15000L;
    private boolean in_esecuzione;
    Thread keepalive;
    private BannerAttesa ba;
    private Timer mostra_banner;
    public static long contatore = 0L;
    private long ciclo_test = 0L;

    public Connessione(String server, String nomeDB) {
        this(server, nomeDB, "", "", "3306");
    }

    public Connessione(String server, String nomeDB, String nomeUtente, String pwdUtente, String porta) {
        MyTrace.log.config("-----ISTANZIATA CONNESSIONE AL DATABASE------");
        MyTrace.log.config("CHIAMANTE: " + Funzioni.getCaller());
        this.eccezione = new Eccezioni();
        this.nomeDB = nomeDB;
        this.nomeUtente = nomeUtente;
        this.pwdUtente = pwdUtente;
        this.server = server;
        this.porta = porta;
        this.connesso = false;
        this.in_esecuzione = false;
        this.errore = "";
        this.ba = new BannerAttesa();
        this.mostra_banner = new Timer((int)BannerAttesa.tempo_franchigia, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Connessione.this.ba.start();
            }
        });
        this.mostra_banner.setRepeats(false);
    }

    public boolean connetti() {
        this.connesso = false;
        MyTrace.log.config("CHIAMANTE: " + Funzioni.getCaller());
        try {
            MyTrace.log.config("Carico il driver JDBC per la connessione con il database MySQL");
            Class.forName("com.mysql.jdbc.Driver");
            MyTrace.log.config("Controllo che il nome del Database non sia nullo");
            if (this.nomeDB.equals("")) {
                this.eccezione.gestisci("2.0", null);
            } else {
                String connessione = "jdbc:mysql://" + this.server + ":" + this.porta + "/" + this.nomeDB;
                if (!this.nomeUtente.equals("")) {
                    connessione = connessione + "?user=" + this.nomeUtente;
                }
                if (!this.pwdUtente.equals("")) {
                    connessione = connessione + "&password=" + this.pwdUtente;
                }
                connessione = connessione + "&zeroDateTimeBehavior=convertToNull";
                connessione = connessione + "&allowMultiQueries=true";
                connessione = connessione + "&autoReConnect=true";
                MyTrace.log.config("Server=" + this.server);
                MyTrace.log.config("Porta=" + this.porta);
                MyTrace.log.config("nomeDb=" + this.nomeDB);
                try {
                    this.connssl = DriverManager.getConnection(connessione);
                    MyTrace.log.config("La connessione \u00e8 stata preparata!!");
                    this.databaseMetaData = this.connssl.getMetaData();
                    MyTrace.log.config("La connessione \u00e8 avvenuta con successo!!");
                    this.connesso = true;
                    this.avvia_keepalive();
                    this.databaseProductVersion = "DATABASE=" + this.databaseMetaData.getDatabaseProductName() + "              Version=" + this.databaseMetaData.getDatabaseProductVersion() + "               DRIVER=" + this.databaseMetaData.getDriverVersion() + "                 JDBC=" + this.databaseMetaData.getJDBCMajorVersion() + "." + this.databaseMetaData.getJDBCMinorVersion();
                    MyTrace.log.config(this.databaseProductVersion);
                }
                catch (SQLException e1) {
                    System.out.println("SQLException: " + e1.getMessage());
                    System.out.println("SQLState: " + e1.getSQLState());
                    System.out.println("VendorError: " + e1.getErrorCode());
                    MyTrace.log.severe("ERRORE NELLA CONNESSIONE " + e1.toString());
                    e1.printStackTrace();
                    Funzioni.LogStackTrace(e1);
                }
            }
        }
        catch (ClassNotFoundException e2) {
            MyTrace.log.severe("DB: NON TROVATO DRIVER JDBC MySQL CONN=" + e2.toString());
            e2.printStackTrace();
            Funzioni.LogStackTrace(e2);
        }
        catch (Exception e3) {
            MyTrace.log.severe("DB: CONN=" + e3.toString());
            e3.printStackTrace();
            Funzioni.LogStackTrace(e3);
        }
        MyTrace.log.config("CONNESSIOINE::=" + this.connesso);
        return this.connesso;
    }

    public ResultSet eseguiQuery(String query) {
        this.startBannerRitardado();
        boolean traccia = !query.contains("NOW()") && !query.contains("sys_sessioni_utente") && !query.contains("ripulisci_sessioni_utente_vecchie");
        Object v = null;
        boolean colonne = false;
        if (traccia) {
            MyTrace.log.info("DB: ESEGUI QUERY::: " + query);
        }
        if (traccia) {
            MyTrace.log.fine("DB: la query sopra \u00e8 stata richiesta da:: " + Funzioni.getCaller());
        }
        ResultSet rs = null;
        if (this.connesso) {
            try {
                Statement stmt = this.connssl.createStatement();
                rs = stmt.executeQuery(query);
            }
            catch (SQLException e) {
                MyTrace.log.severe("DB: ERRORE QUERY ERRATA!");
                MyTrace.log.severe("DB: EXQ1=" + e.toString());
                e.printStackTrace();
                Funzioni.inviaBugPerEmail(e);
                Funzioni.LogStackTrace(e);
            }
            catch (Exception e) {
                MyTrace.log.severe("DB: ERRORE EXQ2=" + e.toString());
                e.printStackTrace();
                Funzioni.inviaBugPerEmail(e);
                Funzioni.LogStackTrace(e);
            }
        } else {
            MyTrace.log.severe("DB: NON SONO CONNESSO E QUINDI NON POSSO ESEGUIRE LA QUERY DB=" + this.nomeDB);
        }
        this.stopBanner();
        return rs;
    }

    public boolean eseguiAggiornamento(String query) {
        boolean traccia = !query.contains("NOW()") && !query.contains("sys_sessioni_utente") && !query.contains("ripulisci_sessioni_utente_vecchie");
        this.startBannerRitardado();
        int numero = 0;
        boolean risultato = false;
        if (traccia) {
            MyTrace.log.info("DB: QUERY DI AGGIORNAMENTO::: " + query);
        }
        if (traccia) {
            MyTrace.log.fine("DB: la query sopra \u00e8 stata richiesta da:: " + Funzioni.getCaller());
        }
        if (Configurazioni.modalit\u00e0ConsultazioneAttiva) {
            return false;
        }
        if (this.connesso) {
            try {
                Statement stmt = this.connssl.createStatement();
                numero = stmt.executeUpdate(query);
                risultato = true;
                stmt.close();
            }
            catch (Exception e) {
                MyTrace.log.severe("DB: EXQ3=" + e.toString());
                e.printStackTrace();
                Funzioni.inviaBugPerEmail(e);
                Funzioni.LogStackTrace(e);
                risultato = false;
            }
        } else {
            MyTrace.log.severe("DB: NON SONO CONNESSO E QUINDI NON POSSO ESEGUIRE LA QUERY");
        }
        this.stopBanner();
        return risultato;
    }

    public boolean rollback() {
        String q_commit = "ROLLBACK";
        return this.eseguiAggiornamento(q_commit);
    }

    public boolean commit() {
        String q_commit = "COMMIT";
        return this.eseguiAggiornamento(q_commit);
    }

    public boolean start_transaction() {
        String q_start = "START TRANSACTION;";
        return this.eseguiAggiornamento(q_start);
    }

    public int id_inserito(String tabella) {
        String strSQL = "SELECT @@identity FROM " + tabella;
        ResultSet res = this.eseguiQuery(strSQL);
        int id_inserito = 0;
        try {
            while (res.next()) {
                id_inserito = res.getInt("@@identity");
            }
        }
        catch (Exception e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
        }
        this.ChiudiResultSet(res);
        return id_inserito;
    }

    public void disconnetti() {
        if (this.isConnesso()) {
            MyTrace.log.config("-----DB: DISCONNESSIONE DAL DATABASE ------");
            this.in_esecuzione = false;
            try {
                this.connesso = false;
                this.connssl.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                Funzioni.inviaBugPerEmail(e);
                Funzioni.LogStackTrace(e);
            }
        } else {
            MyTrace.log.severe("RICHIESTA DISCONNESSIONE SENZA DATABASE CONESSO :" + this.nomeDB);
            Funzioni.getCaller();
        }
    }

    public void ChiudiResultSet(ResultSet rs) {
        Statement stmt = null;
        if (rs != null) {
            try {
                stmt = rs.getStatement();
            }
            catch (SQLException e) {
                MyTrace.log.severe("DB: ECCEZIONE SQL ChiudiResultSet senza statment=" + e.toString());
                e.printStackTrace();
            }
            catch (Exception e) {
                MyTrace.log.severe("DB: ECCEZIONE ChiudiResultSet con statment nullo !!!??!! =" + e.toString());
                e.printStackTrace();
            }
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                MyTrace.log.severe("DB: ECCEZIONE SQL ChiudiResultSet a=" + e.toString());
                e.printStackTrace();
                rs = null;
            }
            catch (Exception e) {
                MyTrace.log.severe("DB: ECCEZIONE Generica a=" + e.toString());
                e.printStackTrace();
                rs = null;
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                MyTrace.log.severe("DB: ECCEZIONE SQL ChiudiResultSet b=" + e.toString());
                e.printStackTrace();
                stmt = null;
            }
            catch (Exception e) {
                MyTrace.log.severe("DB: ECCEZIONE generica  b=" + e.toString());
                e.printStackTrace();
                stmt = null;
            }
        }
    }

    public boolean is_mysqldump_Installed() {
        Process run = null;
        try {
            run = Runtime.getRuntime().exec("accessori/mysqldump --help");
        }
        catch (IOException ex) {
            MyTrace.log.info("DB: ECCEZIONE is installed");
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
            return false;
        }
        try {
            InputStream in = run.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            StringBuffer temp = new StringBuffer();
            String out = br.readLine();
            int n = out.indexOf("mysqldump");
            br.close();
            in.close();
            if (n > -1 && n < 2) {
                return true;
            }
        }
        catch (IOException ex) {
            MyTrace.log.info("DB: ECCEZIONE is installed");
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
        return false;
    }

    public DatabaseMetaData getDatabaseMetaData() {
        return this.databaseMetaData;
    }

    private String retrive_data_from_mysqldump_sullOutputStream(OutputStream stream) throws Exception {
        String buffer;
        Process run = Runtime.getRuntime().exec("accessori\\mysqldump --host=" + this.server + " --port=" + this.porta + " --user=" + this.nomeUtente + " --password=" + this.pwdUtente + " --opt --complete-insert --extended-insert " + " --add-drop-database --add-drop-table --create-options --databases " + this.nomeDB);
        InputStream in = run.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        StringBuffer temp = new StringBuffer();
        DataOutputStream output = new DataOutputStream(stream);
        while ((buffer = br.readLine()) != null) {
            if (stream != null) {
                output.writeBytes(buffer + "\n");
                continue;
            }
            temp.append(buffer + "\n");
        }
        br.close();
        in.close();
        return temp.toString();
    }

    private String getRoutine() throws Exception {
        String buffer;
        Process run = Runtime.getRuntime().exec("accessori\\mysqldump --host=" + this.server + " --port=" + this.porta + " --user=" + this.nomeUtente + " --password=" + this.pwdUtente + " --complete-insert --extended-insert " + "--add-drop-database --add-drop-table --create-options --databases " + this.nomeDB);
        InputStream in = run.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        StringBuffer temp = new StringBuffer();
        while ((buffer = br.readLine()) != null) {
            temp.append(buffer + "\n");
        }
        br.close();
        in.close();
        return temp.toString();
    }

    public String routine_to_string() throws Exception {
        return this.getRoutine();
    }

    public boolean scrive_il_dump_sul_file(File filedst) {
        try {
            FileOutputStream dest = new FileOutputStream(filedst);
            this.retrive_data_from_mysqldump_sullOutputStream(dest);
            dest.flush();
            dest.close();
        }
        catch (Exception ex) {
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
            return false;
        }
        return true;
    }

    public boolean routine_to_file(String nomefile) {
        File filedst = new File(nomefile);
        try {
            FileOutputStream dest = new FileOutputStream(filedst);
            dest.write(this.routine_to_string().getBytes());
            dest.flush();
            dest.close();
        }
        catch (Exception ex) {
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
            return false;
        }
        return true;
    }

    public boolean all_to_zip(String nomefile) {
        try {
            File filedst = new File(nomefile);
            FileOutputStream dest = new FileOutputStream(filedst);
            ZipOutputStream zip = new ZipOutputStream(new BufferedOutputStream(dest));
            zip.setMethod(8);
            zip.setLevel(9);
            zip.putNextEntry(new ZipEntry("data.sql"));
            this.retrive_data_from_mysqldump_sullOutputStream(zip);
            zip.putNextEntry(new ZipEntry("routine.sql"));
            zip.write(this.routine_to_string().getBytes());
            zip.close();
            dest.close();
        }
        catch (Exception ex) {
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
            return false;
        }
        return true;
    }

    public boolean isConnesso() {
        return this.connesso;
    }

    public String getErrore() {
        return this.errore;
    }

    private synchronized void startBannerRitardado() {
        this.mostra_banner.start();
        MyTrace.log.finest("MOSTRA BANNER ATTESA START =" + ++contatore);
    }

    private synchronized void stopBanner() {
        this.mostra_banner.stop();
        this.ba.stop();
        MyTrace.log.finest("MOSTRA BANNER ATTESA STOP =" + ++contatore);
    }

    private void avvia_keepalive() {
        if (this.keepalive == null) {
            this.keepalive = new Thread(this);
            this.keepalive.setName("<<THREAD::AVVIO::KEEPALIVE::" + this.nomeDB + ">>");
            MyTrace.log.info("DB: avviato il KEEPALIVE");
            this.keepalive.start();
        }
    }

    @Override
    public void run() {
        this.in_esecuzione = true;
        Thread.currentThread().setName("<<THREAD::KEEPALIVE:" + this.nomeDB + ":>>");
        while (this.in_esecuzione) {
            try {
                if (!this.connesso) {
                    this.tento_la_riconnessione();
                } else if (!this.test_connection()) {
                    MyTrace.log.severe("DB: si \u00e8 verificata la perdita della connessione al DataBase");
                    this.tento_la_riconnessione();
                    JOptionPane.showMessageDialog(null, "ATTENZIONE: PERDITA DELLA CONNESSIONE con il SERVER del DATABASE \n OK per ritentare la connessione!", "AVVISO DI SISTEMA", 2);
                }
                Thread.sleep(this.attesa_per_ciclo_su_thread);
            }
            catch (Exception e) {
                MyTrace.log.severe("DB: Eccezione su di un trhead del MyConnection");
                e.printStackTrace();
                Funzioni.inviaBugPerEmail(e);
                Funzioni.LogStackTrace(e);
                MyTrace.log.info("DB: >" + e.getMessage());
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ex) {
                    Funzioni.inviaBugPerEmail(ex);
                    Funzioni.LogStackTrace(ex);
                }
            }
        }
    }

    private synchronized boolean test_connection() {
        boolean traccia;
        boolean test = false;
        ++this.ciclo_test;
        boolean bl = traccia = this.ciclo_test % 20L == 0L;
        if (traccia) {
            MyTrace.log.finest("DB: Eseguo Test DB");
        }
        if (this.connesso) {
            ResultSet rs = this.eseguiQuery("SELECT  NOW()");
            if (traccia) {
                MyTrace.log.finest("DB: Test DB effettuato");
            }
            if (rs != null) {
                test = true;
            } else {
                MyTrace.log.severe("DB: Test DB FALLITO");
            }
            this.ChiudiResultSet(rs);
        }
        if (traccia) {
            MyTrace.log.finest("DB:        Test DB=" + test);
        }
        return test;
    }

    private synchronized boolean tento_la_riconnessione() {
        MyTrace.log.severe("DB: Tentativo di riconnessione al DATABASE");
        return this.connetti();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.in_esecuzione = false;
            this.disconnetti();
            this.ba.stop();
            this.ba = null;
            MyTrace.log.config("DB: FINALIZZAZIONE PER USCITA (\u00e8 stata distrutta dal GC la classe Connessione!");
        }
        finally {
            super.finalize();
        }
    }
}

