/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.Timer;
import utils.BannerWorking;
import utils.Funzioni;
import utils.MyTrace;

public class AvvioSuThread
implements Runnable {
    private Object oggetto;
    private Class classe;
    private Method metodo;
    private Object[] parametri = null;
    private Timer timer;
    private BannerWorking attesa;
    boolean con_parametri = false;
    int numero_parametri = 0;

    public AvvioSuThread(Object oggetto_istanziato, String metodo) {
        this(oggetto_istanziato, metodo, null);
    }

    public AvvioSuThread(Object oggetto_istanziato, String metodo, Object[] serie_di_parametri) {
        this.classe = oggetto_istanziato.getClass();
        this.oggetto = oggetto_istanziato;
        Class[] tipi_parametri = null;
        String nome_metodo_ottenuto = "metodo non ottenuto o non trovato";
        if (serie_di_parametri != null) {
            this.parametri = serie_di_parametri;
            this.con_parametri = true;
        }
        if (this.con_parametri) {
            this.numero_parametri = serie_di_parametri.length;
            if (this.numero_parametri == 1) {
                tipi_parametri = new Class[]{serie_di_parametri[0].getClass()};
            }
            if (this.numero_parametri == 2) {
                tipi_parametri = new Class[]{serie_di_parametri[0].getClass(), serie_di_parametri[1].getClass()};
            }
            if (this.numero_parametri == 3) {
                tipi_parametri = new Class[]{serie_di_parametri[0].getClass(), serie_di_parametri[1].getClass(), serie_di_parametri[2].getClass()};
            }
            if (this.numero_parametri == 4) {
                tipi_parametri = new Class[]{serie_di_parametri[0].getClass(), serie_di_parametri[1].getClass(), serie_di_parametri[2].getClass(), serie_di_parametri[3].getClass()};
            }
            if (this.numero_parametri == 5) {
                tipi_parametri = new Class[]{serie_di_parametri[0].getClass(), serie_di_parametri[1].getClass(), serie_di_parametri[2].getClass(), serie_di_parametri[3].getClass(), serie_di_parametri[4].getClass()};
            }
        }
        try {
            this.metodo = this.con_parametri ? this.classe.getMethod(metodo, tipi_parametri) : this.classe.getMethod(metodo, new Class[0]);
            nome_metodo_ottenuto = this.metodo.toString();
        }
        catch (NoSuchMethodException e) {
            MyTrace.log.severe("ERRORE:  eccezione getMethod() molto probabile che il metodo " + metodo + " non esista o non sia stato reso pubblico o abbia differenti parametri! n=" + this.numero_parametri);
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            MyTrace.log.severe("tipi_parametri=" + tipi_parametri.toString());
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE:  eccezione AvvioSuThread errore di istanziazione ");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE: AvvioSuThread errore di avvio o di linkaggio dello specifico modulo");
            err.printStackTrace();
        }
        this.attesa = new BannerWorking(">> INVOCATO SU THREAD IL METODO :" + this.toString() + "." + nome_metodo_ottenuto + ":  con parametri=" + this.con_parametri + " num=" + this.numero_parametri);
        this.attesa.start();
        Thread th = new Thread(this);
        th.start();
    }

    private void invocaMetodo(Method m, Object obj, Object[] args) {
        String nome_thread = Thread.currentThread().getName();
        try {
            Thread.currentThread().setPriority(3);
            String testo_per_trace = "THREAD(" + nome_thread + ")>> IN ESECUZIONE IL METODO =" + m.toString();
            if (!this.con_parametri) {
                testo_per_trace = testo_per_trace + " Senza PARAMETRI";
            } else {
                testo_per_trace = testo_per_trace + " con PARAMETRI = " + args[0].getClass().toString();
                if (this.numero_parametri > 1) {
                    testo_per_trace = testo_per_trace + " + " + args[1].getClass().toString();
                }
                if (this.numero_parametri > 2) {
                    testo_per_trace = testo_per_trace + " + " + args[2].getClass().toString();
                }
                if (this.numero_parametri > 3) {
                    testo_per_trace = testo_per_trace + " + " + args[3].getClass().toString();
                }
                if (this.numero_parametri > 4) {
                    testo_per_trace = testo_per_trace + " + " + args[4].getClass().toString();
                }
            }
            MyTrace.log.info(testo_per_trace);
            m.invoke(obj, args);
        }
        catch (IllegalArgumentException e) {
            MyTrace.log.severe("ERRORE:  eccezione AvvioSuThread.invocaMetodo() ARGOMENTI NON VALIDI ");
            e.printStackTrace();
            MyTrace.log.severe("ECCEZIONE: " + e.toString());
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
        catch (IllegalAccessException e) {
            MyTrace.log.severe("ERRORE:  eccezione AvvioSuThread.invocaMetodo() ACCESSO AL METODO NON CONSENTITO (problemi di permessi o di accesso)");
            e.printStackTrace();
            MyTrace.log.severe("ECCEZIONE: " + e.toString());
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
        catch (InvocationTargetException e) {
            MyTrace.log.severe("ERRORE:  eccezione AvvioSuThread.invocaMetodo() TARGET NON CONSENTITO (possibile crash sul costruttore)");
            e.printStackTrace();
            MyTrace.log.severe("ECCEZIONE: " + e.toString());
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE:  eccezione AvvioSuThread.invocaMetodo() errore di istanziazione su THREAD  o ECCEZIONE DELLO SPECIFICO METODO ");
            ex.printStackTrace();
            MyTrace.log.severe("ECCEZIONE GENERICA: " + ex.toString());
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE: AvvioSuThread.invocaMetodo() errore  su THREAD  di avvio o di linkaggio dello specifico modulo");
            err.printStackTrace();
            MyTrace.log.severe("ERRPRE: " + err.toString());
        }
        MyTrace.log.info("THREAD(" + nome_thread + ")>> TERMINATO");
        this.attesa.stop();
    }

    @Override
    public void run() {
        Thread.currentThread().setName("<<THREAD::AVVIO_SU_THREAD(ProcessoAttuale=" + this.oggetto.getClass().getName() + "." + this.metodo.getName() + "):>>");
        this.invocaMetodo(this.metodo, this.oggetto, this.parametri);
    }
}

