/*
 * Decompiled with CFR 0.152.
 */
package trasporti.viaggi;

import gestionale.auth.Gruppo;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import trasporti.viaggi.Viaggio;
import utils.Funzioni;
import utils.MyTrace;

public class ViaggiTableModel
extends AbstractTableModel {
    Vector cache = new Vector();
    int colCount;
    String[] headers;
    boolean modo_ric = false;

    public void setModo_ric(boolean modo_ric) {
        this.modo_ric = modo_ric;
    }

    @Override
    public String getColumnName(int i) {
        String retVal = "";
        switch (i) {
            case 0: {
                retVal = "Num. Viaggio";
                break;
            }
            case 1: {
                retVal = "Data Partenza";
                break;
            }
            case 2: {
                retVal = "Desc. Breve";
                break;
            }
            case 3: {
                retVal = "P/V";
                break;
            }
            case 4: {
                retVal = "Autista";
                break;
            }
            case 5: {
                retVal = "Trattore";
                break;
            }
            case 6: {
                retVal = "Rimorchio";
                break;
            }
            case 7: {
                retVal = "Vettore";
                break;
            }
            case 8: {
                retVal = "Ordini in viaggio";
                break;
            }
            case 9: {
                retVal = "Clienti del Viaggio";
                break;
            }
            case 10: {
                retVal = "N. Ordini Clienti del Viaggio";
                break;
            }
            default: {
                retVal = this.headers[i];
            }
        }
        return retVal;
    }

    @Override
    public int getRowCount() {
        return this.cache.size();
    }

    @Override
    public int getColumnCount() {
        return 11;
    }

    @Override
    public Object getValueAt(int row, int col) {
        Viaggio v = new Viaggio();
        if (!this.cache.isEmpty()) {
            v = (Viaggio)this.cache.elementAt(row);
            return v.getColValue(col);
        }
        return "";
    }

    public Class getColumnClass(int c) {
        try {
            return this.getValueAt(0, c).getClass();
        }
        catch (Exception e) {
            MyTrace.log.severe("ECCEZIONE: getColumnClass() di Viaggi Table Model colonna=" + c);
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void addRow(Gruppo g) {
        this.cache.add(0, g);
        this.fireTableDataChanged();
    }

    public void setDataViaggi(Vector vettoreV) {
        this.cache = new Vector();
        Iterator i = vettoreV.iterator();
        while (i.hasNext()) {
            this.cache.addElement(i.next());
        }
        this.fireTableChanged(null);
    }
}

