/*
 * Decompiled with CFR 0.152.
 */
package trasporti.viaggi;

import gestionale.configurazioni.ConfigurazioneFinestre;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTMLEditorKit;
import trasporti.bolle.Bolla;
import trasporti.ordini.Ordine;
import trasporti.ordini.RigaOrdineViaggio;
import trasporti.prese_consegne.PresaConsegna;
import trasporti.viaggi.StampaViaggio;
import trasporti.viaggi.Viaggio;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;

public class MyDettaglioViaggio
extends JInternalFrame {
    Viaggio v_selezione;
    Funzioni ff = new Funzioni();
    FunzioniDate fda = new FunzioniDate();
    private JButton jButtonSalva;
    private JButton jButtonStampa;
    private JEditorPane jEditorPane;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator6;
    private JToolBar jToolBar1;

    public MyDettaglioViaggio(Viaggio v) {
        try {
            this.v_selezione = v;
            this.initComponents();
            this.v_selezione.seleziona_dettagli();
            this.riempi_campi();
            this.setLocation(ConfigurazioneFinestre.GetPoint(this.getClass().getName(), new Point(200, 0)));
            this.setSize(ConfigurazioneFinestre.GetDimension(this.getClass().getName(), new Dimension(800, 600)));
        }
        catch (Exception ex) {
            MyTrace.log.severe("MyDettaglioViaggio() eccezione presunta chiamata a dettagli con  viaggio non selezionato");
            ex.printStackTrace();
            Funzioni.LogStackTrace(ex);
            this.dispose();
        }
    }

    private void riempi_campi() {
        File f = new File("viaggio.html");
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(f));
            bw.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\"><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" /><title>Dettaglio Ordine</title></head>");
            bw.write("<LINK REL =\"stylesheet\" TYPE=\"text/css\" HREF=\"config/style.css\" TITLE=\"Style\">");
            bw.write("<body style=\"font-family:Verdana, Geneva, sans-serif;font-size:14px;\">");
            bw.write("<p style=\"font-weight:bolder;font-size:22px;\">VIAGGIO N\u00b0 " + this.v_selezione.getNumero_viaggio() + "/" + this.v_selezione.getAnno() + "</p>");
            bw.write("<p><strong>DATA PARTENZA:</strong><span class=\"testo\">" + this.v_selezione.getData_partenza_it() + "</span></p>");
            bw.write("<p><strong>DESCRIZIONE:</strong>" + this.v_selezione.getDescrizione() + "</p>");
            bw.write("<p><strong>DESCRIZIONE BREVE:</strong>" + this.v_selezione.getDesc_breve() + "</p>");
            bw.write("<p><sTRONG>EFFETTUATO DA:</strong></p>");
            if (this.v_selezione.getId_avettore() != 0) {
                bw.write("<p><strong>VETTORE:</strong>[F" + this.v_selezione.getCodice_vettore() + "] " + this.v_selezione.getRag_soc_vettore() + "</p>");
            } else {
                bw.write("<p ><strong>Autista:  </strong>" + this.v_selezione.getAutista().getCognome() + " </p>");
                bw.write("<p ><strong>Trattore: </strong>" + this.v_selezione.getTrattore().getTarga() + " </p>");
                bw.write("<p ><strong>Rimorchio: </strong>" + this.v_selezione.getRimorchio().getTarga() + " </p>");
            }
            bw.write("<p ><strong>PRESE E CONSEGNE:</strong></p>");
            bw.write("<table width=\"90%\" border=\"1\" cellspacing=\"5\">");
            bw.write("<tr>");
            bw.write("<TD width=\"4%\"><strong>P/C</strong></TD><TD  width=\"12%\"><strong>DATA</strong></TD><TD width=\"21%\"><strong>rif Cliente</strong></TD><TD width=\"51%\"><strong>Luogo</strong></TD><TD width=\"8%\"><strong>Quantit\u00e0</strong></TD><TD width=\"4%\"><strong>UM</strong></TD>");
            bw.write("</tr>");
            for (PresaConsegna pc : this.v_selezione.getInsieme_pc().vettorePC) {
                bw.write("<tr>");
                bw.write("<TD>" + pc.getTipo() + "</TD>" + "<TD>" + pc.getData_it() + "</TD>" + "<TD>" + pc.getN_ordine() + "</TD>" + "<TD>" + pc.getLuogo().getIndirizzoCompleto() + "</TD>" + "<TD>" + pc.getQuantita() + "</TD>" + "<TD>" + pc.getUnitaMisura() + "</TD>");
                bw.write("</tr>");
            }
            bw.write("</table>");
            bw.write("<p ><strong>Bolle registrate per il viaggio per questo ordine:</strong></p>");
            bw.write("<table width=\"50%\" border=\"1\" cellspacing=\"5\">");
            bw.write("<tr>");
            bw.write("<TD width=\"30%\"><strong>DATA BOLLA</strong></TD><TD  width=\"70%\"><strong>NUMERO BOLLA</strong></TD>");
            bw.write("</tr>");
            if (this.v_selezione.getInsieme_bolle() != null && !this.v_selezione.getInsieme_bolle().vettoreV.isEmpty()) {
                for (Bolla b : this.v_selezione.getInsieme_bolle().vettoreV) {
                    bw.write("<tr>");
                    bw.write("<TD>" + this.fda.gira_data(b.getData_bolla()) + "</TD>" + "<TD>" + b.getNumero_bolla() + "</TD>");
                    bw.write("</tr>");
                }
            }
            bw.write("</table>");
            if (this.v_selezione.getId_avettore() != 0) {
                bw.write("<p ><strong>RIGHE FATTURE PASSIVE VETTORI:</strong></p>");
                bw.write("<table width=\"90%\" border=\"1\" cellspacing=\"5\">");
                bw.write("<tr>");
                bw.write("<TD width=\"6%\"><strong>Fattura Num</strong></TD><TD  width=\"10%\"><strong>Data Fattura</strong></TD><TD width=\"4%\"><strong>T/O</strong></TD><TD  width=\"10%\"><strong>CODICE</strong></TD><TD width=\"20%\"><strong>DESCRIZIONE</strong></TD><TD width=\"10%\"><strong>Quantit\u00e0</strong></TD><TD width=\"8%\"><strong>UM</strong></TD><TD width=\"12%\"><strong>Prezzo/Um</strong></TD><TD width=\"12%\"><strong>Prezzo For</strong></TD><TD width=\"12%\"><strong>Tot</strong></TD>");
                bw.write("</tr>");
                Iterator<RigaOrdineViaggio> j = this.v_selezione.getInsieme_r_fp().vettoreR.iterator();
                Money totale = new Money(BigDecimal.ZERO);
                while (j.hasNext()) {
                    RigaOrdineViaggio rov = j.next();
                    bw.write("<tr>");
                    bw.write("<TD>" + rov.getNumero_fattura_passiva() + "</TD>" + "<TD>" + this.fda.gira_data(rov.getData_fattura_passiva()) + "</TD>" + "<TD>" + rov.getT_o() + "</TD>" + "<TD>" + rov.getCodice_riga() + "</TD>" + "<TD>" + rov.getDescrizione_riga() + "</TD>" + "<TD>" + this.ff.formattaNumero("" + rov.getQuantita(), "#0.000") + "</TD>" + "<TD>" + rov.getCodice_um() + "</TD>" + "<TD>" + rov.getP_um() + "</TD>" + "<TD>" + rov.getP_for() + "</TD>" + "<TD>" + rov.getP_tot_riga() + "</TD>");
                    bw.write("</tr>");
                    totale = totale.plus(rov.getP_tot_riga());
                }
                bw.write("<tr>");
                bw.write("<TD></TD><TD></TD><TD></TD><TD></TD><TD></TD><TD></TD><TD></TD><TD><</TD><TD></TD><TD><strong>" + totale + "</strong></TD>");
                bw.write("</tr>");
                bw.write("</table>");
            }
            bw.write("<p ><strong>_______________________*********************_________________________</strong></p>");
            bw.write("<p ><strong>ORDINI COMPRESI NEL VIAGGIO:</strong></p>");
            if (this.v_selezione.getInsieme_o() == null || this.v_selezione.getInsieme_o().vettoreO.isEmpty()) {
                bw.write("<p ><strong>Il viaggio risulta vuoto</strong></p>");
            } else {
                for (Ordine o : this.v_selezione.getInsieme_o().vettoreO) {
                    o.seleziona_dettagli();
                    bw.write("<p ><strong>*)ORDINE N\u00b0 " + o.getN_ordine() + "/" + o.getAnno_ordine() + " </strong></p>");
                    bw.write("<p ><strong>COMMITTENTE:</strong><span class=\"testo\">  [C" + o.getA_cliente().getCodice() + "] " + o.getA_cliente().getRagione_sociale() + "</span></p>");
                    bw.write("<p><strong>TRATTA COMPLESSIVA:</strong><span class=\"testo\">" + o.getTratta_complessiva() + "</span></p>");
                    bw.write("<p ><strong>ANNOTAZIONI ORDINE:</strong><span class=\"testo\">" + o.getNote() + "</span></p>");
                    bw.write("<p ><strong>PRESE E CONSEGNE:</strong></p>");
                    bw.write("<table width=\"90%\" border=\"1\" cellspacing=\"5\">");
                    bw.write("<tr>");
                    bw.write("<TD width=\"4%\"><strong>P/C</strong></TD><TD  width=\"12%\"><strong>DATA</strong></TD><TD width=\"21%\"><strong>rif Cliente</strong></TD><TD width=\"51%\"><strong>Luogo</strong></TD><TD width=\"8%\"><strong>Quantit\u00e0</strong></TD><TD width=\"4%\"><strong>UM</strong></TD>");
                    bw.write("</tr>");
                    for (PresaConsegna pc : o.getInsieme_pc().vettorePC) {
                        bw.write("<tr>");
                        bw.write("<TD>" + pc.getTipo() + "</TD>" + "<TD>" + pc.getData_it() + "</TD>" + "<TD>" + pc.getN_ordine() + "</TD>" + "<TD>" + pc.getLuogo().getIndirizzoCompleto() + "</TD>" + "<TD>" + pc.getQuantita() + "</TD>" + "<TD>" + pc.getUnitaMisura() + "</TD>");
                        bw.write("</tr>");
                    }
                    bw.write("</table>");
                    bw.write("<p ><strong>RIGHE FATTURE ATTIVE:</strong></p>");
                    bw.write("<table width=\"90%\" border=\"1\" cellspacing=\"5\">");
                    bw.write("<tr>");
                    bw.write("<TD width=\"6%\"><strong>Fattura Num</strong></TD><TD  width=\"10%\"><strong>Data Fattura</strong></TD><TD width=\"4%\"><strong>T/O</strong></TD><TD  width=\"10%\"><strong>CODICE</strong></TD><TD width=\"20%\"><strong>DESCRIZIONE</strong></TD><TD width=\"10%\"><strong>Quantit\u00e0</strong></TD><TD width=\"8%\"><strong>UM</strong></TD><TD width=\"12%\"><strong>Prezzo/Um</strong></TD><TD width=\"12%\"><strong>Prezzo For</strong></TD><TD width=\"12%\"><strong>Tot</strong></TD>");
                    bw.write("</tr>");
                    Iterator<RigaOrdineViaggio> j = o.getInsieme_r().vettoreR.iterator();
                    Money totale = new Money(BigDecimal.ZERO);
                    while (j.hasNext()) {
                        RigaOrdineViaggio rov = j.next();
                        bw.write("<tr>");
                        bw.write("<TD>" + rov.getNumero_fattura_attiva() + "</TD>" + "<TD>" + this.fda.gira_data(rov.getData_fattura_attiva()) + "</TD>" + "<TD>" + rov.getT_o() + "</TD>" + "<TD>" + rov.getCodice_riga() + "</TD>" + "<TD>" + rov.getDescrizione_riga() + "</TD>" + "<TD>" + this.ff.formattaNumero("" + rov.getQuantita(), "#0.000") + "</TD>" + "<TD>" + rov.getCodice_um() + "</TD>" + "<TD>" + rov.getP_um() + "</TD>" + "<TD>" + rov.getP_for() + "</TD>" + "<TD>" + rov.getP_tot_riga() + "</TD>");
                        bw.write("</tr>");
                        totale = totale.plus(rov.getP_tot_riga());
                    }
                    bw.write("<tr>");
                    bw.write("<TD></TD><TD></TD><TD></TD><TD></TD><TD></TD><TD></TD><TD></TD><TD><</TD><TD></TD><TD><strong>" + totale + "</strong></TD>");
                    bw.write("</tr>");
                    bw.write("</table>");
                }
            }
            bw.write("</body>");
            bw.write("</html>");
            bw.close();
        }
        catch (IOException e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
        try {
            URL helpURL = f.getAbsoluteFile().toURI().toURL();
            if (helpURL != null) {
                try {
                    this.jEditorPane.setPage(helpURL);
                }
                catch (IOException e) {
                    System.err.println("Attempted to read a bad URL: " + helpURL);
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                }
            } else {
                System.err.println("Couldn't find file: TextSamplerDemoHelp.html");
                MyTrace.log.severe("Couldn't find file: TextSamplerDemoHelp.html");
            }
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(MyDettaglioViaggio.class.getName()).log(Level.SEVERE, null, ex);
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jEditorPane = new JEditorPane();
        this.jToolBar1 = new JToolBar();
        this.jButtonSalva = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButtonStampa = new JButton();
        this.jSeparator6 = new JToolBar.Separator();
        this.setClosable(true);
        this.setDefaultCloseOperation(2);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Dettaglio Viaggio");
        this.setPreferredSize(null);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                MyDettaglioViaggio.this.finestra_spostata(evt);
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                MyDettaglioViaggio.this.finestra_ridimensionata(evt);
            }
        });
        this.jEditorPane.setEditable(false);
        this.jEditorPane.setMinimumSize(null);
        this.jEditorPane.setPreferredSize(null);
        this.jScrollPane1.setViewportView(this.jEditorPane);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.jToolBar1.setRollover(true);
        this.jButtonSalva.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/media-floppy.png")));
        this.jButtonSalva.setText("Salva");
        this.jButtonSalva.setFocusable(false);
        this.jButtonSalva.setVerticalTextPosition(3);
        this.jButtonSalva.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyDettaglioViaggio.this.jButtonSalvaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonSalva);
        this.jToolBar1.add(this.jSeparator1);
        this.jButtonStampa.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-print.png")));
        this.jButtonStampa.setText("Stampa");
        this.jButtonStampa.setFocusable(false);
        this.jButtonStampa.setVerticalTextPosition(3);
        this.jButtonStampa.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyDettaglioViaggio.this.jButtonStampaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonStampa);
        this.jToolBar1.add(this.jSeparator6);
        this.getContentPane().add((Component)this.jToolBar1, "North");
        this.pack();
    }

    private void jButtonSalvaActionPerformed(ActionEvent evt) {
        if (this.jEditorPane.getText().length() > 0) {
            JFileChooser chooser = new JFileChooser();
            chooser.setMultiSelectionEnabled(false);
            chooser.setSelectedFile(new File("ordine_" + this.v_selezione.getNumero_viaggio() + ".rtf"));
            int option = chooser.showSaveDialog(this);
            if (option == 0) {
                StyledDocument doc = (StyledDocument)this.jEditorPane.getDocument();
                HTMLEditorKit kit = new HTMLEditorKit();
                try {
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(chooser.getSelectedFile().getAbsoluteFile()));
                    kit.write(out, (Document)doc, doc.getStartPosition().getOffset(), doc.getLength());
                    JOptionPane.showMessageDialog(this, "File salvato Correttamente");
                }
                catch (FileNotFoundException e) {
                    JOptionPane.showMessageDialog(this, "ERRORE:");
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this, "ERRORE:");
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                }
                catch (BadLocationException e) {
                    JOptionPane.showMessageDialog(this, "ERRORE:");
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                }
            }
        }
    }

    private void jButtonStampaActionPerformed(ActionEvent evt) {
        System.err.println("Chiamata la stampa con  JEditorPane di altezza=" + this.jEditorPane.getHeight());
        StampaViaggio stampa = new StampaViaggio(this.v_selezione, this.jEditorPane);
        stampa.avvia();
    }

    private void finestra_spostata(ComponentEvent evt) {
        ConfigurazioneFinestre.SetPoint(this.getClass().getName(), this.getLocation());
    }

    private void finestra_ridimensionata(ComponentEvent evt) {
        ConfigurazioneFinestre.SetDimension(this.getClass().getName(), this.getSize());
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(MyDettaglioViaggio.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(MyDettaglioViaggio.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MyDettaglioViaggio.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(MyDettaglioViaggio.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MyDettaglioViaggio(null).setVisible(true);
            }
        });
    }
}

