/*
 * Decompiled with CFR 0.152.
 */
package trasporti.tratte;

import gestionale.MyDesktopWindow;
import gestionale.cap.CAP;
import gestionale.cap.InsiemeCAP;
import gestionale.configurazioni.Configurazioni;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Vector;
import trasporti.cap.CapForTratta;
import trasporti.cap.InsiemeCapForTratta;
import trasporti.listini.InsiemePrezzi;
import trasporti.listini.Prezzo;
import utils.Funzioni;
import utils.Money;
import utils.MyTrace;

public class Tratta {
    private String cod_tratta = "";
    private String descrizione = "";
    private String provincia_p;
    private String cap_p;
    private String cap_a;
    private String provincia_a;
    private int id;
    private int id_cap_p;
    private int id_cap_a;
    private int generica;
    private InsiemeCAP insieme_cap_p;
    private InsiemeCAP insieme_cap_a;
    private Vector insieme_cap_riserva;
    private Vector insieme_cap_riserva_a;
    private CAP cp;
    private CAP ca;
    private double km;
    private Money p = new Money(BigDecimal.ZERO);
    private Prezzo prezzo;
    private InsiemePrezzi insieme_p;
    private Funzioni f = new Funzioni();
    private long tempo_di_visualizzazione;
    private boolean da_rigirare = false;

    public String getCod_tratta() {
        return this.cod_tratta;
    }

    public void setCod_tratta(String cod_tratta) {
        this.cod_tratta = cod_tratta;
    }

    public InsiemeCAP getInsieme_cap_a() {
        return this.insieme_cap_a;
    }

    public void setInsieme_cap_a(InsiemeCAP insieme_cap_a) {
        this.insieme_cap_a = insieme_cap_a;
    }

    public InsiemeCAP getInsieme_cap_p() {
        return this.insieme_cap_p;
    }

    public void setInsieme_cap_p(InsiemeCAP insieme_cap_p) {
        this.insieme_cap_p = insieme_cap_p;
    }

    public InsiemePrezzi getInsieme_p() {
        return this.insieme_p;
    }

    public void setInsieme_p(InsiemePrezzi insieme_p) {
        this.insieme_p = insieme_p;
    }

    public double getKm() {
        return this.km;
    }

    public void setKm(double km) {
        this.km = km;
    }

    public int getId_cap_a() {
        return this.id_cap_a;
    }

    public void setId_cap_a(int id_cap_a) {
        this.id_cap_a = id_cap_a;
    }

    public int getId_cap_p() {
        return this.id_cap_p;
    }

    public void setId_cap_p(int id_cap_p) {
        this.id_cap_p = id_cap_p;
    }

    public String getDescrizione() {
        return this.descrizione;
    }

    public void setDescrizione(String descrizione) {
        this.descrizione = descrizione;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getCap_a() {
        return this.cap_a;
    }

    public void setCap_a(String cap_a) {
        this.cap_a = cap_a;
    }

    public String getCap_p() {
        return this.cap_p;
    }

    public void setCap_p(String cap_p) {
        this.cap_p = cap_p;
    }

    public String getProvincia_a() {
        return this.provincia_a;
    }

    public void setProvincia_a(String provincia_a) {
        this.provincia_a = provincia_a;
    }

    public String getProvincia_p() {
        return this.provincia_p;
    }

    public void setProvincia_p(String provincia_p) {
        this.provincia_p = provincia_p;
    }

    public Prezzo getPrezzo() {
        return this.prezzo;
    }

    public void setPrezzo(Prezzo prezzo) {
        this.prezzo = prezzo;
    }

    public Money getP() {
        return this.p;
    }

    public void setP(Money p) {
        this.p = p;
    }

    public int getGenerica() {
        return this.generica;
    }

    public void setGenerica(int generica) {
        this.generica = generica;
    }

    public CAP getCa() {
        return this.ca;
    }

    public void setCa(CAP ca) {
        this.ca = ca;
    }

    public CAP getCp() {
        return this.cp;
    }

    public void setCp(CAP cp) {
        this.cp = cp;
    }

    public boolean isDa_rigirare() {
        return this.da_rigirare;
    }

    public void setDa_rigirare(boolean da_rigirare) {
        this.da_rigirare = da_rigirare;
    }

    public boolean inserisciTratta(boolean da_solo) {
        String query_ins;
        boolean r_ins;
        MyTrace.log.info("START INSERISCI TRATTA ::");
        this.tempo_di_visualizzazione = System.currentTimeMillis();
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(r_ins = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_ins = "INSERT INTO mtra_tratte(cod_tratta,descrizione,distanza,generica) VALUES ('" + this.getCod_tratta().replaceAll("'", "''") + "'," + "'" + this.getDescrizione().replaceAll("'", "''") + "'," + "'" + this.getKm() + "'," + this.getGenerica() + ")"))) {
            MyTrace.log.severe("Inserimento tratta non riuscito");
            Configurazioni.getIstanza().connessione.rollback();
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        String strSQL = "SELECT @@identity FROM mtra_tratte";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(strSQL);
        int id_inserito = 0;
        try {
            while (res.next()) {
                id_inserito = res.getInt("@@identity");
            }
        }
        catch (Exception e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        this.setId(id_inserito);
        InsiemeCapForTratta insieme_cft = new InsiemeCapForTratta();
        for (CAP c : this.getInsieme_cap_p().vettoreC) {
            CapForTratta cft = new CapForTratta();
            cft.setId_tratta(this.getId());
            cft.setId_cap(c.getId());
            cft.setPa("P");
            insieme_cft.vettoreC.add(cft);
        }
        for (CAP c : this.getInsieme_cap_a().vettoreC) {
            CapForTratta cft = new CapForTratta();
            cft.setId_tratta(this.getId());
            cft.setId_cap(c.getId());
            cft.setPa("A");
            insieme_cft.vettoreC.add(cft);
        }
        boolean res_cap = insieme_cft.inserisciInsiemeCFT(false);
        if (!res_cap) {
            MyTrace.log.severe("Inserimento tratta non riuscito");
            Configurazioni.getIstanza().connessione.rollback();
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mtra_tratte','" + this.getId() + "',NOW(),'INS','" + query_ins.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Inserimento tratta non riuscito per trace");
            Configurazioni.eccezione.gestisci("2.3", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        MyTrace.log.info("PERFORMANCE: =" + (System.currentTimeMillis() - this.tempo_di_visualizzazione) + " millisecondi");
        return true;
    }

    public boolean modificaTratta(boolean da_solo) {
        String query_mod;
        boolean r_mod;
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod = "UPDATE mtra_tratte SET cod_tratta='" + this.getCod_tratta().replaceAll("'", "''") + "'," + " descrizione='" + this.getDescrizione().replaceAll("'", "''") + "', " + " distanza='" + this.getKm() + "'," + " generica=" + this.getGenerica() + "" + " WHERE idTratta='" + this.getId() + "'"))) {
            MyTrace.log.severe("Modifica tratta non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        boolean res = this.elimina_vecchi_cap();
        if (!res) {
            MyTrace.log.severe("Modifica tratta non riuscita pere liminazione vecchi cap");
            Configurazioni.eccezione.gestisci("3.2", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        InsiemeCapForTratta insieme_cft = new InsiemeCapForTratta();
        for (CAP c : this.getInsieme_cap_p().vettoreC) {
            CapForTratta cft = new CapForTratta();
            cft.setId_tratta(this.getId());
            cft.setId_cap(c.getId());
            cft.setPa("P");
            insieme_cft.vettoreC.add(cft);
        }
        for (CAP c : this.getInsieme_cap_a().vettoreC) {
            CapForTratta cft = new CapForTratta();
            cft.setId_tratta(this.getId());
            cft.setId_cap(c.getId());
            cft.setPa("A");
            insieme_cft.vettoreC.add(cft);
        }
        boolean res_cap = insieme_cft.inserisciInsiemeCFT(false);
        if (!res_cap) {
            MyTrace.log.severe("Inserimento tratta non riuscito");
            Configurazioni.getIstanza().connessione.rollback();
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mmag_tratte','" + this.getId() + "',NOW(),'MOD','" + query_mod.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Modifica tratta non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.3", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        MyTrace.log.info("PERFORMANCE: =" + (System.currentTimeMillis() - this.tempo_di_visualizzazione) + " millisecondi");
        return true;
    }

    public boolean elimina_vecchi_cap() {
        String query = "DELETE FROM mtra_tratte_cap WHERE id_tratta=" + this.getId();
        return Configurazioni.getIstanza().connessione.eseguiAggiornamento(query);
    }

    public void seleziona(int id) {
        String query_seleziona = "select mtra_tratte.*  from mtra_tratte where idTratta=" + id;
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query_seleziona);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                this.setId(id);
                this.setCod_tratta(res.getString("cod_tratta"));
                this.setKm(res.getDouble("distanza"));
                this.setDescrizione(res.getString("descrizione"));
                this.setGenerica(res.getInt("generica"));
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("Seleziona Tratta non riuscito ");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.1", null);
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
    }

    public void seleziona_prezzi() {
        String w = " WHERE mtra_prezzi.id_tratta=" + this.getId();
        this.setInsieme_p(new InsiemePrezzi());
        this.insieme_p.ccaricamento(w, "");
    }

    public boolean seleziona_prezzo(int id_listino) {
        String w = "WHERE mtra_prezzi.id_tratta=" + this.getId() + " AND mtra_listini.idListino =" + id_listino;
        this.setInsieme_p(new InsiemePrezzi());
        this.insieme_p.ccaricamento(w, "");
        if (!this.getInsieme_p().vettorePL.isEmpty()) {
            this.setPrezzo((Prezzo)this.getInsieme_p().vettorePL.elementAt(0));
            this.setP(this.getPrezzo().getPrezzo());
            return true;
        }
        return false;
    }

    public void seleziona_cap_p(int id_cap) {
        this.setInsieme_cap_p(new InsiemeCAP());
        String query = "SELECT cap.* from mtra_tratte_cap LEFT JOIN cap ON mtra_tratte_cap.id_cap=cap.id_cap WHERE id_tratta=" + this.getId() + " AND pa='P'";
        if (id_cap != 0) {
            query = query + "AND cap.id_cap='" + id_cap + "'";
        }
        this.getInsieme_cap_p().caricamento(query);
        if (this.getInsieme_cap_p().vettoreC.size() != 0) {
            this.setCp((CAP)this.getInsieme_cap_p().vettoreC.elementAt(0));
            this.setCap_p(this.getCp().getCap());
            this.getCp().seleziona_tutti(this.getCp().getCap());
            this.insieme_cap_riserva = this.getInsieme_cap_p().vettoreC;
        }
    }

    public void seleziona_cap_a(int id_cap) {
        this.setInsieme_cap_a(new InsiemeCAP());
        String query2 = "SELECT cap.* from mtra_tratte_cap LEFT JOIN cap ON mtra_tratte_cap.id_cap=cap.id_cap WHERE id_tratta=" + this.getId() + " AND pa='A'";
        if (id_cap != 0) {
            query2 = query2 + "AND cap.id_cap='" + id_cap + "'";
        }
        this.getInsieme_cap_a().caricamento(query2);
        if (this.getInsieme_cap_a().vettoreC.size() != 0) {
            this.setCa((CAP)this.getInsieme_cap_a().vettoreC.elementAt(0));
            this.setCap_a(this.getCa().getCap());
            this.getCa().seleziona_tutti(this.getCa().getCap());
            this.insieme_cap_riserva_a = this.getInsieme_cap_a().vettoreC;
        }
    }

    public void seleziona_province() {
        String q = "Select cd_provincia from mtra_tratte_cap LEFT JOIN cap ON mtra_tratte_cap.id_cap=cap.id_cap where id_tratta=" + this.getId() + " AND pa='P' LIMIT 1";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(q);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                this.setProvincia_p(res.getString("cd_provincia"));
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("Seleziona Tratta non riuscito ");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.1", null);
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        String q2 = "Select cd_provincia from mtra_tratte_cap LEFT JOIN cap ON mtra_tratte_cap.id_cap=cap.id_cap where id_tratta=" + this.getId() + " AND pa='a' LIMIT 1";
        ResultSet res2 = Configurazioni.getIstanza().connessione.eseguiQuery(q2);
        try {
            ResultSetMetaData meta = res2.getMetaData();
            while (res2.next()) {
                this.setProvincia_a(res2.getString("cd_provincia"));
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("Seleziona Tratta non riuscito ");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.1", null);
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res2);
    }

    Object getColValue(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                retVal = this.getCod_tratta();
                break;
            }
            case 1: {
                retVal = this.f.formattaNumero(Double.toString(this.getKm()));
                break;
            }
            case 2: {
                retVal = this.getDescrizione();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }
}

