/*
 * Decompiled with CFR 0.152.
 */
package trasporti.scheda_di_trasporto;

import trasporti.scheda_di_trasporto.SchedaTrasporto;
import utils.BannerWorking;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.FunzioniTrasporti;
import utils.MyTrace;
import utils.stampe.GestoreStampe;

public class StampaSchedaTrasporto
implements Runnable {
    Funzioni f;
    FunzioniDate fda;
    GestoreStampe stampa;
    boolean esito;
    SchedaTrasporto scheda;
    private FunzioniTrasporti ft = new FunzioniTrasporti();
    Thread thread;

    public StampaSchedaTrasporto(SchedaTrasporto scheda) {
        this.stampa = new GestoreStampe();
        this.stampa.aggiungi_pj();
        this.scheda = scheda;
    }

    public void avvia() {
        this.thread = new Thread(this);
        MyTrace.log.info("avvio Procedura su Thread");
        this.thread.start();
    }

    @Override
    public void run() {
        BannerWorking attesa = new BannerWorking("ELABORAZIONE SU THREAD ANDAMENTO TEMPORALE");
        attesa.start();
        this.Elabora();
        attesa.stop();
    }

    public boolean Elabora() {
        try {
            MyTrace.log.info(" XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX STAMPA SCHEDA DI TRASPORTO INIZIO XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
            long tempo_di_visualizzazione = System.currentTimeMillis();
            this.fda = new FunzioniDate();
            this.f = new Funzioni();
            this.stampa = new GestoreStampe();
            this.stampa.aggiungi_pj();
            this.stampa.setFont(this.stampa.Font_Arial_16_B);
            this.stampa.appendTextOvunque("SCHEDA DI TRASPORTO", 200, 30);
            this.stampa.setFont(this.stampa.Font_Arial_8);
            this.stampa.appendTextOvunque("(da compilarsi a cura del committente e conservare dal vettore a bordo del veicolo: art. 7 bis, D.Lgs. 286/2005)", 40, 40);
            int y = 60;
            this.stampa.setFont(this.stampa.Font_Arial_12_B);
            this.stampa.appendTextOvunque("A - DATI DEL VETTORE", 25, y);
            this.stampa.setFont(this.stampa.Font_Arial_8);
            this.stampa.appendTextOvunque("(art. 2, comma 1,lett. b - D.Lgs. 286/2005)", 175, y);
            this.stampa.appendRect(20, y += 5, 220, 45);
            this.stampa.appendTestoDimensionePosizione("Denominazione sociale (1) Ragione Sociale (1) Ditta (1) - Indirizzo e Sede Azienda (riferimenti telefonici o mail)", 25, y + 10, 200);
            this.stampa.appendRect(240, y, 320, 45);
            String[] vettore = this.scheda.getVettore().split("--");
            try {
                this.stampa.appendTestoDimensionePosizione("" + vettore[0], 245, y + 10, 300);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.stampa.appendRect(20, y += 45, 220, 12);
            this.stampa.appendTextOvunque("Partita IVA", 25, y + 10);
            this.stampa.appendRect(240, y, 320, 12);
            try {
                this.stampa.appendTestoDimensionePosizione("" + vettore[1], 245, y + 10, 300);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.stampa.appendRect(20, y += 12, 220, 12);
            this.stampa.appendTextOvunque("Numero Iscrizione Albo Autotrasportatori", 25, y + 10);
            this.stampa.appendRect(240, y, 320, 12);
            this.stampa.appendTestoDimensionePosizione(" " + this.scheda.getNumero_iscrizione_albo(), 245, y + 10, 300);
            this.stampa.setFont(this.stampa.Font_Arial_12_B);
            this.stampa.appendTextOvunque("B - DATI DEL COMMITTENTE", 25, y += 35);
            this.stampa.setFont(this.stampa.Font_Arial_8);
            this.stampa.appendTextOvunque("(art. 2, comma 1,lett. b - D.Lgs. 286/2005)", 195, y);
            this.stampa.appendRect(20, y += 5, 220, 45);
            this.stampa.appendTestoDimensionePosizione("Denominazione ditta individuale o ragione sociale altro tipo di impresa - Indirizzo e Sede Azienda (riferimenti telefonici o mail)", 25, y + 10, 200);
            this.stampa.appendRect(240, y, 320, 45);
            String[] committente = this.scheda.getCommittente().split("--");
            try {
                this.stampa.appendTestoDimensionePosizione("" + committente[0], 245, y + 10, 300);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.stampa.appendRect(20, y += 45, 220, 12);
            this.stampa.appendTextOvunque("Partita IVA", 25, y + 10);
            this.stampa.appendRect(240, y, 320, 12);
            try {
                this.stampa.appendTestoDimensionePosizione("" + committente[1], 245, y + 10, 300);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.stampa.setFont(this.stampa.Font_Arial_12_B);
            this.stampa.appendTextOvunque("C - DATI DEL CARICATORE", 25, y += 35);
            this.stampa.setFont(this.stampa.Font_Arial_8);
            this.stampa.appendTextOvunque("(art. 2, comma 1,lett. b - D.Lgs. 286/2005)", 195, y);
            this.stampa.appendRect(20, y += 5, 220, 45);
            this.stampa.appendTestoDimensionePosizione("Denominazione ditta individuale o ragione sociale altro tipo di impresa - Indirizzo e Sede Azienda (riferimenti telefonici o mail)", 25, y + 10, 200);
            this.stampa.appendRect(240, y, 320, 45);
            String[] caricatore = this.scheda.getCaricatore().split("--");
            try {
                this.stampa.appendTestoDimensionePosizione("" + caricatore[0], 245, y + 10, 300);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.stampa.appendRect(20, y += 45, 220, 12);
            this.stampa.appendTextOvunque("Partita IVA", 25, y + 10);
            this.stampa.appendRect(240, y, 320, 12);
            try {
                this.stampa.appendTestoDimensionePosizione("" + caricatore[1], 245, y + 10, 300);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.stampa.setFont(this.stampa.Font_Arial_12_B);
            this.stampa.appendTextOvunque("D - DATI DEL PROPRIETARIO DELLA MERCE", 25, y += 35);
            this.stampa.setFont(this.stampa.Font_Arial_8);
            this.stampa.appendTextOvunque("(art. 2, comma 1,lett. b - D.Lgs. 286/2005)", 300, y);
            this.stampa.appendRect(20, y += 5, 220, 45);
            this.stampa.appendTestoDimensionePosizione("Denominazione ditta individuale o ragione sociale altro tipo di impresa - Indirizzo e Sede Azienda (riferimenti telefonici o mail)", 25, y + 10, 200);
            this.stampa.appendRect(240, y, 320, 45);
            String[] proprietario = this.scheda.getProprietario().split("--");
            try {
                this.stampa.appendTestoDimensionePosizione("" + proprietario[0], 245, y + 10, 300);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.stampa.appendRect(20, y += 45, 220, 12);
            this.stampa.appendTextOvunque("Partita IVA", 25, y + 10);
            this.stampa.appendRect(240, y, 320, 12);
            try {
                this.stampa.appendTestoDimensionePosizione("" + proprietario[1], 245, y + 10, 300);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.stampa.appendRect(20, y += 25, 540, 25);
            this.stampa.setFont(this.stampa.Font_Arial_8_B);
            this.stampa.appendTextOvunque("Eventuali Dichiarazioni (2)", 25, y + 10);
            this.stampa.setFont(this.stampa.Font_Arial_8);
            this.stampa.appendTestoDimensionePosizione("" + this.scheda.getDichiarazioni(), 150, y + 10, 400);
            this.stampa.setFont(this.stampa.Font_Arial_12_B);
            this.stampa.appendTextOvunque("E - DATI MERCE TRASPORTATA", 25, y += 45);
            this.stampa.setFont(this.stampa.Font_Arial_8);
            this.stampa.appendRect(20, y += 5, 220, 12);
            this.stampa.appendTextOvunque("Tipologia", 25, y + 10);
            this.stampa.appendRect(240, y, 320, 12);
            this.stampa.appendTestoDimensionePosizione("" + this.ft.nome_tipologia_merce(this.scheda.getId_tipologia()), 245, y + 10, 300);
            this.stampa.appendRect(20, y += 12, 220, 12);
            this.stampa.appendTextOvunque("Quantit\u00e0/peso", 25, y + 10);
            this.stampa.appendRect(240, y, 320, 12);
            this.stampa.appendTestoDimensionePosizione("" + this.scheda.getQuantita(), 245, y + 10, 300);
            this.stampa.appendRect(20, y += 12, 220, 12);
            this.stampa.appendTextOvunque("Luogo di carico merce", 25, y + 10);
            this.stampa.appendRect(240, y, 320, 12);
            this.stampa.appendTestoDimensionePosizione("" + this.scheda.luogo_carico, 245, y + 10, 300);
            this.stampa.appendRect(20, y += 12, 220, 12);
            this.stampa.appendTextOvunque("Luogo di scarico merce", 25, y + 10);
            this.stampa.appendRect(240, y, 320, 12);
            this.stampa.appendTestoDimensionePosizione("" + this.scheda.luogo_scarico, 245, y + 10, 300);
            this.stampa.appendRect(20, y += 25, 540, 25);
            this.stampa.setFont(this.stampa.Font_Arial_8_B);
            this.stampa.appendTextOvunque("Osservazioni varie (3)", 25, y + 10);
            this.stampa.setFont(this.stampa.Font_Arial_8);
            this.stampa.appendTestoDimensionePosizione("" + this.scheda.getOsservazioni(), 150, y + 10, 400);
            this.stampa.appendRect(20, y += 45, 540, 25);
            this.stampa.setFont(this.stampa.Font_Arial_8_B);
            this.stampa.appendTextOvunque("Eventuali Istruzioni (4)", 25, y + 10);
            this.stampa.setFont(this.stampa.Font_Arial_8);
            this.stampa.appendTestoDimensionePosizione("" + this.scheda.getIstruzioni(), 150, y + 10, 400);
            this.stampa.setFont(this.stampa.Font_Arial_12_B);
            this.stampa.appendTextOvunque("Luogo data e compilazione", 25, y += 45);
            this.stampa.setFont(this.stampa.Font_Arial_8);
            this.stampa.appendRect(20, y += 5, 220, 12);
            this.stampa.appendTextOvunque("Luogo", 25, y + 10);
            this.stampa.appendRect(240, y, 320, 12);
            this.stampa.appendTestoDimensionePosizione("" + this.scheda.getLuogo_compilazione(), 245, y + 10, 300);
            this.stampa.appendRect(20, y += 12, 220, 12);
            this.stampa.appendTextOvunque("Data", 25, y + 10);
            this.stampa.appendRect(240, y, 320, 12);
            this.stampa.appendTestoDimensionePosizione("" + this.fda.gira_data(this.scheda.getData_compilazione()), 245, y + 10, 300);
            this.stampa.appendRect(20, y += 12, 220, 12);
            this.stampa.appendTextOvunque("Dati compilatore (5)", 25, y + 10);
            this.stampa.appendRect(240, y, 320, 12);
            this.stampa.appendTestoDimensionePosizione("" + this.scheda.getCompilatore(), 245, y + 10, 300);
            this.stampa.appendRect(20, y += 12, 220, 20);
            this.stampa.appendTextOvunque("Firma", 25, y + 10);
            this.stampa.appendRect(240, y, 320, 20);
            this.stampa.appendTestoDimensionePosizione("", 245, y + 10, 300);
            this.stampa.appendTestoDimensionePosizione("(1) Utilizzare denominazione sociale per le societ\u00e0 di capitali; ragione sociale per le societ\u00e0 di persomne e la ditta per le imprese individuali", 25, y += 35, 530);
            this.stampa.appendTestoDimensionePosizione("(2) Da compilare nei casi in cui non \u00e8 possibile indicare la figura del proprietario", 25, y += 10, 530);
            this.stampa.appendTestoDimensionePosizione("(3) Da compilare a cura del vettore o suo conducente qualora si verifichino variazioni rispetto alle indicazioni originarie del presente documento (es. variazione luogo di scarico, variazione tipologia e quantit\u00e0 merce,...)", 25, y += 10, 530);
            this.stampa.appendTestoDimensionePosizione("(4) Riportare eventuali istruzioni fornite dal committente o da uno dei soggetti della filiera del trasporto al vettore", 25, y += 20, 530);
            this.stampa.appendTestoDimensionePosizione("(5) Indicare le generalit\u00e0 di chi sottoscrive la scheda in nome e per conto del committente", 25, y += 10, 530);
            String jobname = this.fda.dataCorrente().replaceAll("-", "") + this.fda.OraCorrente().replaceAll(":", "") + "_SCHEDA_DI_TRASPORTO_VIAGGO";
            this.stampa.getSeg().getMy_pj_corrente().getPj().setJobName(jobname);
            this.stampa.print();
            System.out.println("Fine Stampa");
            MyTrace.log.info(" XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX STAMPA SCHEDA DI TRASPORTO FINE XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
            MyTrace.log.info(" PERFORMANCE: Tempo Totale compresa la stampa =" + (System.currentTimeMillis() - tempo_di_visualizzazione) + " millisecondi");
            this.esito = true;
        }
        catch (Exception ex) {
            MyTrace.log.severe("ECCEZIONE in Elabora() StampaSchedaTrasporto");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
            this.esito = false;
        }
        return this.esito;
    }
}

