/*
 * Decompiled with CFR 0.152.
 */
package trasporti.report_manutenzioni;

import gestionale.configurazioni.Configurazioni;
import gestionale.personalizzazione.stampe.IntestazioneFatturaAttiva;
import gestionale.personalizzazione.stampe.PiedePaginaGenericoIntestato;
import java.awt.Color;
import java.sql.ResultSet;
import java.util.Iterator;
import java.util.Vector;
import trasporti.manutenzione_ddi.DDIManutenzione;
import trasporti.manutenzione_ddi.InsiemeDDIManutenzione;
import utils.BannerWorking;
import utils.ClientiFornitoriField;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;
import utils.stampe.GestoreStampe;
import utils.stampe.OggettoToPrint;

public class StampaManutenzioniFornitore
implements Runnable {
    Funzioni f;
    FunzioniDate fda;
    int y;
    int y_inizio;
    Thread thread;
    String dataDA;
    String dataDA_girata;
    String dataA;
    String dataA_girata;
    float[] dash = new float[]{1.0f, 1.0f};
    boolean riga_spezzata = true;
    ClientiFornitoriField jTextClientiFornitori;
    public String ragione_sociale;
    public int id_anagrafica;

    public StampaManutenzioniFornitore(String dataDA, String dataA, ClientiFornitoriField jTextClientiFornitori) {
        MyTrace.log.info("STAMPA MANUTENZIONI FORNITORE   (START)");
        this.dataA = dataA;
        this.dataDA = dataDA;
        this.jTextClientiFornitori = jTextClientiFornitori;
        this.f = new Funzioni();
        this.fda = new FunzioniDate();
        this.dataDA_girata = this.fda.gira_data(dataDA);
        this.dataA_girata = this.fda.gira_data(dataA);
        Configurazioni.getIstanza();
        this.y_inizio = Configurazioni.inizio_stampe;
        MyTrace.log.info("STAMPA MANUTENZIONI FORNITORE   (STOP)");
    }

    public void avvia() {
        this.thread = new Thread(this);
        MyTrace.log.info("avvio Procedura su Thread");
        this.thread.start();
    }

    @Override
    public void run() {
        BannerWorking attesa = new BannerWorking("ELABORAZIONE SU THREAD STAMPA MANUTENZIONI FORNITORE");
        attesa.start();
        this.elabora_formattazione_stampa(this.jTextClientiFornitori);
        attesa.stop();
    }

    private void elabora_formattazione_stampa(ClientiFornitoriField jTextClientiFornitori) {
        try {
            MyTrace.log.info("STAMPA MANUTENZIONI FORNITORE: XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX  INIZIO STAMPA XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
            int y = this.y_inizio;
            GestoreStampe stampa = new GestoreStampe();
            stampa.aggiungi_pj();
            stampa.setFont(stampa.Font_Calibri_10_B);
            boolean prova = false;
            this.ragione_sociale = jTextClientiFornitori.getAnagrafica().getRagione_sociale();
            this.stampa_intestazione(stampa, y, this.ragione_sociale);
            stampa.setFont(stampa.Font_Calibri_10);
            double tot_costi = 0.0;
            this.id_anagrafica = jTextClientiFornitori.getAnagrafica().getIdanag();
            InsiemeDDIManutenzione insieme_ddi_manutenzione = new InsiemeDDIManutenzione();
            String where = " WHERE mtra_man_ddi.data_fattura between '" + this.dataDA + "' and '" + this.dataA + "' ";
            where = where + " AND  mtra_man_ddi.id_anagrafica ='" + this.id_anagrafica + "' ";
            String orderBy = " ORDER BY mtra_man_ddi.data_fattura ";
            insieme_ddi_manutenzione.caricamento(where, orderBy);
            Iterator iteratore_valori = insieme_ddi_manutenzione.vettoreDDIManutenzione.iterator();
            while (iteratore_valori.hasNext()) {
                stampa.setFont(stampa.Font_Calibri_10);
                prova = false;
                DDIManutenzione ddi_manutenzione = (DDIManutenzione)iteratore_valori.next();
                String data = ddi_manutenzione.getData_fat();
                String descrizione = ddi_manutenzione.getDescrizione();
                int id_ddi_manutenzione = ddi_manutenzione.getId();
                double costo = 0.0;
                String query = "SELECT * FROM mtra_man_magazzino WHERE id_ddi='" + id_ddi_manutenzione + "'";
                ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
                while (res.next()) {
                    double costo_acquisto = res.getDouble("costo_di_acquisto");
                    double quantita_magazzino = res.getDouble("quantita_in_magazzino");
                    double costo_tot = costo_acquisto * quantita_magazzino;
                    costo += costo_tot;
                }
                Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
                Money money_Tot_Singola_Manutenzione = new Money(costo);
                String importo = money_Tot_Singola_Manutenzione + "";
                stampa.appendTextOvunque(this.fda.gira_data(data), 30, y + 75);
                int dimensionesplitstring = stampa.dimensioneSplitString(descrizione, 300, stampa.Font_Calibri_10);
                if (dimensionesplitstring > 1) {
                    Vector str_splittate = stampa.SplitString(descrizione, 300, stampa.Font_Calibri_10);
                    Iterator i_str_splittate = str_splittate.iterator();
                    while (i_str_splittate.hasNext()) {
                        prova = false;
                        stampa.setFont(stampa.Font_Calibri_10);
                        String stringasplittata = (String)i_str_splittate.next();
                        stampa.appendTextOvunque(stringasplittata, 100, y + 75);
                        if (this.riga_spezzata) {
                            stampa.appendStringaOvunqueFormattazioneDestra(importo, 430, y + 75, 45);
                            this.riga_spezzata = false;
                        }
                        stampa.appendLineTratteggiata(30, (y += 12) + 75 - 9, 573, y + 75 - 9, this.dash, Color.gray);
                        if (y <= 670) continue;
                        stampa.paginanuova();
                        y = this.y_inizio;
                        this.stampa_intestazione(stampa, y, this.ragione_sociale);
                        prova = true;
                    }
                    y -= 12;
                } else {
                    stampa.appendTextOvunque(descrizione, 100, y + 75);
                    stampa.appendStringaOvunqueFormattazioneDestra(importo, 430, y + 75, 45);
                }
                this.riga_spezzata = true;
                y += 12;
                if (!prova) {
                    stampa.appendLineTratteggiata(30, y + 75 - 9, 573, y + 75 - 9, this.dash, Color.gray);
                }
                if (y > 670) {
                    stampa.paginanuova();
                    y = this.y_inizio;
                    this.stampa_intestazione(stampa, y, this.ragione_sociale);
                }
                tot_costi += costo;
            }
            Money money_Tot_Manutenzioni = new Money(tot_costi);
            String S_money_Tot_Manutenzioni = "" + money_Tot_Manutenzioni;
            stampa.setFont(stampa.Font_Calibri_12_B);
            stampa.appendLine(30, (y += 8) + 75, 573, y + 75);
            stampa.appendLine(30, y + 80, 573, y + 80);
            if (y > 620) {
                stampa.paginanuova();
                y = this.y_inizio;
                this.stampa_intestazione(stampa, y, this.ragione_sociale);
                y -= 20;
            }
            stampa.appendRoundRect(170, (y += 20) + 75, 250, 50, 10, 10);
            String tot_manutenzioni = "Totale Manutenzioni";
            stampa.appendTextOvunque(tot_manutenzioni, 190, y + 104);
            stampa.appendStringaOvunqueFormattazioneDestra(S_money_Tot_Manutenzioni, 350, y + 104, 45);
            stampa.setFont(stampa.Font_Calibri_8);
            String date_now = this.fda.dataCorrente().replaceAll("-", "");
            String ora_now = this.fda.OraCorrente().replaceAll(":", "");
            String nome_file = this.f.pulisci_nome_file(date_now + ora_now + "_Manutenzione_Fornitore_" + this.ragione_sociale + "_Dal_" + this.dataDA_girata + "_Al_" + this.dataA_girata);
            stampa.getSeg().getMy_pj_corrente().getPj().setJobName(nome_file);
            stampa.setInt((OggettoToPrint)new IntestazioneFatturaAttiva());
            stampa.setIntPP((OggettoToPrint)new IntestazioneFatturaAttiva());
            stampa.setPiedePaginaGenericoIntestato((OggettoToPrint)new PiedePaginaGenericoIntestato("Manutenzioni"));
            stampa.print();
            MyTrace.log.info(" XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX STAMPA MANUTENZIONI FORNITORE FINE XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE: eccezione elabora_formattazione_stampa() nella stampa manutenzione fornitore");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE: elabora_formattazione_stampa() errore di avvio o di linkaggio");
            err.printStackTrace();
        }
    }

    public void stampa_intestazione(GestoreStampe stampa, int altezza, String ragione_sociale) {
        MyTrace.log.info("STAMPA INTESTAZIONE MANUTENZIONI FORNITORE    START");
        stampa.appendRoundRect(18, altezza += 10, 555, 35, 10, 10);
        stampa.setFont(stampa.Font_Calibri_12_B);
        stampa.appendTextOvunque("Manutenzioni di " + ragione_sociale + " dal " + this.dataDA_girata + " al " + this.dataA_girata, 30, altezza + 10 + 3);
        stampa.setFont(stampa.Font_Calibri_10_B);
        stampa.appendTextOvunque("Data", 30, altezza + 10 + 18);
        stampa.appendTextOvunque("Descrizione", 100, altezza + 10 + 18);
        stampa.appendTextOvunque("Importo", 442, altezza + 10 + 18);
        MyTrace.log.info("STAMPA INTESTAZIONE  MANUTENZIONI FORNITORE    STOP");
    }
}

