/*
 * Decompiled with CFR 0.152.
 */
package trasporti.report_lista_fatture;

import gestionale.configurazioni.Configurazioni;
import gestionale.personalizzazione.stampe.IntestazioneFatturaAttiva;
import gestionale.personalizzazione.stampe.PiedePaginaGenericoIntestato;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.Iterator;
import trasporti.fatturazione.InsiemeTraFA;
import trasporti.fatturazione.TraFatturaAttiva;
import utils.BannerWorking;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;
import utils.stampe.GestoreStampe;
import utils.stampe.OggettoToPrint;

public class StampaListaFatture
implements Runnable {
    Funzioni f;
    FunzioniDate fda;
    int y;
    int y_inizio;
    Thread thread;
    String dataDA;
    String dataDA_girata;
    String dataA;
    String dataA_girata;
    float[] dash = new float[]{1.0f, 1.0f};
    InsiemeTraFA insieme_fa;
    String intestazione;

    public StampaListaFatture(InsiemeTraFA i, String intestazione) {
        MyTrace.log.info("STAMPA LISTA FATTURE   (START)");
        this.insieme_fa = i;
        this.intestazione = intestazione;
        this.f = new Funzioni();
        this.fda = new FunzioniDate();
        this.dataDA_girata = this.fda.gira_data(this.dataDA);
        this.dataA_girata = this.fda.gira_data(this.dataA);
        Configurazioni.getIstanza();
        this.y_inizio = Configurazioni.inizio_stampe;
        MyTrace.log.info("STAMPA LISTA FATTURE   (STOP)");
    }

    public void avvia() {
        this.thread = new Thread(this);
        MyTrace.log.info("avvio Procedura su Thread");
        this.thread.start();
    }

    @Override
    public void run() {
        BannerWorking attesa = new BannerWorking("ELABORAZIONE SU THREAD STAMPA LISTA FATTURE");
        attesa.start();
        this.elabora_formattazione_stampa();
        attesa.stop();
    }

    private void elabora_formattazione_stampa() {
        try {
            MyTrace.log.info("STAMPA LISTA FATTURE: XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX  INIZIO STAMPA XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
            int y = this.y_inizio;
            GestoreStampe stampa = new GestoreStampe();
            stampa.aggiungi_pj();
            this.stampa_intestazione(stampa, y);
            Money ricavi_totali_totali = new Money(BigDecimal.ZERO);
            Iterator<TraFatturaAttiva> iteratore_valori = this.insieme_fa.vettoreFA.iterator();
            while (iteratore_valori.hasNext()) {
                stampa.setFont(stampa.Font_Calibri_9);
                TraFatturaAttiva fa = iteratore_valori.next();
                ricavi_totali_totali = fa.getTotale_ricavi();
                stampa.appendTextOvunque(fa.getR().getData_docIt(), 100, y + 75);
                stampa.appendTextOvunque("" + fa.getNumero() + " " + fa.getCodifica() + "/" + fa.getAnno(), 168, y + 75);
                if (!fa.getRicavi_diretti().isZero()) {
                    stampa.appendStringaOvunqueFormattazioneDestra("" + fa.getRicavi_diretti(), 238, y + 75, 45);
                }
                if (!fa.getRicavi_indiretti().isZero()) {
                    stampa.appendStringaOvunqueFormattazioneDestra("" + fa.getRicavi_indiretti(), 328, y + 75, 45);
                }
                stampa.appendStringaOvunqueFormattazioneDestra("" + fa.getTotale_ricavi(), 418, y + 75, 45);
                stampa.appendLineTratteggiata(30, (y += 12) + 75 - 9, 573, y + 75 - 9, this.dash, Color.gray);
                if (y <= 670) continue;
                stampa.paginanuova();
                y = this.y_inizio;
                this.stampa_intestazione(stampa, y);
            }
            stampa.setFont(stampa.Font_Calibri_12_B);
            stampa.appendLine(30, (y += 8) + 75, 573, y + 75);
            stampa.appendLine(30, y + 80, 573, y + 80);
            if (y > 620) {
                stampa.paginanuova();
                y = this.y_inizio;
                this.stampa_intestazione(stampa, y);
                y -= 20;
            }
            stampa.appendRoundRect(350, (y += 20) + 75, 180, 50, 10, 10);
            String tot_fatture = "Totale Fatture";
            stampa.appendTextOvunque(tot_fatture, 370, y + 104);
            stampa.appendStringaOvunqueFormattazioneDestra("" + ricavi_totali_totali, 460, y + 104, 45);
            stampa.setFont(stampa.Font_Calibri_8);
            String date_now = this.fda.dataCorrente().replaceAll("-", "");
            String ora_now = this.fda.OraCorrente().replaceAll(":", "");
            String nome_file = this.f.pulisci_nome_file(date_now + ora_now + this.intestazione.replaceAll(" ", "_"));
            stampa.getSeg().getMy_pj_corrente().getPj().setJobName(nome_file);
            stampa.setInt((OggettoToPrint)new IntestazioneFatturaAttiva());
            stampa.setIntPP((OggettoToPrint)new IntestazioneFatturaAttiva());
            stampa.setPiedePaginaGenericoIntestato((OggettoToPrint)new PiedePaginaGenericoIntestato("Fatturato"));
            stampa.print();
            MyTrace.log.info(" XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX STAMPA LISTA FATTURE FINE XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE: eccezione elabora_formattazione_stampa() nella stampa lista fatture");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE: elabora_formattazione_stampa() errore di avvio o di linkaggio");
            err.printStackTrace();
        }
    }

    public void stampa_intestazione(GestoreStampe stampa, int altezza) {
        MyTrace.log.info("STAMPA INTESTAZIONE LISTA FATTURE    START");
        stampa.appendRoundRect(60, altezza += 10, 470, 35, 10, 10);
        stampa.setFont(stampa.Font_Calibri_14_B);
        stampa.appendTextOvunque(this.intestazione, 100, altezza + 10 + 3);
        stampa.setFont(stampa.Font_Calibri_12_B);
        stampa.appendTextOvunque("Data", 100, altezza + 10 + 18);
        stampa.appendTextOvunque("N\u00b0 fattura", 175, altezza + 10 + 18);
        stampa.appendTextOvunque("Ricavi diretti", 240, altezza + 10 + 18);
        stampa.appendTextOvunque("Ricavi indiretti", 328, altezza + 10 + 18);
        stampa.appendTextOvunque("Totale", 437, altezza + 10 + 18);
        MyTrace.log.info("STAMPA INTESTAZIONE LISTA FATTURE    STOP");
    }
}

