/*
 * Decompiled with CFR 0.152.
 */
package trasporti.report_lista_fatture;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import trasporti.fatturazione.TraFatturaAttiva;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.MyTrace;

public class ReportFattureTableModel
extends AbstractTableModel {
    ArrayList<TraFatturaAttiva> cache;
    int colCount;
    String[] headers;
    boolean modo_ric = false;
    FunzioniDate fda = new FunzioniDate();

    public ReportFattureTableModel() {
        this.cache = new ArrayList();
    }

    public void setModo_ric(boolean modo_ric) {
        this.modo_ric = modo_ric;
    }

    @Override
    public String getColumnName(int i) {
        String retVal = "";
        switch (i) {
            case 0: {
                retVal = "Data";
                break;
            }
            case 1: {
                retVal = "N.Fattura";
                break;
            }
            case 2: {
                retVal = "Ricavi Diretti";
                break;
            }
            case 3: {
                retVal = "Ricavi Indiretti";
                break;
            }
            case 4: {
                retVal = "Totale";
                break;
            }
            default: {
                retVal = this.headers[i];
            }
        }
        return retVal;
    }

    @Override
    public int getRowCount() {
        return this.cache.size();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (!this.cache.isEmpty()) {
            TraFatturaAttiva riga = this.cache.get(row);
            return riga.getColValueRicavi(col);
        }
        return "";
    }

    public Class getColumnClass(int c) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void setDataReport(ArrayList<TraFatturaAttiva> vettoreR) {
        try {
            this.cache = new ArrayList();
            for (TraFatturaAttiva v : vettoreR) {
                this.cache.add(v);
            }
            this.fireTableChanged(null);
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE:  eccezione setDataRegistro errore di istanziazione ");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE: setDataRegistro errore di avvio o di linkaggio dello specifico modulo");
            err.printStackTrace();
        }
    }
}

