/*
 * Decompiled with CFR 0.152.
 */
package trasporti.report_km;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import trasporti.viaggi.Viaggio;
import utils.Funzioni;
import utils.MyTrace;
import utils.Quantita;

public class ReportKMTableModel
extends AbstractTableModel {
    ArrayList<String[]> cache = new ArrayList(10);
    int colCount;
    String[] headers;
    boolean modo_ric = false;

    public void setModo_ric(boolean modo_ric) {
        this.modo_ric = modo_ric;
    }

    @Override
    public String getColumnName(int i) {
        String retVal = "";
        switch (i) {
            case 0: {
                retVal = "Targa";
                break;
            }
            case 1: {
                retVal = "N.Viaggio";
                break;
            }
            case 2: {
                retVal = "Autista";
                break;
            }
            case 3: {
                retVal = "Tratta";
                break;
            }
            case 4: {
                retVal = "Partenza";
                break;
            }
            case 5: {
                retVal = "Arrivo";
                break;
            }
            case 6: {
                retVal = "Km inizio";
                break;
            }
            case 7: {
                retVal = "Km Fine";
                break;
            }
            case 8: {
                retVal = "Km Tot";
                break;
            }
            case 9: {
                retVal = "Km Vuoto";
                break;
            }
            default: {
                retVal = this.headers[i];
            }
        }
        return retVal;
    }

    @Override
    public int getRowCount() {
        return this.cache.size();
    }

    @Override
    public int getColumnCount() {
        return 10;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (!this.cache.isEmpty()) {
            String[] riga = this.cache.get(row);
            return riga[col];
        }
        return "";
    }

    public Class getColumnClass(int c) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void setDataReportKm(Vector vettoreViaggi) {
        try {
            String[] riga;
            this.cache = new ArrayList();
            Iterator i = vettoreViaggi.iterator();
            String targa_mem = "";
            Quantita km_tot = new Quantita(BigDecimal.ZERO);
            Quantita km_a_vuoto = new Quantita(BigDecimal.ZERO);
            Quantita km_tot_tot = new Quantita(BigDecimal.ZERO);
            Quantita km_a_vuoto_tot = new Quantita(BigDecimal.ZERO);
            while (i.hasNext()) {
                Viaggio v = (Viaggio)i.next();
                if (!v.getTarga_trattore().equals(targa_mem)) {
                    if (!this.cache.isEmpty()) {
                        riga = new String[]{"", "", "", "", "", "", "", "", "", ""};
                        riga[8] = km_tot.toString();
                        riga[9] = km_a_vuoto.toString();
                        km_tot = new Quantita(BigDecimal.ZERO);
                        km_a_vuoto = new Quantita(BigDecimal.ZERO);
                        this.cache.add(riga);
                    }
                    riga = new String[]{"", "", "", "", "", "", "", "", "", ""};
                    riga[0] = v.getTarga_trattore();
                    targa_mem = v.getTarga_trattore();
                    this.cache.add(riga);
                }
                riga = new String[]{"", "", "", "", "", "", "", "", "", ""};
                riga[0] = "" + v.getTarga_trattore();
                riga[1] = "" + v.getNumero_viaggio() + "/" + v.getAnno();
                riga[2] = v.getCognome_autista();
                riga[3] = "(" + v.getAr() + ")" + v.getTratta_complessiva();
                riga[4] = "" + v.getData_partenza_it();
                riga[5] = "" + v.getData_arrivo_it();
                riga[6] = "" + v.getKm_partenza();
                riga[7] = "" + v.getKm_arrivo();
                riga[8] = "" + v.getKm_percorsi();
                riga[9] = "" + v.getKm_a_vuoto();
                km_tot.plusplus(new Quantita(v.getKm_percorsi()));
                km_a_vuoto.plusplus(new Quantita(v.getKm_a_vuoto()));
                km_tot_tot.plusplus(new Quantita(v.getKm_percorsi()));
                km_a_vuoto_tot.plusplus(new Quantita(v.getKm_a_vuoto()));
                this.cache.add(riga);
            }
            riga = new String[]{"", "", "", "", "", "", "", "", "", ""};
            riga[8] = km_tot.toString();
            riga[9] = km_a_vuoto.toString();
            this.cache.add(riga);
            riga = new String[]{"", "", "", "", "", "", "", "", "", ""};
            riga[0] = "TOTALE";
            riga[8] = km_tot_tot.toString();
            riga[9] = km_a_vuoto_tot.toString();
            this.cache.add(riga);
            this.fireTableChanged(null);
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE:  eccezione setDataRegistro errore di istanziazione ");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE: setDataRegistro errore di avvio o di linkaggio dello specifico modulo");
            err.printStackTrace();
        }
    }
}

