/*
 * Decompiled with CFR 0.152.
 */
package trasporti.report_fatturato;

import anagrafiche.mezzi.InsiemeMezzi;
import anagrafiche.mezzi.Mezzo;
import gestionale.personalizzazione.stampe.PiedePaginaGenericoIntestato;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import trasporti.report_fatturato.FunzioniReportFatturato;
import trasporti.report_fatturato.RigaReport;
import utils.BannerWorking;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;
import utils.stampe.GestoreStampe;
import utils.stampe.OggettoToPrint;

public class StampaFatturati
implements Runnable {
    Funzioni f;
    FunzioniDate fda;
    int y;
    int y_inizio_senza_intestazione;
    Thread thread;
    String dataDA;
    String dataDA_girata;
    String dataA;
    String dataA_girata;
    Object[] riga;
    ArrayList<Object> fatturati_da_cliente_2;
    InsiemeMezzi im;
    FunzioniReportFatturato trasporti_report;
    int i = 0;
    float[] dash = new float[]{1.0f, 1.0f};

    public StampaFatturati(String dataDA, String dataA, InsiemeMezzi insieme_mezzi) {
        MyTrace.log.info("STAMPA FATTURATI TUTTI MEZZI   (START)");
        this.dataDA = dataDA;
        this.dataA = dataA;
        this.im = insieme_mezzi;
        this.f = new Funzioni();
        this.fda = new FunzioniDate();
        this.dataDA_girata = this.fda.gira_data(dataDA);
        this.dataA_girata = this.fda.gira_data(dataA);
        this.y = this.y_inizio_senza_intestazione = 10;
        MyTrace.log.info("STAMPA FATTURATI TUTTI MEZZI    (STOP)");
    }

    public void avvia() {
        this.thread = new Thread(this);
        MyTrace.log.info("avvio Procedura su Thread");
        this.thread.start();
    }

    @Override
    public void run() {
        BannerWorking attesa = new BannerWorking("ELABORAZIONE SU THREAD STAMPA FATTURATI TUTTI MEZZI");
        attesa.start();
        this.elabora_formattazione_stampa();
        attesa.stop();
    }

    private void elabora_formattazione_stampa() {
        try {
            MyTrace.log.info("STAMPA FATTURATI TUTTI MEZZI: XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX  INIZIO STAMPA XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
            GestoreStampe stampa = new GestoreStampe();
            stampa.aggiungi_pj();
            stampa.setFont(stampa.Font_Calibri_10_B);
            this.stampa_intestazione(stampa, this.y);
            stampa.setFont(stampa.Font_Calibri_12_B);
            String descr_primo = "";
            String targa_primo = "";
            if (!this.im.vettoreMacchine.isEmpty()) {
                Mezzo primo = (Mezzo)this.im.vettoreMacchine.elementAt(0);
                descr_primo = primo.getDescrizione();
                targa_primo = primo.getTarga();
                stampa.appendTextOvunque(descr_primo + "  targato " + targa_primo, 50, this.y + 75);
                stampa.appendLine(50, this.y + 80, 573, this.y + 80);
                ++this.i;
            }
            int indice_per_stampa_solo_prima_pagina = 0;
            Money money_Tot_Fatturati = new Money(BigDecimal.ZERO);
            int progressivo = 1;
            for (Mezzo m : this.im.vettoreMacchine) {
                Money money_Tot_Fatturati_Mezzo = new Money(BigDecimal.ZERO);
                Iterator<RigaReport> iteratore_valori = m.getFatturati_targa().iterator();
                while (iteratore_valori.hasNext()) {
                    stampa.setFont(stampa.Font_Calibri_9);
                    RigaReport riga = iteratore_valori.next();
                    if (indice_per_stampa_solo_prima_pagina == 0) {
                        this.y += 20;
                        ++indice_per_stampa_solo_prima_pagina;
                    }
                    stampa.appendTextOvunque("" + progressivo, 15, this.y + 75);
                    ++progressivo;
                    stampa.appendTextOvunque(riga.getData_partenza_it(), 40, this.y + 75);
                    stampa.appendStringaOvunqueFormattazioneDestra(riga.getNumero_viaggio(), 85, this.y + 75, 45);
                    stampa.appendTextOvunque(riga.getAutista(), 135, this.y + 75);
                    String d = riga.getDescrizione_viaggio();
                    if (riga.getDescrizione_viaggio().length() > 35) {
                        d = riga.getDescrizione_viaggio().substring(0, 35) + "...";
                    }
                    stampa.appendTextOvunque(d, 190, this.y + 75);
                    String c = riga.getCommittente();
                    if (riga.getCommittente().length() > 24) {
                        c = riga.getCommittente().substring(0, 24) + "..";
                    }
                    stampa.appendTextOvunque(riga.getNumero_ordine() + "(" + c + ")", 370, this.y + 75);
                    stampa.appendStringaOvunqueFormattazioneDestra(riga.getImporto_in_riga().toString(), 510, this.y + 75, 45);
                    this.y += 12;
                    stampa.appendLineTratteggiata(30, this.y + 75 - 9, 573, this.y + 75 - 9, this.dash, Color.gray);
                    if (this.y > 670) {
                        stampa.paginanuova();
                        this.y = this.y_inizio_senza_intestazione;
                        this.stampa_intestazione(stampa, this.y);
                    }
                    money_Tot_Fatturati.plusplus(riga.getImporto_in_riga());
                    money_Tot_Fatturati_Mezzo.plusplus(riga.getImporto_in_riga());
                }
                String S_money_Tot_Fatturati_Mezzo = "" + money_Tot_Fatturati_Mezzo;
                stampa.setFont(stampa.Font_Calibri_10_B);
                if (this.y > 670) {
                    stampa.paginanuova();
                    this.y = this.y_inizio_senza_intestazione;
                    this.stampa_intestazione(stampa, this.y);
                }
                stampa.appendLine(310, this.y + 75 - 9, 573, this.y + 75 - 9, Color.GRAY);
                this.y += 2;
                String tot__fatturato = "TOTALE FATTURATO";
                stampa.appendTextOvunque(tot__fatturato, 330, this.y + 75);
                stampa.appendStringaOvunqueFormattazioneDestra(S_money_Tot_Fatturati_Mezzo, 510, this.y + 75, 45);
                this.y += 25;
                if (this.y > 670) {
                    stampa.paginanuova();
                    this.y = this.y_inizio_senza_intestazione;
                    this.stampa_intestazione(stampa, this.y);
                }
                if (this.i < this.im.vettoreMacchine.size()) {
                    stampa.setFont(stampa.Font_Calibri_12_B);
                    Mezzo prima_riga = (Mezzo)this.im.vettoreMacchine.elementAt(this.i);
                    String prima_riga_descr = prima_riga.getDescrizione();
                    String targa_prima = prima_riga.getTarga();
                    String primariga = prima_riga_descr + " targato " + targa_prima;
                    stampa.appendTextOvunque(primariga, 50, this.y + 75);
                    stampa.appendLine(50, this.y + 80, 573, this.y + 80);
                    ++this.i;
                }
                this.y += 20;
                if (this.y <= 670) continue;
                stampa.paginanuova();
                this.y = this.y_inizio_senza_intestazione;
                this.stampa_intestazione(stampa, this.y);
            }
            String S_money_Tot_Fatturati = "" + money_Tot_Fatturati;
            if (this.y > 660) {
                stampa.paginanuova();
                this.y = this.y_inizio_senza_intestazione;
                this.stampa_intestazione(stampa, this.y);
            } else {
                this.y -= 20;
            }
            stampa.appendLine(30, this.y + 75, 573, this.y + 75);
            stampa.appendLine(30, this.y + 80, 573, this.y + 80);
            this.y += 20;
            stampa.appendRoundRect(170, this.y + 75, 250, 50, 10, 10);
            stampa.setFont(stampa.Font_Calibri_12_B);
            String tot_fatturati = "TOTALE FATTURATI";
            stampa.appendTextOvunque(tot_fatturati, 190, this.y + 104);
            stampa.appendStringaOvunqueFormattazioneDestra(S_money_Tot_Fatturati, 350, this.y + 104, 45);
            stampa.setFont(stampa.Font_Calibri_8);
            String date_now = this.fda.dataCorrente().replaceAll("-", "");
            String ora_now = this.fda.OraCorrente().replaceAll(":", "");
            String nome_file = this.f.pulisci_nome_file(date_now + ora_now + "_Fatturato_Tutti_Mezzi_Dal_" + this.dataDA_girata + "_Al_" + this.dataA_girata);
            stampa.getSeg().getMy_pj_corrente().getPj().setJobName(nome_file);
            stampa.setPiedePaginaGenericoIntestato((OggettoToPrint)new PiedePaginaGenericoIntestato("Fatturato"));
            stampa.print();
            MyTrace.log.info(" XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX STAMPA FATTURATI TUTTI MEZZI FINE XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE: eccezione elabora() nella stampa fatturato tutti mezzi");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE: elabora() errore di avvio o di linkaggio");
            err.printStackTrace();
        }
    }

    public void stampa_intestazione(GestoreStampe stampa, int altezza) {
        MyTrace.log.info("STAMPA INTESTAZIONE FATTURATI TUTTI MEZZI    START");
        stampa.appendRoundRect(18, altezza += 10, 555, 35, 10, 10);
        stampa.setFont(stampa.Font_Calibri_12_B);
        stampa.appendTextOvunque("Fatturati degli automezzi dal " + this.dataDA_girata + " al " + this.dataA_girata, 30, altezza + 10 + 3);
        stampa.appendTextOvunque("Data", 40, altezza + 10 + 18);
        stampa.appendTextOvunque("N\u00b0viaggio", 85, altezza + 10 + 18);
        stampa.appendTextOvunque("Autista", 135, altezza + 10 + 18);
        stampa.appendTextOvunque("Tratta", 190, altezza + 10 + 18);
        stampa.appendTextOvunque("N\u00b0Ordine", 350, altezza + 10 + 18);
        stampa.appendTextOvunque("Importo", 520, altezza + 10 + 18);
        stampa.setFont(stampa.Font_Calibri_10_B);
        MyTrace.log.info("STAMPA INTESTAZIONE FATTURATI TUTTI MEZZI   STOP");
    }
}

