/*
 * Decompiled with CFR 0.152.
 */
package trasporti.report_fatturato;

import anagrafiche.mezzi.InsiemeMezzi;
import anagrafiche.mezzi.Mezzo;
import java.util.ArrayList;
import java.util.Iterator;
import trasporti.report_fatturato.RigaReport;
import trasporti.viaggi.InsiemeViaggi;
import trasporti.viaggi.Viaggio;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.MyTrace;

public class FunzioniReportFatturato {
    Funzioni f = new Funzioni();
    FunzioniDate fda = new FunzioniDate();
    String dataDA;
    String dataDA_girata;
    String dataA;
    String dataA_girata;

    public void estrazione_fatturato_singolo_mezzo(Mezzo m, String dataDA, String dataA) {
        MyTrace.log.info("estrazione_fatturato_singolo_mezzo: trasporti.report   (START)");
        try {
            this.dataDA_girata = this.fda.gira_data(dataDA);
            this.dataA_girata = this.fda.gira_data(dataA);
            ArrayList<RigaReport> insieme_righe = new ArrayList<RigaReport>();
            for (Viaggio viaggio : m.getInsieme_viaggi().vettoreV) {
                RigaReport r = new RigaReport();
                r.setData_partenza_it(viaggio.getData_partenza_it());
                r.setNumero_viaggio(viaggio.getNumero_viaggio() + "/" + viaggio.getAnno());
                r.setAutista(viaggio.getCognome_autista());
                r.setDescrizione_viaggio(viaggio.getDesc_breve());
                r.setKm_percorsi(viaggio.getKm_percorsi());
                String[] numeri = viaggio.getOrdini_in_viaggio().contains(",") ? viaggio.getOrdini_in_viaggio().split(",") : new String[]{viaggio.getOrdini_in_viaggio()};
                for (int k = 0; k < numeri.length; ++k) {
                    String[] na = numeri[k].split("/");
                    for (int j = 0; j < na.length; ++j) {
                        na[j] = na[j].trim();
                    }
                    int numero = Integer.parseInt(na[0]);
                    int anno = Integer.parseInt(na[1]);
                    InsiemeViaggi iv = new InsiemeViaggi();
                    String where = " WHERE mtra_ordini.numero_ordine=" + numero + " " + " and mtra_ordini.anno = " + anno + "" + " and mo.numero_ordine=" + numero + "" + " and mo.anno=" + anno + " ";
                    iv.caricamento_da_ordine(where, "");
                    for (Viaggio v_temp : iv.vettoreV) {
                        if (v_temp.getId() != viaggio.getId()) continue;
                        r.setImporto_in_riga(r.getImporto_in_riga().plus(v_temp.getFatturato()));
                        r.setKm_totali_ordine(r.getKm_totali_ordine() + v_temp.getTot_km_ordine());
                        r.setImporto_fatturato(r.getImporto_fatturato().plus(v_temp.getTot_ordine_fattura()));
                        r.setCommittente(v_temp.getClienti_in_viaggio());
                        r.setNumero_ordine(v_temp.getOrdini_in_viaggio());
                    }
                }
                insieme_righe.add(r);
            }
            m.setFatturati_targa(insieme_righe);
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE: eccezione 'estrazione_manutenzioni_singolo_mezzo' nella stampa lista manutenzioni");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE: 'estrazione_manutenzioni_singolo_mezzo' errore di avvio o di linkaggio");
            err.printStackTrace();
        }
        MyTrace.log.info("estrazione_fatturato_singolo_mezzo: trasporti.report   (STOP)");
    }

    public InsiemeMezzi estrazione_fatturati_tutti_mezzi(String dataDA, String dataA, String targa) {
        InsiemeMezzi insiemeMezzi = new InsiemeMezzi();
        try {
            String where = " WHERE mtra_viaggi.data_partenza between '" + dataDA + "' and '" + dataA + "'  " + "and (mtra_viaggi.id_mezzo <> 0 OR mtra_viaggi.id_mezzo IS NOT NULL) ";
            if (!targa.equals("")) {
                where = where + " AND mtra_mezzi.targa='" + targa + "' ";
            }
            String order_by = " ORDER BY mtra_viaggi.id_mezzo, mtra_viaggi.data_partenza ";
            InsiemeViaggi insieme_viaggi = new InsiemeViaggi();
            insieme_viaggi.caricamento(where, order_by, false);
            Iterator i_viaggi = insieme_viaggi.vettoreV.iterator();
            Mezzo ultimo_mezzo = new Mezzo();
            while (i_viaggi.hasNext()) {
                Viaggio v = (Viaggio)i_viaggi.next();
                if (v.getId_trattore() != ultimo_mezzo.getId_macchina()) {
                    ultimo_mezzo = new Mezzo();
                    ultimo_mezzo.setId_macchina(v.getId_trattore());
                    ultimo_mezzo.setTarga(v.getTarga_trattore());
                    ultimo_mezzo.setDescrizione(v.getDescrizione_trattore());
                    ultimo_mezzo.setInsieme_viaggi(new InsiemeViaggi());
                    ultimo_mezzo.getInsieme_viaggi().vettoreV.add(v);
                    insiemeMezzi.vettoreMacchine.add(ultimo_mezzo);
                    continue;
                }
                ultimo_mezzo.getInsieme_viaggi().vettoreV.add(v);
            }
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE: 'eccezione estrazione_fatturati_tutti_mezzi' nella stampa lista fatturati");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE: 'estrazione_fatturati_tutti_mezzi' errore di avvio o di linkaggio");
            err.printStackTrace();
        }
        for (Mezzo m : insiemeMezzi.vettoreMacchine) {
            this.estrazione_fatturato_singolo_mezzo(m, dataDA, dataA);
        }
        return insiemeMezzi;
    }
}

