/*
 * Decompiled with CFR 0.152.
 */
package trasporti.prese_consegne;

import gestionale.MyDesktopWindow;
import gestionale.configurazioni.Configurazioni;
import java.math.BigDecimal;
import java.sql.ResultSet;
import trasporti.indirizzi.IndirizzoPresaConsegna;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.MyTrace;
import utils.Quantita;

public class PresaConsegna {
    String tipo;
    private int id_pc;
    private int id_tipologia_merce;
    private String ragione_sociale;
    private String unitaMisura;
    private String tipologia_merce;
    private String data;
    private String ora = "00:00";
    private String n_ordine;
    private String dettaglio = "";
    private String n_ordine_leo;
    private int id_ordine;
    private int id_luogo;
    private int id_um;
    private int id_viaggio;
    private int ordine;
    private int ordine_viaggio;
    private IndirizzoPresaConsegna luogo;
    private Quantita quantita = new Quantita(BigDecimal.ZERO);
    private boolean assegnato;
    private Funzioni f = new Funzioni();
    private FunzioniDate fda = new FunzioniDate();

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public int getId_pc() {
        return this.id_pc;
    }

    public void setId_pc(int id_pc) {
        this.id_pc = id_pc;
    }

    public String getN_ordine() {
        return this.n_ordine;
    }

    public void setN_ordine(String n_ordine) {
        this.n_ordine = n_ordine;
    }

    public String getOra() {
        return this.ora;
    }

    public void setOra(String ora) {
        this.ora = ora;
    }

    public int getId_tipologia_merce() {
        return this.id_tipologia_merce;
    }

    public void setId_tipologia_merce(int id_tipologia_merce) {
        this.id_tipologia_merce = id_tipologia_merce;
    }

    public int getId_luogo() {
        return this.id_luogo;
    }

    public void setId_luogo(int id_luogo) {
        this.id_luogo = id_luogo;
    }

    public int getId_ordine() {
        return this.id_ordine;
    }

    public void setId_ordine(int id_ordine) {
        this.id_ordine = id_ordine;
    }

    public int getId_um() {
        return this.id_um;
    }

    public void setId_um(int id_um) {
        this.id_um = id_um;
    }

    public int getId_viaggio() {
        return this.id_viaggio;
    }

    public void setId_viaggio(int id_viaggio) {
        this.id_viaggio = id_viaggio;
        if (id_viaggio != 0) {
            this.setAssegnato(true);
        }
    }

    public IndirizzoPresaConsegna getLuogo() {
        return this.luogo;
    }

    public void setLuogo(IndirizzoPresaConsegna luogo) {
        this.luogo = luogo;
    }

    public Quantita getQuantita() {
        return this.quantita;
    }

    public void setQuantita(Quantita quantita) {
        this.quantita = quantita;
    }

    public String getData_it() {
        return this.fda.gira_data(this.data);
    }

    public String getTipo() {
        return this.tipo;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    public String getRagione_sociale() {
        return this.ragione_sociale;
    }

    public void setRagione_sociale(String ragione_sociale) {
        this.ragione_sociale = ragione_sociale;
    }

    public boolean isAssegnato() {
        return this.assegnato;
    }

    public void setAssegnato(boolean assegnato) {
        this.assegnato = assegnato;
    }

    public String getDettaglio() {
        return this.dettaglio;
    }

    public void setDettaglio(String dettaglio) {
        this.dettaglio = dettaglio;
    }

    public int getOrdine() {
        return this.ordine;
    }

    public void setOrdine(int ordine) {
        this.ordine = ordine;
    }

    public int getOrdine_viaggio() {
        return this.ordine_viaggio;
    }

    public void setOrdine_viaggio(int ordine_viaggio) {
        this.ordine_viaggio = ordine_viaggio;
    }

    public String getUnitaMisura() {
        return this.unitaMisura;
    }

    public void setUnitaMisura(String unitaMisura) {
        this.unitaMisura = unitaMisura;
    }

    public String getTipologia_merce() {
        return this.tipologia_merce;
    }

    public void setTipologia_merce(String tipologia_merce) {
        this.tipologia_merce = tipologia_merce;
    }

    public String getN_ordine_leo() {
        return this.n_ordine_leo;
    }

    public void setN_ordine_leo(String n_ordine_leo) {
        this.n_ordine_leo = n_ordine_leo;
    }

    public boolean inserisciPC(boolean da_solo) {
        String query_ins;
        boolean r_ins;
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(r_ins = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_ins = "INSERT INTO mtra_prese_consegne(presa_consegna,id_ordine,data,ora,id_indirizzo,id_um,quantita,id_tipologia_merce,n_ordine,note,ordine) VALUES ('" + this.getTipo() + "'," + this.f.zero_to_null(this.getId_ordine()) + ",'" + this.getData() + "','" + this.getOra() + "'," + this.f.zero_to_null(this.getId_luogo()) + "," + this.getId_um() + "," + "" + this.getQuantita() + "," + "" + this.getId_tipologia_merce() + "," + "'" + this.getN_ordine() + "','" + this.getDettaglio().replaceAll("'", "''") + "'," + this.getOrdine() + ")"))) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Inserimento mtra_prese_consegne non riuscito");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        String strSQL = "SELECT @@identity FROM mtra_prese_consegne";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(strSQL);
        int id_inserito = 0;
        try {
            while (res.next()) {
                id_inserito = res.getInt("@@identity");
            }
        }
        catch (Exception e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        this.setId_pc(id_inserito);
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mtra_prese_consegne','" + this.getId_pc() + "',NOW(),'INS','" + query_ins.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Inserimento pc non riuscito per trace");
            Configurazioni.eccezione.gestisci("2.3", null);
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    public boolean modificaPC(boolean da_solo) {
        String query_mod;
        boolean r_mod;
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod = "UPDATE mtra_prese_consegne SET data='" + this.getData() + "'," + " ora='" + this.getOra() + "'," + " presa_consegna='" + this.getTipo() + "'," + " id_indirizzo=" + this.getId_luogo() + "," + " id_um=" + this.getId_um() + "," + " id_ordine=" + this.f.zero_to_null(this.getId_ordine()) + "," + " quantita=" + this.getQuantita() + "," + " id_tipologia_merce='" + this.getId_tipologia_merce() + "'," + " note='" + this.getDettaglio() + "'," + " ordine='" + this.getOrdine() + "'," + " n_ordine='" + this.getN_ordine() + "'" + " WHERE idmtra_prese_consegne='" + this.getId_pc() + "'"))) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Modifica mtra_prese_consegne non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mtra_prese_consegne','" + this.getId_pc() + "',NOW(),'MOD','" + query_mod.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Modifica mtra_prese_consegne non riuscita per trace");
            Configurazioni.getIstanza().connessione.rollback();
            Configurazioni.eccezione.gestisci("3.3", null);
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    public boolean assegnaAViaggio(boolean da_solo) {
        String query_mod;
        boolean r_mod;
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod = "UPDATE mtra_prese_consegne SET id_viaggio=" + this.f.zero_to_null(this.getId_viaggio()) + ",ordine_viaggio=" + this.getOrdine_viaggio() + "" + " WHERE idmtra_prese_consegne=" + this.getId_pc() + " "))) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Modifica mtra_prese_consegne non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mtra_prese_consegne','" + this.getId_pc() + "',NOW(),'MOD','" + query_mod.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Modifica mtra_prese_consegne non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.3", null);
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    public boolean cambiaOrdinamentoViaggio(boolean da_solo) {
        String query_mod;
        boolean r_mod;
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod = "UPDATE mtra_prese_consegne SET ordine_viaggio=" + this.getOrdine_viaggio() + "" + " WHERE idmtra_prese_consegne='" + this.getId_pc() + "'"))) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Modifica mtra_prese_consegne non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mtra_prese_consegne','" + this.getId_pc() + "',NOW(),'MOD','" + query_mod.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Modifica mtra_prese_consegne non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.3", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    public void seleziona() {
        String q = "SELECT * FROM mtra_prese_consegne WHERE idmtra_prese_consegne=" + this.getId_pc();
        try {
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(q);
            while (res.next()) {
                this.setId_pc(res.getInt("id_presa"));
                this.setTipo(res.getString("presa_consegna"));
                this.setData(res.getString("data"));
                this.setId_ordine(res.getInt("id_ordine"));
                this.setId_luogo(res.getInt("id_indirizzo"));
                this.setId_um(res.getInt("id_um"));
                this.setOra(res.getString("ora"));
                this.setQuantita(new Quantita(res.getDouble("quantita")));
                this.setId_tipologia_merce(res.getInt("id_tipologia_merce"));
                this.setN_ordine(res.getString("n_ordine"));
                this.setOrdine(res.getInt("ordine"));
                this.setLuogo(new IndirizzoPresaConsegna());
                this.getLuogo().setId(this.getId_luogo());
                this.getLuogo().seleziona_da_id();
                this.setId_viaggio(res.getInt("id_viaggio"));
                this.setDettaglio(res.getString("note"));
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        }
        catch (Exception e) {
            MyTrace.log.severe("Seleziona Presa/Cons non riuscito");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.2", null);
        }
    }

    public int seleziona_id_ordine(int id) {
        String q = "SELECT mtra_prese_consegne.id_ordine FROM mtra_prese_consegne WHERE idmtra_prese_consegne=" + id;
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(q);
        int id_ordine = 0;
        try {
            while (res.next()) {
                id_ordine = res.getInt("id_ordine");
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        }
        catch (Exception e) {
            MyTrace.log.severe("Seleziona id_ordine Presa/Cons non riuscito");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.2", null);
        }
        return id_ordine;
    }

    public void seleziona_dettagli() {
        this.setLuogo(new IndirizzoPresaConsegna());
        this.getLuogo().setId(this.getId_luogo());
        this.getLuogo().seleziona_da_id();
    }

    public boolean eliminaPC(boolean da_solo) {
        String query_del;
        boolean r_del;
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(r_del = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_del = "DELETE FROM mtra_prese_consegne WHERE idmtra_prese_consegne=" + this.getId_pc()))) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Delete mtra_prese_consegne non riuscito");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mtra_prese_consegne','" + this.getId_pc() + "',NOW(),'DEL','" + query_del.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Del mtra_prese_consegne non riuscito per trace");
            Configurazioni.eccezione.gestisci("2.3", null);
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    Object getColValue(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                retVal = "" + this.getTipo();
                break;
            }
            case 1: {
                retVal = "" + this.getData_it();
                break;
            }
            case 2: {
                retVal = "" + this.getOra();
                break;
            }
            case 3: {
                retVal = "" + this.getN_ordine();
                break;
            }
            case 4: {
                retVal = "" + this.getLuogo().getIndirizzoCompleto();
                break;
            }
            case 5: {
                retVal = "" + this.getQuantita();
                break;
            }
            case 6: {
                retVal = "" + this.getUnitaMisura();
                break;
            }
            case 7: {
                retVal = "" + this.getTipologia_merce();
                break;
            }
            case 8: {
                retVal = "" + this.getDettaglio();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }

    Object getColValuePC(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                retVal = "" + this.getTipo();
                break;
            }
            case 1: {
                retVal = "" + this.getData_it();
                break;
            }
            case 2: {
                retVal = "" + this.getRagione_sociale();
                break;
            }
            case 3: {
                retVal = "" + this.getLuogo().getIndirizzoCompleto();
                break;
            }
            case 4: {
                retVal = "" + this.getN_ordine();
                break;
            }
            case 5: {
                retVal = "" + this.getN_ordine_leo();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }

    Object getColValueView(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                retVal = "" + this.getTipo();
                break;
            }
            case 1: {
                retVal = "" + this.getData_it() + " / " + this.getOra();
                break;
            }
            case 2: {
                retVal = "" + this.getLuogo().getCodice_pt();
                break;
            }
            case 3: {
                retVal = "" + this.getLuogo().getIndirizzoCompleto();
                break;
            }
            case 4: {
                retVal = "" + this.getDettaglio();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }

    Object getColValueRiassunto(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                retVal = "" + this.getTipo();
                break;
            }
            case 1: {
                retVal = "" + this.getData_it() + " / " + this.getOra();
                break;
            }
            case 2: {
                retVal = "" + this.getLuogo().getCodice_pt();
                break;
            }
            case 3: {
                retVal = "" + this.getN_ordine();
                break;
            }
            case 4: {
                retVal = "" + this.getId_viaggio();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }
}

