/*
 * Decompiled with CFR 0.152.
 */
package trasporti.prese_consegne;

import gestionale.configurazioni.Configurazioni;
import java.sql.ResultSet;
import java.util.Iterator;
import java.util.Vector;
import trasporti.indirizzi.IndirizzoPresaConsegna;
import trasporti.prese_consegne.PresaConsegna;
import utils.Funzioni;
import utils.MyTrace;
import utils.Quantita;

public class InsiemePC {
    public Vector vettorePC = new Vector();
    public Vector pc_assegnati = new Vector();
    int colCount;
    public String[] headers;

    public int caricamento(String where, String order_by) {
        this.vettorePC = new Vector();
        this.pc_assegnati = new Vector();
        String query = "SELECT mtra_prese_consegne.presa_consegna as tipo,        mtra_prese_consegne.idmtra_prese_consegne as id_pc,        mtra_prese_consegne.id_ordine as id_ordine,        anag_anagrafica.ragione_sociale,mtra_prese_consegne.id_viaggio as id_viaggio,mtra_prese_consegne.ora as ora,mtra_prese_consegne.data as data,mtra_prese_consegne.id_indirizzo as id_luogo,mtra_prese_consegne.id_um as id_um,conf_unita_di_misura.codice as unita_misura,mtra_prese_consegne.quantita as quantita,mtra_prese_consegne.id_tipologia_merce as id_tipologia_merce,mtra_tipologie_merce.nome_tipologia as tipologia_merce,mtra_prese_consegne.n_ordine as n_ordine, mtra_prese_consegne.ordine as ordine,mtra_prese_consegne.ordine_viaggio as ordine_viaggio,mtra_prese_consegne.note as note,mtra_ordini.numero_ordine,mtra_ordini.anno as anno_ordine         FROM mtra_prese_consegne LEFT JOIN mtra_ordini on mtra_prese_consegne.id_ordine=mtra_ordini.id_ordine LEFT JOIN conf_unita_di_misura on mtra_prese_consegne.id_um=conf_unita_di_misura.id LEFT JOIN mtra_tipologie_merce on mtra_prese_consegne.id_tipologia_merce=mtra_tipologie_merce.idmtra_tipologie_merce LEFT JOIN anag_anagrafica ON mtra_ordini.id_anagrafica=anag_anagrafica.idanagrafica ";
        query = query + " " + where;
        query = query + " " + order_by;
        try {
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
            while (res.next()) {
                PresaConsegna pc = new PresaConsegna();
                pc.setTipo(res.getString("tipo"));
                pc.setRagione_sociale(res.getString("ragione_sociale"));
                pc.setId_pc(res.getInt("id_pc"));
                pc.setData(res.getString("data"));
                pc.setId_ordine(res.getInt("id_ordine"));
                pc.setId_luogo(res.getInt("id_luogo"));
                pc.setId_um(res.getInt("id_um"));
                pc.setUnitaMisura(res.getString("unita_misura"));
                pc.setOra(res.getString("ora"));
                pc.setQuantita(new Quantita(res.getDouble("quantita")));
                pc.setId_tipologia_merce(res.getInt("id_tipologia_merce"));
                pc.setTipologia_merce(res.getString("tipologia_merce"));
                pc.setN_ordine(res.getString("n_ordine"));
                pc.setOrdine(res.getInt("ordine"));
                pc.setOrdine_viaggio(res.getInt("ordine_viaggio"));
                pc.setLuogo(new IndirizzoPresaConsegna());
                pc.getLuogo().setId(pc.getId_luogo());
                pc.getLuogo().seleziona_da_id();
                pc.setId_viaggio(res.getInt("id_viaggio"));
                pc.setDettaglio(res.getString("note"));
                pc.setN_ordine_leo(res.getString("numero_ordine") + "/" + res.getInt("anno_ordine"));
                if (pc.getId_viaggio() != 0) {
                    pc.setAssegnato(true);
                } else {
                    pc.setAssegnato(false);
                }
                this.pc_assegnati.addElement(pc.isAssegnato());
                this.vettorePC.addElement(pc);
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        }
        catch (Exception e) {
            this.vettorePC = new Vector();
            MyTrace.log.severe("Seleziona PreseConsegne non riuscito");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.2", null);
        }
        return this.vettorePC.size();
    }

    public int conta_prese() {
        int count = 0;
        for (PresaConsegna pc : this.vettorePC) {
            if (!pc.getTipo().equals("P")) continue;
            ++count;
        }
        return count;
    }

    public int conta_consegne() {
        int count = 0;
        for (PresaConsegna pc : this.vettorePC) {
            if (!pc.getTipo().equals("C")) continue;
            ++count;
        }
        return count;
    }

    public PresaConsegna prima_presa() {
        PresaConsegna prima_presa = new PresaConsegna();
        Iterator i_rv = this.vettorePC.iterator();
        int indice_prima_presa = 1000;
        while (i_rv.hasNext()) {
            PresaConsegna pc = (PresaConsegna)i_rv.next();
            if (!pc.getTipo().equals("P") || pc.getOrdine() > indice_prima_presa) continue;
            indice_prima_presa = pc.getOrdine();
            prima_presa = pc;
        }
        MyTrace.log.info("Indice prima presa=" + indice_prima_presa + " Prima Presa=" + prima_presa.getLuogo().getCodice_pt());
        return prima_presa;
    }

    public PresaConsegna ultima_cons() {
        PresaConsegna ultima_cons = new PresaConsegna();
        Iterator i_rv = this.vettorePC.iterator();
        int indice_ultima_consegna = 0;
        while (i_rv.hasNext()) {
            PresaConsegna pc = (PresaConsegna)i_rv.next();
            if (!pc.getTipo().equals("C") || pc.getOrdine() < indice_ultima_consegna) continue;
            indice_ultima_consegna = pc.getOrdine();
            ultima_cons = pc;
        }
        MyTrace.log.info("Indice ultima consegna=" + indice_ultima_consegna + " Ultrima Cons=" + ultima_cons.getLuogo().getCodice_pt());
        return ultima_cons;
    }
}

