/*
 * Decompiled with CFR 0.152.
 */
package trasporti.ordini;

import anagrafiche.clienti_fornitori.Anagrafica;
import java.math.BigDecimal;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.table.AbstractTableModel;
import trasporti.listini.Opzione;
import trasporti.ordini.Ordine;
import trasporti.ordini.RigaOrdineViaggio;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.Quantita;

public class RigheOrdiniViaggiTableModel
extends AbstractTableModel {
    public ArrayList<RigaOrdineViaggio> cache;
    int colCount;
    String[] headers;
    Funzioni f = new Funzioni();
    FunzioniDate fda = new FunzioniDate();

    public RigheOrdiniViaggiTableModel() {
        this.cache = new ArrayList();
    }

    @Override
    public String getColumnName(int i) {
        String retVal = "";
        switch (i) {
            case 0: {
                retVal = "N. Ordine";
                break;
            }
            case 1: {
                retVal = "Cliente";
                break;
            }
            case 2: {
                retVal = "T/O";
                break;
            }
            case 3: {
                retVal = "Codice";
                break;
            }
            case 4: {
                retVal = "Descrizione";
                break;
            }
            case 5: {
                retVal = "Quantit\u00e0";
                break;
            }
            case 6: {
                retVal = "UM";
                break;
            }
            case 7: {
                retVal = "Prezzo/UM";
                break;
            }
            case 8: {
                retVal = "Prezzo Forfait";
                break;
            }
            case 9: {
                retVal = "Prezzo Tot";
                break;
            }
            default: {
                retVal = this.headers[i];
            }
        }
        return retVal;
    }

    @Override
    public int getRowCount() {
        return this.cache.size();
    }

    @Override
    public int getColumnCount() {
        return 10;
    }

    @Override
    public Object getValueAt(int row, int col) {
        RigaOrdineViaggio ro = new RigaOrdineViaggio();
        if (!this.cache.isEmpty()) {
            ro = this.cache.get(row);
            return ro.getColValue(col);
        }
        return "";
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        String v;
        RigaOrdineViaggio ro = new RigaOrdineViaggio();
        ro = this.cache.get(row);
        if (col == 0 && !(v = value.toString()).equals("")) {
            String n = v.substring(0, v.indexOf("/"));
            String anno = v.substring(v.indexOf("/") + 1, v.length());
            Ordine o = new Ordine();
            o.seleziona(" where numero_ordine=" + n + " AND anno=" + anno);
            ro.setId_ordine(o.getId());
            ro.setNumero_ordine("" + o.getN_ordine() + "/" + o.getAnno_ordine());
            ro.setFatturare_a(o.getRagione_sociale());
            this.fireTableRowsUpdated(row, row);
        }
        if (col == 1) {
            Anagrafica a = new Anagrafica();
            a.seleziona_da_ragione(value.toString(), "C");
            ro.setFatturare_a(a.getRagione_sociale());
            ro.setId_fatturare_a(a.getIdanag());
        }
        if (col == 3) {
            Opzione o = new Opzione();
            o.setCod_opzione(value.toString());
            o.seleziona();
            ro.setId_opzione(o.getId());
            ro.setOpzione(o);
            ro.setCodice_riga(o.getCod_opzione());
            ro.setDescrizione_riga(o.getDescrizione());
            boolean prezzo_trovato = ro.getOpzione().seleziona_prezzo_anag(ro.getId_fatturare_a());
            if (prezzo_trovato) {
                ro.setP_um(ro.getOpzione().getP());
            } else {
                ro.setP_um(new Money(BigDecimal.ZERO));
            }
        }
        if (col == 5) {
            ro.setQuantita(new Quantita(value.toString()));
        }
        if (col == 7) {
            ro.setP_um(new Money(value.toString()));
        }
        if (col == 8) {
            ro.setP_for(new Money(value.toString()));
        }
        this.fireTableRowsUpdated(row, row);
    }

    public Class getColumnClass(int c) {
        if (c == 0) {
            return JCheckBox.class;
        }
        if (c == 3) {
            return JComboBox.class;
        }
        if (c == 1) {
            return JPanel.class;
        }
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        RigaOrdineViaggio ro = this.cache.get(row);
        if (ro.getId_riga_documento() == 0) {
            if (this.getValueAt(row, 2).toString().equals("O")) {
                return col == 0 || col == 3 || col == 5 || col == 7 || col == 8 || col == 1;
            }
            if (this.getValueAt(row, 2).toString().equals("T")) {
                return col == 5 || col == 7 || col == 8 || col == 1;
            }
            return false;
        }
        return false;
    }

    public void setDataRiga(ArrayList<RigaOrdineViaggio> vettorePNR) {
        this.cache = new ArrayList();
        for (RigaOrdineViaggio ro : vettorePNR) {
            this.cache.add(ro);
        }
        this.fireTableChanged(null);
    }
}

