/*
 * Decompiled with CFR 0.152.
 */
package trasporti.ordini;

import gestionale.configurazioni.ConfigurazioneFinestre;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTMLEditorKit;
import trasporti.bolle.Bolla;
import trasporti.ordini.Ordine;
import trasporti.ordini.RigaOrdineViaggio;
import trasporti.ordini.StampaOrdine;
import trasporti.prese_consegne.PresaConsegna;
import trasporti.viaggi.Viaggio;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;

public class MyDettaglioOrdine
extends JInternalFrame {
    Ordine o_selezione;
    Funzioni ff = new Funzioni();
    FunzioniDate fda = new FunzioniDate();
    Vector vettore_editor_pane = new Vector();
    Vector vettoreO = new Vector();
    private JButton jButtonSalva;
    private JButton jButtonStampa;
    private JEditorPane jEditorPane;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator6;
    private JTabbedPane jTabbedPane1;
    private JToolBar jToolBar1;

    public MyDettaglioOrdine(Ordine o) {
        this.o_selezione = o;
        this.initComponents();
        this.o_selezione.seleziona_dettagli();
        this.o_selezione.seleziona_viaggi();
        this.riempi_campi();
        this.setLocation(ConfigurazioneFinestre.GetPoint(this.getClass().getName(), new Point(200, 0)));
        this.setSize(ConfigurazioneFinestre.GetDimension(this.getClass().getName(), new Dimension(800, 600)));
    }

    public MyDettaglioOrdine(Vector vettore_ordini) {
        this.vettoreO = vettore_ordini;
        this.initComponents();
        for (Ordine o : this.vettoreO) {
            o.seleziona_dettagli();
            o.seleziona_viaggi();
        }
        this.setLocation(ConfigurazioneFinestre.GetPoint(this.getClass().getName(), new Point(200, 0)));
        this.setSize(ConfigurazioneFinestre.GetDimension(this.getClass().getName(), new Dimension(800, 600)));
    }

    private void riempi_campi() {
        try {
            File f = new File(Funzioni.CartellaPerStampe() + System.getProperty("file.separator") + "ordine.html");
            BufferedWriter bw = new BufferedWriter(new FileWriter(f));
            bw.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\"><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" /><title>Dettaglio Ordine</title></head>");
            bw.write("<LINK REL =\"stylesheet\" TYPE=\"text/css\" HREF=\"config/style.css\" TITLE=\"Style\">");
            bw.write("<body style=\"font-family:Verdana, Geneva, sans-serif;font-size:10px;\">");
            bw.write("<p style=\"font-weight:bolder;font-size:14px;\">ORDINE N\u00b0 " + this.o_selezione.getN_ordine() + "/" + this.o_selezione.getAnno_ordine() + "</p>");
            bw.write("<p><strong>DATA ORDINE:</strong><span class=\"testo\">" + this.o_selezione.getData_ordineIt() + "</span></p>");
            bw.write("<p ><strong>COMMITTENTE:</strong><span class=\"testo\">  [C" + this.o_selezione.getA_cliente().getCodice() + "] " + this.o_selezione.getA_cliente().getRagione_sociale() + "</span></p>");
            if (this.o_selezione.getId_acliente1() != 0 && this.o_selezione.getA_cliente1() != null) {
                bw.write("<p ><strong>COMMITTENTE 2:</strong><span class=\"testo\">  [C" + this.o_selezione.getA_cliente1().getCodice() + "] " + this.o_selezione.getA_cliente1().getRagione_sociale() + "</span></p>");
            }
            if (this.o_selezione.getId_acliente2() != 0 && this.o_selezione.getA_cliente2() != null) {
                bw.write("<p ><strong>COMMITTENTE 3:</strong><span class=\"testo\">  [C" + this.o_selezione.getA_cliente2().getCodice() + "] " + this.o_selezione.getA_cliente2().getRagione_sociale() + "</span></p>");
            }
            bw.write("<p><strong>TRATTA COMPLESSIVA:</strong><span class=\"testo\">" + this.o_selezione.getTratta_complessiva() + "</span></p>");
            bw.write("<p ><strong>ANNOTAZIONI ORDINE:</strong><span class=\"testo\">" + this.o_selezione.getNote() + "</span></p>");
            bw.write("<p ><strong>PRESE E CONSEGNE:</strong></p>");
            bw.write("<table width=\"90%\" border=\"1\" cellspacing=\"0\">");
            bw.write("<tr>");
            bw.write("<TD width=\"4%\"><strong>P/C</strong></TD><TD  width=\"12%\"><strong>DATA</strong></TD><TD width=\"21%\"><strong>rif Cliente</strong></TD><TD width=\"51%\"><strong>Luogo</strong></TD><TD width=\"8%\"><strong>Quantit\u00e0</strong></TD><TD width=\"4%\"><strong>UM</strong></TD>");
            bw.write("</tr>");
            for (PresaConsegna pc : this.o_selezione.getInsieme_pc().vettorePC) {
                bw.write("<tr>");
                bw.write("<TD>" + pc.getTipo() + "</TD>" + "<TD>" + pc.getData_it() + "</TD>" + "<TD>" + pc.getN_ordine() + "</TD>" + "<TD>" + pc.getLuogo().getIndirizzoCompleto() + "</TD>" + "<TD>" + pc.getQuantita() + "</TD>" + "<TD>" + pc.getUnitaMisura() + "</TD>");
                bw.write("</tr>");
            }
            bw.write("</table>");
            bw.write("<p ><strong>RIGHE FATTURE ATTIVE:</strong></p>");
            bw.write("<table width=\"90%\" border=\"1\" cellspacing=\"0\">");
            bw.write("<tr>");
            bw.write("<TD width=\"6%\"><strong>Fattura Num</strong></TD><TD  width=\"10%\"><strong>Data Fattura</strong></TD><TD width=\"4%\"><strong>T/O</strong></TD><TD  width=\"10%\"><strong>CODICE</strong></TD><TD width=\"20%\"><strong>DESCRIZIONE</strong></TD><TD width=\"10%\"><strong>Quantit\u00e0</strong></TD><TD width=\"8%\"><strong>UM</strong></TD><TD width=\"12%\"><strong>Prezzo/Um</strong></TD><TD width=\"12%\"><strong>Prezzo For</strong></TD><TD width=\"12%\"><strong>Tot</strong></TD>");
            bw.write("</tr>");
            Iterator<RigaOrdineViaggio> j = this.o_selezione.getInsieme_r().vettoreR.iterator();
            Money totale = new Money(BigDecimal.ZERO);
            while (j.hasNext()) {
                RigaOrdineViaggio rov = j.next();
                bw.write("<tr>");
                bw.write("<TD>" + rov.getNumero_fattura_attiva() + "</TD>" + "<TD>" + this.fda.gira_data(rov.getData_fattura_attiva()) + "</TD>" + "<TD>" + rov.getT_o() + "</TD>" + "<TD>" + rov.getCodice_riga() + "</TD>" + "<TD>" + rov.getDescrizione_riga() + "</TD>" + "<TD>" + this.ff.formattaNumero("" + rov.getQuantita(), "#0.000") + "</TD>" + "<TD>" + rov.getCodice_um() + "</TD>" + "<TD>" + rov.getP_um() + "</TD>" + "<TD>" + rov.getP_for() + "</TD>" + "<TD>" + rov.getP_tot_riga() + "</TD>");
                bw.write("</tr>");
                totale = totale.plus(rov.getP_tot_riga());
            }
            bw.write("<tr>");
            bw.write("<TD></TD><TD></TD><TD></TD><TD></TD><TD></TD><TD></TD><TD></TD><TD><</TD><TD></TD><TD><strong>" + totale + "</strong></TD>");
            bw.write("</tr>");
            bw.write("</table>");
            bw.write("<p ><strong>VIAGGI CON CUI E STATO ESEGUITO L'ORDINE:</strong></p>");
            if (this.o_selezione.getInsieme_viaggi() == null || this.o_selezione.getInsieme_viaggi().vettoreV.isEmpty()) {
                bw.write("<p ><strong>L'ordine non risulta eseguito</strong></p>");
            } else {
                for (Viaggio v : this.o_selezione.getInsieme_viaggi().vettoreV) {
                    v.seleziona_dettagli();
                    bw.write("<p ><strong>*)VIAGGIO N\u00b0 " + v.getNumero_viaggio() + "/" + v.getAnno() + " </strong></p>");
                    bw.write("<p><strong>DATA PARTENZA:</strong>" + v.getData_partenza_it() + "</p>");
                    bw.write("<p><strong>DESCRIZIONE:</strong>" + v.getDescrizione() + "</p>");
                    bw.write("<p><strong>DESCRIZIONE BREVE:</strong>" + v.getDesc_breve() + "</p>");
                    bw.write("<p><sTRONG>EFFETTUATO DA:</strong></p>");
                    if (v.getId_avettore() != 0) {
                        bw.write("<p><strong>VETTORE:</strong>[F" + v.getCodice_vettore() + "] " + v.getRag_soc_vettore() + "</p>");
                    } else {
                        bw.write("<p ><strong>Autista:  </strong>" + v.getCognome_autista() + " </p>");
                        bw.write("<p ><strong>Trattore: </strong>" + v.getTarga_trattore() + " </p>");
                    }
                    bw.write("<p ><strong>PRESE E CONSEGNE:</strong></p>");
                    bw.write("<table width=\"90%\" border=\"1\" cellspacing=\"0\">");
                    bw.write("<tr>");
                    bw.write("<TD width=\"4%\"><strong>P/C</strong></TD><TD  width=\"12%\"><strong>DATA</strong></TD><TD width=\"21%\"><strong>rif Cliente</strong></TD><TD width=\"51%\"><strong>Luogo</strong></TD><TD width=\"8%\"><strong>Quantit\u00e0</strong></TD><TD width=\"4%\"><strong>UM</strong></TD>");
                    bw.write("</tr>");
                    for (PresaConsegna pc : v.getInsieme_pc().vettorePC) {
                        bw.write("<tr>");
                        bw.write("<TD>" + pc.getTipo() + "</TD>" + "<TD>" + pc.getData_it() + "</TD>" + "<TD>" + pc.getN_ordine() + "</TD>" + "<TD>" + pc.getLuogo().getIndirizzoCompleto() + "</TD>" + "<TD>" + pc.getQuantita() + "</TD>" + "<TD>" + pc.getUnitaMisura() + "</TD>");
                        bw.write("</tr>");
                    }
                    bw.write("</table>");
                    bw.write("<p ><strong>Bolle registrate per il viaggio per questo ordine:</strong></p>");
                    bw.write("<table width=\"50%\" border=\"1\" cellspacing=\"0\">");
                    bw.write("<tr>");
                    bw.write("<TD width=\"30%\"><strong>DATA BOLLA</strong></TD><TD  width=\"70%\"><strong>NUMERO BOLLA</strong></TD>");
                    bw.write("</tr>");
                    if (v.getInsieme_bolle() != null && !v.getInsieme_bolle().vettoreV.isEmpty()) {
                        for (Bolla b : v.getInsieme_bolle().vettoreV) {
                            if (b.getId_ordine() != this.o_selezione.getId()) continue;
                            bw.write("<tr>");
                            bw.write("<TD>" + this.fda.gira_data(b.getData_bolla()) + "</TD>" + "<TD>" + b.getNumero_bolla() + "</TD>");
                            bw.write("</tr>");
                        }
                    }
                    bw.write("</table>");
                }
            }
            bw.write("</body>");
            bw.write("</html>");
            bw.close();
            URL helpURL = f.getAbsoluteFile().toURI().toURL();
            if (helpURL != null) {
                try {
                    System.err.println("JEditorPane con altezza=" + this.jEditorPane.getHeight());
                    this.jEditorPane.setPage(helpURL);
                    System.err.println("riempito JEditorPane di altezza=" + this.jEditorPane.getHeight());
                }
                catch (IOException e) {
                    System.err.println("Attempted to read a bad URL: " + helpURL);
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                }
            } else {
                System.err.println("Couldn't find file: TextSamplerDemoHelp.html");
                MyTrace.log.severe("Couldn't find file: TextSamplerDemoHelp.html");
            }
        }
        catch (MalformedURLException ex) {
            MyTrace.log.severe(ex.toString());
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
        catch (IOException e) {
            Logger.getLogger(MyDettaglioOrdine.class.getName()).log(Level.SEVERE, null, e);
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
    }

    public void riempi_campi_insieme() {
        Iterator oo = this.vettoreO.iterator();
        int count = 0;
        this.jTabbedPane1.removeAll();
        while (oo.hasNext()) {
            Ordine o = (Ordine)oo.next();
            JEditorPane editor_pane = new JEditorPane();
            JScrollPane s = new JScrollPane();
            s.setViewportView(editor_pane);
            this.jTabbedPane1.addTab("" + o.getN_ordine(), s);
            try {
                File f = new File(Funzioni.CartellaPerStampe() + System.getProperty("file.separator") + "ordine_" + count + ".html");
                ++count;
                BufferedWriter bw = new BufferedWriter(new FileWriter(f));
                bw.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\"><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" /><title>Dettaglio Ordine</title></head>");
                bw.write("<body style=\"font-family:Verdana, Geneva, sans-serif;font-size:10px;\">");
                bw.write("<p style=\"font-weight:bolder;font-size:18px;\">ORDINE N\u00b0 " + o.getN_ordine() + "/" + o.getAnno_ordine() + "</p>");
                bw.write("<p><strong>DATA ORDINE:</strong><span class=\"testo\">" + o.getData_ordineIt() + "&nbsp;&nbsp;</span> <strong>TRATTA COMPLESSIVA:</strong>" + "<span class=\"testo\">" + o.getTratta_complessiva() + "</span></p>");
                bw.write("<p ><strong>COMMITTENTE:</strong><span class=\"testo\">  [C" + o.getA_cliente().getCodice() + "] " + o.getA_cliente().getRagione_sociale() + "</span></p>");
                if (o.getId_acliente1() != 0 && o.getA_cliente1() != null) {
                    bw.write("<p ><strong>COMMITTENTE 2:</strong><span class=\"testo\">  [C" + o.getA_cliente1().getCodice() + "] " + o.getA_cliente1().getRagione_sociale() + "</span></p>");
                }
                if (o.getId_acliente2() != 0 && o.getA_cliente2() != null) {
                    bw.write("<p ><strong>COMMITTENTE 3:</strong><span class=\"testo\">  [C" + o.getA_cliente2().getCodice() + "] " + o.getA_cliente2().getRagione_sociale() + "</span></p>");
                }
                bw.write("<p ><strong>ANNOTAZIONI ORDINE:</strong><span class=\"testo\">" + o.getNote() + "</span></p>");
                bw.write("<p ><strong>PRESE E CONSEGNE:</strong></p>");
                bw.write("<table width=\"90%\" border=\"1\" cellspacing=\"0\">");
                bw.write("<tr>");
                bw.write("<TD width=\"4%\"><strong>P/C</strong></TD><TD  width=\"12%\"><strong>DATA</strong></TD><TD width=\"21%\"><strong>rif Cliente</strong></TD><TD width=\"51%\"><strong>Luogo</strong></TD><TD width=\"8%\"><strong>Quantit\u00e0</strong></TD><TD width=\"4%\"><strong>UM</strong></TD>");
                bw.write("</tr>");
                for (PresaConsegna pc : o.getInsieme_pc().vettorePC) {
                    bw.write("<tr>");
                    bw.write("<TD>" + pc.getTipo() + "</TD>" + "<TD>" + pc.getData_it() + "</TD>" + "<TD>" + pc.getN_ordine() + "</TD>" + "<TD>" + pc.getLuogo().getIndirizzoCompleto() + "</TD>" + "<TD>" + pc.getQuantita() + "</TD>" + "<TD>" + pc.getUnitaMisura() + "</TD>");
                    bw.write("</tr>");
                }
                bw.write("</table>");
                bw.write("<p ><strong>RIGHE FATTURE ATTIVE:</strong></p>");
                bw.write("<table width=\"90%\" border=\"1\" cellspacing=\"0\">");
                bw.write("<tr>");
                bw.write("<TD width=\"6%\"><strong>Fattura Num</strong></TD><TD  width=\"10%\"><strong>Data Fattura</strong></TD><TD width=\"4%\"><strong>T/O</strong></TD><TD  width=\"10%\"><strong>CODICE</strong></TD><TD width=\"20%\"><strong>DESCRIZIONE</strong></TD><TD width=\"10%\"><strong>Quantit\u00e0</strong></TD><TD width=\"8%\"><strong>UM</strong></TD><TD width=\"12%\"><strong>Prezzo/Um</strong></TD><TD width=\"12%\"><strong>Prezzo For</strong></TD><TD width=\"12%\"><strong>Tot</strong></TD>");
                bw.write("</tr>");
                Iterator<RigaOrdineViaggio> j = o.getInsieme_r().vettoreR.iterator();
                Money totale = new Money(BigDecimal.ZERO);
                while (j.hasNext()) {
                    RigaOrdineViaggio rov = j.next();
                    bw.write("<tr>");
                    bw.write("<TD>" + rov.getNumero_fattura_attiva() + "</TD>" + "<TD>" + this.fda.gira_data(rov.getData_fattura_attiva()) + "</TD>" + "<TD>" + rov.getT_o() + "</TD>" + "<TD>" + rov.getCodice_riga() + "</TD>" + "<TD>" + rov.getDescrizione_riga() + "</TD>" + "<TD>" + this.ff.formattaNumero("" + rov.getQuantita(), "#0.000") + "</TD>" + "<TD>" + rov.getCodice_um() + "</TD>" + "<TD>" + rov.getP_um() + "</TD>" + "<TD>" + rov.getP_for() + "</TD>" + "<TD>" + rov.getP_tot_riga() + "</TD>");
                    bw.write("</tr>");
                    totale = totale.plus(rov.getP_tot_riga());
                }
                bw.write("<tr>");
                bw.write("<TD></TD><TD></TD><TD></TD><TD></TD><TD></TD><TD></TD><TD></TD><TD><</TD><TD></TD><TD><strong>" + totale + "</strong></TD>");
                bw.write("</tr>");
                bw.write("</table>");
                bw.write("<p ><strong>VIAGGI CON CUI E STATO ESEGUITO L'ORDINE:</strong></p>");
                if (o.getInsieme_viaggi() == null || o.getInsieme_viaggi().vettoreV.isEmpty()) {
                    bw.write("<p ><strong>L'ordine non risulta eseguito</strong></p>");
                } else {
                    for (Viaggio v : o.getInsieme_viaggi().vettoreV) {
                        v.seleziona_dettagli();
                        bw.write("<p ><strong>*)VIAGGIO N\u00b0 " + v.getNumero_viaggio() + "/" + v.getAnno() + " </strong></p>");
                        bw.write("<p><strong>DATA PARTENZA:&nbsp;&nbsp;</strong>" + v.getData_partenza_it() + "<strong>DESCRIZIONE:</strong>" + v.getDesc_breve() + "</p>");
                        bw.write("<p><strong>DESCRIZIONE BREVE:</strong>" + v.getDesc_breve() + "</p>");
                        bw.write("<p><sTRONG>EFFETTUATO DA:</strong></p>");
                        if (v.getId_avettore() != 0) {
                            bw.write("<p><strong>VETTORE:</strong>[F" + v.getCodice_vettore() + "] " + v.getRag_soc_vettore() + "</p>");
                        } else {
                            bw.write("<p ><strong>Autista:  </strong>" + v.getCognome_autista() + " </p>");
                            bw.write("<p ><strong>Trattore: </strong>" + v.getTarga_trattore() + " </p>");
                        }
                        bw.write("<p ><strong>PRESE E CONSEGNE:</strong></p>");
                        bw.write("<table width=\"90%\" border=\"1\" cellspacing=\"0\">");
                        bw.write("<tr>");
                        bw.write("<TD width=\"4%\"><strong>P/C</strong></TD><TD  width=\"12%\"><strong>DATA</strong></TD><TD width=\"21%\"><strong>rif Cliente</strong></TD><TD width=\"51%\"><strong>Luogo</strong></TD><TD width=\"8%\"><strong>Quantit\u00e0</strong></TD><TD width=\"4%\"><strong>UM</strong></TD>");
                        bw.write("</tr>");
                        for (PresaConsegna pc : v.getInsieme_pc().vettorePC) {
                            bw.write("<tr>");
                            bw.write("<TD>" + pc.getTipo() + "</TD>" + "<TD>" + pc.getData_it() + "</TD>" + "<TD>" + pc.getN_ordine() + "</TD>" + "<TD>" + pc.getLuogo().getIndirizzoCompleto() + "</TD>" + "<TD>" + pc.getQuantita() + "</TD>" + "<TD>" + pc.getUnitaMisura() + "</TD>");
                            bw.write("</tr>");
                        }
                        bw.write("</table>");
                        if (v.getInsieme_bolle() != null && !v.getInsieme_bolle().vettoreV.isEmpty()) {
                            bw.write("<p ><strong>Bolle registrate per il viaggio per questo ordine:</strong></p>");
                            bw.write("<table width=\"50%\" border=\"1\" cellspacing=\"0\">");
                            bw.write("<tr>");
                            bw.write("<TD width=\"30%\"><strong>DATA BOLLA</strong></TD><TD  width=\"70%\"><strong>NUMERO BOLLA</strong></TD>");
                            bw.write("</tr>");
                            for (Bolla b : v.getInsieme_bolle().vettoreV) {
                                if (b.getId_ordine() != o.getId()) continue;
                                bw.write("<tr>");
                                bw.write("<TD>" + this.fda.gira_data(b.getData_bolla()) + "</TD>" + "<TD>" + b.getNumero_bolla() + "</TD>");
                                bw.write("</tr>");
                            }
                        }
                        bw.write("</table>");
                    }
                }
                bw.write("</body>");
                bw.write("</html>");
                bw.close();
                URL helpURL = f.getAbsoluteFile().toURI().toURL();
                if (helpURL != null) {
                    try {
                        System.err.println("JEditorPane con altezza=" + editor_pane.getHeight());
                        editor_pane.setPage(helpURL);
                        System.err.println("riempito JEditorPane di altezza=" + editor_pane.getHeight());
                        this.vettore_editor_pane.add(editor_pane);
                    }
                    catch (IOException e) {
                        System.err.println("Attempted to read a bad URL: " + helpURL);
                        Funzioni.inviaBugPerEmail(e);
                        Funzioni.LogStackTrace(e);
                    }
                    continue;
                }
                System.err.println("Couldn't find file: TextSamplerDemoHelp.html");
                MyTrace.log.severe("Couldn't find file: TextSamplerDemoHelp.html");
            }
            catch (MalformedURLException ex) {
                MyTrace.log.severe(ex.toString());
                Funzioni.inviaBugPerEmail(ex);
                Funzioni.LogStackTrace(ex);
            }
            catch (IOException e) {
                Logger.getLogger(MyDettaglioOrdine.class.getName()).log(Level.SEVERE, null, e);
                Funzioni.inviaBugPerEmail(e);
                Funzioni.LogStackTrace(e);
            }
        }
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.jButtonSalva = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButtonStampa = new JButton();
        this.jSeparator6 = new JToolBar.Separator();
        this.jTabbedPane1 = new JTabbedPane();
        this.jScrollPane1 = new JScrollPane();
        this.jEditorPane = new JEditorPane();
        this.setClosable(true);
        this.setDefaultCloseOperation(2);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Dettaglio Ordine");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                MyDettaglioOrdine.this.finestra_spostata(evt);
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                MyDettaglioOrdine.this.finestra_ridimensionata(evt);
            }
        });
        this.jToolBar1.setRollover(true);
        this.jButtonSalva.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/media-floppy.png")));
        this.jButtonSalva.setText("Salva");
        this.jButtonSalva.setFocusable(false);
        this.jButtonSalva.setVerticalTextPosition(3);
        this.jButtonSalva.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyDettaglioOrdine.this.jButtonSalvaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonSalva);
        this.jToolBar1.add(this.jSeparator1);
        this.jButtonStampa.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-print.png")));
        this.jButtonStampa.setText("Stampa");
        this.jButtonStampa.setFocusable(false);
        this.jButtonStampa.setVerticalTextPosition(3);
        this.jButtonStampa.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyDettaglioOrdine.this.jButtonStampaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonStampa);
        this.jToolBar1.add(this.jSeparator6);
        this.getContentPane().add((Component)this.jToolBar1, "North");
        this.jEditorPane.setEditable(false);
        this.jScrollPane1.setViewportView(this.jEditorPane);
        this.jTabbedPane1.addTab("tab1", this.jScrollPane1);
        this.getContentPane().add((Component)this.jTabbedPane1, "Center");
        this.pack();
    }

    private void jButtonSalvaActionPerformed(ActionEvent evt) {
        if (this.jEditorPane.getText().length() > 0) {
            JFileChooser chooser = new JFileChooser();
            chooser.setMultiSelectionEnabled(false);
            chooser.setSelectedFile(new File("ordine_" + this.o_selezione.getN_ordine() + ".rtf"));
            int option = chooser.showSaveDialog(this);
            if (option == 0) {
                StyledDocument doc = (StyledDocument)this.jEditorPane.getDocument();
                HTMLEditorKit kit = new HTMLEditorKit();
                try {
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(chooser.getSelectedFile().getAbsoluteFile()));
                    kit.write(out, (Document)doc, doc.getStartPosition().getOffset(), doc.getLength());
                    JOptionPane.showMessageDialog(this, "File salvato Correttamente");
                }
                catch (FileNotFoundException e) {
                    JOptionPane.showMessageDialog(this, "ERRORE:");
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this, "ERRORE:");
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                }
                catch (BadLocationException e) {
                    JOptionPane.showMessageDialog(this, "ERRORE:");
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                }
            }
        }
    }

    private void jButtonStampaActionPerformed(ActionEvent evt) {
        if (this.o_selezione != null && this.o_selezione.getId() != 0) {
            System.err.println("Chiamata la stampa con  JEditorPane di altezza=" + this.jEditorPane.getHeight());
            StampaOrdine stampa = new StampaOrdine(this.o_selezione, this.jEditorPane);
            stampa.avvia();
        } else {
            StampaOrdine stampa = new StampaOrdine(this.vettore_editor_pane);
            stampa.avvia();
        }
    }

    private void finestra_spostata(ComponentEvent evt) {
        ConfigurazioneFinestre.SetPoint(this.getClass().getName(), this.getLocation());
    }

    private void finestra_ridimensionata(ComponentEvent evt) {
        ConfigurazioneFinestre.SetDimension(this.getClass().getName(), this.getSize());
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(MyDettaglioOrdine.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(MyDettaglioOrdine.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MyDettaglioOrdine.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(MyDettaglioOrdine.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MyDettaglioOrdine(new Ordine()).setVisible(true);
            }
        });
    }
}

