/*
 * Decompiled with CFR 0.152.
 */
package trasporti.manutenzioni;

import controlling.analitica_operativa.AnaliticaOperativaVDA;
import gestionale.MyDesktopWindow;
import gestionale.configurazioni.Configurazioni;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import trasporti.magazzino_manutenzione.InsiemeOggettiMagazzinoManutenzione;
import trasporti.magazzino_manutenzione.OggettoMagazzinoManutenzione;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;

public class Manutenzione {
    private int idManutenzione;
    private int id_mezzo;
    private int eseguita;
    private int id_anagrafica;
    private String data;
    private String descrizione;
    private String note;
    private String targa;
    private String descrizione_mezzo;
    private String trattore_semirimorchio;
    private String ragione_sociale;
    private String codice_fornitore;
    private String ddi;
    private double chilometri;
    public Money costo_previsto = new Money(BigDecimal.ZERO);
    public Money costo_totale = new Money(BigDecimal.ZERO);
    private InsiemeOggettiMagazzinoManutenzione insieme_om;
    private Vector v_el;
    FunzioniDate fda;
    Funzioni f = new Funzioni();
    public AnaliticaOperativaVDA analitica_manutenzione;
    public int id_centro_responsabilita;

    public Manutenzione() {
        this.fda = new FunzioniDate();
    }

    public int getIdManutenzione() {
        return this.idManutenzione;
    }

    public void setIdManutenzione(int idManutenzione) {
        this.idManutenzione = idManutenzione;
    }

    public Vector getV_el() {
        return this.v_el;
    }

    public void setV_el(Vector v_el) {
        this.v_el = v_el;
    }

    public int getId_mezzo() {
        return this.id_mezzo;
    }

    public void setId_mezzo(int id_mezzo) {
        this.id_mezzo = id_mezzo;
    }

    public Money getCosto_previsto() {
        return this.costo_previsto;
    }

    public void setCosto_previsto(Money costo_previsto) {
        this.costo_previsto = costo_previsto;
    }

    public Money getCosto_totale() {
        return this.costo_totale;
    }

    public void setCosto_totale(Money costo_totale) {
        this.costo_totale = costo_totale;
    }

    public int getId_anagrafica() {
        return this.id_anagrafica;
    }

    public void setId_anagrafica(int id_anagrafica) {
        this.id_anagrafica = id_anagrafica;
    }

    public String getCodice_fornitore() {
        return this.codice_fornitore;
    }

    public void setCodice_fornitore(String codice_fornitore) {
        this.codice_fornitore = codice_fornitore;
    }

    public String getRagione_sociale() {
        return this.ragione_sociale;
    }

    public void setRagione_sociale(String ragione_sociale) {
        this.ragione_sociale = ragione_sociale;
    }

    public String getDdi() {
        return this.ddi;
    }

    public void setDdi(String ddi) {
        this.ddi = ddi;
    }

    public String getData() {
        return this.data;
    }

    public String getData_it() {
        return this.fda.gira_data(this.getData());
    }

    public void setData(String data_scadenza) {
        this.data = data_scadenza;
    }

    public int getEseguita() {
        return this.eseguita;
    }

    public void setEseguita(int eseguita) {
        this.eseguita = eseguita;
    }

    public String getDescrizione() {
        return this.descrizione;
    }

    public void setDescrizione(String descrizione) {
        this.descrizione = descrizione;
    }

    public String getDescrizione_mezzo() {
        return this.descrizione_mezzo;
    }

    public void setDescrizione_mezzo(String descrizione_mezzo) {
        this.descrizione_mezzo = descrizione_mezzo;
    }

    public String getT_S() {
        return this.trattore_semirimorchio;
    }

    public void setT_S(String trattore_semirimorchio) {
        this.trattore_semirimorchio = trattore_semirimorchio;
    }

    public int getId_centro_responsabilita() {
        return this.id_centro_responsabilita;
    }

    public void setId_centro_responsabilita(int id_centro_responsabilita) {
        this.id_centro_responsabilita = id_centro_responsabilita;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getTarga() {
        return this.targa;
    }

    public void setTarga(String targa) {
        this.targa = targa;
    }

    public InsiemeOggettiMagazzinoManutenzione getInsieme_om() {
        return this.insieme_om;
    }

    public void setInsieme_om(InsiemeOggettiMagazzinoManutenzione insieme_om) {
        this.insieme_om = insieme_om;
    }

    public double getChilometri() {
        return this.chilometri;
    }

    public void setChilometri(double chilometri) {
        this.chilometri = chilometri;
    }

    public AnaliticaOperativaVDA getAnalitica_manutenzione() {
        return this.analitica_manutenzione;
    }

    public void setAnalitica_manutenzione(AnaliticaOperativaVDA analitica_manutenzione) {
        this.analitica_manutenzione = analitica_manutenzione;
    }

    public boolean inserisci(boolean da_fuori) {
        String q_trace;
        boolean r_trace;
        String query_inserimento;
        boolean r_ins;
        if (!da_fuori) {
            String q_start = "START TRANSACTION;";
            boolean r_start = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_start);
        }
        if (!(r_ins = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_inserimento = "INSERT INTO mtra_manutenzioni(id_mezzo,data,eseguita,descrizione,note,chilometri,costo_previsto,abilita,costo_totale,id_anagrafica)  VALUES (" + this.getId_mezzo() + "," + " '" + this.getData() + "', " + " '" + this.getEseguita() + "', " + " '" + this.getDescrizione().replaceAll("'", "''") + "', " + " '" + this.getNote().replaceAll("'", "''") + "', " + " '" + this.getChilometri() + "', " + " " + this.getCosto_previsto() + ",1, " + " " + this.getCosto_totale() + ", " + " " + this.f.zero_to_null(this.getId_anagrafica()) + " " + ")"))) {
            String q_commit = "ROLLBACK";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            MyTrace.log.severe("Inserimento manutenzione trasporti non riuscito");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        String strSQL = "SELECT @@identity FROM mtra_manutenzioni";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(strSQL);
        int id_inserito = 0;
        try {
            while (res.next()) {
                id_inserito = res.getInt("@@identity");
            }
        }
        catch (Exception e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        this.setIdManutenzione(id_inserito);
        boolean ris_om = true;
        if (this.getInsieme_om() != null && !this.getInsieme_om().vettoreOM.isEmpty()) {
            for (OggettoMagazzinoManutenzione om : this.getInsieme_om().vettoreOM) {
                om.setId_ddu(id_inserito);
                om.setQuantita(om.getQuantita().negate());
                ris_om = om.inserisci(true);
            }
        }
        if (!(r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mtra_manutenzioni','" + this.getIdManutenzione() + "',NOW(),'INS','" + query_inserimento.replaceAll("'", "''") + "')"))) {
            String q_commit = "ROLLBACK";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            MyTrace.log.severe("Inserimento mtra_manutenzioni non riuscito per trace");
            Configurazioni.eccezione.gestisci("2.3", null);
            return false;
        }
        if (!da_fuori) {
            String q_commit = "COMMIT";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            if (r_commit) {
                return true;
            }
            MyTrace.log.severe("Inserimento mtra_scadenziario_manutenzioni non riuscito per commit");
            Configurazioni.eccezione.gestisci("2.4", null);
            return false;
        }
        return true;
    }

    public boolean modifica(boolean da_fuori) {
        String query_modifica;
        boolean res;
        if (!da_fuori) {
            String q_start = "START TRANSACTION;";
            boolean r_start = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_start);
        }
        if (!(res = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_modifica = "UPDATE mtra_manutenzioni SET id_mezzo='" + this.getId_mezzo() + "', " + " data='" + this.getData() + "', " + " eseguita='" + this.getEseguita() + "', " + " descrizione='" + this.getDescrizione().replaceAll("'", "''") + "', " + " note='" + this.getNote().replaceAll("'", "''") + "', " + " costo_previsto='" + this.getCosto_previsto() + "', " + " costo_totale='" + this.getCosto_totale() + "', " + " id_anagrafica=" + this.f.zero_to_null(this.getId_anagrafica()) + ", " + " chilometri='" + this.getChilometri() + "' " + " where idManutenzione='" + this.getIdManutenzione() + "'"))) {
            String q_commit = "ROLLBACK";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            MyTrace.log.severe("Modifica mtra_manutenzioni non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            return false;
        }
        boolean ris_om = true;
        for (OggettoMagazzinoManutenzione om : this.getInsieme_om().vettoreOM) {
            om.setId_ddu(this.getIdManutenzione());
            om.setQuantita(om.getQuantita().negate());
            if (om.getId() == 0) {
                om.inserisci(true);
                continue;
            }
            om.modifica(true);
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mtra_manutenzioni','" + this.getIdManutenzione() + "',NOW(),'MOD','" + query_modifica.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Modifica mtra_manutenzioni non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.3", null);
            return false;
        }
        if (!da_fuori) {
            String q_commit = "COMMIT";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            if (r_commit) {
                return true;
            }
            MyTrace.log.severe("Modifica mtra_manutenzioni non riuscito per commit");
            Configurazioni.eccezione.gestisci("3.4", null);
            return false;
        }
        return true;
    }

    public boolean svuotaOM(boolean da_fuori) {
        try {
            if (!da_fuori) {
                String q_start = "START TRANSACTION;";
                boolean r_start = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_start);
            }
            boolean ris_om = true;
            for (OggettoMagazzinoManutenzione om : this.getV_el()) {
                ris_om = om.elimina(true);
            }
            if (!ris_om) {
                String q_commit = "ROLLBACK";
                boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
                MyTrace.log.severe("DDU_Modifica manutenzioni non riuscita per trace");
                Configurazioni.eccezione.gestisci("3.3", null);
                return false;
            }
            String q_c = "COMMIT";
            boolean r_c = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_c);
            this.setInsieme_om(new InsiemeOggettiMagazzinoManutenzione());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean elimina(boolean da_fuori) {
        String query_elimina;
        boolean res;
        if (!da_fuori) {
            String q_start = "START TRANSACTION;";
            boolean r_start = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_start);
        }
        if (!(res = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_elimina = "UPDATE mtra_manutenzioni SET abilita='0' where idManutenzione='" + this.getIdManutenzione() + "'"))) {
            String q_commit = "ROLLBACK";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            MyTrace.log.severe("Delete mtra_manutenzioni non riuscito");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        this.svuotaOM(true);
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mtra_manutenzioni','" + this.getIdManutenzione() + "',NOW(),'DEL','" + query_elimina.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            String q_commit = "ROLLBACK";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            MyTrace.log.severe("Del mtra_manutenzioni non riuscito per trace");
            Configurazioni.eccezione.gestisci("2.3", null);
            return false;
        }
        if (!da_fuori) {
            String q_commit = "COMMIT";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            if (r_commit) {
                return true;
            }
            MyTrace.log.severe("DEL mtra_manutenzioni non riuscito per commit");
            Configurazioni.eccezione.gestisci("2.4", null);
            return false;
        }
        return true;
    }

    public void seleziona_dettagli() {
        String w = " WHERE id_ddu=" + this.getIdManutenzione();
        this.setInsieme_om(new InsiemeOggettiMagazzinoManutenzione());
        this.getInsieme_om().caricamento(w, "");
        Iterator i = this.getInsieme_om().vettoreOM.iterator();
        while (i.hasNext()) {
            OggettoMagazzinoManutenzione om = new OggettoMagazzinoManutenzione();
            om = (OggettoMagazzinoManutenzione)i.next();
            om.setQuantita(om.getQuantita().negate());
        }
    }

    public void seleziona(String where, String order_by) {
        String query_seleziona = "select mtra_manutenzioni.* from mtra_manutenzioni  ";
        query_seleziona = query_seleziona + " " + where;
        query_seleziona = query_seleziona + " " + order_by;
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query_seleziona);
        try {
            while (res.next()) {
                this.setCosto_previsto(new Money(res.getDouble("costo_previsto")));
                this.setCosto_totale(new Money(res.getDouble("costo_totale")));
                this.setData(res.getString("data"));
                this.setDescrizione(res.getString("descrizione"));
                this.setEseguita(res.getInt("eseguita"));
                this.setId_anagrafica(res.getInt("id_anagrafica"));
                this.setId_mezzo(res.getInt("id_mezzo"));
                this.setNote(res.getString("note"));
                this.setChilometri(res.getDouble("chilometri"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(Manutenzione.class.getName()).log(Level.SEVERE, null, ex);
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
    }

    Object getColValue(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                retVal = "" + this.getData_it();
                break;
            }
            case 1: {
                retVal = "" + this.f.si_no(this.getEseguita());
                break;
            }
            case 2: {
                retVal = "" + this.getDescrizione_mezzo();
                break;
            }
            case 3: {
                retVal = "" + this.getTarga();
                break;
            }
            case 4: {
                retVal = "" + this.getDescrizione();
                break;
            }
            case 5: {
                retVal = "" + this.getRagione_sociale();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }

    public Object getColValueReport(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                retVal = "" + this.getData_it();
                break;
            }
            case 1: {
                retVal = "" + this.getTarga();
                break;
            }
            case 2: {
                retVal = "" + this.getDescrizione();
                break;
            }
            case 3: {
                retVal = "" + this.getRagione_sociale();
                break;
            }
            case 4: {
                retVal = "" + this.getDdi();
                break;
            }
            case 5: {
                retVal = "" + this.getCosto_totale();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }
}

