/*
 * Decompiled with CFR 0.152.
 */
package trasporti.manutenzione_articoli;

import gestionale.configurazioni.ConfigurazioneFinestre;
import gestionale.configurazioni.Configurazioni;
import gestionale.configurazioni.MyProprietaFrame;
import gestionale.iva.Aliquota;
import gestionale.iva.MyConfiguraAliquotaIVA;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableRowSorter;
import trasporti.manutenzione_articoli.ArticoliManutenzioneFixedModel;
import trasporti.manutenzione_articoli.ArticoliManutenzioneTableModel;
import trasporti.manutenzione_articoli.ArticoloManutenzione;
import trasporti.manutenzione_articoli.InsiemeArticoliManutenzione;
import trasporti.manutenzione_ddi.MyDDIManutenzione;
import trasporti.manutenzione_gruppi.GruppiManutenzione;
import utils.Funzioni;
import utils.FunzioniTrasporti;
import utils.GenericTableRenderer;
import utils.Money;
import utils.MyTrace;
import utils.Performance;
import utils.RicercaCellEditor;
import utils.RicercaCellRenderer;
import utils.ToolTipHeader;

public class MyArticoliManutenzione
extends JInternalFrame
implements ListSelectionListener,
MouseListener,
InternalFrameListener {
    JToolBar jToolBarMod;
    ArticoliManutenzioneTableModel atm;
    InsiemeArticoliManutenzione insieme_a;
    JScrollPane scroll;
    JTable jTableArticoli;
    ArticoliManutenzioneFixedModel afm;
    JScrollPane fixedScroll;
    JTable fixedTable;
    private TableRowSorter<ArticoliManutenzioneTableModel> sorter;
    RowFilter<ArticoliManutenzioneTableModel, Object> rf = null;
    ArrayList<RowFilter<ArticoliManutenzioneTableModel, Object>> andFilters = new ArrayList();
    boolean in_filter = false;
    boolean in_modifica = false;
    boolean in_new = false;
    boolean non_tutte_le_righe = false;
    ArticoloManutenzione a_selezione;
    Funzioni f = new Funzioni();
    private FunzioniTrasporti ft = new FunzioniTrasporti();
    public JInternalFrame chiamante;
    public int row_chiamante;
    public boolean f_c5_open = false;
    public boolean f_te_open = false;
    public boolean f_al_open = false;
    double prezzo_base = 0.0;
    private JButton jButtonClean;
    private JButton jButtonElimina;
    private JToggleButton jButtonFiltra;
    private JButton jButtonFirst;
    private JButton jButtonForm;
    private JButton jButtonLast;
    private JButton jButtonModifica;
    private JButton jButtonNext;
    private JButton jButtonNuovo;
    private JButton jButtonPrevious;
    private JButton jButtonRefresh;
    private JButton jButtonStampa;
    private JComboBox jComboGruppo;
    private JComboBox jComboUM;
    private JLabel jLabelAliquota;
    private JLabel jLabelCF;
    private JLabel jLabelCodice;
    private JLabel jLabelCodiceBarreProdotto;
    private JLabel jLabelNote;
    private JLabel jLabelTel;
    private JLabel jLabelUtimoCosto;
    private JLabel jLabelVia;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanelDettaglio;
    private JPanel jPanelElenco;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JTabbedPane jTabbedPane1;
    public JTextField jTextCodAliquota;
    private JTextField jTextCodice;
    private JTextField jTextCodiceBarre;
    private JTextField jTextDescrizione;
    private JTextArea jTextNote;
    private JTextField jTextUltimoCosto;
    private JToolBar jToolBar1;
    private JPanel p;

    public MyArticoliManutenzione() {
        Performance perf = new Performance("+++ ISTANZA MyArticoliManutenzione +++");
        this.atm = new ArticoliManutenzioneTableModel();
        this.insieme_a = new InsiemeArticoliManutenzione();
        this.jTableArticoli = new JTable(this.atm);
        this.jTableArticoli.setSelectionMode(0);
        this.sorter = new TableRowSorter<ArticoliManutenzioneTableModel>(this.atm);
        for (int i = 0; i < this.atm.getColumnCount(); ++i) {
            RowFilter rf_local = RowFilter.regexFilter("(?i)", i);
            this.andFilters.add(i, rf_local);
        }
        this.afm = new ArticoliManutenzioneFixedModel();
        this.afm.setFIXED_NUM(0);
        this.fixedTable = new JTable(this.afm);
        this.fixedTable.setAutoResizeMode(4);
        this.addInternalFrameListener(this);
        this.initComponents();
        this.crea_toolbar();
        this.aggiungi_tabelle();
        this.filtra();
        ListSelectionModel listSelectionModel = this.jTableArticoli.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        this.formatta();
        this.visualizzazione();
        this.controlla_diritti();
        this.setLocation(ConfigurazioneFinestre.GetPoint(this.getClass().getName(), new Point(200, 0)));
        this.setSize(ConfigurazioneFinestre.GetDimension(this.getClass().getName(), new Dimension(600, 550)));
        perf.fine();
    }

    private void controlla_diritti() {
    }

    private void crea_toolbar() {
        this.jToolBarMod = new JToolBar();
        JButton jButtonSalva = new JButton();
        JButton jButtonAnnulla = new JButton();
        jButtonSalva.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-save-as.png")));
        jButtonSalva.setText("Salva");
        jButtonSalva.setFocusable(true);
        jButtonSalva.setVerticalTextPosition(3);
        jButtonSalva.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyArticoliManutenzione.this.jButtonSalvaActionPerformed(evt);
            }
        });
        this.jToolBarMod.add(jButtonSalva);
        jButtonAnnulla.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-undo.png")));
        jButtonAnnulla.setText("Annulla");
        jButtonAnnulla.setFocusable(true);
        jButtonAnnulla.setVerticalTextPosition(3);
        jButtonAnnulla.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyArticoliManutenzione.this.jButtonAnnullaActionPerformed(evt);
            }
        });
        this.jToolBarMod.add(jButtonAnnulla);
    }

    private void aggiungi_tabelle() {
        this.scroll = new JScrollPane(this.jTableArticoli){

            @Override
            public void setColumnHeaderView(Component view) {
            }
        };
        this.scroll.setHorizontalScrollBarPolicy(31);
        this.fixedScroll = new JScrollPane(this.fixedTable);
        this.fixedScroll.setVerticalScrollBarPolicy(22);
        this.fixedScroll.setPreferredSize(new Dimension(400, 25));
        JScrollBar bar = this.fixedScroll.getVerticalScrollBar();
        JScrollBar dummyBar = new JScrollBar(){

            @Override
            public void paint(Graphics g) {
            }
        };
        dummyBar.setPreferredSize(bar.getPreferredSize());
        this.fixedScroll.setVerticalScrollBar(dummyBar);
        final JScrollBar bar1 = this.scroll.getHorizontalScrollBar();
        JScrollBar bar2 = this.fixedScroll.getHorizontalScrollBar();
        bar2.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                bar1.setValue(e.getValue());
            }
        });
        this.jTableArticoli.setModel(this.atm);
        this.jTableArticoli.setAutoCreateRowSorter(true);
        this.jTableArticoli.setRowSorter(this.sorter);
        this.jTableArticoli.setFillsViewportHeight(true);
        this.p.add((Component)this.scroll, "Center");
        this.p.add((Component)this.fixedScroll, "North");
    }

    public void visualizzazione() {
        this.jTextCodice.setEnabled(this.in_modifica);
        this.jTextDescrizione.setEnabled(this.in_modifica);
        this.jComboGruppo.setEnabled(this.in_modifica);
        this.jComboUM.setEnabled(this.in_modifica);
        this.jTextCodiceBarre.setEnabled(this.in_modifica);
        this.jTextUltimoCosto.setEnabled(this.in_modifica);
        this.jTextNote.setEnabled(this.in_modifica);
        this.jTextCodAliquota.setEnabled(this.in_modifica);
        if (this.in_modifica) {
            this.getContentPane().remove(this.jToolBar1);
            this.getContentPane().add((Component)this.jToolBarMod, "North");
            this.jTabbedPane1.setEnabledAt(0, false);
        } else {
            this.getContentPane().remove(this.jToolBarMod);
            this.getContentPane().add((Component)this.jToolBar1, "North");
            this.jTabbedPane1.setEnabledAt(0, true);
        }
        this.getContentPane().validate();
        this.getContentPane().repaint();
    }

    public void formatta() {
        this.jTableArticoli.getSelectionModel().setSelectionInterval(0, 0);
        this.jTableArticoli.setDefaultRenderer(Object.class, new GenericTableRenderer());
        this.fixedTable.setRowHeight(30);
        this.fixedTable.setDefaultEditor(String.class, new TextEditor());
        this.fixedTable.setDefaultRenderer(Object.class, new RicercaCellRenderer());
        this.jTableArticoli.addMouseListener(this);
        this.header_tebella();
    }

    public void header_tebella() {
        try {
            String[] toolTipStr = new String[]{"Codice Articolo", "Descrizione Articolo", "Gruppo"};
            ToolTipHeader header1 = new ToolTipHeader(this.jTableArticoli.getColumnModel());
            ToolTipHeader header2 = new ToolTipHeader(this.fixedTable.getColumnModel());
            header1.setToolTipStrings(toolTipStr);
            header2.setToolTipStrings(toolTipStr);
            this.fixedTable.setTableHeader(header2);
            this.jTableArticoli.setTableHeader(header1);
            header1.setResizingAllowed(false);
            header2.setResizingAllowed(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void filtra() {
        String query = "SELECT mtra_man_articoli.*, mtra_man_gruppi.descrizione as descrizione_gruppo,  mtra_man_gruppi.nome as nome_gruppo,  mtra_man_gruppi.id_conto as id_conto,  conf_unita_di_misura.descrizione as descrizione_um,  conf_unita_di_misura.codice as codice_um,  conf_unita_di_misura.tipo as tipo_um,  conf_unita_di_misura.volume as volume_um  FROM mtra_man_articoli  LEFT JOIN mtra_man_gruppi ON mtra_man_articoli.id_gruppo=mtra_man_gruppi.id  LEFT JOIN conf_unita_di_misura ON mtra_man_articoli.id_unita_di_misura=conf_unita_di_misura.id ORDER BY codice_articolo ASC ";
        if (Configurazioni.righe_ricerca != 0) {
            query = query + " LIMIT 0," + Configurazioni.righe_ricerca;
        }
        this.insieme_a.caricamento(query);
        this.atm.setDatArticoli(this.insieme_a.vettoreArticoli);
        if (Configurazioni.righe_ricerca != 0 && this.insieme_a.vettoreArticoli.size() >= Configurazioni.righe_ricerca) {
            this.non_tutte_le_righe = true;
        }
    }

    public void seleziona(int row) {
        this.a_selezione = new ArticoloManutenzione();
        this.a_selezione = (ArticoloManutenzione)this.insieme_a.vettoreArticoli.elementAt(row);
        this.riempi_campi();
    }

    public void riempi_campi() {
        String query_seleziona_prezzo_base = " Select prezzo from mmag_listino where id_listino=1 and id_articolo=" + this.a_selezione.getId();
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query_seleziona_prezzo_base);
        try {
            while (res.next()) {
                this.prezzo_base = res.getDouble("prezzo");
            }
        }
        catch (SQLException ex) {
            MyTrace.log.severe("ECCEZIONE in riemi i campi: richiesto il prezzo base");
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        GruppiManutenzione gruppomanutenzione = new GruppiManutenzione();
        gruppomanutenzione.seleziona(this.a_selezione.getId_gruppo());
        String codice_conto = this.f.codice_conto(gruppomanutenzione.getId_conto());
        String descrizione_conto = this.f.descrizione_conto(gruppomanutenzione.getId_conto());
        System.out.println("Codice conto= " + codice_conto + "   descrizione conto= " + descrizione_conto);
        this.jTextCodice.setText(this.a_selezione.getCodice_articolo());
        this.jTextDescrizione.setText(this.a_selezione.getDescrizione());
        this.jTextCodiceBarre.setText(this.a_selezione.getCod_barre());
        this.jTextUltimoCosto.setText(this.f.formattaNumero("" + this.a_selezione.getUltimo_costo_acquisto()));
        this.jTextNote.setText(this.a_selezione.getNote());
        this.jComboGruppo.setSelectedItem(this.a_selezione.getNome_gruppo());
        this.jComboUM.setSelectedItem(this.a_selezione.getCodice_um());
        Aliquota a = new Aliquota();
        String w = " WHERE idAliquota=" + this.a_selezione.getId_aliquota() + " ";
        a.seleziona(w);
        this.jTextCodAliquota.setText(a.getCodice());
        this.visualizzazione();
    }

    private void costruisci() {
        this.a_selezione.setCodice_articolo(this.jTextCodice.getText());
        this.a_selezione.setDescrizione(this.jTextDescrizione.getText());
        this.a_selezione.setCod_barre(this.jTextCodiceBarre.getText());
        this.a_selezione.setNote(this.jTextNote.getText());
        this.a_selezione.setUltimo_costo_acquisto(new Money(this.jTextUltimoCosto.getText()));
        this.a_selezione.setId_gruppo(this.ft.id_gruppo_di_articoli_manutenzione(this.jComboGruppo.getSelectedItem().toString()));
        this.a_selezione.setId_um(this.f.id_um(this.jComboUM.getSelectedItem().toString()));
        this.a_selezione.setId_aliquota(this.f.id_aliquota_iva(this.jTextCodAliquota.getText()));
    }

    private boolean check() {
        if (this.jTextDescrizione.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Inserire la Descrizione");
            return false;
        }
        if (this.jTextCodice.equals("")) {
            JOptionPane.showMessageDialog(this, "Inserire il codice articolo");
            return false;
        }
        if (this.jComboGruppo.getSelectedItem() == null) {
            JOptionPane.showMessageDialog(this, "Inserire il Gruppo di articoli");
            return false;
        }
        if (this.jComboUM.getSelectedItem() == null) {
            JOptionPane.showMessageDialog(this, "Inserire l'unit\u00e0 di misura");
            return false;
        }
        if (this.jTextCodAliquota.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Inserire il Codice Aliquota");
            return false;
        }
        if (!this.jTextCodAliquota.getText().equals("") && !this.f.controlla_aliquota(this.jTextCodAliquota.getText())) {
            JOptionPane.showMessageDialog(this, "Il codice inserito non \u00e8 un'Aliquota");
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.jButtonNuovo = new JButton();
        this.jButtonModifica = new JButton();
        this.jButtonElimina = new JButton();
        this.jButtonForm = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButtonFirst = new JButton();
        this.jButtonPrevious = new JButton();
        this.jButtonNext = new JButton();
        this.jButtonLast = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jButtonRefresh = new JButton();
        this.jButtonFiltra = new JToggleButton();
        this.jButtonClean = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.jButtonStampa = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelElenco = new JPanel();
        this.p = new JPanel();
        this.jPanelDettaglio = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabelCodice = new JLabel();
        this.jTextCodice = new JTextField();
        this.jLabelCF = new JLabel();
        this.jTextDescrizione = new JTextField();
        this.jLabelVia = new JLabel();
        this.jComboGruppo = new JComboBox(this.ft.crea_vettore_gruppi_articoli_manutenzione(1));
        this.jLabelTel = new JLabel();
        this.jComboUM = new JComboBox(this.f.crea_vettore_um(1));
        this.jLabelCodiceBarreProdotto = new JLabel();
        this.jTextCodiceBarre = new JTextField();
        this.jLabelUtimoCosto = new JLabel();
        this.jTextUltimoCosto = new JTextField();
        this.jLabelNote = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextNote = new JTextArea();
        this.jTextCodAliquota = new JTextField();
        this.jLabelAliquota = new JLabel();
        this.jPanel4 = new JPanel();
        this.setClosable(true);
        this.setDefaultCloseOperation(2);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Trasporti \\ Manutenzione \\ Articoli");
        this.addInternalFrameListener(new InternalFrameListener(){

            @Override
            public void internalFrameActivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent evt) {
                MyArticoliManutenzione.this.formInternalFrameClosing(evt);
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent evt) {
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                MyArticoliManutenzione.this.posizione_finestra(evt);
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                MyArticoliManutenzione.this.finestra_ridimensionata(evt);
            }
        });
        this.jToolBar1.setRollover(true);
        this.jButtonNuovo.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-new.png")));
        this.jButtonNuovo.setText("Nuovo");
        this.jButtonNuovo.setFocusable(false);
        this.jButtonNuovo.setVerticalTextPosition(3);
        this.jButtonNuovo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyArticoliManutenzione.this.jButtonNuovoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonNuovo);
        this.jButtonModifica.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/accessories-text-editor.png")));
        this.jButtonModifica.setText("Modifica");
        this.jButtonModifica.setFocusable(false);
        this.jButtonModifica.setHorizontalAlignment(11);
        this.jButtonModifica.setVerticalTextPosition(3);
        this.jButtonModifica.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyArticoliManutenzione.this.jButtonModificaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonModifica);
        this.jButtonElimina.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/user-trash.png")));
        this.jButtonElimina.setText("Elimina");
        this.jButtonElimina.setFocusable(false);
        this.jButtonElimina.setHorizontalAlignment(11);
        this.jButtonElimina.setVerticalTextPosition(3);
        this.jButtonElimina.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyArticoliManutenzione.this.jButtonEliminaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonElimina);
        this.jButtonForm.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/preferences-system.png")));
        this.jButtonForm.setText("Propriet\u00e0");
        this.jButtonForm.setFocusable(false);
        this.jButtonForm.setHorizontalAlignment(11);
        this.jButtonForm.setVerticalTextPosition(3);
        this.jButtonForm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyArticoliManutenzione.this.jButtonFormActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonForm);
        this.jToolBar1.add(this.jSeparator1);
        this.jButtonFirst.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-first.png")));
        this.jButtonFirst.setFocusable(false);
        this.jButtonFirst.setHorizontalTextPosition(0);
        this.jButtonFirst.setVerticalTextPosition(3);
        this.jButtonFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyArticoliManutenzione.this.jButtonFirstActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonFirst);
        this.jButtonPrevious.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-previous.png")));
        this.jButtonPrevious.setFocusable(false);
        this.jButtonPrevious.setHorizontalTextPosition(0);
        this.jButtonPrevious.setVerticalTextPosition(3);
        this.jButtonPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyArticoliManutenzione.this.jButtonPreviousActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonPrevious);
        this.jButtonNext.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-next.png")));
        this.jButtonNext.setFocusable(false);
        this.jButtonNext.setHorizontalTextPosition(0);
        this.jButtonNext.setVerticalTextPosition(3);
        this.jButtonNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyArticoliManutenzione.this.jButtonNextActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonNext);
        this.jButtonLast.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-last.png")));
        this.jButtonLast.setFocusable(false);
        this.jButtonLast.setHorizontalTextPosition(0);
        this.jButtonLast.setVerticalTextPosition(3);
        this.jButtonLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyArticoliManutenzione.this.jButtonLastActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonLast);
        this.jToolBar1.add(this.jSeparator2);
        this.jButtonRefresh.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/view-refresh.png")));
        this.jButtonRefresh.setFocusable(false);
        this.jButtonRefresh.setHorizontalTextPosition(0);
        this.jButtonRefresh.setVerticalTextPosition(3);
        this.jButtonRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyArticoliManutenzione.this.jButtonRefreshActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonRefresh);
        this.jButtonFiltra.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-find.png")));
        this.jButtonFiltra.setFocusable(false);
        this.jButtonFiltra.setHorizontalTextPosition(0);
        this.jButtonFiltra.setVerticalTextPosition(3);
        this.jButtonFiltra.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyArticoliManutenzione.this.jButtonFiltraActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonFiltra);
        this.jButtonClean.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-clear.png")));
        this.jButtonClean.setFocusable(false);
        this.jButtonClean.setHorizontalTextPosition(0);
        this.jButtonClean.setVerticalTextPosition(3);
        this.jButtonClean.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyArticoliManutenzione.this.jButtonCleanActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonClean);
        this.jToolBar1.add(this.jSeparator3);
        this.jButtonStampa.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-print.png")));
        this.jButtonStampa.setFocusable(false);
        this.jButtonStampa.setHorizontalTextPosition(0);
        this.jButtonStampa.setVerticalTextPosition(3);
        this.jToolBar1.add(this.jButtonStampa);
        this.getContentPane().add((Component)this.jToolBar1, "North");
        this.jPanelElenco.setLayout(new BorderLayout());
        this.p.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.p.setLayout(new BorderLayout());
        this.jPanelElenco.add((Component)this.p, "Center");
        this.jTabbedPane1.addTab("Elenco", this.jPanelElenco);
        this.jPanelDettaglio.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabelCodice.setText("Codice Articolo");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelCodice, gridBagConstraints);
        this.jTextCodice.setMinimumSize(new Dimension(200, 30));
        this.jTextCodice.setPreferredSize(new Dimension(200, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextCodice, gridBagConstraints);
        this.jLabelCF.setText("Descrizione");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelCF, gridBagConstraints);
        this.jTextDescrizione.setMinimumSize(new Dimension(200, 30));
        this.jTextDescrizione.setPreferredSize(new Dimension(350, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextDescrizione, gridBagConstraints);
        this.jLabelVia.setText("Gruppo");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelVia, gridBagConstraints);
        this.jComboGruppo.setMinimumSize(new Dimension(51, 27));
        this.jComboGruppo.setPreferredSize(new Dimension(150, 27));
        this.jComboGruppo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyArticoliManutenzione.this.jComboGruppoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jComboGruppo, gridBagConstraints);
        this.jLabelTel.setText("Unit\u00e0 di Misura");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelTel, gridBagConstraints);
        this.jComboUM.setMinimumSize(new Dimension(51, 27));
        this.jComboUM.setPreferredSize(new Dimension(150, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jComboUM, gridBagConstraints);
        this.jLabelCodiceBarreProdotto.setText("Codice a Barre Prodotto");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelCodiceBarreProdotto, gridBagConstraints);
        this.jTextCodiceBarre.setMinimumSize(new Dimension(200, 30));
        this.jTextCodiceBarre.setPreferredSize(new Dimension(200, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextCodiceBarre, gridBagConstraints);
        this.jLabelUtimoCosto.setText("Ultimo Costo Acquisto");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelUtimoCosto, gridBagConstraints);
        this.jTextUltimoCosto.setMinimumSize(new Dimension(200, 30));
        this.jTextUltimoCosto.setPreferredSize(new Dimension(200, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextUltimoCosto, gridBagConstraints);
        this.jLabelNote.setText("Note");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelNote, gridBagConstraints);
        this.jTextNote.setColumns(60);
        this.jTextNote.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextNote);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jTextCodAliquota.setMinimumSize(new Dimension(200, 30));
        this.jTextCodAliquota.setPreferredSize(new Dimension(200, 30));
        this.jTextCodAliquota.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MyArticoliManutenzione.this.jTextCodAliquotaKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextCodAliquota, gridBagConstraints);
        this.jLabelAliquota.setText("Codice Aliquota IVA");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelAliquota, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 1, 0, 0);
        this.jPanel2.add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 1, 0, 0);
        this.jPanel2.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanelDettaglio.add((Component)this.jPanel2, "West");
        this.jTabbedPane1.addTab("Dettaglio", this.jPanelDettaglio);
        this.getContentPane().add((Component)this.jTabbedPane1, "Center");
        this.pack();
    }

    private void jButtonSalvaActionPerformed(ActionEvent evt) {
        if (this.in_new) {
            if (this.check()) {
                this.costruisci();
                boolean check2 = this.a_selezione.inserisci(false);
                if (check2) {
                    this.in_new = false;
                    this.in_modifica = false;
                    this.filtra();
                    this.visualizzazione();
                    this.jTabbedPane1.setSelectedIndex(0);
                } else {
                    JOptionPane.showMessageDialog(this, "Si \u00e8 verificato un errore al momento dell'inserimento dei dati nel database,\nRicontrollare i campi riempiti e non.\nSe il problema persiste contattare Kronos");
                }
            }
        } else if (this.check()) {
            this.costruisci();
            boolean check2 = this.a_selezione.modifica(false);
            if (check2) {
                this.in_modifica = false;
                this.filtra();
                this.visualizzazione();
                this.jTabbedPane1.setSelectedIndex(0);
            } else {
                JOptionPane.showMessageDialog(this, "Si \u00e8 verificato un errore al momento della modifica dei dati nel database,\nRicontrollare i campi riempiti e non.\nSe il problema persiste contattare Kronos");
            }
        }
    }

    private void jButtonAnnullaActionPerformed(ActionEvent evt) {
        int res = JOptionPane.showConfirmDialog(this, "Abbandonare le modifiche?");
        if (res == 0) {
            this.in_modifica = false;
            this.visualizzazione();
            this.jTabbedPane1.setSelectedIndex(0);
        }
    }

    private void jButtonNuovoActionPerformed(ActionEvent evt) {
        this.in_new = true;
        this.jTableArticoli.getSelectionModel().clearSelection();
        this.a_selezione = new ArticoloManutenzione();
        Configurazioni.getIstanza();
        int id = Configurazioni.aliquota_predefinita.getId();
        this.a_selezione.setId_aliquota(id);
        this.riempi_campi();
        this.in_modifica = true;
        this.jTabbedPane1.setSelectedIndex(1);
        this.visualizzazione();
    }

    private void jButtonModificaActionPerformed(ActionEvent evt) {
        this.in_modifica = true;
        this.visualizzazione();
        if (this.jTabbedPane1.getSelectedIndex() == 0) {
            this.jTabbedPane1.setSelectedIndex(1);
        }
    }

    private void jButtonEliminaActionPerformed(ActionEvent evt) {
        this.jTabbedPane1.setSelectedIndex(1);
        int res = JOptionPane.showConfirmDialog(this, "Sei sicuro di voler eleiminare questo Articolo?");
        if (res == 0) {
            this.a_selezione.elimina(res);
            this.in_modifica = false;
            this.filtra();
        }
        this.visualizzazione();
        this.jTabbedPane1.setSelectedIndex(0);
    }

    private void jButtonFormActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        MyProprietaFrame oggetto = new MyProprietaFrame();
        this.getDesktopPane().add(oggetto);
        oggetto.setLocation(200, 0);
        oggetto.setVisible(true);
        oggetto.moveToFront();
        this.setCursor(new Cursor(0));
    }

    private void jButtonFirstActionPerformed(ActionEvent evt) {
        if (this.atm.getRowCount() != 0) {
            this.jTableArticoli.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void jButtonPreviousActionPerformed(ActionEvent evt) {
        try {
            if (this.jTableArticoli.getSelectedRow() > 0 && this.atm.getRowCount() != 0) {
                this.jTableArticoli.getSelectionModel().setSelectionInterval(this.jTableArticoli.getSelectedRow() - 1, this.jTableArticoli.getSelectedRow() - 1);
            }
        }
        catch (Exception err) {
            MyTrace.log.severe("RAGGIUNTO PRIMO");
            err.printStackTrace();
        }
    }

    private void jButtonNextActionPerformed(ActionEvent evt) {
        try {
            if (this.atm.getRowCount() != 0) {
                this.jTableArticoli.getSelectionModel().setSelectionInterval(this.jTableArticoli.getSelectedRow() + 1, this.jTableArticoli.getSelectedRow() + 1);
            }
        }
        catch (Exception err) {
            MyTrace.log.severe("RAGGIUNTO ULTIMO");
            err.printStackTrace();
        }
    }

    private void jButtonLastActionPerformed(ActionEvent evt) {
        if (this.atm.getRowCount() != 0) {
            this.jTableArticoli.getSelectionModel().setSelectionInterval(this.atm.getRowCount() - 1, this.atm.getRowCount() - 1);
        }
    }

    private void jButtonRefreshActionPerformed(ActionEvent evt) {
        this.filtra();
        this.formatta();
        this.visualizzazione();
    }

    private void jButtonFiltraActionPerformed(ActionEvent evt) {
        if (!this.in_filter) {
            this.in_filter = true;
            String[] a_ric = new String[]{"", "", ""};
            this.afm.addRow(a_ric);
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 65));
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
            this.fixedTable.setCellSelectionEnabled(true);
            this.fixedTable.changeSelection(0, 0, false, false);
            this.fixedTable.requestFocus();
        } else {
            this.in_filter = false;
            this.afm.deleteRow();
            this.afm = new ArticoliManutenzioneFixedModel();
            this.fixedTable.setModel(this.afm);
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 25));
            this.sorter.setRowFilter(null);
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
        }
        this.formatta();
    }

    private void jButtonCleanActionPerformed(ActionEvent evt) {
        if (this.in_filter) {
            this.in_filter = true;
            this.sorter.setRowFilter(null);
            String[] a_ric = new String[]{"", "", ""};
            this.afm = new ArticoliManutenzioneFixedModel();
            this.fixedTable.setModel(this.afm);
            this.afm.addRow(a_ric);
            this.andFilters = new ArrayList();
            for (int i = 0; i < this.atm.getColumnCount(); ++i) {
                RowFilter rf_local = RowFilter.regexFilter("(?i)", i);
                this.andFilters.add(i, rf_local);
            }
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 65));
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
        }
        this.formatta();
    }

    private void jTextCodAliquotaKeyPressed(KeyEvent evt) {
        int keyCode = evt.getKeyCode();
        if (keyCode == 115 && !this.f_al_open) {
            MyConfiguraAliquotaIVA oggetto = new MyConfiguraAliquotaIVA();
            oggetto.chiamante = this;
            this.getDesktopPane().add(oggetto);
            oggetto.setVisible(true);
            oggetto.moveToFront();
            this.f_al_open = true;
        }
    }

    private void posizione_finestra(ComponentEvent evt) {
        ConfigurazioneFinestre.SetPoint(this.getClass().getName(), this.getLocation());
    }

    private void finestra_ridimensionata(ComponentEvent evt) {
        ConfigurazioneFinestre.SetDimension(this.getClass().getName(), this.getSize());
    }

    private void jComboGruppoActionPerformed(ActionEvent evt) {
    }

    private void formInternalFrameClosing(InternalFrameEvent evt) {
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MyArticoliManutenzione().setVisible(true);
            }
        });
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int viewRow = this.jTableArticoli.getSelectedRow();
        int modelRow = 1000000000;
        if (this.in_filter) {
            if (viewRow >= 0) {
                modelRow = this.jTableArticoli.convertRowIndexToModel(viewRow);
            }
        } else {
            modelRow = viewRow;
        }
        if (modelRow <= this.atm.getRowCount() - 1 && modelRow >= 0) {
            this.seleziona(modelRow);
        }
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            JTable jtb = (JTable)e.getSource();
            int viewRow = jtb.getSelectedRow();
            int modelRow = 1000000000;
            if (this.in_filter) {
                if (viewRow >= 0) {
                    modelRow = this.jTableArticoli.convertRowIndexToModel(viewRow);
                }
            } else {
                modelRow = viewRow;
            }
            if (modelRow <= this.atm.getRowCount() - 1 && modelRow >= 0) {
                ArticoloManutenzione a = new ArticoloManutenzione();
                a = (ArticoloManutenzione)this.insieme_a.vettoreArticoli.elementAt(modelRow);
                if (this.chiamante != null) {
                    if (this.chiamante.getClass() == MyDDIManutenzione.class) {
                        ((MyDDIManutenzione)this.chiamante).jTableMagazzino.getCellEditor().getTableCellEditorComponent(((MyDDIManutenzione)this.chiamante).jTableMagazzino, a.getCodice_articolo(), false, this.row_chiamante, 0);
                        ((MyDDIManutenzione)this.chiamante).jTableMagazzino.getCellEditor().stopCellEditing();
                        ((MyDDIManutenzione)this.chiamante).aiuto_riga_open = false;
                    }
                    this.dispose();
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
        if (this.chiamante != null) {
            if (this.chiamante.getClass() == MyDDIManutenzione.class && ((MyDDIManutenzione)this.chiamante).aiuto_riga_open) {
                ((MyDDIManutenzione)this.chiamante).aiuto_riga_open = false;
            }
            this.dispose();
        }
    }

    public class TextEditor
    extends RicercaCellEditor {
        RowFilter<ArticoliManutenzioneTableModel, Object> rf_local = null;

        @Override
        public void newFilter(int col) {
            if (!MyArticoliManutenzione.this.non_tutte_le_righe) {
                try {
                    this.rf_local = RowFilter.regexFilter("(?i)" + this.tf.getText(), col);
                    MyArticoliManutenzione.this.andFilters.set(col, this.rf_local);
                }
                catch (PatternSyntaxException e) {
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                    return;
                }
                MyArticoliManutenzione.this.rf = RowFilter.andFilter(MyArticoliManutenzione.this.andFilters);
                MyArticoliManutenzione.this.sorter.setRowFilter(MyArticoliManutenzione.this.rf);
                MyArticoliManutenzione.this.formatta();
            } else {
                String query = "SELECT mtra_man_articoli.*, mtra_man_gruppi.descrizione as descrizione_gruppo,  mtra_man_gruppi.nome as nome_gruppo,  mtra_man_gruppi.id_conto as id_conto,  conf_unita_di_misura.descrizione as descrizione_um,  conf_unita_di_misura.codice as codice_um,  conf_unita_di_misura.tipo as tipo_um,  conf_unita_di_misura.volume as volume_um  FROM mtra_man_articoli  LEFT JOIN mtra_man_gruppi ON mtra_man_articoli.id_gruppo=mtra_man_gruppi.id  LEFT JOIN conf_unita_di_misura ON mtra_man_articoli.id_unita_di_misura=conf_unita_di_misura.id  WHERE 1 ";
                if (col == 0) {
                    query = query + " AND codice_articolo LIKE '%" + this.tf.getText() + "%'";
                }
                if (col == 1) {
                    query = query + " AND mtra_man_articoli.descrizione LIKE '%" + this.tf.getText() + "%'";
                }
                if (col == 2) {
                    query = query + " AND mtra_man_gruppi.nome LIKE '%" + this.tf.getText() + "%'";
                }
                query = query + " ORDER BY codice_articolo ASC LIMIT 0," + Configurazioni.righe_ricerca;
                MyArticoliManutenzione.this.insieme_a.caricamento(query);
                MyArticoliManutenzione.this.atm.setDatArticoli(MyArticoliManutenzione.this.insieme_a.vettoreArticoli);
                MyArticoliManutenzione.this.formatta();
            }
        }
    }
}

