/*
 * Decompiled with CFR 0.152.
 */
package trasporti.manutenzione_articoli;

import gestionale.MyDesktopWindow;
import gestionale.configurazioni.Configurazioni;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import magazzino.listini.InsiemePrezziListino;
import utils.Funzioni;
import utils.Money;
import utils.MyTrace;

public class ArticoloManutenzione {
    private String codice_articolo = "";
    private String descrizione = "";
    private String note;
    private String cod_barre;
    private String nome_gruppo;
    private String codice_um = "";
    private int id;
    private int id_gruppo;
    private int id_um;
    private int id_aliquota;
    private Money ultimo_costo_acquisto = new Money(BigDecimal.ZERO);
    private InsiemePrezziListino insieme_pl;
    private Funzioni f = new Funzioni();

    public String getCod_barre() {
        return this.cod_barre;
    }

    public void setCod_barre(String cod_barre) {
        this.cod_barre = cod_barre;
    }

    public String getCodice_articolo() {
        return this.codice_articolo;
    }

    public void setCodice_articolo(String codice_articolo) {
        this.codice_articolo = codice_articolo;
    }

    public String getDescrizione() {
        return this.descrizione;
    }

    public void setDescrizione(String descrizione) {
        this.descrizione = descrizione;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId_gruppo() {
        return this.id_gruppo;
    }

    public void setId_gruppo(int id_gruppo) {
        this.id_gruppo = id_gruppo;
    }

    public int getId_um() {
        return this.id_um;
    }

    public void setId_um(int id_um) {
        this.id_um = id_um;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public Money getUltimo_costo_acquisto() {
        return this.ultimo_costo_acquisto;
    }

    public void setUltimo_costo_acquisto(Money ultimo_costo_acquisto) {
        this.ultimo_costo_acquisto = ultimo_costo_acquisto;
    }

    public String getNome_gruppo() {
        return this.nome_gruppo;
    }

    public void setNome_gruppo(String nome_gruppo) {
        this.nome_gruppo = nome_gruppo;
    }

    public String getCodice_um() {
        return this.codice_um;
    }

    public void setCodice_um(String codice_um) {
        this.codice_um = codice_um;
    }

    public int getId_aliquota() {
        return this.id_aliquota;
    }

    public void setId_aliquota(int id_aliquota) {
        this.id_aliquota = id_aliquota;
    }

    public InsiemePrezziListino getInsieme_pl() {
        return this.insieme_pl;
    }

    public void setInsieme_pl(InsiemePrezziListino insieme_pl) {
        this.insieme_pl = insieme_pl;
    }

    public boolean inserisci(boolean da_fuori) {
        String q_start = "START TRANSACTION;";
        boolean r_start = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_start);
        String query_ins = "INSERT INTO mtra_man_articoli(codice_articolo,id_gruppo,descrizione,id_unita_di_misura,codice_a_barre,ultimo_costo_di_acquisto,id_aliquota,note) VALUES ('" + this.getCodice_articolo().replaceAll("'", "''") + "'," + "'" + this.getId_gruppo() + "'," + "'" + this.getDescrizione().replaceAll("'", "''") + "'," + "'" + this.getId_um() + "'," + "'" + this.getCod_barre() + "'," + "'" + this.getUltimo_costo_acquisto() + "'," + "'" + this.getId_aliquota() + "'," + "'" + this.getNote().replaceAll("'", "''") + "')";
        boolean r_ins = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_ins);
        if (!r_start || !r_ins) {
            MyTrace.log.severe("Inserimento aRTICOLO non riuscito");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        String strSQL = "SELECT @@identity FROM mtra_man_articoli";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(strSQL);
        int id_inserito = 0;
        try {
            while (res.next()) {
                id_inserito = res.getInt("@@identity");
            }
        }
        catch (Exception e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        this.setId(id_inserito);
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mtra_man_articoli','" + this.getId() + "',NOW(),'INS','" + query_ins.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Inserimento aRTICOLO non riuscito per trace");
            Configurazioni.eccezione.gestisci("2.3", null);
            return false;
        }
        if (!da_fuori) {
            String q_commit = "COMMIT";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            if (r_commit) {
                return true;
            }
            MyTrace.log.severe("Inserimento Articolo non riuscito per commit");
            Configurazioni.eccezione.gestisci("2.4", null);
            return false;
        }
        return true;
    }

    public boolean modifica(boolean da_fuori) {
        try {
            if (!this.getCodice_articolo().equals("")) {
                String query_mod;
                boolean r_mod;
                System.out.println("Questo \u00e8 il codice dell'articolo :_" + this.getCodice_articolo() + "_");
                if (!da_fuori) {
                    String q_start = "START TRANSACTION;";
                    boolean r_start = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_start);
                }
                if (!(r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod = "UPDATE mtra_man_articoli  SET codice_articolo='" + this.getCodice_articolo().replaceAll("'", "''") + "'," + " id_gruppo=" + this.getId_gruppo() + ", " + " descrizione='" + this.getDescrizione().replaceAll("'", "''") + "', " + " id_unita_di_misura='" + this.getId_um() + "',  " + " codice_a_barre='" + this.getCod_barre() + "', " + " ultimo_costo_di_acquisto='" + this.getUltimo_costo_acquisto() + "', " + " id_aliquota='" + this.getId_aliquota() + "', " + " note='" + this.getNote().replaceAll("'", "''") + "' " + " WHERE id='" + this.getId() + "'"))) {
                    MyTrace.log.severe("Modifica Articolo non riuscita");
                    Configurazioni.eccezione.gestisci("3.2", null);
                    return false;
                }
                String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mtra_man_articoli','" + this.getId() + "',NOW(),'MOD','" + query_mod.replaceAll("'", "''") + "')";
                boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
                if (!r_trace) {
                    MyTrace.log.severe("Modifica Articolo non riuscita per trace");
                    Configurazioni.eccezione.gestisci("3.3", null);
                    return false;
                }
                if (!da_fuori) {
                    String q_commit = "COMMIT";
                    boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
                    if (r_commit) {
                        return true;
                    }
                    MyTrace.log.severe("Modifica Articolo non riuscito per commit");
                    Configurazioni.eccezione.gestisci("3.4", null);
                    return false;
                }
                return true;
            }
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE:  eccezione modifica() errore di istanziazione della configurazione o della chiamata");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE: modifica() errore di avvio o di linkaggio");
            err.printStackTrace();
        }
        return false;
    }

    public void seleziona(int id) {
        String query_seleziona = "SELECT mtra_man_articoli.*, mtra_man_gruppi.descrizione as descrizione_gruppo,  mtra_man_gruppi.nome as nome_gruppo,  conf_unita_di_misura.descrizione as descrizione_um,  conf_unita_di_misura.codice as codice_um,  conf_unita_di_misura.tipo as tipo_um,  conf_unita_di_misura.volume as volume_um  FROM mtra_man_articoli  LEFT JOIN mtra_man_gruppi ON mtra_man_articoli.id_gruppo=mtra_man_gruppi.id  LEFT JOIN conf_unita_di_misura ON mtra_man_articoli.id_unita_di_misura=conf_unita_di_misura.id where mtra_man_articoli.id='" + id + "'";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query_seleziona);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                this.setId(id);
                this.setCod_barre(res.getString("codice_a_barre"));
                this.setCodice_articolo(res.getString("codice_articolo"));
                this.setId_gruppo(res.getInt("id_gruppo"));
                this.setDescrizione(res.getString("descrizione"));
                this.setNome_gruppo(res.getString("nome_gruppo"));
                this.setId_um(res.getInt("id_unita_di_misura"));
                this.setCodice_um(res.getString("codice_um"));
                this.setId_aliquota(res.getInt("id_aliquota"));
                this.setUltimo_costo_acquisto(new Money(res.getDouble("ultimo_costo_di_acquisto")));
                this.setNote(res.getString("note"));
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("Seleziona Articolo non riuscito ");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.1", null);
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
    }

    public boolean elimina(int id) {
        String q_start = "START TRANSACTION;";
        boolean r_start = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_start);
        String query_del = "DELETE FROM mtra_man_articoli WHERE id='" + this.getId() + "'";
        boolean r_del = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_del);
        if (!r_start || !r_del) {
            MyTrace.log.severe("Elimina Articolo non riuscita");
            Configurazioni.eccezione.gestisci("3.5", null);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mtra_man_articoli','" + this.getId() + "',NOW(),'DEL','" + query_del.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Elimina Articolo non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.6", null);
            return false;
        }
        String q_commit = "COMMIT";
        boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
        if (r_commit) {
            return true;
        }
        MyTrace.log.severe("Modifica Articolo non riuscito per commit");
        Configurazioni.eccezione.gestisci("3.4", null);
        return false;
    }

    Object getColValue(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                retVal = "" + this.getCodice_articolo();
                break;
            }
            case 1: {
                retVal = "" + this.getDescrizione();
                break;
            }
            case 2: {
                retVal = this.getNome_gruppo();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }
}

