/*
 * Decompiled with CFR 0.152.
 */
package trasporti.magazzino_manutenzione;

import gestionale.MyDesktopWindow;
import gestionale.configurazioni.Configurazioni;
import java.math.BigDecimal;
import java.sql.ResultSet;
import trasporti.manutenzione_articoli.ArticoloManutenzione;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;
import utils.Quantita;

public class OggettoMagazzinoManutenzione {
    private String data_acquisto;
    private String ddi;
    private int id;
    private int id_articolo;
    private int id_ddi;
    private int id_ddu;
    private int id_magazzino_kit;
    private int idkit;
    private Quantita quantita = new Quantita(BigDecimal.ZERO);
    private Quantita q_presa = new Quantita(BigDecimal.ZERO);
    private Money prezzo_acquisto = new Money(BigDecimal.ZERO);
    private ArticoloManutenzione am;
    private boolean sel = false;
    private Funzioni f = new Funzioni();
    private FunzioniDate fda = new FunzioniDate();

    public String getData_acquisto() {
        if (this.data_acquisto == null) {
            return "0000-00-00";
        }
        return this.data_acquisto;
    }

    public void setData_acquisto(String data_acquisto) {
        this.data_acquisto = data_acquisto;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId_articolo() {
        return this.id_articolo;
    }

    public void setId_articolo(int id_articolo) {
        this.id_articolo = id_articolo;
    }

    public int getId_ddi() {
        return this.id_ddi;
    }

    public void setId_ddi(int id_ddi) {
        this.id_ddi = id_ddi;
    }

    public String getDdi() {
        return this.ddi;
    }

    public void setDdi(String ddi) {
        this.ddi = ddi;
    }

    public Quantita getQuantita() {
        return this.quantita;
    }

    public void setQuantita(Quantita quantita) {
        this.quantita = quantita;
    }

    public ArticoloManutenzione getA() {
        return this.am;
    }

    public void setA(ArticoloManutenzione a) {
        this.am = a;
    }

    public Money getPrezzo_acquisto() {
        return this.prezzo_acquisto;
    }

    public void setPrezzo_acquisto(Money prezzo_acquisto) {
        this.prezzo_acquisto = prezzo_acquisto;
    }

    public int getId_ddu() {
        return this.id_ddu;
    }

    public void setId_ddu(int id_ddu) {
        this.id_ddu = id_ddu;
    }

    public int getId_magazzino_kit() {
        return this.id_magazzino_kit;
    }

    public void setId_magazzino_kit(int id_magazzino_kit) {
        this.id_magazzino_kit = id_magazzino_kit;
    }

    public int getIdkit() {
        return this.idkit;
    }

    public void setIdkit(int idkit) {
        this.idkit = idkit;
    }

    public boolean isSel() {
        return this.sel;
    }

    public void setSel(boolean sel) {
        this.sel = sel;
    }

    public Quantita getQ_presa() {
        return this.q_presa;
    }

    public void setQ_presa(Quantita q_presa) {
        this.q_presa = q_presa;
    }

    public boolean inserisci(boolean da_fuori) {
        if (this.getId_articolo() != 0) {
            if (!da_fuori) {
                String q_start = "START TRANSACTION;";
                boolean r_start = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_start);
            }
            String query_ins = "INSERT INTO mtra_man_magazzino(id_articolo,quantita_in_magazzino,data_acquisto,costo_di_acquisto,id_ddu,id_ddi) VALUES ('" + this.getId_articolo() + "'," + "'" + this.getQuantita() + "'," + "'" + this.getData_acquisto() + "'," + "'" + this.getPrezzo_acquisto() + "'," + "" + this.f.zero_to_null(this.getId_ddu()) + "," + "" + this.f.zero_to_null(this.getId_ddi()) + ")";
            boolean r_ins = false;
            r_ins = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_ins);
            if (!r_ins) {
                String q_commit = "ROLLBACK";
                boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
                MyTrace.log.severe("Inserimento magazzino non riuscito");
                Configurazioni.eccezione.gestisci("2.2", null);
                return false;
            }
            String strSQL = "SELECT @@identity FROM mtra_man_magazzino";
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(strSQL);
            int id_inserito = 0;
            try {
                while (res.next()) {
                    id_inserito = res.getInt("@@identity");
                }
            }
            catch (Exception e) {
                Funzioni.inviaBugPerEmail(e);
                Funzioni.LogStackTrace(e);
                e.printStackTrace();
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
            this.setId(id_inserito);
            String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mtra_man_magazzino','" + this.getId() + "',NOW(),'INS','" + query_ins.replaceAll("'", "''") + "')";
            boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
            if (!r_trace) {
                MyTrace.log.severe("Inserimento magazzino non riuscito per trace");
                Configurazioni.eccezione.gestisci("2.3", null);
                return false;
            }
            if (!da_fuori) {
                String q_commit = "COMMIT";
                boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
                if (r_commit) {
                    return true;
                }
                MyTrace.log.severe("Inserimento magazzino non riuscito per commit");
                Configurazioni.eccezione.gestisci("2.4", null);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean modifica(boolean da_fuori) {
        String query_mod;
        boolean r_mod;
        if (!da_fuori) {
            String q_start = "START TRANSACTION;";
            boolean r_start = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_start);
        }
        if (!(r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod = "UPDATE mtra_man_magazzino SET id_articolo=" + this.getId_articolo() + "," + " quantita_in_magazzino=" + this.getQuantita() + ", " + " data_acquisto='" + this.getData_acquisto() + "', " + " costo_di_acquisto=" + this.getPrezzo_acquisto() + ", " + " id_ddu=" + this.f.zero_to_null(this.getId_ddu()) + ", " + " id_ddi=" + this.f.zero_to_null(this.getId_ddi()) + " " + " WHERE id='" + this.getId() + "'"))) {
            String q_commit = "ROLLBACK";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            MyTrace.log.severe("Modifica Magazzino non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mtra_man_articoli','" + this.getId() + "',NOW(),'MOD','" + query_mod.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Modifica Magazzino non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.3", null);
            return false;
        }
        if (!da_fuori) {
            String q_commit = "COMMIT";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            if (r_commit) {
                return true;
            }
            MyTrace.log.severe("Modifica Magazzino non riuscito per commit");
            Configurazioni.eccezione.gestisci("3.4", null);
            return false;
        }
        return true;
    }

    public boolean elimina(boolean da_fuori) {
        String query_del;
        boolean r_del;
        if (!da_fuori) {
            String q_start = "START TRANSACTION;";
            boolean r_start = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_start);
        }
        if (!(r_del = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_del = "DELETE FROM mtra_man_magazzino WHERE id=" + this.getId()))) {
            MyTrace.log.severe("Delete magazzino non riuscito");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mtra_man_magazzino','" + this.getId() + "',NOW(),'DEL','" + query_del.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Delete magazzino non riuscito per trace");
            Configurazioni.eccezione.gestisci("2.3", null);
            return false;
        }
        if (!da_fuori) {
            String q_commit = "COMMIT";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            if (r_commit) {
                return true;
            }
            MyTrace.log.severe("Delete magazzino non riuscito per commit");
            Configurazioni.eccezione.gestisci("2.4", null);
            return false;
        }
        return true;
    }

    Object getColValue(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                retVal = "" + this.getA().getCodice_articolo();
                break;
            }
            case 1: {
                retVal = "" + this.getA().getCodice_um();
                break;
            }
            case 2: {
                retVal = "" + this.getQuantita();
                break;
            }
            case 3: {
                retVal = this.fda.gira_data(this.getData_acquisto());
                break;
            }
            case 4: {
                retVal = "" + this.getPrezzo_acquisto();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }

    Object getColValueGiacenza(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                if (this.isSel()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case 1: {
                retVal = "" + this.getA().getNome_gruppo();
                break;
            }
            case 2: {
                retVal = "" + this.getA().getCodice_articolo();
                break;
            }
            case 3: {
                retVal = "" + this.getDdi();
                break;
            }
            case 4: {
                retVal = "" + this.getA().getCodice_um();
                break;
            }
            case 5: {
                retVal = "" + this.getQuantita();
                break;
            }
            case 6: {
                retVal = "" + this.getQ_presa();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }

    Object getColValueScelta(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                if (this.isSel()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case 1: {
                retVal = "" + this.getA().getCodice_articolo();
                break;
            }
            case 2: {
                retVal = "" + this.getA().getCodice_um();
                break;
            }
            case 3: {
                retVal = "" + this.getQuantita();
                break;
            }
            case 4: {
                retVal = this.fda.gira_data(this.getData_acquisto());
                break;
            }
            case 5: {
                retVal = "" + this.getPrezzo_acquisto();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }
}

