/*
 * Decompiled with CFR 0.152.
 */
package trasporti.magazzino_manutenzione;

import gestionale.auth.Gruppo;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import trasporti.magazzino_manutenzione.OggettoMagazzinoManutenzione;
import trasporti.manutenzione_articoli.ArticoloManutenzione;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.FunzioniTrasporti;
import utils.Money;
import utils.Quantita;

public class MagazzinoManutenzioneTableModel
extends AbstractTableModel {
    Vector cache;
    int colCount;
    String[] headers;
    boolean modo_ric = false;
    boolean modificabile = true;
    Funzioni f = new Funzioni();
    FunzioniDate fda = new FunzioniDate();
    private FunzioniTrasporti ft = new FunzioniTrasporti();

    public MagazzinoManutenzioneTableModel(boolean mod) {
        this.cache = new Vector();
        this.modificabile = mod;
    }

    public void setModo_ric(boolean modo_ric) {
        this.modo_ric = modo_ric;
    }

    @Override
    public String getColumnName(int i) {
        String retVal = "";
        switch (i) {
            case 0: {
                retVal = "Codice Articolo";
                break;
            }
            case 1: {
                retVal = "Unit\u00e0 di misura";
                break;
            }
            case 2: {
                retVal = "Quantit\u00e0";
                break;
            }
            case 3: {
                retVal = "Data di acquisto";
                break;
            }
            case 4: {
                retVal = "Prezzo di acquisto";
                break;
            }
            default: {
                retVal = this.headers[i];
            }
        }
        return retVal;
    }

    @Override
    public int getRowCount() {
        return this.cache.size();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public Object getValueAt(int row, int col) {
        OggettoMagazzinoManutenzione om = new OggettoMagazzinoManutenzione();
        if (this.cache.size() != 0) {
            om = (OggettoMagazzinoManutenzione)this.cache.elementAt(row);
            return om.getColValue(col);
        }
        return "";
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        OggettoMagazzinoManutenzione om = (OggettoMagazzinoManutenzione)this.cache.elementAt(row);
        ArticoloManutenzione a = new ArticoloManutenzione();
        if (col == 0) {
            a.seleziona(this.ft.id_articolo_manutenzione_da_codice(value.toString()));
            om.setId_articolo(this.ft.id_articolo_manutenzione_da_codice(value.toString()));
            om.setA(a);
            om.setQuantita(new Quantita(BigDecimal.ONE));
            om.setPrezzo_acquisto(a.getUltimo_costo_acquisto());
        }
        if (col == 2) {
            om.setQuantita(new Quantita(value.toString()));
        }
        if (col == 3) {
            om.setData_acquisto(this.fda.gira_data(value.toString()));
        }
        if (col == 4) {
            om.setPrezzo_acquisto(new Money(value.toString()));
        }
        this.fireTableRowsUpdated(row, row);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (this.modificabile) {
            return col == 0 || col == 2 || col == 3 || col == 4;
        }
        return false;
    }

    public void addRow(Gruppo g) {
        this.cache.add(0, g);
        this.fireTableDataChanged();
    }

    public void setDataMagazzino(Vector vettoreOM) {
        this.cache = new Vector();
        Iterator i = vettoreOM.iterator();
        while (i.hasNext()) {
            this.cache.addElement(i.next());
        }
        this.fireTableChanged(null);
    }
}

