/*
 * Decompiled with CFR 0.152.
 */
package trasporti.magazzino_manutenzione;

import gestionale.configurazioni.Configurazioni;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Vector;
import trasporti.magazzino_manutenzione.OggettoMagazzinoManutenzione;
import trasporti.manutenzione_articoli.ArticoloManutenzione;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;
import utils.Quantita;

public class InsiemeOggettiMagazzinoManutenzione {
    public Vector vettoreOM;
    int colCount;
    public String[] headers;
    private FunzioniDate fda = new FunzioniDate();

    public InsiemeOggettiMagazzinoManutenzione() {
        this.vettoreOM = new Vector();
    }

    public int caricamento(String where, String order_by) {
        this.vettoreOM = new Vector();
        String query = " SELECT mtra_man_magazzino.*, mtra_man_articoli.ultimo_costo_di_acquisto as costo_di_acquisto, mtra_man_articoli.codice_articolo,mtra_man_articoli.id_aliquota, mtra_man_articoli.id_gruppo, mtra_man_articoli.descrizione, mtra_man_articoli.id_unita_di_misura, mtra_man_articoli.codice_a_barre, mtra_man_articoli.note as note_articolo, conf_unita_di_misura.codice as codice_um,  mtra_man_gruppi.nome as nome_gruppo  FROM mtra_man_magazzino LEFT JOIN mtra_man_articoli ON mtra_man_magazzino.id_articolo=mtra_man_articoli.id LEFT JOIN mtra_man_gruppi ON mtra_man_articoli.id_gruppo=mtra_man_gruppi.id LEFT JOIN conf_unita_di_misura ON mtra_man_articoli.id_unita_di_misura=conf_unita_di_misura.id ";
        query = query + " " + where;
        query = query + " " + order_by;
        try {
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
            while (res.next()) {
                OggettoMagazzinoManutenzione om = new OggettoMagazzinoManutenzione();
                om.setId(res.getInt("id"));
                om.setId_articolo(res.getInt("id_articolo"));
                om.setQuantita(new Quantita(res.getDouble("quantita_in_magazzino")));
                om.setData_acquisto(res.getString("data_acquisto"));
                om.setId_ddi(res.getInt("id_ddi"));
                om.setPrezzo_acquisto(new Money(res.getDouble("costo_di_acquisto")));
                om.setId_ddu(res.getInt("id_ddu"));
                ArticoloManutenzione a = new ArticoloManutenzione();
                a.setId(res.getInt("id_articolo"));
                a.setCodice_articolo(res.getString("codice_articolo"));
                a.setNome_gruppo(res.getString("nome_gruppo"));
                a.setCodice_um(res.getString("codice_um"));
                a.setId_aliquota(res.getInt("id_aliquota"));
                a.setId_gruppo(res.getInt("id_gruppo"));
                a.setDescrizione(res.getString("descrizione"));
                a.setId_um(res.getInt("id_unita_di_misura"));
                a.setCod_barre(res.getString("codice_a_barre"));
                a.setUltimo_costo_acquisto(new Money(res.getDouble("costo_di_acquisto")));
                a.setNote(res.getString("note_articolo"));
                om.setA(a);
                this.vettoreOM.addElement(om);
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        }
        catch (Exception e) {
            this.vettoreOM = new Vector();
            MyTrace.log.severe("Seleziona Oggetto in magazzino non riuscito");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.2", null);
        }
        return this.vettoreOM.size();
    }

    public int caricamento_giacenza(String where, String order_by) {
        this.vettoreOM = new Vector();
        Vector<OggettoMagazzinoManutenzione> tutti = new Vector<OggettoMagazzinoManutenzione>();
        ArrayList<String> array_id_articoli = new ArrayList<String>();
        String query = "Select mtra_man_magazzino.quantita_in_magazzino as quantita,mtra_man_magazzino.id_articolo,mtra_man_magazzino.id_ddi,mtra_man_ddi.numero_fattura,mtra_man_ddi.numero_ddt,mtra_man_ddi.data_fattura,mtra_man_ddi.data_ddt,anag_anagrafica.ragione_sociale,mtra_man_articoli.ultimo_costo_di_acquisto as costo_di_acquisto,mtra_man_magazzino.data_acquisto,mtra_man_articoli.codice_articolo,conf_unita_di_misura.codice as codice_um, mtra_man_gruppi.nome as nome_gruppo from mtra_man_magazzino LEFT JOIN mtra_man_articoli ON mtra_man_magazzino.id_articolo=mtra_man_articoli.id LEFT JOIN mtra_man_gruppi ON mtra_man_articoli.id_gruppo=mtra_man_gruppi.id LEFT JOIN mtra_man_ddi ON mtra_man_magazzino.id_ddi=mtra_man_ddi.id LEFT JOIN anag_anagrafica ON mtra_man_ddi.id_anagrafica=anag_anagrafica.idanagrafica LEFT JOIN conf_unita_di_misura ON mtra_man_articoli.id_unita_di_misura=conf_unita_di_misura.id ";
        query = query + " " + where;
        query = query + " " + order_by;
        try {
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
            while (res.next()) {
                String verifica = res.getInt("id_articolo") + "-" + res.getInt("id_ddi");
                if (array_id_articoli.contains(verifica)) {
                    for (OggettoMagazzinoManutenzione om_temp : tutti) {
                        if (om_temp.getId_articolo() != res.getInt("id_articolo") || om_temp.getId_ddi() != res.getInt("id_ddi")) continue;
                        om_temp.getQuantita().plusplus(new Quantita(res.getDouble("quantita")));
                    }
                    continue;
                }
                OggettoMagazzinoManutenzione om = new OggettoMagazzinoManutenzione();
                om.setId_articolo(res.getInt("id_articolo"));
                om.setQuantita(new Quantita(res.getDouble("quantita")));
                om.setPrezzo_acquisto(new Money(res.getDouble("costo_di_acquisto")));
                om.setData_acquisto(res.getString("data_acquisto"));
                om.setId_ddi(res.getInt("id_ddi"));
                if (res.getString("numero_ddt") != null && !res.getString("numero_ddt").equals("")) {
                    om.setDdi("DDT N\u00b0" + res.getString("numero_ddt") + " del " + this.fda.gira_data(res.getString("data_ddt")));
                } else {
                    om.setDdi("FATTURA N\u00b0" + res.getString("numero_fattura") + " del " + this.fda.gira_data(res.getString("data_fattura")));
                }
                ArticoloManutenzione a = new ArticoloManutenzione();
                a.setId(res.getInt("id_articolo"));
                a.setCodice_articolo(res.getString("codice_articolo"));
                a.setNome_gruppo(res.getString("nome_gruppo"));
                a.setCodice_um(res.getString("codice_um"));
                om.setA(a);
                if (om.getQuantita().isZero()) continue;
                tutti.addElement(om);
                array_id_articoli.add(verifica);
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
            for (OggettoMagazzinoManutenzione om : tutti) {
                if (om.getQuantita().isZero()) continue;
                this.vettoreOM.add(om);
            }
        }
        catch (Exception e) {
            this.vettoreOM = new Vector();
            MyTrace.log.severe("Seleziona Oggetto in magazzino non riuscito");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.2", null);
        }
        return this.vettoreOM.size();
    }
}

