/*
 * Decompiled with CFR 0.152.
 */
package trasporti.listini;

import anagrafiche.clienti_fornitori.Anagrafica;
import gestionale.MyDesktopWindow;
import gestionale.configurazioni.Configurazioni;
import java.sql.ResultSet;
import trasporti.listini.InsiemePrezzi;
import trasporti.listini.Prezzo;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.FunzioniTrasporti;
import utils.MyTrace;

public class TraListino {
    private String data_stipula;
    private String data_um;
    private String note;
    private String codice_cf;
    private String ragione_sociale_cf;
    private String cf;
    private String nome_listino;
    private int id;
    private int id_anagrafica;
    private int contratto;
    private int tipologia_listino;
    private int id_conf_um;
    private InsiemePrezzi insieme_pt;
    private InsiemePrezzi insieme_po;
    private Anagrafica anagrafica;
    private Funzioni f = new Funzioni();
    private FunzioniDate fda = new FunzioniDate();
    private FunzioniTrasporti ft = new FunzioniTrasporti();

    public int getContratto() {
        return this.contratto;
    }

    public void setContratto(int contratto) {
        this.contratto = contratto;
    }

    public String getData_stipula() {
        return this.data_stipula;
    }

    public String getData_stipulaIt() {
        return this.fda.gira_data(this.data_stipula);
    }

    public void setData_stipula(String data_stipula) {
        this.data_stipula = data_stipula;
    }

    public String getData_um() {
        return this.data_um;
    }

    public String getData_umIt() {
        return this.fda.gira_data(this.data_um);
    }

    public void setData_um(String data_um) {
        this.data_um = data_um;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId_conf_um() {
        return this.id_conf_um;
    }

    public void setId_conf_um(int id_conf_um) {
        this.id_conf_um = id_conf_um;
    }

    public int getTipologia_listino() {
        return this.tipologia_listino;
    }

    public void setTipologia_listino(int tipologia_listino) {
        this.tipologia_listino = tipologia_listino;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getCodice_cf() {
        return this.codice_cf;
    }

    public void setCodice_cf(String codice_cf) {
        this.codice_cf = codice_cf;
    }

    public String getRagione_sociale_cf() {
        return this.ragione_sociale_cf;
    }

    public void setRagione_sociale_cf(String ragione_sociale_cf) {
        this.ragione_sociale_cf = ragione_sociale_cf;
    }

    public String getCf() {
        return this.cf;
    }

    public void setCf(String cf) {
        this.cf = cf;
    }

    public InsiemePrezzi getInsieme_po() {
        return this.insieme_po;
    }

    public void setInsieme_po(InsiemePrezzi insieme_po) {
        this.insieme_po = insieme_po;
    }

    public InsiemePrezzi getInsieme_pt() {
        return this.insieme_pt;
    }

    public void setInsieme_pt(InsiemePrezzi insieme_pt) {
        this.insieme_pt = insieme_pt;
    }

    public String getNome_listino() {
        return this.nome_listino;
    }

    public void setNome_listino(String nome_listino) {
        this.nome_listino = nome_listino;
    }

    public Anagrafica getAnagrafica() {
        return this.anagrafica;
    }

    public void setAnagrafica(Anagrafica anagrafica) {
        this.anagrafica = anagrafica;
    }

    public int getId_anagrafica() {
        return this.id_anagrafica;
    }

    public void setId_anagrafica(int id_anagrafica) {
        this.id_anagrafica = id_anagrafica;
    }

    public boolean inserisci(boolean da_fuori) {
        String query_ins;
        boolean r_ins;
        if (!da_fuori) {
            String q_start = "START TRANSACTION;";
            boolean r_start = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_start);
        }
        if (!(r_ins = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_ins = "INSERT INTO mtra_listini(id_anagrafica,tipo_anag,nome,contratto,data_stipula,data_ultimo_aggiornamento,note,tipologia_listino,id_conf_um) VALUES (" + this.f.zero_to_null(this.getId_anagrafica()) + "," + "'" + this.getCf() + "'," + "'" + this.getNome_listino().replaceAll("'", "''") + "'," + "" + this.getContratto() + "," + "'" + this.getData_stipula() + "'," + "'" + this.getData_um() + "'," + "'" + this.getNote().replaceAll("'", "''") + "'," + "" + this.getTipologia_listino() + "," + "" + this.f.zero_to_null(this.getId_conf_um()) + ")"))) {
            String q_commit = "ROLLBACK";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            MyTrace.log.severe("Inserimento mtra_listini non riuscito");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        String strSQL = "SELECT @@identity FROM mtra_listini";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(strSQL);
        int id_inserito = 0;
        try {
            while (res.next()) {
                id_inserito = res.getInt("@@identity");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        this.setId(id_inserito);
        boolean res_t = true;
        boolean res_o = true;
        for (Prezzo p : this.insieme_po.vettorePL) {
            p.setId_listino(id_inserito);
            res_o = p.inserisci();
        }
        for (Prezzo p : this.insieme_pt.vettorePL) {
            p.setId_listino(id_inserito);
            res_t = p.inserisci();
        }
        if (!res_t || !res_o) {
            String q_commit = "ROLLBACK";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            MyTrace.log.severe("Inserimento mtra_listini non riuscito per trace");
            Configurazioni.eccezione.gestisci("2.3", null);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mtra_listini','" + this.getId() + "',NOW(),'INS','" + query_ins.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Inserimento mtra_listini non riuscito per trace");
            Configurazioni.eccezione.gestisci("2.3", null);
            return false;
        }
        if (!da_fuori) {
            String q_commit = "COMMIT";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            if (r_commit) {
                return true;
            }
            MyTrace.log.severe("Inserimento mtra_listini non riuscito per commit");
            Configurazioni.eccezione.gestisci("2.4", null);
            return false;
        }
        return true;
    }

    public boolean modifica(boolean da_fuori) {
        String query_mod;
        boolean r_mod;
        if (!da_fuori) {
            String q_start = "START TRANSACTION;";
            boolean r_start = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_start);
        }
        if (!(r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod = "UPDATE mtra_listini SET  id_anagrafica=" + this.f.zero_to_null(this.getId_anagrafica()) + ", " + " tipo_anag='" + this.getCf() + "', " + " nome='" + this.getNome_listino().replaceAll("'", "''") + "', " + " contratto=" + this.getContratto() + ", " + " data_stipula='" + this.getData_stipula() + "', " + " data_ultimo_aggiornamento='" + this.getData_um() + "', " + " tipologia_listino=" + this.getTipologia_listino() + ", " + " note='" + this.getNote().replaceAll("'", "''") + "', " + " id_conf_um=" + this.f.zero_to_null(this.getId_conf_um()) + " " + " WHERE idListino='" + this.getId() + "'"))) {
            String q_commit = "ROLLBACK";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            MyTrace.log.severe("Modifica mtra_listini non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            return false;
        }
        boolean res_t = true;
        boolean res_o = true;
        for (Prezzo p : this.insieme_po.vettorePL) {
            p.setId_listino(this.getId());
            if (p.getId() == 0) {
                res_o = p.inserisci();
                continue;
            }
            res_o = p.modifica();
        }
        for (Prezzo p : this.insieme_pt.vettorePL) {
            p.setId_listino(this.getId());
            if (p.getId() == 0) {
                res_t = p.inserisci();
                continue;
            }
            res_t = p.modifica();
        }
        if (!res_t || !res_o) {
            String q_commit = "ROLLBACK";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            MyTrace.log.severe("Inserimento mtra_listini non riuscito per trace");
            Configurazioni.eccezione.gestisci("2.3", null);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mtra_listini','" + this.getId() + "',NOW(),'MOD','" + query_mod.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Modifica mtra_listini non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.3", null);
            return false;
        }
        if (!da_fuori) {
            String q_commit = "COMMIT";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            if (r_commit) {
                return true;
            }
            MyTrace.log.severe("Modifica mtra_listini non riuscito per commit");
            Configurazioni.eccezione.gestisci("3.4", null);
            return false;
        }
        return true;
    }

    public void selezionaDati() {
        this.setInsieme_po(new InsiemePrezzi());
        String w = " WHERE mtra_prezzi.id_opzione !=0 AND mtra_prezzi.id_listino=" + this.getId();
        this.insieme_po.ccaricamento(w, "");
        this.setInsieme_pt(new InsiemePrezzi());
        String w2 = " WHERE mtra_prezzi.id_tratta !=0 AND mtra_prezzi.id_listino=" + this.getId();
        this.insieme_pt.ccaricamento(w2, "");
        this.setAnagrafica(new Anagrafica());
        this.getAnagrafica().seleziona_da_id(this.getId_anagrafica());
    }

    public boolean elimina(boolean da_fuori) {
        String query_del;
        boolean r_del;
        if (!da_fuori) {
            String q_start = "START TRANSACTION;";
            boolean r_start = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_start);
        }
        if (!(r_del = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_del = "DELETE FROM mtra_listini WHERE idListino=" + this.getId()))) {
            MyTrace.log.severe("Delete mtra_listini non riuscito");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mtra_listini','" + this.getId() + "',NOW(),'DEL','" + query_del.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("DElete mtra_listini non riuscito per trace");
            Configurazioni.eccezione.gestisci("2.3", null);
            return false;
        }
        if (!da_fuori) {
            String q_commit = "COMMIT";
            boolean r_commit = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_commit);
            if (r_commit) {
                return true;
            }
            MyTrace.log.severe("Delete mtra_listini non riuscito per commit");
            Configurazioni.eccezione.gestisci("2.4", null);
            return false;
        }
        return true;
    }

    Object getColValue(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                retVal = this.f.si_no(this.getContratto());
                break;
            }
            case 1: {
                retVal = this.getCf() + this.getCodice_cf();
                break;
            }
            case 2: {
                retVal = this.getRagione_sociale_cf();
                break;
            }
            case 3: {
                retVal = this.ft.nome_tipologia_listini(this.getTipologia_listino());
                break;
            }
            case 4: {
                try {
                    retVal = (" " + this.getNome_listino() + " ").replaceAll(" null ", "");
                }
                catch (Exception exception) {}
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }
}

