/*
 * Decompiled with CFR 0.152.
 */
package trasporti.fatturazione;

import gestionale.documenti.Documento;
import gestionale.documenti.RigaDocumento;
import java.math.BigDecimal;
import trasporti.ordini.RigaOrdineViaggio;
import utils.Funzioni;
import utils.Money;

public class TraFatturaAttiva
extends Documento {
    Funzioni f = new Funzioni();
    Money ricavi_diretti = new Money(BigDecimal.ZERO);
    Money ricavi_indiretti = new Money(BigDecimal.ZERO);
    Money totale_ricavi = new Money(BigDecimal.ZERO);

    public Money getRicavi_diretti() {
        return this.ricavi_diretti;
    }

    public void setRicavi_diretti(Money ricavi_diretti) {
        this.ricavi_diretti = ricavi_diretti;
    }

    public Money getRicavi_indiretti() {
        return this.ricavi_indiretti;
    }

    public void setRicavi_indiretti(Money ricavi_indiretti) {
        this.ricavi_indiretti = ricavi_indiretti;
    }

    public Money getTotale_ricavi() {
        return this.totale_ricavi;
    }

    public void setTotale_ricavi(Money totale_ricavi) {
        this.totale_ricavi = totale_ricavi;
    }

    @Override
    public void seleziona_dettagli() {
        super.seleziona_dettagli();
        for (RigaDocumento rd : this.getInsieme_r().vettoreR) {
            rd.setRiga_ov(new RigaOrdineViaggio());
            String w = " WHERE id_riga_doc=" + rd.getId_riga() + " ";
            rd.getRiga_ov().seleziona_da_riga_fattura(w);
        }
    }

    Object getColValue(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                try {
                    retVal = this.getR().getCodice_causale_contabile();
                }
                catch (Exception x) {
                    retVal = this.f.codice_CC(this.getId_causale_contabile());
                }
                break;
            }
            case 1: {
                retVal = "" + this.getNumero();
                if (this.getCodifica().equals("")) break;
                retVal = retVal + "/" + this.getCodifica();
                break;
            }
            case 2: {
                retVal = "" + this.getAnno();
                break;
            }
            case 3: {
                retVal = "" + this.getR().getData_docIt();
                break;
            }
            case 4: {
                retVal = "" + this.getR().getRagione_sociale_cf();
                break;
            }
            case 5: {
                retVal = "" + this.getDescrizione();
                break;
            }
            case 6: {
                retVal = this.f.formattaNumero("" + this.getR().getImporto_doc());
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }

    public Object getColValueRicavi(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                retVal = this.getR().getData_docIt();
                break;
            }
            case 1: {
                retVal = "" + this.getNumero() + " " + this.getCodifica() + "/" + this.getAnno();
                break;
            }
            case 2: {
                retVal = "" + this.getRicavi_diretti();
                break;
            }
            case 3: {
                retVal = "" + this.getRicavi_indiretti();
                break;
            }
            case 4: {
                retVal = "" + this.getTotale_ricavi();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }
}

