/*
 * Decompiled with CFR 0.152.
 */
package trasporti.borderaux;

import anagrafiche.mezzi.InsiemeMezzi;
import anagrafiche.mezzi.MezziBreveTableModel;
import anagrafiche.mezzi.Mezzo;
import anagrafiche.mezzi.MyMezzi;
import gestionale.configurazioni.ConfigurazioneFinestre;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import trasporti.autista.Autista;
import trasporti.autista.AutistiBreveTableModel;
import trasporti.autista.InsiemeAutisti;
import trasporti.autista.MyAutisti;
import trasporti.borderaux.OrdiniBTableModel;
import trasporti.borderaux.OrdiniBTableRenderer;
import trasporti.indirizzi.IndirizzoPresaConsegna;
import trasporti.listini.InsiemePrezzi;
import trasporti.listini.InsiemeTraListini;
import trasporti.listini.Opzione;
import trasporti.listini.Prezzo;
import trasporti.listini.TraListino;
import trasporti.ordini.InsiemeOrdini;
import trasporti.ordini.InsiemeRigheOrdineViaggio;
import trasporti.ordini.MyOrdini;
import trasporti.ordini.Ordine;
import trasporti.ordini.RigaOrdineViaggio;
import trasporti.prese_consegne.InsiemePC;
import trasporti.prese_consegne.MyPreseConsegne;
import trasporti.prese_consegne.PCRiassuntoTableModel;
import trasporti.prese_consegne.PresaConsegna;
import trasporti.prese_consegne.PreseConsegneTableModel;
import trasporti.tratte.Tratta;
import trasporti.viaggi.InsiemeViaggi;
import trasporti.viaggi.OccupatiTableRenderer;
import trasporti.viaggi.RigheViaggiTableModel;
import trasporti.viaggi.Transfer;
import trasporti.viaggi.ViaggiTableModel;
import trasporti.viaggi.Viaggio;
import utils.AvvioSuThread;
import utils.ClientiFornitoriField;
import utils.ComboInsertEditor;
import utils.DateField;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.FunzioniTrasporti;
import utils.GenericTableRenderer;
import utils.Money;
import utils.MyTrace;
import utils.Performance;
import utils.Quantita;
import utils.RicercaCellComboRenderer;
import utils.RicercaCellRenderer;
import utils.TextInsertEditor;
import utils.TimeFormatter;

public class MyBorderaux
extends JInternalFrame {
    AutistiBreveTableModel atm;
    InsiemeAutisti insieme_a;
    Vector autisti_assegnati = new Vector();
    InsiemeMezzi insieme_tr;
    InsiemeMezzi insieme_sr;
    MezziBreveTableModel trtm;
    MezziBreveTableModel srtm;
    Vector tr_assegnati = new Vector();
    Vector sr_assegnati = new Vector();
    PCRiassuntoTableModel pctm;
    InsiemePC insieme_pc;
    public PreseConsegneTableModel precontm = new PreseConsegneTableModel();
    public DateField data_ordine;
    public DateField data_partenza;
    TimeFormatter mf = null;
    TimeFormatter mf_1 = null;
    Ordine o_selezione;
    public Viaggio v_selezione;
    InsiemeOrdini insieme_o;
    InsiemeViaggi insieme_v;
    Vector vettorePanel;
    Vector vettorePanelV;
    Vector colori;
    int countV = 0;
    JPanel panel;
    int order_max;
    int order_previous;
    JTable table_ordini;
    JTable table_viaggi;
    ViaggiTableModel vtm;
    public RigheViaggiTableModel rvtm;
    JToolBar jToolBarMod;
    private int riga_viaggio_selezionata;
    boolean in_modifica = false;
    boolean in_new = false;
    public boolean f_autisti_open = false;
    public boolean f_mezzi_open = false;
    public boolean f_pc_open = false;
    public boolean f_o_open = false;
    private Funzioni f = new Funzioni();
    private FunzioniDate fda = new FunzioniDate();
    private FunzioniTrasporti ft = new FunzioniTrasporti();
    public ClientiFornitoriField jTextVettore;
    private DragGestureListener dragHandlerAutisti = new DragGestureListener(){

        @Override
        public void dragGestureRecognized(DragGestureEvent evt) {
            System.out.println("Drag...");
            Autista a = (Autista)MyBorderaux.this.insieme_a.vettoreAutisti.elementAt(MyBorderaux.this.jTableAutisti.getSelectedRow());
            Transfer trans = new Transfer((Autista)MyBorderaux.this.insieme_a.vettoreAutisti.elementAt(MyBorderaux.this.jTableAutisti.getSelectedRow()));
            evt.startDrag(DragSource.DefaultLinkNoDrop, trans);
        }
    };
    private DropTargetListener dropHandlerAutisti = new DropTargetAdapter(){

        @Override
        public void drop(DropTargetDropEvent evt) {
            System.out.println("Drop...");
            if (evt.isDataFlavorSupported(Transfer.FLAVOR)) {
                Transferable t = evt.getTransferable();
                try {
                    evt.acceptDrop(1);
                    Autista a = new Autista();
                    try {
                        a = (Autista)t.getTransferData(Transfer.FLAVOR);
                        System.out.println("Drop is: " + a.getCognome());
                        MyBorderaux.this.jTextAutista.setText(a.getCognome());
                        MyBorderaux.this.v_selezione.setId_autista(a.getIdautista());
                        MyBorderaux.this.v_selezione.setAutista(a);
                        ((Autista)MyBorderaux.this.insieme_a.vettoreAutisti.elementAt(MyBorderaux.this.jTableAutisti.getSelectedRow())).setAssegnato(true);
                        MyBorderaux.this.autisti_assegnati.removeAllElements();
                        Iterator i = MyBorderaux.this.insieme_a.vettoreAutisti.iterator();
                        while (i.hasNext()) {
                            MyBorderaux.this.autisti_assegnati.add(((Autista)i.next()).isAssegnato());
                        }
                        MyBorderaux.this.atm.setDataAutisti(MyBorderaux.this.insieme_a.vettoreAutisti);
                        MyBorderaux.this.jTableAutisti.setDefaultRenderer(Object.class, new OccupatiTableRenderer(MyBorderaux.this.autisti_assegnati));
                        evt.dropComplete(true);
                    }
                    catch (ClassCastException e) {
                        evt.dropComplete(false);
                        Funzioni.inviaBugPerEmail(e);
                        Funzioni.LogStackTrace(e);
                    }
                }
                catch (UnsupportedFlavorException e) {
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                    evt.dropComplete(false);
                    throw new InternalError();
                }
                catch (IOException e) {
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                    evt.dropComplete(false);
                    throw new InternalError();
                }
            } else {
                evt.rejectDrop();
            }
        }
    };
    private DragGestureListener dragHandlerTr = new DragGestureListener(){

        @Override
        public void dragGestureRecognized(DragGestureEvent evt) {
            System.out.println("Drag...");
            Mezzo a = (Mezzo)MyBorderaux.this.insieme_tr.vettoreMacchine.elementAt(MyBorderaux.this.jTableTrattori.getSelectedRow());
            Transfer trans = new Transfer((Mezzo)MyBorderaux.this.insieme_tr.vettoreMacchine.elementAt(MyBorderaux.this.jTableTrattori.getSelectedRow()));
            evt.startDrag(DragSource.DefaultLinkNoDrop, trans);
        }
    };
    private DropTargetListener dropHandlerTr = new DropTargetAdapter(){

        @Override
        public void drop(DropTargetDropEvent evt) {
            System.out.println("Drop...");
            if (evt.isDataFlavorSupported(Transfer.FLAVOR)) {
                Transferable t = evt.getTransferable();
                try {
                    evt.acceptDrop(1);
                    Mezzo a = new Mezzo();
                    try {
                        a = (Mezzo)t.getTransferData(Transfer.FLAVOR);
                        System.out.println("Drop is: " + a.getTarga());
                        MyBorderaux.this.jTextTrattore.setText(a.getTarga());
                        MyBorderaux.this.v_selezione.setId_trattore(a.getId_macchina());
                        MyBorderaux.this.v_selezione.setTrattore(a);
                        ((Mezzo)MyBorderaux.this.insieme_tr.vettoreMacchine.elementAt(MyBorderaux.this.jTableTrattori.getSelectedRow())).setAsseganto(true);
                        MyBorderaux.this.tr_assegnati.removeAllElements();
                        Iterator i = MyBorderaux.this.insieme_tr.vettoreMacchine.iterator();
                        while (i.hasNext()) {
                            MyBorderaux.this.tr_assegnati.add(((Mezzo)i.next()).isAsseganto());
                        }
                        MyBorderaux.this.trtm.setDataMacchine(MyBorderaux.this.insieme_tr.vettoreMacchine);
                        MyBorderaux.this.jTableTrattori.setDefaultRenderer(Object.class, new OccupatiTableRenderer(MyBorderaux.this.tr_assegnati));
                        evt.dropComplete(true);
                    }
                    catch (ClassCastException e) {
                        Funzioni.inviaBugPerEmail(e);
                        Funzioni.LogStackTrace(e);
                        evt.dropComplete(false);
                    }
                }
                catch (UnsupportedFlavorException e) {
                    evt.dropComplete(false);
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                    throw new InternalError();
                }
                catch (IOException e) {
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                    evt.dropComplete(false);
                    throw new InternalError();
                }
            } else {
                evt.rejectDrop();
            }
        }
    };
    private DragGestureListener dragHandlerSr = new DragGestureListener(){

        @Override
        public void dragGestureRecognized(DragGestureEvent evt) {
            System.out.println("Drag...");
            Mezzo a = (Mezzo)MyBorderaux.this.insieme_sr.vettoreMacchine.elementAt(MyBorderaux.this.jTableSemirimorchi.getSelectedRow());
            Transfer trans = new Transfer((Mezzo)MyBorderaux.this.insieme_sr.vettoreMacchine.elementAt(MyBorderaux.this.jTableSemirimorchi.getSelectedRow()));
            evt.startDrag(DragSource.DefaultLinkNoDrop, trans);
        }
    };
    private DropTargetListener dropHandlerSr = new DropTargetAdapter(){

        @Override
        public void drop(DropTargetDropEvent evt) {
            System.out.println("Drop...");
            if (evt.isDataFlavorSupported(Transfer.FLAVOR)) {
                Transferable t = evt.getTransferable();
                try {
                    evt.acceptDrop(1);
                    Mezzo a = new Mezzo();
                    try {
                        a = (Mezzo)t.getTransferData(Transfer.FLAVOR);
                        System.out.println("Drop is: " + a.getTarga());
                        MyBorderaux.this.jTextRimorchio.setText(a.getTarga());
                        MyBorderaux.this.v_selezione.setId_rimorchio(a.getId_macchina());
                        MyBorderaux.this.v_selezione.setRimorchio(a);
                        ((Mezzo)MyBorderaux.this.insieme_sr.vettoreMacchine.elementAt(MyBorderaux.this.jTableSemirimorchi.getSelectedRow())).setAsseganto(true);
                        MyBorderaux.this.sr_assegnati.removeAllElements();
                        Iterator i = MyBorderaux.this.insieme_sr.vettoreMacchine.iterator();
                        while (i.hasNext()) {
                            MyBorderaux.this.sr_assegnati.add(((Mezzo)i.next()).isAsseganto());
                        }
                        MyBorderaux.this.srtm.setDataMacchine(MyBorderaux.this.insieme_sr.vettoreMacchine);
                        MyBorderaux.this.jTableSemirimorchi.setDefaultRenderer(Object.class, new OccupatiTableRenderer(MyBorderaux.this.sr_assegnati));
                        evt.dropComplete(true);
                    }
                    catch (ClassCastException e) {
                        Funzioni.inviaBugPerEmail(e);
                        Funzioni.LogStackTrace(e);
                        evt.dropComplete(false);
                    }
                }
                catch (UnsupportedFlavorException e) {
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                    evt.dropComplete(false);
                    throw new InternalError();
                }
                catch (IOException e) {
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                    evt.dropComplete(false);
                    throw new InternalError();
                }
            } else {
                evt.rejectDrop();
            }
        }
    };
    private DragGestureListener dragHandlerPrese = new DragGestureListener(){

        @Override
        public void dragGestureRecognized(DragGestureEvent evt) {
            System.out.println("Drag...");
            PresaConsegna pc = (PresaConsegna)MyBorderaux.this.insieme_pc.vettorePC.elementAt(MyBorderaux.this.jTablePC.getSelectedRow());
            Transfer trans = new Transfer((PresaConsegna)MyBorderaux.this.insieme_pc.vettorePC.elementAt(MyBorderaux.this.jTablePC.getSelectedRow()));
            evt.startDrag(DragSource.DefaultLinkNoDrop, trans);
        }
    };
    private DropTargetListener dropHandlerD = new DropTargetAdapter(){

        @Override
        public void drop(DropTargetDropEvent evt) {
            System.out.println("Drop...");
            if (evt.isDataFlavorSupported(Transfer.FLAVOR)) {
                Transferable t = evt.getTransferable();
                try {
                    evt.acceptDrop(1);
                    PresaConsegna p_nuova = new PresaConsegna();
                    Object data = t.getTransferData(Transfer.FLAVOR);
                    if (data.getClass().equals(PresaConsegna.class)) {
                        PresaConsegna p;
                        p_nuova = p = (PresaConsegna)data;
                        ((PresaConsegna)MyBorderaux.this.o_selezione.getInsieme_pc().vettorePC.elementAt(MyBorderaux.this.jTablePC.getSelectedRow())).setAssegnato(true);
                        MyBorderaux.this.o_selezione.getP_assegnati().removeAllElements();
                        for (PresaConsegna pp : MyBorderaux.this.o_selezione.getInsieme_pc().vettorePC) {
                            MyBorderaux.this.o_selezione.getP_assegnati().add(pp.isAssegnato());
                        }
                        MyBorderaux.this.pctm.setDataDettaglio(MyBorderaux.this.insieme_pc.vettorePC);
                        MyBorderaux.this.jTablePC.setDefaultRenderer(Object.class, new OccupatiTableRenderer(MyBorderaux.this.o_selezione.getP_assegnati()));
                    }
                    p_nuova.setOrdine_viaggio(MyBorderaux.this.v_selezione.getInsieme_pc().vettorePC.size());
                    p_nuova.setId_viaggio(MyBorderaux.this.v_selezione.getId());
                    MyBorderaux.this.v_selezione.getInsieme_pc().vettorePC.add(p_nuova);
                    MyBorderaux.this.precontm.setDataDettaglio(MyBorderaux.this.v_selezione.getInsieme_pc().vettorePC);
                    if ((MyBorderaux.this.data_partenza.getText().equals("00-00-0000") || MyBorderaux.this.data_partenza.getText().equals(MyBorderaux.this.fda.dataCorrenteIt())) && MyBorderaux.this.v_selezione.getInsieme_pc() != null && MyBorderaux.this.v_selezione.getInsieme_pc().vettorePC.elementAt(0) != null) {
                        PresaConsegna prima = (PresaConsegna)MyBorderaux.this.v_selezione.getInsieme_pc().vettorePC.elementAt(0);
                        MyBorderaux.this.data_partenza.setText(prima.getData_it());
                    }
                    MyBorderaux.this.o_selezione.controlla_sistemazione();
                    MyBorderaux.this.jPanel2.repaint();
                    evt.dropComplete(true);
                }
                catch (UnsupportedFlavorException e) {
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                    evt.dropComplete(false);
                    throw new InternalError();
                }
                catch (IOException e) {
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                    evt.dropComplete(false);
                    throw new InternalError();
                }
            } else {
                evt.rejectDrop();
            }
        }
    };
    private JButton JButtonEliminaRiga;
    private JButton JButtonTransito;
    private JButton JButtonTransito1;
    private ButtonGroup buttonGroup1;
    private JButton jButtonAddOrder;
    private JButton jButtonAddPC;
    private JButton jButtonAddRow;
    private JButton jButtonAddRow1;
    private JButton jButtonCreaViaggio;
    private JButton jButtonElimina;
    private JButton jButtonModifica;
    private JButton jButtonNuovoViaggio;
    private JButton jButtonRefresh;
    private JButton jButtonSalvaPrezzi;
    private JButton jButtonSpostaGiu;
    private JButton jButtonSpostaSu;
    private JCheckBox jCheckConfermato;
    private JComboBox jComboAR;
    private JLabel jLabel1;
    private JLabel jLabel11;
    private JLabel jLabel13;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabelCF;
    private JLabel jLabelCliente;
    private JLabel jLabelCodice;
    private JLabel jLabelCodice1;
    private JLabel jLabelCodice2;
    private JLabel jLabelCodice3;
    private JLabel jLabelNote;
    public JLabel jLabelRS;
    private JPanel jPanel1;
    private JPanel jPanel13;
    private JPanel jPanel14;
    private JPanel jPanel15;
    private JPanel jPanel17;
    private JPanel jPanel19;
    private JPanel jPanel2;
    private JPanel jPanel20;
    private JPanel jPanel21;
    private JPanel jPanel23;
    private JPanel jPanel25;
    private JPanel jPanel3;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel9;
    private JPanel jPanelAutisti;
    private JPanel jPanelDettaglioO;
    private JPanel jPanelDettaglioViaggio;
    private JPanel jPanelListaOrdini;
    private JPanel jPanelListaViaggi;
    private JPanel jPanelViaggi;
    private JRadioButton jRadioAssegnato;
    private JRadioButton jRadioProprio;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane10;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane6;
    private JScrollPane jScrollPane7;
    private JScrollPane jScrollPane8;
    private JTabbedPane jTabbedPane1;
    private JTabbedPane jTabbedPane3;
    private JTable jTableAutisti;
    private JTable jTableDettaglio;
    private JTable jTablePC;
    private JTable jTableRigheViaggio;
    private JTable jTableSemirimorchi;
    private JTable jTableTrattori;
    private JTextField jTextAnnoViaggio;
    public JTextField jTextAutista;
    public JTextField jTextCodiceCliente;
    public JTextArea jTextDescrizioneV;
    private JTextField jTextKm;
    public JTextField jTextNOrdine;
    private JTextField jTextNV;
    private JTextArea jTextNote;
    private JTextField jTextRicOrdine;
    public JTextField jTextRimorchio;
    public JTextField jTextTotale;
    public JTextField jTextTotale2;
    public JTextField jTextTrattaComplessiva;
    public JTextField jTextTrattore;
    private JToolBar jToolBar1;
    private JToolBar jToolBar2;
    private JToolBar jToolBar3;
    private JScrollPane scroll2;

    public MyBorderaux() {
        MyTrace.log.info("TRASPORTI ###################  ISTANZIAZIONE  MYBORDERAUX    ###############################  START");
        this.atm = new AutistiBreveTableModel();
        this.insieme_a = new InsiemeAutisti();
        this.trtm = new MezziBreveTableModel();
        this.insieme_tr = new InsiemeMezzi();
        this.srtm = new MezziBreveTableModel();
        this.insieme_sr = new InsiemeMezzi();
        this.precontm = new PreseConsegneTableModel();
        this.pctm = new PCRiassuntoTableModel();
        this.vettorePanel = new Vector();
        this.vettorePanelV = new Vector();
        this.rvtm = new RigheViaggiTableModel();
        this.initComponents();
        this.crea_toolbar();
        this.colori = this.f.crea_vettore_colori();
        this.mf_1 = new TimeFormatter();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.data_ordine = new DateField(this.mf_1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.data_ordine.setEnabled(false);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        this.jPanelDettaglioO.add((Component)this.data_ordine, gridBagConstraints);
        this.mf = new TimeFormatter();
        this.data_partenza = new DateFieldLocal(this.mf);
        this.data_partenza.setText(this.fda.dataCorrenteIt());
        this.data_partenza.setMinimumSize(new Dimension(120, 27));
        this.data_partenza.setPreferredSize(new Dimension(120, 27));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        this.jPanel2.add((Component)this.data_partenza, gridBagConstraints);
        this.jTextVettore = new ClientiFornitoriFieldLocal(this, "F");
        this.jTextVettore.tipo = "F";
        this.jTextVettore.setMinimumSize(new Dimension(100, 27));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        this.jPanel5.add((Component)this.jTextVettore, gridBagConstraints);
        this.jTableAutisti.setModel(this.atm);
        this.jTableTrattori.setModel(this.trtm);
        this.jTableSemirimorchi.setModel(this.srtm);
        this.jTablePC.setModel(this.pctm);
        this.jTableDettaglio.setModel(this.precontm);
        this.jTableDettaglio.setFillsViewportHeight(true);
        DragSource ds_a = new DragSource();
        ds_a.createDefaultDragGestureRecognizer(this.jTableAutisti, 1, this.dragHandlerAutisti);
        DropTarget dt_a = new DropTarget(this.jTextAutista, this.dropHandlerAutisti);
        DragSource ds_tr = new DragSource();
        ds_tr.createDefaultDragGestureRecognizer(this.jTableTrattori, 1, this.dragHandlerTr);
        DropTarget dt_tr = new DropTarget(this.jTextTrattore, this.dropHandlerTr);
        DragSource ds_sr = new DragSource();
        ds_sr.createDefaultDragGestureRecognizer(this.jTableSemirimorchi, 1, this.dragHandlerSr);
        DropTarget dt_sr = new DropTarget(this.jTextRimorchio, this.dropHandlerSr);
        DragSource ds_p = new DragSource();
        ds_p.createDefaultDragGestureRecognizer(this.jTablePC, 1, this.dragHandlerPrese);
        DropTarget dt_d = new DropTarget(this.jTableDettaglio, this.dropHandlerD);
        AvvioSuThread avvio_separato = new AvvioSuThread(this, "primo_caricamento_apertura_form");
        this.setLocation(ConfigurazioneFinestre.GetPoint(this.getClass().getName(), new Point(0, 20)));
        this.setSize(ConfigurazioneFinestre.GetDimension(this.getClass().getName(), new Dimension(1200, 800)));
        MyTrace.log.info("TRASPORTI ###################  ISTANZIAZIONE  MYBORDERAUX    ###############################  STOP");
    }

    public void primo_caricamento_apertura_form() {
        this.filtra();
        this.visualizzazione();
    }

    private void crea_toolbar() {
        this.jToolBarMod = new JToolBar();
        this.jToolBarMod.setBackground(Color.white);
        JButton jButtonSalva = new JButton();
        JButton jButtonAnnulla = new JButton();
        jButtonSalva.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-save-as.png")));
        jButtonSalva.setText("Salva");
        jButtonSalva.setFocusable(true);
        jButtonSalva.setBackground(Color.white);
        jButtonSalva.setVerticalTextPosition(3);
        jButtonSalva.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBorderaux.this.jButtonSalvaActionPerformed(evt);
            }
        });
        this.jToolBarMod.add(jButtonSalva);
        jButtonAnnulla.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-undo.png")));
        jButtonAnnulla.setText("Annulla");
        jButtonAnnulla.setFocusable(true);
        jButtonAnnulla.setBackground(Color.white);
        jButtonAnnulla.setVerticalTextPosition(3);
        jButtonAnnulla.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBorderaux.this.jButtonAnnullaActionPerformed(evt);
            }
        });
        this.jToolBarMod.add(jButtonAnnulla);
    }

    public void visualizzazione() {
        MyTrace.log.info("VISUALIZZAZIONE()   [START]");
        this.jComboAR.setEnabled(this.in_modifica);
        if (this.jCheckConfermato.isSelected()) {
            this.jCheckConfermato.setEnabled(false);
        } else {
            this.jCheckConfermato.setEnabled(this.in_modifica);
        }
        this.jTextDescrizioneV.setEnabled(this.in_modifica);
        this.jRadioAssegnato.setEnabled(this.in_modifica);
        this.jRadioProprio.setEnabled(this.in_modifica);
        this.data_partenza.setEnabled(this.in_modifica);
        this.jTextAutista.setEnabled(this.in_modifica);
        this.jTextTrattore.setEnabled(this.in_modifica);
        this.jTextVettore.setEnabled(this.in_modifica);
        this.jTextRimorchio.setEnabled(this.in_modifica);
        this.jTextTrattaComplessiva.setEnabled(this.in_modifica);
        this.jTextDescrizioneV.setEnabled(this.in_modifica);
        this.jButtonAddPC.setEnabled(this.in_modifica);
        this.jTableDettaglio.setEnabled(this.in_modifica);
        this.jButtonSpostaGiu.setEnabled(this.in_modifica);
        this.jButtonSpostaSu.setEnabled(this.in_modifica);
        ListSelectionModel listSelectionModel = this.jTableDettaglio.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (MyBorderaux.this.jTableDettaglio.getModel() != null && MyBorderaux.this.jTableDettaglio.getModel().getRowCount() != 0) {
                    MyBorderaux.this.riga_viaggio_selezionata = MyBorderaux.this.jTableDettaglio.getSelectedRow();
                    if (MyBorderaux.this.riga_viaggio_selezionata == 0) {
                        MyBorderaux.this.jButtonSpostaSu.setEnabled(false);
                    }
                    if (MyBorderaux.this.riga_viaggio_selezionata == MyBorderaux.this.jTableDettaglio.getModel().getRowCount() - 1) {
                        MyBorderaux.this.jButtonSpostaGiu.setEnabled(false);
                    }
                }
            }
        });
        this.jButtonSpostaGiu.setEnabled(this.in_modifica);
        this.jButtonSpostaSu.setEnabled(this.in_modifica);
        this.JButtonEliminaRiga.setEnabled(this.in_modifica);
        this.jButtonAddPC.setEnabled(this.in_modifica);
        this.jButtonSpostaGiu.setEnabled(this.in_modifica);
        this.jButtonSpostaSu.setEnabled(this.in_modifica);
        this.JButtonEliminaRiga.setEnabled(this.in_modifica);
        this.visualizza_proprio_vettore();
        if (this.in_modifica) {
            this.jPanelViaggi.remove(this.jToolBar2);
            this.jPanelViaggi.add((Component)this.jToolBarMod, "North");
            this.jTabbedPane1.setEnabledAt(0, false);
        } else {
            this.jPanelViaggi.remove(this.jToolBarMod);
            this.jPanelViaggi.add((Component)this.jToolBar2, "North");
            this.jTabbedPane1.setEnabledAt(0, true);
        }
        this.getContentPane().validate();
        this.getContentPane().repaint();
        MyTrace.log.info("VISUALIZZAZIONE()   [END]");
    }

    public void filtra() {
        MyTrace.log.info("FILTRA()   [START]");
        Performance p = new Performance("FILTRA() (01) riempe i campi");
        this.riempi_campi();
        p.fine();
        Performance p2 = new Performance("FILTRA() (02) creaTableOrdini");
        this.creaTableOrdini();
        p2.fine();
        Performance p3 = new Performance("FILTRA() (03) creaTableViaggi");
        this.creaTableViaggi();
        p3.fine();
        Performance p4 = new Performance("FILTRA() (04) filtra_mezzi");
        this.filtra_mezzi();
        p4.fine();
        MyTrace.log.info("FILTRA()   [END]");
    }

    private void creaTableOrdini() {
        this.jPanelListaOrdini.removeAll();
        OrdiniBTableModel otm = new OrdiniBTableModel();
        otm.setDataOrdini(this.insieme_o.vettoreO);
        this.table_ordini = new JTable(otm);
        JScrollPane sp = new JScrollPane(this.table_ordini);
        this.jPanelListaOrdini.add((Component)sp, "Center");
        this.table_ordini.setDefaultRenderer(Object.class, new OrdiniBTableRenderer());
        ListSelectionModel listSelectionModel = this.table_ordini.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MyBorderaux.this.seleziona_ordine(MyBorderaux.this.table_ordini.getSelectedRow());
            }
        });
        this.table_ordini.getSelectionModel().setSelectionInterval(0, 0);
        TableColumn c = this.table_ordini.getColumn("");
        c.setPreferredWidth(10);
    }

    private void creaTableViaggi() {
        this.jPanelListaViaggi.removeAll();
        this.vtm = new ViaggiTableModel();
        this.vtm.setDataViaggi(this.insieme_v.vettoreV);
        this.table_viaggi = new JTable(this.vtm);
        JScrollPane sp = new JScrollPane(this.table_viaggi);
        this.jPanelListaViaggi.add((Component)sp, "Center");
        this.table_viaggi.setDefaultRenderer(Object.class, new GenericTableRenderer());
        ListSelectionModel listSelectionModel = this.table_viaggi.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MyBorderaux.this.seleziona_viaggio(MyBorderaux.this.table_viaggi.getSelectedRow());
            }
        });
        this.table_viaggi.getSelectionModel().setSelectionInterval(0, 0);
        JTableHeader header = this.table_viaggi.getTableHeader();
        if (header != null) {
            header.setAutoscrolls(true);
            header.setBackground(new Color(255, 255, 255));
            header.setMaximumSize(new Dimension(100, 35));
            header.setMinimumSize(new Dimension(100, 35));
            header.setPreferredSize(new Dimension(100, 35));
            header.setForeground(new Color(0, 0, 102));
            header.setFont(new Font("Tahoma", 0, 11));
            header.setAlignmentX(0.5f);
            header.setAlignmentY(0.5f);
        }
        this.table_viaggi.setBackground(Color.WHITE);
        sp.setBackground(Color.white);
    }

    public void seleziona_ordine(int row) {
        try {
            if (this.insieme_o != null && !this.insieme_o.vettoreO.isEmpty()) {
                this.o_selezione = (Ordine)this.insieme_o.vettoreO.elementAt(row);
                this.riempi_campi_ordine();
            }
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE:  eccezione in seleziona_ordine(int row)");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE:  errore in seleziona_ordine(int row)");
            err.printStackTrace();
        }
    }

    public void seleziona_viaggio(int row) {
        this.costruisci_viaggio();
        if (row >= 0 && this.insieme_v != null && !this.insieme_v.vettoreV.isEmpty()) {
            this.v_selezione = (Viaggio)this.insieme_v.vettoreV.elementAt(row);
            this.riempi_campi_viaggio();
            this.filtra_mezzi();
        }
    }

    private void costruisci_viaggio() {
        if (this.v_selezione != null) {
            this.v_selezione.setDesc_breve(this.jTextTrattaComplessiva.getText());
            this.v_selezione.setDescrizione(this.jTextDescrizioneV.getText());
            this.v_selezione.setAr(this.jComboAR.getSelectedItem().toString().substring(0, 1));
            PresaConsegna prima = (PresaConsegna)this.v_selezione.getInsieme_pc().vettorePC.elementAt(0);
            PresaConsegna ultima = (PresaConsegna)this.v_selezione.getInsieme_pc().vettorePC.lastElement();
            if (this.data_partenza.getText().equals("00-00-0000") || this.data_partenza.getText().equals("  -  -    ")) {
                this.data_partenza.setText(prima.getData_it());
            }
            this.v_selezione.setData_partenza(this.fda.gira_data(this.data_partenza.getText()));
            this.v_selezione.setData_arrivo(ultima.getData());
            if (this.jCheckConfermato.isSelected()) {
                this.v_selezione.setConfermato(1);
                if (!this.v_selezione.getData_partenza().equals("0000-00-00") || !this.v_selezione.getData_partenza().equals("    -  -  ")) {
                    if (this.jTextAnnoViaggio.getText().equals("")) {
                        this.jTextAnnoViaggio.setText(this.fda.anno(this.v_selezione.getData_partenza()));
                    }
                    this.v_selezione.setAnno(Integer.parseInt(this.jTextAnnoViaggio.getText()));
                } else {
                    this.v_selezione.setAnno(this.fda.annoCorrente());
                }
                this.v_selezione.setNumero_viaggio(Integer.parseInt(this.jTextNV.getText()));
            }
        }
    }

    public void filtra_mezzi() {
        String query = " WHERE mtra_autisti.abilita='1' ";
        this.insieme_a.caricamento(query, "");
        String query2 = " WHERE abilita='1' AND trattore_semirimorchio='T' ";
        this.insieme_tr.caricamento(query2, "");
        String query3 = " WHERE abilita='1' AND trattore_semirimorchio='S' ";
        this.insieme_sr.caricamento(query3, "");
        String data_selezionata = this.fda.dataCorrente();
        if (this.v_selezione != null && this.v_selezione.getData_partenza() != null) {
            data_selezionata = this.v_selezione.getData_partenza();
        }
        for (Viaggio v : this.insieme_v.vettoreV) {
            if (!v.getData_partenza().equals(data_selezionata)) continue;
            for (Autista a : this.insieme_a.vettoreAutisti) {
                if (v.getId_autista() != a.getIdautista() || a.getJolly() == 1) continue;
                a.setAssegnato(true);
            }
            for (Mezzo m : this.insieme_tr.vettoreMacchine) {
                if (v.getId_trattore() != m.getId_macchina() || m.getJolly() == 1) continue;
                m.setAsseganto(true);
            }
            for (Mezzo m : this.insieme_sr.vettoreMacchine) {
                if (v.getId_rimorchio() != m.getId_macchina() || m.getJolly() == 1) continue;
                m.setAsseganto(true);
            }
        }
        Iterator i = this.insieme_a.vettoreAutisti.iterator();
        this.autisti_assegnati = new Vector();
        while (i.hasNext()) {
            this.autisti_assegnati.add(((Autista)i.next()).isAssegnato());
        }
        this.atm.setDataAutisti(this.insieme_a.vettoreAutisti);
        this.jTableAutisti.setModel(this.atm);
        this.jTableAutisti.setDefaultRenderer(Object.class, new OccupatiTableRenderer(this.autisti_assegnati));
        Iterator i2 = this.insieme_tr.vettoreMacchine.iterator();
        this.tr_assegnati = new Vector();
        while (i2.hasNext()) {
            this.tr_assegnati.add(((Mezzo)i2.next()).isAsseganto());
        }
        this.trtm.setDataMacchine(this.insieme_tr.vettoreMacchine);
        this.jTableTrattori.setModel(this.trtm);
        this.jTableTrattori.setDefaultRenderer(Object.class, new OccupatiTableRenderer(this.tr_assegnati));
        Iterator i3 = this.insieme_sr.vettoreMacchine.iterator();
        this.sr_assegnati = new Vector();
        while (i3.hasNext()) {
            this.sr_assegnati.add(((Mezzo)i3.next()).isAsseganto());
        }
        this.srtm.setDataMacchine(this.insieme_sr.vettoreMacchine);
        this.jTableSemirimorchi.setModel(this.srtm);
        this.jTableSemirimorchi.setDefaultRenderer(Object.class, new OccupatiTableRenderer(this.sr_assegnati));
    }

    public void riempi_campi() {
        Performance p = new Performance("riempi_campi() PARTE_A  mtra_viaggi.confermato=0 ");
        String where_v = " WHERE mtra_viaggi.confermato=0 ";
        this.insieme_v = new InsiemeViaggi();
        this.insieme_v.caricamento(where_v, "", true);
        p.fine();
        Performance p2 = new Performance("riempi_campi() PARTE_B  mtra_ordini.confermato=1 ecc.. ");
        String where = " WHERE  mtra_ordini.confermato=1  AND mtra_ordini.anno>2011 AND ((pc.num_pc!=pc.num_pc_assegnate)OR(mtra_viaggi.confermato=0)) ";
        String order_by = " ORDER BY mtra_ordini.data_ordine ASC ";
        this.insieme_o = new InsiemeOrdini();
        this.insieme_o.caricamento(where, order_by, true);
        p2.fine();
    }

    private void riempi_campi_ordine() {
        this.jTextCodiceCliente.setText("C" + this.o_selezione.getA_cliente().getCodice());
        this.jTextNOrdine.setText(this.o_selezione.getN_ordine() + " / " + this.o_selezione.getAnno_ordine());
        this.jLabelCliente.setText(this.o_selezione.getA_cliente().getRagione_sociale());
        this.data_ordine.setText(this.o_selezione.getData_ordineIt());
        this.jTextNote.setText(this.o_selezione.getNote());
        Iterator i4 = this.o_selezione.getInsieme_pc().vettorePC.iterator();
        while (i4.hasNext()) {
            this.o_selezione.getP_assegnati().add(((PresaConsegna)i4.next()).isAssegnato());
        }
        this.insieme_pc = this.o_selezione.getInsieme_pc();
        this.pctm.setDataDettaglio(this.insieme_pc.vettorePC);
        this.jTablePC.setModel(this.pctm);
        this.jTablePC.setDefaultRenderer(Object.class, new OccupatiTableRenderer(this.o_selezione.getP_assegnati()));
    }

    private void riempi_campi_viaggio() {
        if (this.v_selezione.getId_avettore() != 0) {
            this.jTextVettore.setText("F" + this.v_selezione.getCodice_vettore());
            this.jLabelRS.setText(this.v_selezione.getRag_soc_vettore());
            this.jRadioAssegnato.setSelected(true);
            this.jTextAutista.setText("");
            this.jTextTrattore.setText("");
            this.jTextRimorchio.setText("");
        } else {
            this.jTextAutista.setText(this.v_selezione.getAutista().getCognome());
            this.jTextTrattore.setText(this.v_selezione.getTrattore().getTarga());
            this.jTextRimorchio.setText(this.v_selezione.getRimorchio().getTarga());
            this.jRadioProprio.setSelected(true);
            this.jTextVettore.setText("");
            this.jLabelRS.setText("");
        }
        if (this.v_selezione.getAr().equals("A")) {
            this.jComboAR.setSelectedItem("ANDATA");
        } else {
            this.jComboAR.setSelectedItem("RITORNO");
        }
        this.jTextDescrizioneV.setText(this.v_selezione.getDescrizione());
        this.jTextTrattaComplessiva.setText(this.v_selezione.getDesc_breve());
        Iterator i4 = this.v_selezione.getInsieme_pc().vettorePC.iterator();
        this.precontm.setDataDettaglio(this.v_selezione.getInsieme_pc().vettorePC);
        this.data_partenza.setText(this.v_selezione.getData_partenza_it());
        this.jTableDettaglio.setModel(this.precontm);
        if (this.v_selezione.getConfermato() == 1) {
            this.jCheckConfermato.setSelected(true);
            this.jTextNV.setText("" + this.v_selezione.getNumero_viaggio());
            this.jTextAnnoViaggio.setText("" + this.v_selezione.getAnno());
        } else {
            this.jCheckConfermato.setSelected(false);
            this.jTextNV.setText("");
            this.jTextAnnoViaggio.setText("");
        }
    }

    private void visualizza_proprio_vettore() {
        if (this.jRadioProprio.isSelected()) {
            this.jTextAutista.setEnabled(this.in_modifica);
            this.jTextRimorchio.setEnabled(this.in_modifica);
            this.jTextTrattore.setEnabled(this.in_modifica);
            this.jTextVettore.setEnabled(false);
            if (this.v_selezione != null) {
                this.v_selezione.setId_avettore(0);
                this.v_selezione.setVettore(null);
            }
        } else {
            this.jTextAutista.setEnabled(false);
            this.jTextRimorchio.setEnabled(false);
            this.jTextTrattore.setEnabled(false);
            this.jTextVettore.setEnabled(this.in_modifica);
            if (this.v_selezione != null) {
                if (this.v_selezione.getAutista() != null) {
                    for (Object a : this.insieme_a.vettoreAutisti) {
                        if (((Autista)a).getIdautista() != this.v_selezione.getAutista().getIdautista()) continue;
                        ((Autista)a).setAssegnato(false);
                    }
                }
                if (this.v_selezione.getTrattore() != null) {
                    for (Object a : this.insieme_tr.vettoreMacchine) {
                        if (((Mezzo)a).getId_macchina() != this.v_selezione.getTrattore().getId_macchina()) continue;
                        ((Mezzo)a).setAsseganto(false);
                    }
                }
                if (this.v_selezione.getRimorchio() != null) {
                    for (Object a : this.insieme_sr.vettoreMacchine) {
                        if (((Mezzo)a).getId_macchina() != this.v_selezione.getTrattore().getId_macchina()) continue;
                        ((Mezzo)a).setAsseganto(false);
                    }
                }
                this.v_selezione.setAutista(new Autista());
                this.v_selezione.setRimorchio(new Mezzo());
                this.v_selezione.setTrattore(new Mezzo());
                this.v_selezione.setId_autista(0);
                this.v_selezione.setId_rimorchio(0);
                this.v_selezione.setId_trattore(0);
            }
        }
    }

    public void calcola_totale() {
        double tot = 0.0;
        int s = this.rvtm.getRowCount();
        for (int j = 0; j < s; ++j) {
            tot += Double.parseDouble(this.rvtm.getValueAt(j, 7).toString());
        }
        this.jTextTotale.setText(Double.toString(tot));
        this.v_selezione.setPrezzo(new Money(tot));
    }

    private TraListino cerca_listino_giusto() {
        TraListino t_da_tornare = new TraListino();
        InsiemeTraListini insieme_l = new InsiemeTraListini();
        String where = " WHERE mtra_listini.id_anagrafica =" + this.v_selezione.getId_avettore() + "" + " AND mtra_listini.tipo_anag='F' ";
        insieme_l.caricamento(where, "");
        if (!insieme_l.vettoreL.isEmpty()) {
            if (insieme_l.vettoreL.size() > 1) {
                Object[] possibilities = new String[insieme_l.vettoreL.size()];
                Iterator i = insieme_l.vettoreL.iterator();
                int count = 0;
                String scelta_zero = "";
                while (i.hasNext()) {
                    TraListino t = (TraListino)i.next();
                    possibilities[count] = "[" + t.getId() + "] " + t.getNome_listino();
                    if (count == 0) {
                        scelta_zero = "[" + t.getId() + "] " + t.getNome_listino();
                    }
                    ++count;
                }
                String s = (String)JOptionPane.showInputDialog(this, "Esistono pi\u00f9 listini per questo cliente:\n Scegli quello che vuoi usare:", "Scegli listino", -1, null, possibilities, scelta_zero);
                if (s != null && s.length() > 0) {
                    int index_seconda_quadra = s.indexOf("]");
                    int id_listino = Integer.parseInt(s.substring(1, index_seconda_quadra));
                    for (TraListino tt : insieme_l.vettoreL) {
                        if (tt.getId() != id_listino) continue;
                        tt.selezionaDati();
                        t_da_tornare = tt;
                    }
                } else {
                    JOptionPane.showMessageDialog(this, "Errore");
                    this.jTabbedPane1.setSelectedIndex(2);
                    t_da_tornare = null;
                }
            } else {
                t_da_tornare = (TraListino)insieme_l.vettoreL.elementAt(0);
            }
        } else {
            MyTrace.log.info("NON ESISTE LISTINO PER QUESTO FORNITORE");
            TraListino listino = new TraListino();
            listino.setId_anagrafica(this.v_selezione.getId_avettore());
            listino.setCf("F");
            listino.setContratto(0);
            listino.setData_um(this.fda.dataCorrente());
            listino.setData_stipula(this.fda.dataCorrente());
            listino.setTipologia_listino(1);
            listino.setId_conf_um(0);
            listino.setNote("Prezzo inserito da nuovo viaggio");
            listino.setNome_listino("Automatico");
            listino.setInsieme_pt(new InsiemePrezzi());
            listino.setInsieme_po(new InsiemePrezzi());
            t_da_tornare = listino;
        }
        return t_da_tornare;
    }

    private double conta_km() {
        double km = 0.0;
        int size = this.v_selezione.getInsieme_pc().vettorePC.size();
        this.v_selezione.setArray_tratte(new Tratta[size - 1]);
        for (int i = 0; i < size - 1; ++i) {
            this.v_selezione.getArray_tratte()[i] = this.ft.cerca_tratta_giusta((PresaConsegna)this.v_selezione.getInsieme_pc().vettorePC.elementAt(i), (PresaConsegna)this.v_selezione.getInsieme_pc().vettorePC.elementAt(i + 1), this, 0.0);
            MyTrace.log.info(this.v_selezione.getArray_tratte()[i].getCod_tratta());
            km += this.v_selezione.getArray_tratte()[i].getKm();
        }
        return km;
    }

    private void costruisci_riepilogo() {
        MyTrace.log.info("INIZIO COSTRUISCI RIEPILOGO");
        PresaConsegna prima_presa = new PresaConsegna();
        PresaConsegna ultima_cons = new PresaConsegna();
        String tratta_complessiva = "";
        Iterator i_rv = this.v_selezione.getInsieme_pc().vettorePC.iterator();
        int indice_prima_presa = 1000;
        int indice_ultima_consegna = 0;
        while (i_rv.hasNext()) {
            PresaConsegna pc = (PresaConsegna)i_rv.next();
            tratta_complessiva = tratta_complessiva + pc.getLuogo().getCodice_pt() + "-";
            if (pc.getTipo().equals("P") && pc.getOrdine_viaggio() <= indice_prima_presa) {
                indice_prima_presa = pc.getOrdine_viaggio();
                prima_presa = pc;
            }
            if (!pc.getTipo().equals("C") || pc.getOrdine_viaggio() < indice_ultima_consegna) continue;
            indice_ultima_consegna = pc.getOrdine_viaggio();
            ultima_cons = pc;
        }
        MyTrace.log.info("Indice prima presa=" + indice_prima_presa + " Prima Presa=" + prima_presa.getLuogo().getCodice_pt());
        MyTrace.log.info("Indice ultima consegna=" + indice_ultima_consegna + " Ultrima Cons=" + ultima_cons.getLuogo().getCodice_pt());
        if (tratta_complessiva.endsWith("-")) {
            tratta_complessiva = tratta_complessiva.substring(0, tratta_complessiva.length() - 1);
        }
        this.jTextTrattaComplessiva.setText(tratta_complessiva);
        this.v_selezione.setTratta_complessiva(tratta_complessiva);
        MyTrace.log.info("Tratta complessiva=" + tratta_complessiva);
        Tratta t_generica = this.ft.cerca_tratta_generica(prima_presa, ultima_cons);
        double km_approssimativi = 0.0;
        if (t_generica != null) {
            km_approssimativi = t_generica.getKm();
        }
        Tratta t_giusta = this.ft.cerca_tratta_giusta(prima_presa, ultima_cons, this, km_approssimativi);
        Tratta t_memorizzata = new Tratta();
        double tot_km = 0.0;
        if (t_giusta != null) {
            tot_km = this.v_selezione.getInsieme_pc().vettorePC.size() > 2 ? this.conta_km() : t_giusta.getKm();
            this.jTextKm.setText("" + tot_km);
            this.v_selezione.setKm_tot((int)tot_km);
        }
        boolean da_costruire = false;
        if (this.v_selezione.getInsieme_r_fp() == null || this.v_selezione.getInsieme_r_fp().vettoreR.isEmpty()) {
            MyTrace.log.info("NON HO RIGHE VIAGGIO: PRENDO LA TRATTA TROVATA PRIMA");
            this.v_selezione.setTratta(t_giusta);
            da_costruire = true;
        } else {
            MyTrace.log.info("cerco la tratta memorizzata nelle righe");
            for (RigaOrdineViaggio rov : this.v_selezione.getInsieme_r_fp().vettoreR) {
                if (!rov.getT_o().equals("T")) continue;
                t_memorizzata.seleziona(rov.getId_tratta());
                if (rov.getDescrizione_riga().substring(0, 4).equals(t_memorizzata.getDescrizione().substring(0, 4))) continue;
                int index = t_memorizzata.getDescrizione().indexOf("-");
                String uno = t_memorizzata.getDescrizione().substring(0, index - 1);
                String due = t_memorizzata.getDescrizione().substring(index + 1, t_memorizzata.getDescrizione().length());
                rov.setDescrizione_riga(due + " - " + uno);
                index = t_memorizzata.getCod_tratta().indexOf("-");
                uno = t_memorizzata.getCod_tratta().substring(0, index - 1);
                due = t_memorizzata.getCod_tratta().substring(index + 1, t_memorizzata.getCod_tratta().length());
                rov.setCodice_riga(due + " - " + uno);
            }
            if (t_giusta.getId() == 0 || t_giusta.getId() != t_memorizzata.getId()) {
                da_costruire = true;
                this.v_selezione.setTratta(t_giusta);
                MyTrace.log.info("DEVO COSTRUIRE LA RIGA ORDINE");
            } else {
                this.v_selezione.setTratta(t_memorizzata);
                da_costruire = false;
                MyTrace.log.info("NON DEVO COSTRUIRE LA RIGA ORDINE");
            }
        }
        if (this.v_selezione.getVettore() != null && this.v_selezione.getId_avettore() != 0) {
            this.v_selezione.setListino(this.cerca_listino_giusto());
        } else {
            this.v_selezione.setListino(new TraListino());
        }
        if (da_costruire) {
            if (this.v_selezione.getTratta() != null && t_generica != null) {
                if (this.v_selezione.getTratta().getId() != 0 && this.v_selezione.getListino().getId() != 0) {
                    MyTrace.log.info("CERCO IL PREZZO DELLA TRATTA SPECIFICA NEL LISTINO DEL FORNITORE");
                    boolean prezzo_trovato = this.v_selezione.getTratta().seleziona_prezzo(this.v_selezione.getListino().getId());
                    if (!prezzo_trovato) {
                        MyTrace.log.info("NON HO TROVATO IL PREZZO DELLA TRATTA SPECIFICA. CERCO QUELLO DELLA TRATTA GENERICA");
                        boolean prezzo_generica_trovato = t_generica.seleziona_prezzo(this.v_selezione.getListino().getId());
                        if (!prezzo_generica_trovato) {
                            MyTrace.log.info("NON TROVO NEANCHE IL PREZZO DELLA GENERICA => PREZZO A ZERO");
                            this.v_selezione.getTratta().setP(new Money(BigDecimal.ZERO));
                        } else {
                            MyTrace.log.info("ASSEGNO ALLA TRATTA IL PREZZO DELLA GENERICA");
                            this.v_selezione.getTratta().setPrezzo(t_generica.getPrezzo());
                            this.v_selezione.getTratta().setP(t_generica.getP());
                        }
                    } else {
                        MyTrace.log.info("TROVATO E ASSEGNATO IL PREZZO DELLA SPECIFICA");
                    }
                } else {
                    MyTrace.log.info("NON ESISTE LA TRATTA O NON ESISTE IL LISTINO => PREZZO A ZERO");
                    this.v_selezione.getTratta().setP(new Money(BigDecimal.ZERO));
                }
            } else {
                MyTrace.log.info("NON ESISTE LA TRATTA O NON ESISTE IL LISTINO => PREZZO A ZERO");
                this.v_selezione.getTratta().setP(new Money(BigDecimal.ZERO));
            }
            Vector<RigaOrdineViaggio> righe_di_prima = new Vector<RigaOrdineViaggio>();
            if (this.v_selezione.getInsieme_r_fp() != null && !this.v_selezione.getInsieme_r_fp().vettoreR.isEmpty()) {
                for (RigaOrdineViaggio ro : this.v_selezione.getInsieme_r_fp().vettoreR) {
                    if (!ro.getT_o().equals("O")) continue;
                    RigaOrdineViaggio ro_new = new RigaOrdineViaggio();
                    ro_new.setCodice_riga(ro.getCodice_riga());
                    ro_new.setDescrizione_riga(ro.getDescrizione_riga());
                    ro_new.setData_ordine(ro.getData_ordine());
                    ro_new.setId(ro_new.getId());
                    ro_new.setId_riga_documento(ro.getId_riga_documento());
                    ro_new.setId_opzione(ro.getId_viaggio());
                    ro_new.setId_viaggio(ro.getId_ordine());
                    ro_new.setId_tratta(ro.getId_tratta());
                    ro_new.setId_um(ro.getId_um());
                    ro_new.setNumero_ordine(ro.getNumero_ordine());
                    ro_new.setOpzione(ro.getOpzione());
                    ro_new.setP_for(ro.getP_for());
                    ro_new.setP_um(ro.getP_um());
                    ro_new.setPrezzo(ro.getPrezzo());
                    ro_new.setQuantita(ro.getQuantita());
                    ro_new.setT_o(ro.getT_o());
                    ro_new.setUm(ro.getUm());
                    ro_new.setRif_ordine(ro_new.getRif_ordine());
                    righe_di_prima.add(ro_new);
                }
            }
            this.v_selezione.setInsieme_r_fp(new InsiemeRigheOrdineViaggio());
            RigaOrdineViaggio ro = new RigaOrdineViaggio();
            ro.setId_viaggio(this.v_selezione.getId());
            ro.setT_o("T");
            ro.setId_tratta(this.v_selezione.getTratta().getId());
            ro.setTratta(this.v_selezione.getTratta());
            String descrizione = "";
            String codice = "";
            if (this.v_selezione.getTratta().isDa_rigirare()) {
                int index = this.v_selezione.getTratta().getDescrizione().indexOf("-");
                String uno = this.v_selezione.getTratta().getDescrizione().substring(0, index - 1);
                String due = this.v_selezione.getTratta().getDescrizione().substring(index + 1, this.v_selezione.getTratta().getDescrizione().length());
                descrizione = due + " - " + uno;
                index = this.v_selezione.getTratta().getCod_tratta().indexOf("-");
                uno = this.v_selezione.getTratta().getCod_tratta().substring(0, index - 1);
                due = this.v_selezione.getTratta().getCod_tratta().substring(index + 1, this.v_selezione.getTratta().getCod_tratta().length());
                codice = due + " - " + uno;
            } else {
                descrizione = this.v_selezione.getTratta().getDescrizione();
                codice = this.v_selezione.getTratta().getCod_tratta();
            }
            ro.setDescrizione_riga(descrizione);
            ro.setCodice_riga(codice);
            if (prima_presa.getQuantita().gteq(new Quantita("28")) && prima_presa.getId_um() == this.f.id_um("t")) {
                ro.setQuantita(prima_presa.getQuantita());
            } else {
                ro.setQuantita(new Quantita("28"));
            }
            ro.setId_um(prima_presa.getId_um());
            if (this.v_selezione.getListino().getTipologia_listino() == 0 || this.v_selezione.getListino().getTipologia_listino() == 2) {
                ro.setP_um(this.v_selezione.getTratta().getP());
            }
            if (this.v_selezione.getListino().getTipologia_listino() == 1) {
                ro.setP_for(this.v_selezione.getTratta().getP());
            }
            this.v_selezione.getInsieme_r_fp().vettoreR.add(ro);
            Iterator i = righe_di_prima.iterator();
            while (i.hasNext()) {
                this.v_selezione.getInsieme_r_fp().vettoreR.add((RigaOrdineViaggio)i.next());
            }
        }
        this.rvtm.setDataRiga(this.v_selezione.getInsieme_r_fp().vettoreR);
        this.jTableRigheViaggio.setModel(this.rvtm);
        this.calcola_totale();
    }

    public void formatta_riepilogo() {
        String aggiunta = "";
        if (this.v_selezione == null || this.v_selezione.getInsieme_r_fp().vettoreR.isEmpty() || !this.v_selezione.getInsieme_r_fp().vettoreR.get(0).getCodice_riga().equals("")) {
            // empty if block
        }
        Vector array_opzioni = this.ft.crea_array_opzioni(0, aggiunta);
        this.jTableRigheViaggio.setRowHeight(27);
        this.jTableRigheViaggio.setDefaultEditor(Object.class, new TextInsertEditor());
        this.jTableRigheViaggio.setDefaultEditor(JCheckBox.class, new ComboInsertEditor(array_opzioni));
        this.jTableRigheViaggio.setDefaultRenderer(Object.class, new RicercaCellRenderer());
        this.jTableRigheViaggio.setDefaultRenderer(JCheckBox.class, new RicercaCellComboRenderer(array_opzioni));
    }

    public void azzera() {
        this.jComboAR.setSelectedItem("ANDATA");
        this.data_partenza.setText(this.fda.dataCorrenteIt());
        this.jTextTrattaComplessiva.setText("");
        this.jCheckConfermato.setSelected(false);
        this.jTextNV.setText("");
        this.jTextAnnoViaggio.setText("");
        this.jTextDescrizioneV.setText("");
        this.jTextVettore.setText("");
        this.jLabelRS.setText("** Non Definito **");
        this.jTextAutista.setText("");
        this.jTextRimorchio.setText("");
        this.jTextTrattore.setText("");
        this.precontm = new PreseConsegneTableModel();
        this.jTableDettaglio.setModel(this.precontm);
        this.visualizzazione();
    }

    public boolean check() {
        if (this.data_partenza.getText().equals("00-00-0000") || this.data_partenza.getText().equals("  -  -    ")) {
            JOptionPane.showMessageDialog(this, "Inserire la data Partenza");
            return false;
        }
        if (this.jCheckConfermato.isSelected()) {
            if (this.jRadioProprio.isSelected()) {
                if (this.jTextAutista.getText().equals("")) {
                    JOptionPane.showMessageDialog(this, "Inserire l'autista");
                    return false;
                }
                if (this.jTextTrattore.getText().equals("")) {
                    JOptionPane.showMessageDialog(this, "Inserire il trattore");
                    return false;
                }
                if (this.jTextRimorchio.getText().equals("")) {
                    JOptionPane.showMessageDialog(this, "Inserire il rimorchio");
                    return false;
                }
            }
            if (this.jRadioAssegnato.isSelected() && this.jTextVettore.getText().equals("")) {
                JOptionPane.showMessageDialog(this, "Inserire il vettore");
                return false;
            }
        }
        return true;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jPanelDettaglioO = new JPanel();
        this.jLabelCodice = new JLabel();
        this.jTextCodiceCliente = new JTextField();
        this.jLabelCF = new JLabel();
        this.jLabelNote = new JLabel();
        this.jScrollPane5 = new JScrollPane();
        this.jTextNote = new JTextArea();
        this.jLabelCliente = new JLabel();
        this.scroll2 = new JScrollPane();
        this.jTablePC = new JTable(this.pctm);
        this.jLabel5 = new JLabel();
        this.jButtonCreaViaggio = new JButton();
        this.jLabel1 = new JLabel();
        this.jTextNOrdine = new JTextField();
        this.jPanelListaOrdini = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.jButtonRefresh = new JButton();
        this.jTextRicOrdine = new JTextField();
        this.jLabel6 = new JLabel();
        this.jPanelViaggi = new JPanel();
        this.jToolBar2 = new JToolBar();
        this.jButtonNuovoViaggio = new JButton();
        this.jButtonModifica = new JButton();
        this.jButtonElimina = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelListaViaggi = new JPanel();
        this.jPanelDettaglioViaggio = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel8 = new JLabel();
        this.jScrollPane8 = new JScrollPane();
        this.jTextDescrizioneV = new JTextArea();
        this.jComboAR = new JComboBox();
        this.jLabel13 = new JLabel();
        this.jCheckConfermato = new JCheckBox();
        this.jLabel7 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jRadioProprio = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.jTextAutista = new JTextField();
        this.jLabel3 = new JLabel();
        this.jTextTrattore = new JTextField();
        this.jLabel4 = new JLabel();
        this.jTextRimorchio = new JTextField();
        this.jPanel5 = new JPanel();
        this.jRadioAssegnato = new JRadioButton();
        this.jLabel11 = new JLabel();
        this.jLabelRS = new JLabel();
        this.jLabel16 = new JLabel();
        this.jTextNV = new JTextField();
        this.jLabel19 = new JLabel();
        this.jTextAnnoViaggio = new JTextField();
        this.jPanel6 = new JPanel();
        this.jToolBar3 = new JToolBar();
        this.jButtonAddOrder = new JButton();
        this.jButtonAddPC = new JButton();
        this.jButtonSpostaSu = new JButton();
        this.jButtonSpostaGiu = new JButton();
        this.JButtonEliminaRiga = new JButton();
        this.JButtonTransito = new JButton();
        this.JButtonTransito1 = new JButton();
        this.jScrollPane6 = new JScrollPane();
        this.jTableDettaglio = new JTable();
        this.jPanel19 = new JPanel();
        this.jPanel9 = new JPanel();
        this.jLabel17 = new JLabel();
        this.jLabelCodice1 = new JLabel();
        this.jTextTrattaComplessiva = new JTextField();
        this.jLabel18 = new JLabel();
        this.jTextKm = new JTextField();
        this.jTabbedPane3 = new JTabbedPane();
        this.jPanel14 = new JPanel();
        this.jPanel21 = new JPanel();
        this.jLabelCodice2 = new JLabel();
        this.jTextTotale = new JTextField();
        this.jButtonSalvaPrezzi = new JButton();
        this.jPanel13 = new JPanel();
        this.jScrollPane10 = new JScrollPane();
        this.jTableRigheViaggio = new JTable(this.rvtm);
        this.jPanel17 = new JPanel();
        this.jButtonAddRow1 = new JButton();
        this.jPanel15 = new JPanel();
        this.jPanel25 = new JPanel();
        this.jLabelCodice3 = new JLabel();
        this.jTextTotale2 = new JTextField();
        this.jPanel23 = new JPanel();
        this.jPanel20 = new JPanel();
        this.jButtonAddRow = new JButton();
        this.jPanelAutisti = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jTableAutisti = new JTable();
        this.jScrollPane7 = new JScrollPane();
        this.jTableTrattori = new JTable();
        this.jScrollPane4 = new JScrollPane();
        this.jTableSemirimorchi = new JTable();
        this.setClosable(true);
        this.setDefaultCloseOperation(2);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Trasporti \\ Borderaux");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                MyBorderaux.this.finestra_spostata(evt);
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                MyBorderaux.this.finestra_ridimensionata(evt);
            }
        });
        this.jPanel1.setBackground(new Color(204, 204, 255));
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel7.setBackground(new Color(204, 204, 255));
        this.jPanel7.setBorder(BorderFactory.createTitledBorder(null, "Ordini da Assegnare", 0, 0, new Font("Tahoma", 1, 14), new Color(0, 0, 153)));
        this.jPanel7.setLayout(new GridBagLayout());
        this.jPanelDettaglioO.setBackground(new Color(204, 204, 255));
        this.jPanelDettaglioO.setBorder(new LineBorder(new Color(255, 255, 0), 2, true));
        this.jPanelDettaglioO.setLayout(new GridBagLayout());
        this.jLabelCodice.setText("Cliente");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanelDettaglioO.add((Component)this.jLabelCodice, gridBagConstraints);
        this.jTextCodiceCliente.setEditable(false);
        this.jTextCodiceCliente.setMinimumSize(new Dimension(100, 20));
        this.jTextCodiceCliente.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 9, 0);
        this.jPanelDettaglioO.add((Component)this.jTextCodiceCliente, gridBagConstraints);
        this.jLabelCF.setText("Data Ordine");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanelDettaglioO.add((Component)this.jLabelCF, gridBagConstraints);
        this.jLabelNote.setText("Note");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanelDettaglioO.add((Component)this.jLabelNote, gridBagConstraints);
        this.jScrollPane5.setPreferredSize(new Dimension(300, 50));
        this.jTextNote.setColumns(20);
        this.jTextNote.setEditable(false);
        this.jTextNote.setRows(2);
        this.jScrollPane5.setViewportView(this.jTextNote);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.jPanelDettaglioO.add((Component)this.jScrollPane5, gridBagConstraints);
        this.jLabelCliente.setText("** Non Definito **");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        this.jPanelDettaglioO.add((Component)this.jLabelCliente, gridBagConstraints);
        this.scroll2.setPreferredSize(new Dimension(300, 120));
        this.jTablePC.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jTablePC.setPreferredSize(new Dimension(200, 200));
        this.jTablePC.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                MyBorderaux.this.jTablePCMouseDragged(evt);
            }
        });
        this.scroll2.setViewportView(this.jTablePC);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.jPanelDettaglioO.add((Component)this.scroll2, gridBagConstraints);
        this.jLabel5.setText("Prese/Consegne");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanelDettaglioO.add((Component)this.jLabel5, gridBagConstraints);
        this.jButtonCreaViaggio.setText("Crea Viaggio ->");
        this.jButtonCreaViaggio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBorderaux.this.jButtonCreaViaggioActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 10, 0);
        this.jPanelDettaglioO.add((Component)this.jButtonCreaViaggio, gridBagConstraints);
        this.jLabel1.setText("N. Ordine");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanelDettaglioO.add((Component)this.jLabel1, gridBagConstraints);
        this.jTextNOrdine.setEditable(false);
        this.jTextNOrdine.setMinimumSize(new Dimension(100, 20));
        this.jTextNOrdine.setPreferredSize(new Dimension(100, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.jPanelDettaglioO.add((Component)this.jTextNOrdine, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel7.add((Component)this.jPanelDettaglioO, gridBagConstraints);
        this.jPanelListaOrdini.setBackground(new Color(204, 204, 255));
        this.jPanelListaOrdini.setBorder(BorderFactory.createLineBorder(new Color(255, 255, 0)));
        this.jPanelListaOrdini.setMaximumSize(new Dimension(200, Integer.MAX_VALUE));
        this.jPanelListaOrdini.setMinimumSize(new Dimension(200, 300));
        this.jPanelListaOrdini.setPreferredSize(new Dimension(200, 200));
        this.jPanelListaOrdini.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel7.add((Component)this.jPanelListaOrdini, gridBagConstraints);
        this.jToolBar1.setRollover(true);
        this.jButtonRefresh.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/view-refresh.png")));
        this.jButtonRefresh.setFocusable(false);
        this.jButtonRefresh.setHorizontalTextPosition(0);
        this.jButtonRefresh.setVerticalTextPosition(3);
        this.jButtonRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBorderaux.this.jButtonRefreshActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonRefresh);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 4, 2, 10);
        this.jPanel7.add((Component)this.jToolBar1, gridBagConstraints);
        this.jTextRicOrdine.setMinimumSize(new Dimension(80, 27));
        this.jTextRicOrdine.setPreferredSize(new Dimension(80, 27));
        this.jTextRicOrdine.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MyBorderaux.this.jTextRicOrdineKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel7.add((Component)this.jTextRicOrdine, gridBagConstraints);
        this.jLabel6.setText("Ricerca per n\u00b0 ordine");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.jPanel7.add((Component)this.jLabel6, gridBagConstraints);
        this.jPanel1.add((Component)this.jPanel7, "West");
        this.jPanelViaggi.setBackground(new Color(255, 255, 255));
        this.jPanelViaggi.setBorder(BorderFactory.createTitledBorder(null, "Viaggi da Confermare", 0, 0, new Font("Tahoma", 1, 14), new Color(0, 102, 0)));
        this.jPanelViaggi.setMinimumSize(new Dimension(630, 433));
        this.jPanelViaggi.setLayout(new BorderLayout());
        this.jToolBar2.setBackground(new Color(255, 255, 255));
        this.jToolBar2.setRollover(true);
        this.jButtonNuovoViaggio.setBackground(new Color(255, 255, 255));
        this.jButtonNuovoViaggio.setFont(new Font("Tahoma", 1, 11));
        this.jButtonNuovoViaggio.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-new.png")));
        this.jButtonNuovoViaggio.setText("Nuovo");
        this.jButtonNuovoViaggio.setFocusable(false);
        this.jButtonNuovoViaggio.setMargin(new Insets(5, 10, 5, 10));
        this.jButtonNuovoViaggio.setVerticalTextPosition(3);
        this.jButtonNuovoViaggio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBorderaux.this.jButtonNuovoViaggioActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.jButtonNuovoViaggio);
        this.jButtonModifica.setBackground(new Color(255, 255, 255));
        this.jButtonModifica.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/accessories-text-editor.png")));
        this.jButtonModifica.setText("Modifica");
        this.jButtonModifica.setFocusable(false);
        this.jButtonModifica.setHorizontalAlignment(11);
        this.jButtonModifica.setMargin(new Insets(5, 10, 5, 10));
        this.jButtonModifica.setVerticalTextPosition(3);
        this.jButtonModifica.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBorderaux.this.jButtonModificaActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.jButtonModifica);
        this.jButtonElimina.setBackground(new Color(255, 255, 255));
        this.jButtonElimina.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/user-trash.png")));
        this.jButtonElimina.setText("Elimina");
        this.jButtonElimina.setFocusable(false);
        this.jButtonElimina.setHorizontalAlignment(11);
        this.jButtonElimina.setMargin(new Insets(5, 10, 5, 10));
        this.jButtonElimina.setVerticalTextPosition(3);
        this.jButtonElimina.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBorderaux.this.jButtonEliminaActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.jButtonElimina);
        this.jPanelViaggi.add((Component)this.jToolBar2, "North");
        this.jTabbedPane1.setBackground(new Color(255, 255, 255));
        this.jTabbedPane1.setForeground(new Color(0, 0, 153));
        this.jTabbedPane1.setTabLayoutPolicy(1);
        this.jTabbedPane1.setFont(new Font("Tahoma", 1, 12));
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MyBorderaux.this.jTabbedPane1StateChanged(evt);
            }
        });
        this.jPanelListaViaggi.setBorder(BorderFactory.createLineBorder(new Color(0, 102, 0)));
        this.jPanelListaViaggi.setMaximumSize(new Dimension(200, Integer.MAX_VALUE));
        this.jPanelListaViaggi.setMinimumSize(new Dimension(200, 200));
        this.jPanelListaViaggi.setPreferredSize(new Dimension(200, 200));
        this.jPanelListaViaggi.setLayout(new BorderLayout());
        this.jTabbedPane1.addTab("Lista Viaggi da confermare", this.jPanelListaViaggi);
        this.jPanelDettaglioViaggio.setLayout(new BorderLayout());
        this.jPanel2.setBackground(new Color(255, 255, 255));
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(0, 102, 0)));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel8.setText("Descrizione");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        this.jPanel2.add((Component)this.jLabel8, gridBagConstraints);
        this.jScrollPane8.setMinimumSize(new Dimension(300, 50));
        this.jScrollPane8.setPreferredSize(new Dimension(300, 50));
        this.jTextDescrizioneV.setColumns(20);
        this.jTextDescrizioneV.setRows(2);
        this.jScrollPane8.setViewportView(this.jTextDescrizioneV);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        this.jPanel2.add((Component)this.jScrollPane8, gridBagConstraints);
        this.jComboAR.setModel(new DefaultComboBoxModel<String>(new String[]{"ANDATA", "RITORNO"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        this.jPanel2.add((Component)this.jComboAR, gridBagConstraints);
        this.jLabel13.setText("Viaggio di");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        this.jPanel2.add((Component)this.jLabel13, gridBagConstraints);
        this.jCheckConfermato.setBackground(new Color(255, 255, 255));
        this.jCheckConfermato.setText("Confermato");
        this.jCheckConfermato.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBorderaux.this.jCheckConfermatoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        this.jPanel2.add((Component)this.jCheckConfermato, gridBagConstraints);
        this.jLabel7.setText("Data Partenza");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        this.jPanel2.add((Component)this.jLabel7, gridBagConstraints);
        this.jPanel3.setBackground(new Color(255, 255, 255));
        this.jPanel3.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 204), 2));
        this.jPanel3.setForeground(new Color(0, 0, 204));
        this.jPanel3.setLayout(new GridBagLayout());
        this.jRadioProprio.setBackground(new Color(255, 255, 255));
        this.buttonGroup1.add(this.jRadioProprio);
        this.jRadioProprio.setFont(new Font("Tahoma", 1, 11));
        this.jRadioProprio.setForeground(new Color(0, 0, 204));
        this.jRadioProprio.setText("Proprio");
        this.jRadioProprio.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MyBorderaux.this.jRadioProprioStateChanged(evt);
            }
        });
        this.jRadioProprio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBorderaux.this.jRadioProprioActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jRadioProprio, gridBagConstraints);
        this.jLabel2.setText("Autista");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabel2, gridBagConstraints);
        this.jTextAutista.setDragEnabled(true);
        this.jTextAutista.setMinimumSize(new Dimension(150, 27));
        this.jTextAutista.setPreferredSize(new Dimension(150, 27));
        this.jTextAutista.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MyBorderaux.this.jTextAutistaFocusLost(evt);
            }
        });
        this.jTextAutista.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MyBorderaux.this.jTextAutistaKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        this.jPanel3.add((Component)this.jTextAutista, gridBagConstraints);
        this.jLabel3.setText("Trattore");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabel3, gridBagConstraints);
        this.jTextTrattore.setDragEnabled(true);
        this.jTextTrattore.setMaximumSize(new Dimension(150, 27));
        this.jTextTrattore.setMinimumSize(new Dimension(100, 27));
        this.jTextTrattore.setPreferredSize(new Dimension(150, 27));
        this.jTextTrattore.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MyBorderaux.this.jTextTrattoreFocusLost(evt);
            }
        });
        this.jTextTrattore.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MyBorderaux.this.jTextTrattoreKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        this.jPanel3.add((Component)this.jTextTrattore, gridBagConstraints);
        this.jLabel4.setText("Rimorchio");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabel4, gridBagConstraints);
        this.jTextRimorchio.setDragEnabled(true);
        this.jTextRimorchio.setMaximumSize(new Dimension(150, 27));
        this.jTextRimorchio.setMinimumSize(new Dimension(100, 27));
        this.jTextRimorchio.setPreferredSize(new Dimension(150, 27));
        this.jTextRimorchio.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MyBorderaux.this.jTextRimorchioFocusLost(evt);
            }
        });
        this.jTextRimorchio.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MyBorderaux.this.jTextRimorchioKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.jPanel3.add((Component)this.jTextRimorchio, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel2.add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel5.setBackground(new Color(255, 255, 255));
        this.jPanel5.setBorder(BorderFactory.createLineBorder(new Color(0, 204, 0), 2));
        this.jPanel5.setLayout(new GridBagLayout());
        this.jRadioAssegnato.setBackground(new Color(255, 255, 255));
        this.buttonGroup1.add(this.jRadioAssegnato);
        this.jRadioAssegnato.setFont(new Font("Tahoma", 1, 11));
        this.jRadioAssegnato.setForeground(new Color(0, 102, 0));
        this.jRadioAssegnato.setText("Assegnato");
        this.jRadioAssegnato.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBorderaux.this.jRadioAssegnatoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        this.jPanel5.add((Component)this.jRadioAssegnato, gridBagConstraints);
        this.jLabel11.setText("Vettore");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 9, 0, 0);
        this.jPanel5.add((Component)this.jLabel11, gridBagConstraints);
        this.jLabelRS.setText("** Non Definito **");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        this.jPanel5.add((Component)this.jLabelRS, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel2.add((Component)this.jPanel5, gridBagConstraints);
        this.jLabel16.setText("Numero Viaggio");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(20, 10, 0, 0);
        this.jPanel2.add((Component)this.jLabel16, gridBagConstraints);
        this.jTextNV.setEditable(false);
        this.jTextNV.setEnabled(false);
        this.jTextNV.setMinimumSize(new Dimension(100, 27));
        this.jTextNV.setPreferredSize(new Dimension(100, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        this.jPanel2.add((Component)this.jTextNV, gridBagConstraints);
        this.jLabel19.setText("/");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        this.jPanel2.add((Component)this.jLabel19, gridBagConstraints);
        this.jTextAnnoViaggio.setEditable(false);
        this.jTextAnnoViaggio.setEnabled(false);
        this.jTextAnnoViaggio.setMinimumSize(new Dimension(100, 27));
        this.jTextAnnoViaggio.setPreferredSize(new Dimension(100, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        this.jPanel2.add((Component)this.jTextAnnoViaggio, gridBagConstraints);
        this.jPanelDettaglioViaggio.add((Component)this.jPanel2, "Center");
        this.jPanel6.setBackground(new Color(255, 255, 255));
        this.jPanel6.setBorder(BorderFactory.createTitledBorder(null, "Prese e Consegne", 0, 0, new Font("Tahoma", 1, 11), new Color(153, 0, 153)));
        this.jPanel6.setLayout(new BorderLayout());
        this.jToolBar3.setBackground(new Color(255, 255, 255));
        this.jToolBar3.setRollover(true);
        this.jButtonAddOrder.setBackground(new Color(255, 255, 255));
        this.jButtonAddOrder.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/list-add.png")));
        this.jButtonAddOrder.setText("Aggiungi Ordine");
        this.jButtonAddOrder.setFocusable(false);
        this.jButtonAddOrder.setHorizontalAlignment(11);
        this.jButtonAddOrder.setVerticalTextPosition(3);
        this.jButtonAddOrder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBorderaux.this.jButtonAddOrderActionPerformed(evt);
            }
        });
        this.jToolBar3.add(this.jButtonAddOrder);
        this.jButtonAddPC.setBackground(new Color(255, 255, 255));
        this.jButtonAddPC.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/list-add.png")));
        this.jButtonAddPC.setText("Aggiungi Presa o Consegna");
        this.jButtonAddPC.setFocusable(false);
        this.jButtonAddPC.setVerticalTextPosition(3);
        this.jButtonAddPC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBorderaux.this.jButtonAddPCActionPerformed(evt);
            }
        });
        this.jToolBar3.add(this.jButtonAddPC);
        this.jButtonSpostaSu.setBackground(new Color(255, 255, 255));
        this.jButtonSpostaSu.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-up.png")));
        this.jButtonSpostaSu.setText("Sposta Su");
        this.jButtonSpostaSu.setFocusable(false);
        this.jButtonSpostaSu.setVerticalTextPosition(3);
        this.jButtonSpostaSu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBorderaux.this.jButtonSpostaSuActionPerformed(evt);
            }
        });
        this.jToolBar3.add(this.jButtonSpostaSu);
        this.jButtonSpostaGiu.setBackground(new Color(255, 255, 255));
        this.jButtonSpostaGiu.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-down.png")));
        this.jButtonSpostaGiu.setText("Sposta Giu");
        this.jButtonSpostaGiu.setFocusable(false);
        this.jButtonSpostaGiu.setVerticalTextPosition(3);
        this.jButtonSpostaGiu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBorderaux.this.jButtonSpostaGiuActionPerformed(evt);
            }
        });
        this.jToolBar3.add(this.jButtonSpostaGiu);
        this.JButtonEliminaRiga.setBackground(new Color(255, 255, 255));
        this.JButtonEliminaRiga.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/list-remove.png")));
        this.JButtonEliminaRiga.setText("Elimina riga Selezionata");
        this.JButtonEliminaRiga.setFocusable(false);
        this.JButtonEliminaRiga.setVerticalTextPosition(3);
        this.JButtonEliminaRiga.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBorderaux.this.JButtonEliminaRigaActionPerformed(evt);
            }
        });
        this.jToolBar3.add(this.JButtonEliminaRiga);
        this.JButtonTransito.setBackground(new Color(255, 255, 255));
        this.JButtonTransito.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/Home16.gif")));
        this.JButtonTransito.setText("Transito Consegna");
        this.JButtonTransito.setFocusable(false);
        this.JButtonTransito.setHorizontalAlignment(11);
        this.JButtonTransito.setVerticalTextPosition(3);
        this.JButtonTransito.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBorderaux.this.JButtonTransitoActionPerformed(evt);
            }
        });
        this.jToolBar3.add(this.JButtonTransito);
        this.JButtonTransito1.setBackground(new Color(255, 255, 255));
        this.JButtonTransito1.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/Home16.gif")));
        this.JButtonTransito1.setText("Transito Presa");
        this.JButtonTransito1.setFocusable(false);
        this.JButtonTransito1.setHorizontalAlignment(11);
        this.JButtonTransito1.setVerticalTextPosition(3);
        this.JButtonTransito1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBorderaux.this.JButtonTransito1ActionPerformed(evt);
            }
        });
        this.jToolBar3.add(this.JButtonTransito1);
        this.jPanel6.add((Component)this.jToolBar3, "North");
        this.jScrollPane6.setMaximumSize(new Dimension(250, 150));
        this.jScrollPane6.setMinimumSize(new Dimension(250, 150));
        this.jScrollPane6.setPreferredSize(new Dimension(250, 150));
        this.jTableDettaglio.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jTableDettaglio.setDragEnabled(true);
        this.jTableDettaglio.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MyBorderaux.this.jTableDettaglioFocusLost(evt);
            }
        });
        this.jScrollPane6.setViewportView(this.jTableDettaglio);
        this.jPanel6.add((Component)this.jScrollPane6, "Center");
        this.jPanelDettaglioViaggio.add((Component)this.jPanel6, "First");
        this.jTabbedPane1.addTab("Dettaglio", this.jPanelDettaglioViaggio);
        this.jPanel19.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel19.setPreferredSize(new Dimension(600, 200));
        this.jPanel19.setLayout(new BorderLayout());
        this.jPanel9.setBackground(new Color(255, 255, 255));
        this.jPanel9.setLayout(new GridBagLayout());
        this.jLabel17.setBackground(new Color(255, 255, 255));
        this.jLabel17.setFont(new Font("Tahoma", 1, 11));
        this.jLabel17.setText("Riepilogo Viaggio");
        this.jLabel17.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel9.add((Component)this.jLabel17, gridBagConstraints);
        this.jLabelCodice1.setText("Tratta Complessiva");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        this.jPanel9.add((Component)this.jLabelCodice1, gridBagConstraints);
        this.jTextTrattaComplessiva.setMinimumSize(new Dimension(200, 30));
        this.jTextTrattaComplessiva.setPreferredSize(new Dimension(200, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        this.jPanel9.add((Component)this.jTextTrattaComplessiva, gridBagConstraints);
        this.jLabel18.setText("Km complessivi");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        this.jPanel9.add((Component)this.jLabel18, gridBagConstraints);
        this.jTextKm.setMinimumSize(new Dimension(70, 28));
        this.jTextKm.setPreferredSize(new Dimension(70, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        this.jPanel9.add((Component)this.jTextKm, gridBagConstraints);
        this.jPanel19.add((Component)this.jPanel9, "North");
        this.jTabbedPane3.setBackground(new Color(255, 255, 255));
        this.jPanel14.setLayout(new BorderLayout());
        this.jPanel21.setLayout(new GridBagLayout());
        this.jLabelCodice2.setText("Totale");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel21.add((Component)this.jLabelCodice2, gridBagConstraints);
        this.jTextTotale.setEditable(false);
        this.jTextTotale.setMinimumSize(new Dimension(200, 30));
        this.jTextTotale.setPreferredSize(new Dimension(200, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel21.add((Component)this.jTextTotale, gridBagConstraints);
        this.jButtonSalvaPrezzi.setText("Salva i prezzi");
        this.jButtonSalvaPrezzi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBorderaux.this.jButtonSalvaPrezziActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 21, 0, 20);
        this.jPanel21.add((Component)this.jButtonSalvaPrezzi, gridBagConstraints);
        this.jPanel14.add((Component)this.jPanel21, "South");
        this.jPanel13.setLayout(new BorderLayout());
        this.jScrollPane10.setMaximumSize(new Dimension(250, 150));
        this.jScrollPane10.setMinimumSize(new Dimension(250, 150));
        this.jScrollPane10.setPreferredSize(new Dimension(250, 150));
        this.jTableRigheViaggio.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jTableRigheViaggio.setDragEnabled(true);
        this.jTableRigheViaggio.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MyBorderaux.this.jTableRigheViaggioFocusLost(evt);
            }
        });
        this.jScrollPane10.setViewportView(this.jTableRigheViaggio);
        this.jPanel13.add((Component)this.jScrollPane10, "Center");
        this.jPanel17.setLayout(new BorderLayout());
        this.jButtonAddRow1.setText("+");
        this.jButtonAddRow1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBorderaux.this.jButtonAddRow1ActionPerformed(evt);
            }
        });
        this.jPanel17.add((Component)this.jButtonAddRow1, "East");
        this.jPanel13.add((Component)this.jPanel17, "South");
        this.jPanel14.add((Component)this.jPanel13, "Center");
        this.jTabbedPane3.addTab("Vettore", this.jPanel14);
        this.jPanel15.setLayout(new BorderLayout());
        this.jPanel25.setLayout(new GridBagLayout());
        this.jLabelCodice3.setText("Totale");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel25.add((Component)this.jLabelCodice3, gridBagConstraints);
        this.jTextTotale2.setEditable(false);
        this.jTextTotale2.setMinimumSize(new Dimension(200, 30));
        this.jTextTotale2.setPreferredSize(new Dimension(200, 30));
        this.jTextTotale2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MyBorderaux.this.jTextTotale2FocusLost(evt);
            }
        });
        this.jTextTotale2.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MyBorderaux.this.jTextTotale2KeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel25.add((Component)this.jTextTotale2, gridBagConstraints);
        this.jPanel15.add((Component)this.jPanel25, "South");
        this.jPanel23.setLayout(new BorderLayout());
        this.jPanel20.setBackground(new Color(255, 255, 255));
        this.jPanel20.setLayout(new GridBagLayout());
        this.jButtonAddRow.setText("+");
        this.jButtonAddRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyBorderaux.this.jButtonAddRowActionPerformed(evt);
            }
        });
        this.jPanel20.add((Component)this.jButtonAddRow, new GridBagConstraints());
        this.jPanel23.add((Component)this.jPanel20, "South");
        this.jPanel15.add((Component)this.jPanel23, "Center");
        this.jTabbedPane3.addTab("Proprio", this.jPanel15);
        this.jPanel19.add((Component)this.jTabbedPane3, "Center");
        this.jTabbedPane1.addTab("Costi", this.jPanel19);
        this.jPanelViaggi.add((Component)this.jTabbedPane1, "Center");
        this.jPanel1.add((Component)this.jPanelViaggi, "Center");
        this.jPanelAutisti.setBackground(new Color(204, 204, 255));
        this.jPanelAutisti.setBorder(BorderFactory.createTitledBorder(null, "Disponibilit\u00e0 Mezzi e Autisti nella data Viaggio selezionata", 0, 0, new Font("Tahoma", 1, 14), new Color(102, 102, 255)));
        this.jPanelAutisti.setLayout(new GridBagLayout());
        this.jScrollPane2.setMaximumSize(new Dimension(350, 180));
        this.jScrollPane2.setMinimumSize(new Dimension(300, 140));
        this.jScrollPane2.setPreferredSize(new Dimension(300, 140));
        this.jScrollPane2.setRequestFocusEnabled(false);
        this.jTableAutisti.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jTableAutisti.setDragEnabled(true);
        this.jTableAutisti.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                MyBorderaux.this.jTableAutistiMouseDragged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTableAutisti);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        this.jPanelAutisti.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jScrollPane7.setMaximumSize(new Dimension(350, 180));
        this.jScrollPane7.setMinimumSize(new Dimension(300, 140));
        this.jScrollPane7.setPreferredSize(new Dimension(300, 140));
        this.jScrollPane7.setRequestFocusEnabled(false);
        this.jTableTrattori.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jTableTrattori.setDragEnabled(true);
        this.jTableTrattori.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                MyBorderaux.this.jTableTrattoriMouseDragged(evt);
            }
        });
        this.jScrollPane7.setViewportView(this.jTableTrattori);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        this.jPanelAutisti.add((Component)this.jScrollPane7, gridBagConstraints);
        this.jScrollPane4.setMaximumSize(new Dimension(350, 180));
        this.jScrollPane4.setMinimumSize(new Dimension(300, 140));
        this.jScrollPane4.setPreferredSize(new Dimension(300, 140));
        this.jScrollPane4.setRequestFocusEnabled(false);
        this.jTableSemirimorchi.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jTableSemirimorchi.setDragEnabled(true);
        this.jTableSemirimorchi.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                MyBorderaux.this.jTableSemirimorchiMouseDragged(evt);
            }
        });
        this.jScrollPane4.setViewportView(this.jTableSemirimorchi);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        this.jPanelAutisti.add((Component)this.jScrollPane4, gridBagConstraints);
        this.jPanel1.add((Component)this.jPanelAutisti, "South");
        this.jScrollPane1.setViewportView(this.jPanel1);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.pack();
    }

    private void jTableAutistiMouseDragged(MouseEvent evt) {
    }

    private void jTableSemirimorchiMouseDragged(MouseEvent evt) {
    }

    private void jTablePCMouseDragged(MouseEvent evt) {
    }

    private void jTableTrattoriMouseDragged(MouseEvent evt) {
    }

    private void jButtonNuovoViaggioActionPerformed(ActionEvent evt) {
        MyTrace.log.info("TRASPORTI ###################  NUOVO    ###############################  START");
        this.in_new = true;
        this.in_modifica = true;
        this.table_viaggi.getSelectionModel().clearSelection();
        this.v_selezione = new Viaggio();
        this.v_selezione.setInsieme_pc(new InsiemePC());
        this.azzera();
        this.jTabbedPane1.setSelectedIndex(1);
        this.visualizzazione();
        MyTrace.log.info("TRASPORTI ###################  NUOVO    ###############################  STOP");
    }

    private void jRadioProprioActionPerformed(ActionEvent evt) {
        this.visualizza_proprio_vettore();
    }

    private void jRadioAssegnatoActionPerformed(ActionEvent evt) {
        this.visualizza_proprio_vettore();
    }

    private void jRadioProprioStateChanged(ChangeEvent evt) {
        this.visualizza_proprio_vettore();
    }

    private void jButtonSalvaActionPerformed(ActionEvent evt) {
        if (this.v_selezione.getTratta() == null) {
            this.costruisci_riepilogo();
        }
        if (this.in_new) {
            if (this.check()) {
                this.costruisci_viaggio();
                boolean check2 = this.v_selezione.inserisciViaggio(true);
                if (check2) {
                    this.in_new = false;
                    this.in_modifica = false;
                    this.filtra();
                    this.visualizzazione();
                    this.jTabbedPane1.setSelectedIndex(0);
                } else {
                    JOptionPane.showMessageDialog(this, "Si \u00e8 verificato un errore al momento dell'inserimento dei dati nel database,\nRicontrollare i campi riempiti e non.\nSe il problema persiste contattare Kronos");
                }
            }
        } else if (this.check()) {
            this.costruisci_viaggio();
            boolean check2 = this.v_selezione.modificaViaggio(true);
            if (check2) {
                this.in_modifica = false;
                this.filtra();
                this.visualizzazione();
                this.jTabbedPane1.setSelectedIndex(0);
            } else {
                JOptionPane.showMessageDialog(this, "Si \u00e8 verificato un errore al momento della modifica dei dati nel database,\nRicontrollare i campi riempiti e non.\nSe il problema persiste contattare Kronos");
            }
        }
    }

    private void jButtonAnnullaActionPerformed(ActionEvent evt) {
        int res = JOptionPane.showConfirmDialog(this, "Abbandonare le modifiche?");
        if (res == 0) {
            this.in_modifica = false;
            this.visualizzazione();
            this.jTabbedPane1.setSelectedIndex(0);
        }
    }

    private void finestra_spostata(ComponentEvent evt) {
        System.out.println("component moved");
        ConfigurazioneFinestre.SetPoint(this.getClass().getName(), this.getLocation());
    }

    private void finestra_ridimensionata(ComponentEvent evt) {
        System.out.println("component resized");
        ConfigurazioneFinestre.SetDimension(this.getClass().getName(), this.getSize());
    }

    private void jTextAutistaFocusLost(FocusEvent evt) {
        Autista a = this.v_selezione.getAutista();
        if (a != null && this.jTextAutista.getText().equals("")) {
            this.autisti_assegnati.removeAllElements();
            for (Autista temp : this.insieme_a.vettoreAutisti) {
                if (temp.getIdautista() == a.getIdautista()) {
                    temp.setAssegnato(false);
                }
                this.autisti_assegnati.add(temp.isAssegnato());
            }
            this.v_selezione.setAutista(new Autista());
            this.v_selezione.setId_autista(0);
            this.atm.setDataAutisti(this.insieme_a.vettoreAutisti);
            this.jTableAutisti.setDefaultRenderer(Object.class, new OccupatiTableRenderer(this.autisti_assegnati));
        }
    }

    private void jTextTrattoreFocusLost(FocusEvent evt) {
        if (this.jTextTrattore.getText() != null && !this.jTextTrattore.getText().equals("")) {
            Mezzo t = new Mezzo();
            t.setTarga(this.jTextTrattore.getText());
            t.seleziona_da_targa("T");
            if (t.getId_macchina() != 0) {
                this.v_selezione.setId_trattore(t.getId_macchina());
                this.v_selezione.setTrattore(t);
            } else {
                JOptionPane.showMessageDialog(this, "Targa non riconosciuta");
                this.jTextTrattore.setText("");
                this.v_selezione.setId_trattore(0);
                this.v_selezione.setTrattore(null);
            }
        } else {
            Mezzo m = this.v_selezione.getTrattore();
            if (m != null) {
                this.tr_assegnati.removeAllElements();
                for (Mezzo temp : this.insieme_tr.vettoreMacchine) {
                    if (temp.getId_macchina() == m.getId_macchina()) {
                        temp.setAsseganto(false);
                    }
                    this.tr_assegnati.add(temp.isAsseganto());
                }
                this.v_selezione.setTrattore(new Mezzo());
                this.v_selezione.setId_trattore(0);
                this.trtm.setDataMacchine(this.insieme_tr.vettoreMacchine);
                this.jTableTrattori.setDefaultRenderer(Object.class, new OccupatiTableRenderer(this.tr_assegnati));
            }
        }
    }

    private void jTextRimorchioFocusLost(FocusEvent evt) {
        if (this.jTextRimorchio.getText() != null && !this.jTextRimorchio.getText().equals("")) {
            Mezzo t = new Mezzo();
            t.setTarga(this.jTextRimorchio.getText());
            t.seleziona_da_targa("S");
            if (t.getId_macchina() != 0) {
                this.v_selezione.setId_rimorchio(t.getId_macchina());
                this.v_selezione.setRimorchio(t);
            } else {
                JOptionPane.showMessageDialog(this, "Targa non riconosciuta");
                this.jTextRimorchio.setText("");
                this.v_selezione.setId_rimorchio(0);
                this.v_selezione.setRimorchio(null);
            }
        } else {
            Mezzo m = this.v_selezione.getRimorchio();
            if (m != null) {
                this.sr_assegnati.removeAllElements();
                for (Mezzo temp : this.insieme_sr.vettoreMacchine) {
                    if (temp.getId_macchina() == m.getId_macchina()) {
                        temp.setAsseganto(false);
                    }
                    this.sr_assegnati.add(temp.isAsseganto());
                }
                this.v_selezione.setRimorchio(new Mezzo());
                this.v_selezione.setId_rimorchio(0);
                this.srtm.setDataMacchine(this.insieme_sr.vettoreMacchine);
                this.jTableSemirimorchi.setDefaultRenderer(Object.class, new OccupatiTableRenderer(this.sr_assegnati));
            }
        }
    }

    private void jCheckConfermatoActionPerformed(ActionEvent evt) {
        int res = JOptionPane.showConfirmDialog(this, "Sei sicuro di voler confermare il viaggio?");
        if (res == 0 && this.jCheckConfermato.isSelected()) {
            this.jTextAnnoViaggio.setText(this.fda.anno(this.fda.gira_data(this.data_partenza.getText())));
            this.jTextNV.setText("" + (this.ft.ultimo_viaggio(Integer.parseInt(this.jTextAnnoViaggio.getText())) + 1));
            this.jCheckConfermato.setEnabled(false);
        }
    }

    private void jButtonCreaViaggioActionPerformed(ActionEvent evt) {
        if (this.o_selezione != null) {
            System.out.println("Nuovo viaggio");
            this.in_new = true;
            this.in_modifica = true;
            this.table_viaggi.getSelectionModel().clearSelection();
            this.v_selezione = new Viaggio();
            this.v_selezione.setInsieme_pc(new InsiemePC());
            this.azzera();
            this.jTabbedPane1.setSelectedIndex(1);
            this.visualizzazione();
            PresaConsegna prima_presa = this.o_selezione.getInsieme_pc().prima_presa();
            PresaConsegna ultima_consegna = this.o_selezione.getInsieme_pc().ultima_cons();
            this.data_partenza.setText(this.fda.gira_data(prima_presa.getData()));
            this.jComboAR.setSelectedIndex(0);
            this.jTextTrattaComplessiva.setText(this.o_selezione.getTratta_complessiva());
            this.jTextDescrizioneV.setText("ordine " + this.o_selezione.getN_ordine() + " / " + this.o_selezione.getAnno_ordine());
            for (PresaConsegna pc : this.o_selezione.getInsieme_pc().vettorePC) {
                this.v_selezione.getInsieme_pc().vettorePC.add(pc);
            }
            this.precontm.setDataDettaglio(this.v_selezione.getInsieme_pc().vettorePC);
        }
    }

    private void jButtonAddPCActionPerformed(ActionEvent evt) {
        if (!this.f_pc_open) {
            MyPreseConsegne oggetto = new MyPreseConsegne(this);
            oggetto.occupati = true;
            oggetto.filtra();
            oggetto.formatta();
            this.getDesktopPane().add(oggetto);
            oggetto.setVisible(true);
            oggetto.moveToFront();
            this.f_pc_open = true;
        }
    }

    private void jButtonSpostaSuActionPerformed(ActionEvent evt) {
        MyTrace.log.info("Riga selezionata= " + this.riga_viaggio_selezionata);
        PresaConsegna rv_temp = (PresaConsegna)this.v_selezione.getInsieme_pc().vettorePC.elementAt(this.riga_viaggio_selezionata - 1);
        PresaConsegna rv_sel = (PresaConsegna)this.v_selezione.getInsieme_pc().vettorePC.elementAt(this.riga_viaggio_selezionata);
        rv_temp.setOrdine_viaggio(this.riga_viaggio_selezionata);
        rv_sel.setOrdine_viaggio(this.riga_viaggio_selezionata - 1);
        this.v_selezione.getInsieme_pc().vettorePC.setElementAt(rv_sel, this.riga_viaggio_selezionata - 1);
        this.v_selezione.getInsieme_pc().vettorePC.setElementAt(rv_temp, this.riga_viaggio_selezionata);
        --this.riga_viaggio_selezionata;
        this.precontm.setDataDettaglio(this.v_selezione.getInsieme_pc().vettorePC);
        this.jTableDettaglio.getSelectionModel().setSelectionInterval(this.riga_viaggio_selezionata, this.riga_viaggio_selezionata);
    }

    private void jButtonSpostaGiuActionPerformed(ActionEvent evt) {
        MyTrace.log.info("Riga selezionata= " + this.riga_viaggio_selezionata);
        PresaConsegna rv_temp = (PresaConsegna)this.v_selezione.getInsieme_pc().vettorePC.elementAt(this.riga_viaggio_selezionata + 1);
        PresaConsegna rv_sel = (PresaConsegna)this.v_selezione.getInsieme_pc().vettorePC.elementAt(this.riga_viaggio_selezionata);
        rv_temp.setOrdine_viaggio(this.riga_viaggio_selezionata);
        rv_sel.setOrdine_viaggio(this.riga_viaggio_selezionata + 1);
        this.v_selezione.getInsieme_pc().vettorePC.setElementAt(rv_sel, this.riga_viaggio_selezionata + 1);
        this.v_selezione.getInsieme_pc().vettorePC.setElementAt(rv_temp, this.riga_viaggio_selezionata);
        ++this.riga_viaggio_selezionata;
        this.precontm.setDataDettaglio(this.v_selezione.getInsieme_pc().vettorePC);
        this.jTableDettaglio.getSelectionModel().setSelectionInterval(this.riga_viaggio_selezionata, this.riga_viaggio_selezionata);
    }

    private void JButtonEliminaRigaActionPerformed(ActionEvent evt) {
        int res = JOptionPane.showConfirmDialog(this, "Sei sicuro di voler eleiminare la riga numero" + this.riga_viaggio_selezionata + " selezionata?");
        if (res == 0) {
            PresaConsegna rv_sel = (PresaConsegna)this.v_selezione.getInsieme_pc().vettorePC.elementAt(this.riga_viaggio_selezionata);
            rv_sel.setId_viaggio(0);
            if (this.in_new) {
                this.v_selezione.getInsieme_pc().vettorePC.remove(this.riga_viaggio_selezionata);
            }
            this.precontm.setDataDettaglio(this.v_selezione.getInsieme_pc().vettorePC);
        }
    }

    private void jButtonSalvaPrezziActionPerformed(ActionEvent evt) {
        if (this.v_selezione.getId_avettore() != 0) {
            this.v_selezione.setListino(this.cerca_listino_giusto());
            for (RigaOrdineViaggio ro : this.v_selezione.getInsieme_r_fp().vettoreR) {
                boolean prezzo_trovato;
                ro.seleziona_dettagli();
                if (!ro.getP_um().isZero() && this.v_selezione.getListino().getId() == 0) {
                    this.v_selezione.getListino().setTipologia_listino(2);
                    this.v_selezione.getListino().setId_conf_um(ro.getId_um());
                }
                if (ro.getT_o().equals("T")) {
                    prezzo_trovato = ro.getTratta().seleziona_prezzo(this.v_selezione.getListino().getId());
                    if (!prezzo_trovato) {
                        ro.setPrezzo(new Prezzo());
                        ro.getPrezzo().setId(0);
                        ro.getPrezzo().setId_listino(this.v_selezione.getListino().getId());
                        ro.getPrezzo().setId_tratta(ro.getTratta().getId());
                        if (!ro.getP_um().isZero()) {
                            ro.getPrezzo().setPrezzo(ro.getP_um());
                        } else {
                            ro.getPrezzo().setPrezzo(ro.getP_for());
                        }
                        ro.getPrezzo().setT_o(0);
                        this.v_selezione.getListino().getInsieme_pt().vettorePL.add(ro.getPrezzo());
                    } else {
                        for (Prezzo p_t : this.v_selezione.getListino().getInsieme_pt().vettorePL) {
                            if (p_t.getId() != ro.getTratta().getPrezzo().getId()) continue;
                            p_t.setPrezzo(ro.getP());
                        }
                    }
                }
                if (!ro.getT_o().equals("O")) continue;
                prezzo_trovato = ro.getOpzione().seleziona_prezzo_anag(this.v_selezione.getId_avettore());
                if (!prezzo_trovato) {
                    ro.setPrezzo(new Prezzo());
                    ro.getPrezzo().setId(0);
                    ro.getPrezzo().setId_listino(this.v_selezione.getListino().getId());
                    ro.getPrezzo().setId_opzione(ro.getOpzione().getId());
                    ro.getPrezzo().setPrezzo(ro.getP());
                    ro.getPrezzo().setT_o(1);
                    this.v_selezione.getListino().getInsieme_po().vettorePL.add(ro.getPrezzo());
                    continue;
                }
                for (Prezzo p_t : this.v_selezione.getListino().getInsieme_po().vettorePL) {
                    if (p_t.getId() != ro.getOpzione().getPrezzo().getId()) continue;
                    p_t.setPrezzo(ro.getP());
                }
            }
            if (this.v_selezione.salva_prezzi()) {
                JOptionPane.showMessageDialog(this, "Listino prezzi salvato correttamente!");
            } else {
                JOptionPane.showMessageDialog(this, "Listino prezzi NON salvato!");
            }
        } else {
            JOptionPane.showMessageDialog(this, "Scegliere il vettore!!");
        }
    }

    private void jTableRigheViaggioFocusLost(FocusEvent evt) {
        this.calcola_totale();
    }

    private void jButtonAddRow1ActionPerformed(ActionEvent evt) {
        RigaOrdineViaggio ro = new RigaOrdineViaggio();
        ro.setT_o("O");
        ro.setOpzione(new Opzione());
        ro.getOpzione().setCod_opzione("2_PRE");
        ro.getOpzione().seleziona();
        ro.setId_opzione(ro.getOpzione().getId());
        ro.setCodice_riga(ro.getOpzione().getCod_opzione());
        ro.setDescrizione_riga(ro.getOpzione().getDescrizione());
        ro.setQuantita(new Quantita(BigDecimal.ONE));
        boolean prezzo_trovato = ro.getOpzione().seleziona_prezzo_anag(this.v_selezione.getId_avettore());
        if (prezzo_trovato) {
            ro.setP_um(ro.getOpzione().getP());
        } else {
            ro.setP_um(new Money(BigDecimal.ZERO));
        }
        ro.setId_viaggio(this.v_selezione.getId());
        this.v_selezione.getInsieme_r_fp().vettoreR.add(ro);
        this.rvtm.setDataRiga(this.v_selezione.getInsieme_r_fp().vettoreR);
    }

    private void jTextTotale2FocusLost(FocusEvent evt) {
    }

    private void jTextTotale2KeyPressed(KeyEvent evt) {
    }

    private void jButtonAddRowActionPerformed(ActionEvent evt) {
        RigaOrdineViaggio ro = new RigaOrdineViaggio();
        ro.setT_o("O");
        ro.setOpzione(new Opzione());
        ro.getOpzione().setCod_opzione("2_PRE");
        ro.getOpzione().seleziona();
        ro.setId_opzione(ro.getOpzione().getId());
        ro.setCodice_riga(ro.getOpzione().getCod_opzione());
        ro.setDescrizione_riga(ro.getOpzione().getDescrizione());
        boolean prezzo_trovato = ro.getOpzione().seleziona_prezzo_anag(this.v_selezione.getId_avettore());
        ro.setQuantita(new Quantita(BigDecimal.ONE));
        if (prezzo_trovato) {
            ro.setP_um(ro.getOpzione().getP());
        } else {
            ro.setP_um(new Money(BigDecimal.ZERO));
        }
        ro.setId_viaggio(this.v_selezione.getId());
        this.v_selezione.getInsieme_r_fp().vettoreR.add(ro);
        this.rvtm.setDataRiga(this.v_selezione.getInsieme_r_fp().vettoreR);
    }

    private void jTabbedPane1StateChanged(ChangeEvent evt) {
        if (this.jTabbedPane1.getSelectedIndex() == 2 && this.v_selezione != null) {
            if (this.v_selezione.getInsieme_pc().vettorePC == null || this.v_selezione.getInsieme_pc().conta_prese() == 0) {
                JOptionPane.showMessageDialog(this, "Non c'\u00e8 nessuna presa");
            } else if (this.v_selezione.getInsieme_pc().vettorePC == null || this.v_selezione.getInsieme_pc().conta_consegne() == 0) {
                JOptionPane.showMessageDialog(this, "Non c'\u00e8 nessuna consegna");
            } else {
                this.costruisci_riepilogo();
            }
        }
        if (this.jTabbedPane1.getSelectedIndex() == 2) {
            this.formatta_riepilogo();
        }
    }

    private void jButtonModificaActionPerformed(ActionEvent evt) {
        MyTrace.log.info("TRASPORTI ###################  MODIFICA    ###############################  START");
        this.in_modifica = true;
        this.visualizzazione();
        if (this.jTabbedPane1.getSelectedIndex() == 0) {
            this.jTabbedPane1.setSelectedIndex(1);
        }
        MyTrace.log.info("TRASPORTI ###################  MODIFICA    ###############################  STOP");
    }

    private void jButtonEliminaActionPerformed(ActionEvent evt) {
        MyTrace.log.info("TRASPORTI ###################  ELIMINA    ###############################  START");
        this.jTabbedPane1.setSelectedIndex(1);
        int res = JOptionPane.showConfirmDialog(this, "Sei sicuro di voler eleiminare questo Viaggio?");
        if (res == 0) {
            this.v_selezione.eliminaViaggio(true);
            this.in_modifica = false;
            this.filtra();
        }
        this.visualizzazione();
        this.jTabbedPane1.setSelectedIndex(0);
        MyTrace.log.info("TRASPORTI ###################  ELIMINA    ###############################  STOP");
    }

    private void jButtonRefreshActionPerformed(ActionEvent evt) {
        MyTrace.log.info("@@@@  REFRESH RICHIESTO           (FERMO IL PUNTATORE DEL SISTEMA OPERATIVO)");
        AvvioSuThread avvioseparato = new AvvioSuThread(this, "filtra");
        MyTrace.log.info("@@@@  REFRESH  FINE               (TORNA IL PUNTATORE AL SISTEMA OPERATIVO)");
    }

    private void jTextAutistaKeyPressed(KeyEvent evt) {
        int keyCode = evt.getKeyCode();
        if (keyCode == 115 && !this.f_autisti_open) {
            if (this.data_partenza.getText().equals("") || this.data_partenza.getText().equals("00-00-0000") || this.data_partenza.getText().equals("  -  -    ")) {
                JOptionPane.showMessageDialog(this, "Scegliere prima la data di partenza!!");
            } else {
                MyAutisti oggetto = new MyAutisti();
                oggetto.chiamante = this;
                oggetto.occupati = true;
                oggetto.occupati_in_data = this.fda.gira_data(this.data_partenza.getText());
                oggetto.filtra();
                oggetto.formatta();
                this.getDesktopPane().add(oggetto);
                oggetto.setVisible(true);
                oggetto.moveToFront();
                this.f_autisti_open = true;
            }
        }
    }

    private void jTextTrattoreKeyPressed(KeyEvent evt) {
        int keyCode = evt.getKeyCode();
        if (keyCode == 115 && !this.f_mezzi_open) {
            if (this.data_partenza.getText().equals("") || this.data_partenza.getText().equals("00-00-0000") || this.data_partenza.getText().equals("  -  -    ")) {
                JOptionPane.showMessageDialog(this, "Scegliere prima la data di partenza!!");
            } else {
                MyMezzi oggetto = new MyMezzi();
                oggetto.chiamante = this;
                oggetto.occupati = true;
                oggetto.occupati_in_data = this.fda.gira_data(this.data_partenza.getText());
                oggetto.tipo = "T";
                oggetto.filtra();
                oggetto.formatta();
                this.getDesktopPane().add(oggetto);
                oggetto.setVisible(true);
                oggetto.moveToFront();
                this.f_mezzi_open = true;
            }
        }
    }

    private void jButtonAddOrderActionPerformed(ActionEvent evt) {
        if (!this.f_o_open) {
            MyOrdini oggetto = new MyOrdini();
            oggetto.chiamante = this;
            oggetto.occupati = true;
            String par = " AND mtra_ordini.confermato=1 AND ((mtra_ordini_viaggi_rif.id_viaggio is Null OR mtra_ordini_viaggi_rif.id_viaggio=0)OR(mtra_viaggi.confermato=0))";
            oggetto.filtra(par);
            oggetto.formatta();
            this.getDesktopPane().add(oggetto);
            oggetto.setVisible(true);
            oggetto.moveToFront();
            this.f_o_open = true;
        }
    }

    private void JButtonTransitoActionPerformed(ActionEvent evt) {
        if (this.v_selezione.getInsieme_pc() == null || this.v_selezione.getInsieme_pc().vettorePC.size() == 0) {
            JOptionPane.showMessageDialog(this, "Inserire prima la presa");
        } else {
            PresaConsegna ultima = (PresaConsegna)this.v_selezione.getInsieme_pc().vettorePC.lastElement();
            PresaConsegna pc_transito = new PresaConsegna();
            pc_transito.setData(ultima.getData());
            pc_transito.setDettaglio("TRANSITO");
            IndirizzoPresaConsegna indirizzo_transito = new IndirizzoPresaConsegna();
            indirizzo_transito.seleziona_magazzino();
            pc_transito.setId_luogo(indirizzo_transito.getId());
            pc_transito.setId_tipologia_merce(ultima.getId_tipologia_merce());
            pc_transito.setId_um(ultima.getId_um());
            pc_transito.setId_viaggio(this.v_selezione.getId());
            pc_transito.setLuogo(indirizzo_transito);
            pc_transito.setN_ordine(ultima.getN_ordine());
            pc_transito.setOrdine_viaggio(this.v_selezione.getInsieme_pc().vettorePC.size());
            pc_transito.setId_pc(0);
            pc_transito.setTipo("C");
            this.v_selezione.getInsieme_pc().vettorePC.add(pc_transito);
            this.precontm.setDataDettaglio(this.v_selezione.getInsieme_pc().vettorePC);
        }
    }

    private void jTextRimorchioKeyPressed(KeyEvent evt) {
        int keyCode = evt.getKeyCode();
        if (keyCode == 115 && !this.f_mezzi_open) {
            if (this.data_partenza.getText().equals("") || this.data_partenza.getText().equals("00-00-0000") || this.data_partenza.getText().equals("  -  -    ")) {
                JOptionPane.showMessageDialog(this, "Scegliere prima la data di partenza!!");
            } else {
                MyMezzi oggetto = new MyMezzi();
                oggetto.chiamante = this;
                oggetto.occupati = true;
                oggetto.occupati_in_data = this.fda.gira_data(this.data_partenza.getText());
                oggetto.tipo = "S";
                oggetto.filtra();
                oggetto.formatta();
                this.getDesktopPane().add(oggetto);
                oggetto.setVisible(true);
                oggetto.moveToFront();
                this.f_mezzi_open = true;
            }
        }
    }

    private void JButtonTransito1ActionPerformed(ActionEvent evt) {
        if (this.v_selezione.getInsieme_pc() == null || this.v_selezione.getInsieme_pc().vettorePC.size() == 0) {
            JOptionPane.showMessageDialog(this, "Inserire prima la consegna");
        } else {
            PresaConsegna ultima = (PresaConsegna)this.v_selezione.getInsieme_pc().vettorePC.lastElement();
            PresaConsegna pc_transito = new PresaConsegna();
            pc_transito.setData(ultima.getData());
            pc_transito.setDettaglio("TRANSITO");
            IndirizzoPresaConsegna indirizzo_transito = new IndirizzoPresaConsegna();
            indirizzo_transito.seleziona_magazzino();
            pc_transito.setId_luogo(indirizzo_transito.getId());
            pc_transito.setId_tipologia_merce(ultima.getId_tipologia_merce());
            pc_transito.setId_um(ultima.getId_um());
            pc_transito.setId_viaggio(this.v_selezione.getId());
            pc_transito.setLuogo(indirizzo_transito);
            pc_transito.setN_ordine(ultima.getN_ordine());
            pc_transito.setOrdine_viaggio(this.v_selezione.getInsieme_pc().vettorePC.size());
            pc_transito.setId_pc(0);
            pc_transito.setTipo("P");
            this.v_selezione.getInsieme_pc().vettorePC.add(pc_transito);
            this.precontm.setDataDettaglio(this.v_selezione.getInsieme_pc().vettorePC);
            PresaConsegna rv_temp = ultima;
            PresaConsegna rv_sel = pc_transito;
            this.riga_viaggio_selezionata = this.v_selezione.getInsieme_pc().vettorePC.size() - 1;
            rv_temp.setOrdine_viaggio(this.riga_viaggio_selezionata);
            rv_sel.setOrdine_viaggio(this.riga_viaggio_selezionata - 1);
            this.v_selezione.getInsieme_pc().vettorePC.setElementAt(rv_sel, this.riga_viaggio_selezionata - 1);
            this.v_selezione.getInsieme_pc().vettorePC.setElementAt(rv_temp, this.riga_viaggio_selezionata);
            --this.riga_viaggio_selezionata;
            this.precontm.setDataDettaglio(this.v_selezione.getInsieme_pc().vettorePC);
            this.jTableDettaglio.getSelectionModel().setSelectionInterval(this.riga_viaggio_selezionata, this.riga_viaggio_selezionata);
        }
    }

    private void jTextRicOrdineKeyReleased(KeyEvent evt) {
        try {
            OrdiniBTableModel otm = (OrdiniBTableModel)this.table_ordini.getModel();
            TableRowSorter<OrdiniBTableModel> sorter = new TableRowSorter<OrdiniBTableModel>(otm);
            this.table_ordini.setRowSorter(sorter);
            RowFilter rf = RowFilter.regexFilter("(?i)" + this.jTextRicOrdine.getText(), 4);
            sorter.setRowFilter(rf);
        }
        catch (PatternSyntaxException e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            return;
        }
    }

    private void jTableDettaglioFocusLost(FocusEvent evt) {
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MyBorderaux().setVisible(true);
            }
        });
    }

    class ClientiFornitoriFieldLocal
    extends ClientiFornitoriField {
        ClientiFornitoriFieldLocal(JInternalFrame frame, String t) {
            super(frame, t);
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.completaAutomaticamente();
            MyBorderaux.this.jLabelRS.setText(this.getAnagrafica().getRagione_sociale());
            MyBorderaux.this.v_selezione.setId_avettore(this.getAnagrafica().getIdanag());
            MyBorderaux.this.v_selezione.setVettore(this.getAnagrafica());
        }
    }

    class DateFieldLocal
    extends DateField {
        public DateFieldLocal(JFormattedTextField.AbstractFormatter formatter) {
            super(formatter);
        }

        @Override
        public void focusLost(FocusEvent e) {
            MyTrace.log.info("DateFieldLocal FOCUS LOST  START **************************************************************+");
            this.setText(this.getText().replaceAll(" ", ""));
            if (MyBorderaux.this.v_selezione != null && MyBorderaux.this.v_selezione.getInsieme_pc() != null) {
                Iterator i = MyBorderaux.this.v_selezione.getInsieme_pc().vettorePC.iterator();
                IndirizzoPresaConsegna indirizzo_transito = new IndirizzoPresaConsegna();
                indirizzo_transito.seleziona_magazzino();
                while (i.hasNext()) {
                    PresaConsegna pc = (PresaConsegna)i.next();
                    if (pc.getId_luogo() != indirizzo_transito.getId() || !pc.getTipo().equals("P")) continue;
                    pc.setData(MyBorderaux.this.fda.gira_data(MyBorderaux.this.data_partenza.getText()));
                    MyBorderaux.this.precontm.setDataDettaglio(MyBorderaux.this.v_selezione.getInsieme_pc().vettorePC);
                    MyBorderaux.this.jTableDettaglio.setModel(MyBorderaux.this.precontm);
                }
                MyTrace.log.info("DateFieldLocal FOCUS LOST  END **************************************************************+");
            }
        }
    }
}

