/*
 * Decompiled with CFR 0.152.
 */
package protocollo;

import gestionale.MyDesktopWindow;
import gestionale.configurazioni.Configurazioni;
import java.sql.ResultSet;
import protocollo.categorie.CategoriaProtocollo;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.MyTrace;
import utils.Performance;

public class RegistrazioneProtocollo {
    private int idProtocollo;
    private int num_prot;
    private int anno;
    private int id_categoria;
    private int id_anagrafica;
    private int id_commessa;
    private String categoria;
    private String codifica;
    private String data;
    private String regesto;
    private String tipo_doc;
    private String note;
    private String in_out;
    private String string_numero_commessa = "";
    private String db_commessa = "";
    private String ragione_sociale;
    private String tipo_cf;
    private String codice_cf;
    private CategoriaProtocollo categoria_protocollo;
    private FunzioniDate fda = new FunzioniDate();
    private Funzioni f = new Funzioni();
    private long tempo_di_visualizzazione;

    public int getIdProtocollo() {
        return this.idProtocollo;
    }

    public void setIdProtocollo(int idProtocollo) {
        this.idProtocollo = idProtocollo;
    }

    public CategoriaProtocollo getCategoria_protocollo() {
        return this.categoria_protocollo;
    }

    public void setCategoria_protocollo(CategoriaProtocollo categoria_protocollo) {
        this.categoria_protocollo = categoria_protocollo;
    }

    public String getTipo_cf() {
        return this.tipo_cf;
    }

    public void setTipo_cf(String tipo_cf) {
        this.tipo_cf = tipo_cf;
    }

    public String getCodice_cf() {
        return this.codice_cf;
    }

    public void setCodice_cf(String codice_cf) {
        this.codice_cf = codice_cf;
    }

    public int getNum_prot() {
        return this.num_prot;
    }

    public void setNum_prot(int num_prot) {
        this.num_prot = num_prot;
    }

    public int getAnno() {
        return this.anno;
    }

    public void setAnno(int anno) {
        this.anno = anno;
    }

    public int getId_categoria() {
        return this.id_categoria;
    }

    public void setId_categoria(int id_categoria) {
        this.id_categoria = id_categoria;
    }

    public int getId_anagrafica() {
        return this.id_anagrafica;
    }

    public void setId_anagrafica(int id_anagrafica) {
        this.id_anagrafica = id_anagrafica;
    }

    public int getId_commessa() {
        return this.id_commessa;
    }

    public void setId_commessa(int id_commessa) {
        this.id_commessa = id_commessa;
    }

    public String getCategoria() {
        return this.categoria;
    }

    public void setCategoria(String categoria) {
        this.categoria = categoria;
    }

    public String getData() {
        return this.data;
    }

    public String getData_it() {
        return this.fda.gira_data(this.data);
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getRegesto() {
        return this.regesto;
    }

    public void setRegesto(String regesto) {
        this.regesto = regesto;
    }

    public String getTipo_doc() {
        return this.tipo_doc;
    }

    public void setTipo_doc(String tipo_doc) {
        this.tipo_doc = tipo_doc;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getIn_out() {
        return this.in_out;
    }

    public void setIn_out(String in_out) {
        this.in_out = in_out;
    }

    public String getString_numero_commessa() {
        return this.string_numero_commessa;
    }

    public void setString_numero_commessa(String string_numero_commessa) {
        this.string_numero_commessa = string_numero_commessa;
    }

    public long getTempo_di_visualizzazione() {
        return this.tempo_di_visualizzazione;
    }

    public void setTempo_di_visualizzazione(long tempo_di_visualizzazione) {
        this.tempo_di_visualizzazione = tempo_di_visualizzazione;
    }

    public String getRagione_sociale() {
        return this.ragione_sociale;
    }

    public void setRagione_sociale(String ragione_sociale) {
        this.ragione_sociale = ragione_sociale;
    }

    public String getCodifica() {
        return this.codifica;
    }

    public void setCodifica(String codifica) {
        this.codifica = codifica;
    }

    public String getDb_commessa() {
        return this.db_commessa;
    }

    public void setDb_commessa(String db_commessa) {
        this.db_commessa = db_commessa;
    }

    public boolean inserisci(boolean da_solo) {
        String q_trace;
        boolean r_trace;
        String query_ins;
        boolean r_ins;
        Performance perf = new Performance("INSERISCI REGISTRAZIONE");
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(r_ins = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_ins = "INSERT INTO protocollo_registro(num_prot,anno,id_categoria_prot,data,id_anag,regesto,tipo_documento,in_out,id_commessa,note ) VALUES ( (SELECT (COALESCE(MAX(num_prot),0))+1 FROM (SELECT * FROM protocollo_registro WHERE anno=" + this.fda.anno(this.getData()) + ")as tab_temporanea)," + "'" + this.getAnno() + "'," + "" + this.f.zero_to_null(this.getId_categoria()) + "," + "'" + this.getData() + "'," + "" + this.f.zero_to_null(this.getId_anagrafica()) + "," + "'" + this.getRegesto().replaceAll("'", "''") + "'," + "'" + this.getTipo_doc().replaceAll("'", "''") + "'," + "'" + this.getIn_out() + "'," + "" + this.f.zero_to_null(this.getId_commessa()) + "," + "'" + this.getNote().replaceAll("'", "''") + " ')"))) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Inserimento Registrazione Protocollo non riuscito");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        String strSQL = "SELECT @@identity FROM protocollo_registro";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(strSQL);
        int id_inserito = 0;
        try {
            while (res.next()) {
                id_inserito = res.getInt("@@identity");
            }
        }
        catch (Exception e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
        }
        this.setIdProtocollo(id_inserito);
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        String q_prot = "SELECT num_prot from protocollo_registro where idProtocollo=" + id_inserito;
        ResultSet res_num = Configurazioni.getIstanza().connessione.eseguiQuery(q_prot);
        int numero = 0;
        try {
            while (res_num.next()) {
                numero = res_num.getInt("num_prot");
            }
        }
        catch (Exception e) {
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            e.printStackTrace();
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res_num);
        if (numero != this.getNum_prot()) {
            this.setNum_prot(numero);
        }
        if (!(r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','protocollo_registro','" + this.getIdProtocollo() + "',NOW(),'INS','" + query_ins.replaceAll("'", "''") + "')"))) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Inserimento Protocollo Registrazione non riuscito");
            Configurazioni.eccezione.gestisci("2.3", null);
            Configurazioni.getIstanza().connessione.eseguiAggiornamento("ROLLBACK");
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
            return true;
        }
        MyTrace.log.info("END INSERISCI TUTTO OK");
        perf.fine();
        return true;
    }

    public void seleziona(String where) {
        String query = "SELECT protocollo_registro.*,anag_anagrafica.ragione_sociale ,anag_anagrafica.tipo_anag as tipo_cf ,anag_anagrafica.codice as codice_cf ,protocollo_categorie.descrizione as categoria,  protocollo_categorie.codifica,protocollo_categorie.inserimento_diretto,  commesse.numero_commessa as numero_commessa,  commesse.descrizione_breve as db_commessa,  commesse.anno as anno_commessa  FROM protocollo_registro  LEFT JOIN anag_anagrafica on protocollo_registro.id_anag=anag_anagrafica.idanagrafica  LEFT JOIN protocollo_categorie on protocollo_registro.id_categoria_prot=protocollo_categorie.idProtCategorie  LEFT JOIN commesse ON protocollo_registro.id_commessa=commesse.idCommessa ";
        query = query + " " + where;
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        try {
            while (res.next()) {
                this.setIdProtocollo(res.getInt("idProtocollo"));
                this.setNum_prot(res.getInt("num_prot"));
                this.setData(res.getString("data"));
                this.setAnno(res.getInt("anno"));
                this.setCategoria_protocollo(new CategoriaProtocollo());
                this.setId_categoria(res.getInt("id_categoria_prot"));
                this.getCategoria_protocollo().setIdCat(res.getInt("id_categoria_prot"));
                this.setCategoria(res.getString("categoria"));
                this.getCategoria_protocollo().setDescrizioneCat(res.getString("categoria"));
                this.getCategoria_protocollo().setInserimentoDiretto(res.getInt("inserimento_diretto"));
                this.setCodifica(res.getString("codifica"));
                this.getCategoria_protocollo().setCodifica(res.getString("codifica"));
                this.setRegesto(res.getString("regesto"));
                this.setId_anagrafica(res.getInt("id_anag"));
                this.setRagione_sociale(res.getString("ragione_sociale"));
                this.setCodice_cf(res.getString("codice_cf"));
                this.setTipo_cf(res.getString("tipo_cf"));
                this.setTipo_doc(res.getString("tipo_documento"));
                this.setIn_out(res.getString("in_out"));
                this.setId_commessa(res.getInt("id_commessa"));
                this.setString_numero_commessa(res.getInt("numero_commessa") + "/" + res.getInt("anno_commessa"));
                this.setDb_commessa(res.getString("db_commessa"));
                this.setNote(res.getString("note"));
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("Seleziona Registrazione non riuscito");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.1", null);
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
    }

    public boolean modifica(boolean da_solo) {
        String query_mod;
        boolean r_mod;
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod = "Update protocollo_registro SET num_prot='" + this.getNum_prot() + "'," + "anno='" + this.getAnno() + "'," + "id_categoria_prot=" + this.f.zero_to_null(this.getId_categoria()) + "," + "data='" + this.getData() + "'," + "id_anag=" + this.f.zero_to_null(this.getId_anagrafica()) + "," + "regesto='" + this.getRegesto().replaceAll("'", "''") + "'," + "tipo_documento='" + this.getTipo_doc() + "'," + "note='" + this.getNote().replaceAll("'", "''") + "'," + "in_out='" + this.getIn_out() + "'," + "id_commessa=" + this.f.zero_to_null(this.getId_commessa()) + "" + " WHERE idProtocollo='" + this.getIdProtocollo() + "'"))) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Modifica Registro Protocollo non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','protocollo_registro','" + this.getIdProtocollo() + "',NOW(),'MOD','" + query_mod.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Modifica Registro Protocollo non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.3", null);
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    public void seleziona_dettagli() {
    }

    Object getColValue(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                retVal = "" + this.getNum_prot();
                break;
            }
            case 1: {
                retVal = "" + this.getAnno();
                break;
            }
            case 2: {
                retVal = "" + this.getCategoria();
                break;
            }
            case 3: {
                retVal = "" + this.fda.gira_data(this.getData());
                break;
            }
            case 4: {
                retVal = "" + this.getIn_out();
                break;
            }
            case 5: {
                retVal = this.getTipo_cf() + this.getCodice_cf() + " - " + this.getRagione_sociale();
                break;
            }
            case 6: {
                if (this.getRegesto().length() > 15) {
                    retVal = "" + this.getRegesto().substring(0, 15) + " ... ";
                    break;
                }
                retVal = "" + this.getRegesto();
                break;
            }
            case 7: {
                if (this.getId_commessa() != 0) {
                    retVal = "" + this.getString_numero_commessa();
                    break;
                }
                retVal = "";
                break;
            }
            case 8: {
                retVal = "" + this.getTipo_doc();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }
}

