/*
 * Decompiled with CFR 0.152.
 */
package magazzino.richieste_offerte;

import gestionale.configurazioni.Configurazioni;
import gestionale.personalizzazione.stampe.IntestazioneFatturaAttiva;
import gestionale.personalizzazione.stampe.PiedePaginaGenericoIntestato;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import magazzino.materiale_richiesto.MaterialeRichiesto;
import magazzino.richieste_offerte.RichiestaOfferta;
import utils.BannerWorking;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.MyTrace;
import utils.stampe.GestoreStampe;
import utils.stampe.OggettoToPrint;

public class StampaRO
implements Runnable {
    ArrayList<RichiestaOfferta> v_ro;
    RichiestaOfferta ro_selezione;
    Funzioni f = new Funzioni();
    FunzioniDate fda = new FunzioniDate();
    int y_inizio;
    Thread thread;
    GestoreStampe stampa;

    public StampaRO(RichiestaOfferta ro_selezione) {
        Configurazioni.getIstanza();
        this.y_inizio = Configurazioni.inizio_stampe;
        this.v_ro = new ArrayList();
        this.v_ro.add(ro_selezione);
    }

    public StampaRO(Vector v) {
        Configurazioni.getIstanza();
        this.y_inizio = Configurazioni.inizio_stampe;
        this.v_ro = new ArrayList();
        for (RichiestaOfferta f : v) {
            this.v_ro.add(f);
        }
    }

    public void avvia() {
        this.thread = new Thread(this);
        MyTrace.log.info("avvio Procedura su Thread");
        this.thread.start();
    }

    @Override
    public void run() {
        BannerWorking attesa = new BannerWorking("ELABORAZIONE SU THREAD STAMPA FATTURA ATTIVA");
        attesa.start();
        this.elabora1();
        attesa.stop();
    }

    public void elabora1() {
        Iterator<RichiestaOfferta> i = this.v_ro.iterator();
        this.stampa = new GestoreStampe();
        int contatore_doc = 0;
        while (i.hasNext()) {
            this.ro_selezione = i.next();
            this.stampa.aggiungi_pj();
            this.elabora();
            ++contatore_doc;
        }
        this.stampa.print();
    }

    public void elabora() {
        int y = this.y_inizio;
        int y_da_togliere = y - 100;
        MyTrace.log.info("STAMPA RO: XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX  INIZIO STAMPA XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        int contatore = 0;
        Vector insiemepagine = new Vector();
        Vector<MaterialeRichiesto> pagina = new Vector<MaterialeRichiesto>();
        for (MaterialeRichiesto mat : this.ro_selezione.getInsieme_materiale().vettoreOM) {
            int righe = 0;
            Vector rigasplittata = new Vector();
            righe = this.stampa.dimensioneSplitString(mat.getA().getDescrizione(), 350, this.stampa.Font_Calibri_8);
            rigasplittata = this.stampa.SplitString(mat.getA().getDescrizione(), 350, this.stampa.Font_Calibri_8);
            contatore = righe > 1 ? (contatore += 11 + (righe - 1) * 11) : (contatore += 11);
            Object[] str = rigasplittata.toArray();
            mat.getA().setDescrizione(str[0].toString());
            pagina.add(mat);
            for (int j = 1; j < str.length; ++j) {
                MaterialeRichiesto mat_r = new MaterialeRichiesto();
                mat_r.getA().setDescrizione(str[j].toString());
                pagina.add(mat_r);
            }
            if (contatore <= 308) continue;
            insiemepagine.add(pagina);
            pagina = new Vector();
            contatore = 0;
        }
        insiemepagine.add(pagina);
        int ultima_pagina = insiemepagine.size();
        int conta_pagina = 0;
        Iterator i_pagine = insiemepagine.iterator();
        while (i_pagine.hasNext()) {
            ++conta_pagina;
            Vector righerighe = (Vector)i_pagine.next();
            this.appendi_ro(y);
            this.appendi_seconda(y);
            this.appendi_terza(y);
            this.appendi_quarta(y);
            this.appendi_righe(y, y - this.y_inizio, this.y_inizio);
            if (conta_pagina == ultima_pagina) {
                this.appendi_resp(y, y_da_togliere);
                this.appendi_data(y, y_da_togliere);
            } else {
                this.appendi_resp(y, y_da_togliere);
                this.appendi_data(y, y_da_togliere);
            }
            this.appendi_piedi_pagina(y, y_da_togliere);
        }
        this.stampa.setFont(this.stampa.Font_Calibri_8);
        String date_now = this.fda.dataCorrente().replaceAll("-", "");
        String ora_now = this.fda.OraCorrente().replaceAll(":", "");
        String nome_file = this.f.pulisci_nome_file(date_now + ora_now + "_RO_" + this.ro_selezione.getRo_come_registrazione().getNum_prot() + "_" + this.ro_selezione.getRo_come_registrazione().getAnno());
        this.stampa.getSeg().getMy_pj_corrente().getPj().setJobName(nome_file);
        this.stampa.setInt((OggettoToPrint)new IntestazioneFatturaAttiva());
        this.stampa.setIntPP((OggettoToPrint)new IntestazioneFatturaAttiva());
        this.stampa.setPiedePaginaGenericoIntestato((OggettoToPrint)new PiedePaginaGenericoIntestato("Fattura Attiva"));
        MyTrace.log.info(" XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX STAMPA FATTURA ATTIVA FINE XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
    }

    public void appendi_ro(int y) {
        this.stampa.setFont(this.stampa.Font_Calibri_14_B);
        this.stampa.appendRoundRect(18, y, 550, 30, 10, 10);
        this.stampa.appendTextOvunque("RICHIESTA DI OFFERTA: N\u00b0 " + this.ro_selezione.getRo_come_registrazione().getNum_prot() + " " + this.ro_selezione.getRo_come_registrazione().getCodifica() + " / " + this.ro_selezione.getRo_come_registrazione().getAnno() + " DEL " + this.ro_selezione.getRo_come_registrazione().getData_it(), 22, y + 20);
    }

    public void appendi_seconda(int y) {
        this.stampa.setFont(this.stampa.Font_Calibri_10_B);
        this.stampa.appendRoundRect(18, y + 32, 300, 30, 10, 10);
        this.stampa.appendTextOvunque("Richiesta di certificati: " + this.f.si_no(this.ro_selezione.getCertificati_si_no()), 22, y + 42);
        this.stampa.appendRoundRect(320, y + 32, 250, 30, 10, 10);
        this.stampa.appendTextOvunque("COMMESSA :" + this.ro_selezione.getRo_come_registrazione().getString_numero_commessa(), 342, y + 42);
    }

    public void appendi_terza(int y) {
        this.stampa.setFont(this.stampa.Font_Calibri_10);
        this.stampa.appendRoundRect(18, y + 64, 300, 30, 10, 10);
        this.stampa.appendTextOvunque("Consegna Franco:" + this.ro_selezione.getTipo_consegna(), 22, y + 74);
        this.stampa.appendRoundRect(320, y + 64, 250, 62, 10, 10);
        this.stampa.appendTextOvunque(this.ro_selezione.getRo_come_registrazione().getRagione_sociale(), 342, y + 74);
        this.stampa.appendTextOvunque("Spett. :" + this.ro_selezione.getReferente(), 342, y + 85);
    }

    public void appendi_quarta(int y) {
        this.stampa.setFont(this.stampa.Font_Calibri_10_B);
        this.stampa.appendRoundRect(18, y + 96, 300, 30, 10, 10);
        this.stampa.appendTextOvunque("Condizioni di pagamento:" + this.ro_selezione.getDescrizione_te(), 22, y + 106);
    }

    public void appendi_righe(int y, int y_da_togliere, int y_inizio) {
        this.stampa.appendRoundRect(18, y + 140, 559, 18, 10, 10);
        this.stampa.appendRoundRect(18, y + 161, 559, 380 - y_da_togliere, 10, 10);
        this.stampa.setFont(this.stampa.Font_Calibri_8);
        int y_tabella = y + 150;
        this.stampa.appendTextOvunque("POS.", 20, y_tabella);
        this.stampa.appendTextOvunque("DESCRIZIONE", 90, y_tabella);
        this.stampa.appendTextOvunque("U.M.", 340, y_tabella);
        this.stampa.appendTextOvunque("QUANTITA'", 410, y_tabella);
        this.stampa.appendTextOvunque("EURO", 470, y_tabella);
        this.stampa.appendTextOvunque("PREZZO UNITARIO", 500, y_tabella);
        y_tabella += 20;
        boolean trovato = false;
        for (MaterialeRichiesto temp : this.ro_selezione.getInsieme_materiale().vettoreOM) {
            this.stampa.appendTestoDimensionePosizione("" + temp.getPos(), 20, y_tabella, 350);
            this.stampa.appendTestoDimensionePosizione(temp.getA().getDescrizione(), 90, y_tabella, 240);
            int righe = this.stampa.dimensioneSplitString(temp.getA().getDescrizione(), 240, this.stampa.Font_Calibri_8);
            this.stampa.appendTestoDimensionePosizione(temp.getA().getCodice_um(), 340, y_tabella, 80);
            this.stampa.appendTestoDimensionePosizione(temp.getQuantita().toString(), 410, y_tabella, 350);
            this.stampa.appendTextOvunque("", 500, y_tabella);
            this.stampa.appendTextOvunque("", 550, y_tabella);
            if (righe > 1) {
                y_tabella += 11 + (righe - 1) * 11;
                continue;
            }
            y_tabella += 11;
        }
    }

    public void appendi_resp(int y, int y_da_togliere) {
        this.stampa.appendRoundRect(18, y + 558 - y_da_togliere, 550, 80, 10, 10);
        this.stampa.setFont(this.stampa.Font_Calibri_12_B);
        this.stampa.appendTextOvunque("Data: " + this.ro_selezione.getRo_come_registrazione().getData_it(), 30, y + 578);
        this.stampa.appendTextOvunque("Resp. Commerciale", 330, y + 578);
        this.stampa.appendLine(300, y + 598, 540, y + 598);
    }

    public void appendi_data(int y, int y_da_togliere) {
    }

    public void appendi_piedi_pagina(int y, int y_da_togliere) {
        this.stampa.setFont(this.stampa.Font_Calibri_8);
        this.stampa.appendTextOvunque(" I Vs. dati anagrafici sono da noi considerati esatti sotto la Vs. responsabilit\u00e0, salvo diversa comunicazione, come previsto dall'art. 41 DPR 26/10/72 n\u00b0633.", 22, y + 665 - y_da_togliere);
        this.stampa.appendTextOvunque(" Legge 196/2003 PRIVACY: I Vs. dati esposti nel presente documento vengono usati esclusivamente per fini contabili ed amministrativi", 22, y + 673 - y_da_togliere);
    }
}

