/*
 * Decompiled with CFR 0.152.
 */
package magazzino.ordini_for;

import gestionale.configurazioni.Configurazioni;
import gestionale.personalizzazione.stampe.IntestazioneFatturaAttiva;
import gestionale.personalizzazione.stampe.PiedePaginaGenericoIntestato;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import magazzino.materiale_richiesto.MaterialeRichiesto;
import magazzino.movimenti.MovimentoMagazzino;
import magazzino.ordini_for.MmagOrdine;
import utils.BannerWorking;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.MyTrace;
import utils.stampe.GestoreStampe;
import utils.stampe.OggettoToPrint;

public class StampaOR
implements Runnable {
    ArrayList<MmagOrdine> v_ro;
    MmagOrdine o_selezione;
    Funzioni f = new Funzioni();
    FunzioniDate fda = new FunzioniDate();
    int y_inizio;
    Thread thread;
    GestoreStampe stampa;

    public StampaOR(MmagOrdine o_selezione) {
        Configurazioni.getIstanza();
        this.y_inizio = Configurazioni.inizio_stampe;
        this.v_ro = new ArrayList();
        this.v_ro.add(o_selezione);
    }

    public StampaOR(Vector v) {
        Configurazioni.getIstanza();
        this.y_inizio = Configurazioni.inizio_stampe;
        this.v_ro = new ArrayList();
        for (MmagOrdine f : v) {
            this.v_ro.add(f);
        }
    }

    public void avvia() {
        this.thread = new Thread(this);
        MyTrace.log.info("avvio Procedura su Thread");
        this.thread.start();
    }

    @Override
    public void run() {
        BannerWorking attesa = new BannerWorking("ELABORAZIONE SU THREAD STAMPA FATTURA ATTIVA");
        attesa.start();
        this.elabora1();
        attesa.stop();
    }

    public void elabora1() {
        Iterator<MmagOrdine> i = this.v_ro.iterator();
        this.stampa = new GestoreStampe();
        int contatore_doc = 0;
        while (i.hasNext()) {
            this.o_selezione = i.next();
            this.stampa.aggiungi_pj();
            this.elabora();
            ++contatore_doc;
        }
        this.stampa.print();
    }

    public void elabora() {
        int y = this.y_inizio;
        int y_da_togliere = y - 100;
        MyTrace.log.info("STAMPA RO: XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX  INIZIO STAMPA XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        int contatore = 0;
        Vector insiemepagine = new Vector();
        Vector<MaterialeRichiesto> pagina = new Vector<MaterialeRichiesto>();
        for (MaterialeRichiesto materialeRichiesto : this.o_selezione.getInsieme_materiale().vettoreOM) {
            int righe = 0;
            Vector rigasplittata = new Vector();
            righe = this.stampa.dimensioneSplitString(materialeRichiesto.getA().getDescrizione(), 350, this.stampa.Font_Calibri_8);
            rigasplittata = this.stampa.SplitString(materialeRichiesto.getA().getDescrizione(), 350, this.stampa.Font_Calibri_8);
            contatore = righe > 1 ? (contatore += 11 + (righe - 1) * 11) : (contatore += 11);
            Object[] str = rigasplittata.toArray();
            materialeRichiesto.getA().setDescrizione(str[0].toString());
            pagina.add(materialeRichiesto);
            for (int j = 1; j < str.length; ++j) {
                MaterialeRichiesto mat_r = new MaterialeRichiesto();
                mat_r.getA().setDescrizione(str[j].toString());
                pagina.add(mat_r);
            }
            if (contatore <= 308) continue;
            insiemepagine.add(pagina);
            pagina = new Vector();
            contatore = 0;
        }
        insiemepagine.add(pagina);
        int n = insiemepagine.size();
        int conta_pagina = 0;
        Iterator i_pagine = insiemepagine.iterator();
        while (i_pagine.hasNext()) {
            ++conta_pagina;
            Vector righerighe = (Vector)i_pagine.next();
            this.appendi_ro(y);
            this.appendi_seconda(y);
            this.appendi_terza(y);
            this.appendi_quarta(y);
            this.appendi_quinta(y);
            this.appendi_righe(y, y - this.y_inizio, this.y_inizio);
            if (conta_pagina == n) {
                this.appendi_resp(y, y_da_togliere);
                this.appendi_data(y, y_da_togliere);
            } else {
                this.appendi_resp(y, y_da_togliere);
                this.appendi_data(y, y_da_togliere);
            }
            this.appendi_piedi_pagina(y, y_da_togliere);
        }
        this.stampa.setFont(this.stampa.Font_Calibri_8);
        String date_now = this.fda.dataCorrente().replaceAll("-", "");
        String ora_now = this.fda.OraCorrente().replaceAll(":", "");
        String nome_file = this.f.pulisci_nome_file(date_now + ora_now + "_OR_" + this.o_selezione.getOrdine_come_registrazione().getNum_prot() + "_" + this.o_selezione.getOrdine_come_registrazione().getAnno());
        this.stampa.getSeg().getMy_pj_corrente().getPj().setJobName(nome_file);
        this.stampa.setInt((OggettoToPrint)new IntestazioneFatturaAttiva());
        this.stampa.setIntPP((OggettoToPrint)new IntestazioneFatturaAttiva());
        this.stampa.setPiedePaginaGenericoIntestato((OggettoToPrint)new PiedePaginaGenericoIntestato("Fattura Attiva"));
        MyTrace.log.info(" XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX STAMPA FATTURA ATTIVA FINE XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
    }

    public void appendi_ro(int y) {
        this.stampa.setFont(this.stampa.Font_Calibri_14_B);
        this.stampa.appendRoundRect(18, y, 550, 30, 10, 10);
        this.stampa.appendTextOvunque("ORDINE DI ACQUISTO: N\u00b0 " + this.o_selezione.getOrdine_come_registrazione().getNum_prot() + " " + this.o_selezione.getOrdine_come_registrazione().getCodifica() + " / " + this.o_selezione.getOrdine_come_registrazione().getAnno() + " DEL " + this.o_selezione.getOrdine_come_registrazione().getData_it(), 22, y + 20);
    }

    public void appendi_seconda(int y) {
        this.stampa.setFont(this.stampa.Font_Calibri_10_B);
        this.stampa.appendRoundRect(18, y + 32, 300, 20, 10, 10);
        this.stampa.appendTextOvunque("Richiesta di certificati: " + this.f.si_no(this.o_selezione.getCertificati_si_no()), 22, y + 42);
        this.stampa.appendRoundRect(320, y + 32, 250, 20, 10, 10);
        this.stampa.appendTextOvunque("COMMESSA :" + this.o_selezione.getOrdine_come_registrazione().getString_numero_commessa(), 342, y + 42);
    }

    public void appendi_terza(int y) {
        this.stampa.setFont(this.stampa.Font_Calibri_10);
        this.stampa.appendRoundRect(18, y + 54, 300, 20, 10, 10);
        this.stampa.appendTextOvunque("Riferimento Offerta:" + this.o_selezione.getString_ro(), 22, y + 64);
        this.stampa.appendRoundRect(320, y + 54, 250, 20, 10, 10);
        this.stampa.appendTextOvunque("CIG:" + this.o_selezione.getCig() + " | CUP:" + this.o_selezione.getCup(), 342, y + 64);
    }

    public void appendi_quarta(int y) {
        this.stampa.setFont(this.stampa.Font_Calibri_10);
        this.stampa.appendRoundRect(18, y + 76, 300, 20, 10, 10);
        this.stampa.appendTextOvunque("Consegna Franco:" + this.o_selezione.getTipo_consegna(), 22, y + 87);
        this.stampa.appendRoundRect(320, y + 76, 250, 62, 10, 10);
        this.stampa.appendTextOvunque("Spett. :" + this.o_selezione.getReferente(), 342, y + 87);
        this.stampa.appendTextOvunque(this.o_selezione.getOrdine_come_registrazione().getRagione_sociale(), 342, y + 98);
    }

    public void appendi_quinta(int y) {
        this.stampa.setFont(this.stampa.Font_Calibri_10_B);
        this.stampa.appendRoundRect(18, y + 98, 300, 32, 10, 10);
        this.stampa.appendTextOvunque("Condizioni di pagamento:" + this.o_selezione.getDescrizione_te(), 22, y + 111);
    }

    public void appendi_righe(int y, int y_da_togliere, int y_inizio) {
        this.stampa.appendRoundRect(18, y + 140, 559, 25, 10, 10);
        this.stampa.appendRoundRect(18, y + 167, 559, 380 - y_da_togliere, 10, 10);
        this.stampa.setFont(this.stampa.Font_Calibri_8);
        int y_tabella = y + 150;
        this.stampa.appendTextOvunque("Codice Articolo", 20, y_tabella);
        this.stampa.appendTextOvunque("DESCRIZIONE", 90, y_tabella);
        this.stampa.appendTextOvunque("U.M.", 340, y_tabella);
        this.stampa.appendTextOvunque("QUANTITA'", 370, y_tabella);
        this.stampa.appendTextOvunque("PREZZO", 430, y_tabella);
        this.stampa.appendTextOvunque("UNITARIO", 430, y_tabella + 9);
        this.stampa.appendTextOvunque("PREZZO", 530, y_tabella);
        this.stampa.appendTextOvunque("TOTALE", 530, y_tabella + 9);
        y_tabella += 30;
        boolean trovato = false;
        for (MovimentoMagazzino temp : this.o_selezione.getInsieme_materiale().vettoreOM) {
            this.stampa.appendTestoDimensionePosizione(temp.getA().getCodice_articolo(), 20, y_tabella, 350);
            this.stampa.appendTestoDimensionePosizione(temp.getA().getDescrizione(), 90, y_tabella, 240);
            int righe = this.stampa.dimensioneSplitString(temp.getA().getDescrizione(), 240, this.stampa.Font_Calibri_8);
            this.stampa.appendTestoDimensionePosizione(temp.getA().getCodice_um(), 340, y_tabella, 80);
            this.stampa.appendStringaOvunqueFormattazioneDestra(temp.getQ_arrivo().toString(), 370, y_tabella, 35);
            this.stampa.appendStringaOvunqueFormattazioneDestra("" + temp.getCosto_di_acquisto(), 410, y_tabella, 50);
            this.stampa.appendStringaOvunqueFormattazioneDestra("" + temp.getCosto_di_acquisto().multiply(temp.getQ_arrivo()), 510, y_tabella, 50);
            if (righe > 1) {
                y_tabella += 11 + (righe - 1) * 11;
                continue;
            }
            y_tabella += 11;
        }
    }

    public void appendi_resp(int y, int y_da_togliere) {
        this.stampa.appendRoundRect(18, y + 558 - y_da_togliere, 550, 80, 10, 10);
        this.stampa.setFont(this.stampa.Font_Calibri_12_B);
        this.stampa.appendTextOvunque("Data: " + this.o_selezione.getOrdine_come_registrazione().getData_it(), 30, y + 578);
        this.stampa.appendTextOvunque("Resp. Commerciale", 330, y + 578);
        this.stampa.appendLine(300, y + 598, 540, y + 598);
        this.stampa.appendTextOvunque("NOTE: DA CONSEGNARE ENTRO IL: " + this.o_selezione.getConsegna_entro_it(), 30, y + 615);
    }

    public void appendi_data(int y, int y_da_togliere) {
    }

    public void appendi_piedi_pagina(int y, int y_da_togliere) {
        this.stampa.setFont(this.stampa.Font_Calibri_8);
        this.stampa.appendTextOvunque(" I Vs. dati anagrafici sono da noi considerati esatti sotto la Vs. responsabilit\u00e0, salvo diversa comunicazione, come previsto dall'art. 41 DPR 26/10/72 n\u00b0633.", 22, y + 665 - y_da_togliere);
        this.stampa.appendTextOvunque(" Legge 196/2003 PRIVACY: I Vs. dati esposti nel presente documento vengono usati esclusivamente per fini contabili ed amministrativi", 22, y + 673 - y_da_togliere);
    }
}

