/*
 * Decompiled with CFR 0.152.
 */
package magazzino.movimenti;

import gestionale.configurazioni.Configurazioni;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import magazzino.articoli.Articolo;
import magazzino.ddtOUT.InsiemeDDTOut;
import magazzino.movimenti.MovimentoMagazzino;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;
import utils.Performance;
import utils.Quantita;

public class InsiemeMovimentiMagazzino {
    public ArrayList<MovimentoMagazzino> vettoreOM;
    int colCount;
    public String[] headers;
    FunzioniDate fda = new FunzioniDate();
    InsiemeDDTOut insieme_ddt_out = new InsiemeDDTOut();

    public InsiemeMovimentiMagazzino() {
        this.vettoreOM = new ArrayList();
    }

    public InsiemeDDTOut getInsieme_ddt_out() {
        return this.insieme_ddt_out;
    }

    public void setInsieme_ddt_out(InsiemeDDTOut insieme_ddt_out) {
        this.insieme_ddt_out = insieme_ddt_out;
    }

    public int caricamento_vista(String where, String order_by) {
        Performance perf = new Performance("CARICAMENTO INSIEME OGGETTI MAGAZZINO");
        String q = "SELECT v_mmag_movimenti.*  FROM v_mmag_movimenti ";
        q = q + " " + where;
        q = q + " " + order_by;
        this.vettoreOM = new ArrayList();
        try {
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(q);
            while (res.next()) {
                MovimentoMagazzino om = new MovimentoMagazzino();
                om.setId(res.getInt("idmmag_movimenti"));
                om.setId_articolo(res.getInt("id_articolo"));
                om.setA(new Articolo());
                om.getA().setId(res.getInt("id_articolo"));
                om.getA().setCodice_articolo(res.getString("codice_articolo"));
                om.getA().setId_gruppo(res.getInt("id_gruppo"));
                om.getA().setDescrizione(res.getString("descrizione"));
                om.getA().setNome_gruppo(res.getString("nome_gruppo"));
                om.getA().setId_um(res.getInt("id_unita_di_misura"));
                om.getA().setCodice_um(res.getString("codice_um"));
                om.getA().setId_conto_c(res.getInt("id_conto_costi"));
                om.getA().setId_conto_r(res.getInt("id_conto_ricavi"));
                om.getA().setId_conto_stock(res.getInt("id_conto_stock"));
                om.getA().setId_aliquota(res.getInt("id_aliquota"));
                om.getA().setId_aliquota_vendite(res.getInt("id_aliquota_vendite"));
                om.getA().setCod_barre(res.getString("codice_a_barre"));
                om.getA().setUltimo_costo_acquisto(new Money(res.getDouble("ultimo_costo_di_acquisto")));
                om.getA().setNote(res.getString("note"));
                om.getA().setDecimali_quantita(res.getInt("decimali_quantita"));
                om.getA().setDecimali_prezzo(res.getInt("decimali_prezzo"));
                om.setQ_arrivo(new Quantita(res.getDouble("q_arrivo")));
                om.setQ_magazzino(new Quantita(res.getDouble("q_magazzino")));
                om.setQ_uscita(new Quantita(res.getDouble("q_uscita")));
                om.setQ_da_fatturare(new Quantita(res.getDouble("q_da_fatturare")));
                om.setQ_da_fatturare_out(new Quantita(res.getDouble("q_da_fatturare_out")));
                om.setData_movimento(res.getString("data_movimento"));
                om.setId_causale_movimento(res.getInt("id_causale_movimento"));
                om.setCodice_causale(res.getString("codice_causale"));
                om.setDescrizione_causale(res.getString("descrizione_causale"));
                om.setId_ordine_for(res.getInt("id_ordine_for"));
                if (om.getId_ordine_for() != 0) {
                    om.setString_ordine_for("[" + res.getInt("num_prot_ordine") + "OR/" + res.getInt("anno_ordine") + " a +" + res.getString("ragione_sociale_ordini") + "]");
                } else {
                    om.setString_ordine_for("");
                }
                om.setId_registro_in(res.getInt("id_registro_in"));
                if (om.getId_registro_in() != 0) {
                    if (res.getString("num_ddt_in") != null && !res.getString("num_ddt_in").equals("")) {
                        om.setString_ddt_for("[DDT " + res.getString("num_ddt_in") + "/" + res.getInt("anno_ddt") + "] del " + this.fda.gira_data(res.getString("data_ddt")) + "a +" + res.getString("ragione_sociale_ddt") + "]");
                    }
                } else {
                    om.setString_ddt_for("");
                }
                om.setId_registro_f_in(res.getInt("id_registro_f_in"));
                if (om.getId_registro_f_in() != 0) {
                    if (res.getString("num_fp_in") != null && !res.getString("num_fp_in").equals("")) {
                        om.setString_f_for("[FP " + res.getString("num_fp_in") + "/" + res.getInt("anno_fp") + "] del " + this.fda.gira_data(res.getString("data_fp")) + "a +" + res.getString("ragione_sociale_fp") + "]");
                    }
                } else {
                    om.setString_f_for("");
                }
                om.setId_riga_doc_out(res.getInt("id_riga_doc_out"));
                if (om.getId_riga_doc_out() != 0) {
                    if (res.getString("numero_ddt_out") != null && !res.getString("numero_ddt_out").equals("")) {
                        om.setString_ddt_cli("[DDT " + res.getString("numero_ddt_out") + res.getString("codifica_ddt_out") + "/" + res.getInt("anno_ddt_out") + " a " + res.getString("ragione_sociale_ddt_out") + "]");
                    }
                } else {
                    om.setString_ddt_cli("");
                }
                om.setId_riga_f_out(res.getInt("id_riga_f_out"));
                if (om.getId_riga_f_out() != 0) {
                    if (res.getString("numero_f_out") != null && !res.getString("numero_f_out").equals("")) {
                        om.setString_f_cli("[FA " + res.getString("numero_f_out") + res.getString("codifica_f_out") + "/" + res.getInt("anno_f_out") + " a +" + res.getString("ragione_sociale_f_out") + "]");
                    }
                } else {
                    om.setString_f_cli("");
                }
                om.setCosto_di_acquisto(new Money(res.getDouble("costo_acquisto")));
                om.setId_ordine_cli(res.getInt("id_ordine_cli"));
                om.setId_produzione(res.getInt("id_produzione"));
                if (om.getId_produzione() != 0) {
                    om.setString_produzione("[PRODUZIONE DEL " + this.fda.gira_data(res.getString("data_produzione")) + "]");
                }
                om.setId_riga_nc_in(res.getInt("id_riga_nc_in"));
                if (om.getId_riga_nc_in() != 0) {
                    if (res.getString("numero_nc_in") != null && !res.getString("numero_nc_in").equals("")) {
                        om.setString_nc_in("[NC " + res.getString("numero_nc_in") + res.getString("codifica_nc_in") + "/" + res.getInt("anno_nc_in") + " a +" + res.getString("ragione_sociale_nc_in") + "]");
                    }
                } else {
                    om.setString_nc_in("");
                }
                om.setId_registro_nc_out(res.getInt("id_registro_nc_out"));
                if (om.getId_registro_nc_out() != 0) {
                    if (res.getString("num_nc_out") != null && !res.getString("num_nc_out").equals("")) {
                        om.setString_nc_out("[NC " + res.getString("num_nc_out") + "/" + res.getInt("anno_nc_out") + "] del " + this.fda.gira_data(res.getString("data_nc_out")) + "a +" + res.getString("ragione_sociale_nc_out") + "]");
                    }
                } else {
                    om.setString_nc_out("");
                }
                this.vettoreOM.add(om);
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        }
        catch (Exception e) {
            this.vettoreOM = new ArrayList();
            MyTrace.log.severe("Seleziona Oggetto in magazzino non riuscito");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.2", null);
        }
        perf.fine();
        return this.vettoreOM.size();
    }

    public int caricamentoDDI(String where, String order_by) {
        this.vettoreOM = new ArrayList();
        String query = "SELECT v_mmag_articoli_estesa.*, SUM(mmag_movimenti.q_arrivo) as q_in_arrivo,  mmag_movimenti.*, protocollo_registro.*, anag_anagrafica.ragione_sociale, anag_anagrafica.codice, mmag_movimenti.costo_acquisto  FROM v_mmag_articoli_estesa  LEFT JOIN mmag_movimenti on v_mmag_articoli_estesa.id=mmag_movimenti.id_articolo  LEFT JOIN mmag_ordini ON mmag_movimenti.id_ordine_for=mmag_ordini.idMmag_ordini  LEFT JOIN protocollo_registro on mmag_ordini.id_protocollo=protocollo_registro.idProtocollo  LEFT JOIN anag_anagrafica on protocollo_registro.id_anag=anag_anagrafica.idAnagrafica ";
        query = query + " " + where;
        query = query + " GROUP BY v_mmag_articoli_estesa.id " + order_by;
        try {
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
            while (res.next()) {
                MovimentoMagazzino om = new MovimentoMagazzino();
                om.setId_articolo(res.getInt("id"));
                Articolo a = new Articolo();
                a.setId(res.getInt("id"));
                a.setCodice_articolo(res.getString("codice_articolo"));
                a.setDescrizione(res.getString("descrizione"));
                a.setNome_gruppo(res.getString("nome_gruppo"));
                a.setCodice_um(res.getString("codice_um"));
                a.setId_gruppo(res.getInt("id_gruppo"));
                a.setDescrizione(res.getString("descrizione"));
                a.setNome_gruppo(res.getString("nome_gruppo"));
                a.setId_um(res.getInt("id_unita_di_misura"));
                a.setCodice_um(res.getString("codice_um"));
                a.setId_conto_c(res.getInt("id_conto_costi"));
                a.setId_conto_stock(res.getInt("id_conto_stock"));
                a.setId_aliquota(res.getInt("id_aliquota"));
                a.setId_aliquota_vendite(res.getInt("id_aliquota_vendite"));
                a.setCod_barre(res.getString("codice_a_barre"));
                om.getA().setUltimo_costo_acquisto(new Money(res.getDouble("ultimo_costo_di_acquisto")));
                om.getA().setNote(res.getString("note"));
                om.getA().setDecimali_quantita(res.getInt("decimali_quantita"));
                om.getA().setDecimali_prezzo(res.getInt("decimali_prezzo"));
                om.setA(a);
                om.setCosto_di_acquisto(new Money(res.getDouble("costo_acquisto")));
                om.setData_movimento(res.getString("data_movimento"));
                om.setQ_arrivo(new Quantita(res.getDouble("q_in_arrivo")));
                om.setRs_anagrafica(res.getString("ragione_sociale"));
                om.setCodice_anagrafica("F" + res.getString("codice"));
                om.setId_ordine_for(res.getInt("id_ordine_for"));
                if (om.getId_ordine_for() != 0) {
                    om.setString_ordine_for("[" + res.getInt("num_prot") + "OR/" + res.getInt("anno") + "]");
                } else {
                    om.setString_ordine_for("");
                }
                if (om.getQ_arrivo().isZero()) continue;
                this.vettoreOM.add(om);
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        }
        catch (Exception e) {
            this.vettoreOM = new ArrayList();
            MyTrace.log.severe("Seleziona Oggetto in magazzino non riuscito");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.2", null);
        }
        return this.vettoreOM.size();
    }

    public int caricamentoDAFATA(String where, String order_by) {
        this.vettoreOM = new ArrayList();
        String query = "SELECT v_mmag_articoli_estesa.*, SUM(mmag_movimenti.q_da_fatturare_out) as q_fat,  mmag_movimenti.*, documenti_attivi.*, registro.*, anag_anagrafica.ragione_sociale, anag_anagrafica.codice  FROM v_mmag_articoli_estesa  LEFT JOIN mmag_movimenti on v_mmag_articoli_estesa.id=mmag_movimenti.id_articolo  LEFT JOIN documenti_attivi_righe ON mmag_movimenti.id_riga_doc_out=documenti_attivi_righe.iddocumenti_attivi_righe  LEFT JOIN documenti_attivi ON documenti_attivi.iddocumenti_attivi=documenti_attivi_righe.id_documenti_attivi  LEFT JOIN registro ON documenti_attivi.id_registro=registro.idregistro  LEFT JOIN anag_anagrafica on registro.id_anagrafica=anag_anagrafica.idAnagrafica ";
        query = query + " " + where;
        query = query + " GROUP BY v_mmag_articoli_estesa.id " + order_by;
        Vector<Integer> v_id = new Vector<Integer>();
        try {
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
            while (res.next()) {
                MovimentoMagazzino om = new MovimentoMagazzino();
                om.setId_articolo(res.getInt("id"));
                Articolo a = new Articolo();
                a.setId(res.getInt("id"));
                a.setCodice_articolo(res.getString("codice_articolo"));
                a.setDescrizione(res.getString("descrizione"));
                a.setNome_gruppo(res.getString("nome_gruppo"));
                a.setCodice_um(res.getString("codice_um"));
                a.setId_conto_c(res.getInt("id_conto_costi"));
                a.setId_conto_stock(res.getInt("id_conto_stock"));
                a.setId_aliquota(res.getInt("id_aliquota"));
                a.setId_aliquota_vendite(res.getInt("id_aliquota_vendite"));
                om.setA(a);
                om.setCosto_di_acquisto(new Money(res.getDouble("costo_acquisto")));
                om.setData_movimento(res.getString("data_movimento"));
                om.setQ_da_fatturare_out(new Quantita(res.getDouble("q_fat")));
                om.setRs_anagrafica(res.getString("ragione_sociale"));
                om.setCodice_anagrafica("F" + res.getString("codice"));
                om.setId_riga_doc_out(res.getInt("id_riga_doc_out"));
                om.setId_riga_f_out(res.getInt("id_riga_f_out"));
                if (om.getId_riga_doc_out() != 0) {
                    if (res.getString("num_doc") != null && !res.getString("num_doc").equals("")) {
                        om.setString_ddt_cli("[DDT " + res.getString("num_doc") + "/" + res.getInt("anno_prot") + "] del " + this.fda.gira_data(res.getString("data_doc")) + "]");
                        int IdDocumento = res.getInt("iddocumenti_attivi");
                        boolean trovato = false;
                        Iterator k = v_id.iterator();
                        while (k.hasNext()) {
                            int ddt_temp = (Integer)k.next();
                            if (ddt_temp != IdDocumento) continue;
                            trovato = true;
                        }
                        if (!trovato && om.getQ_da_fatturare_out().gt(new Quantita(BigDecimal.ZERO))) {
                            v_id.add(IdDocumento);
                        }
                    }
                } else {
                    om.setString_ddt_cli("");
                }
                if (!om.getQ_da_fatturare_out().gt(new Quantita(BigDecimal.ZERO))) continue;
                this.vettoreOM.add(om);
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
            if (this.insieme_ddt_out == null) {
                this.insieme_ddt_out = new InsiemeDDTOut();
            }
            String w = "WHERE id_modelli_cc=20  ";
            if (!v_id.isEmpty()) {
                w = w + "AND ( ";
                Iterator k = v_id.iterator();
                while (k.hasNext()) {
                    int id = (Integer)k.next();
                    w = w + "  documenti_attivi.idDocumenti_attivi=" + id + " ";
                    if (k.hasNext()) {
                        w = w + "OR";
                        continue;
                    }
                    w = w + ")";
                }
            }
            this.insieme_ddt_out.caricamento(w, "");
        }
        catch (Exception e) {
            this.vettoreOM = new ArrayList();
            MyTrace.log.severe("Seleziona Oggetto in magazzino non riuscito");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.2", null);
        }
        return this.vettoreOM.size();
    }

    public int caricamentoDAFAT(String where, String order_by) {
        this.vettoreOM = new ArrayList();
        String query = "SELECT v_mmag_articoli_estesa.*, SUM(mmag_movimenti.q_da_fatturare) as q_fat,  mmag_movimenti.*, registro.*, anag_anagrafica.ragione_sociale, anag_anagrafica.codice  FROM v_mmag_articoli_estesa  LEFT JOIN mmag_movimenti on v_mmag_articoli_estesa.id=mmag_movimenti.id_articolo  LEFT JOIN registro ON mmag_movimenti.id_registro_in=registro.idregistro  LEFT JOIN anag_anagrafica on registro.id_anagrafica=anag_anagrafica.idAnagrafica ";
        query = query + " " + where;
        query = query + " GROUP BY v_mmag_articoli_estesa.id " + order_by;
        try {
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
            while (res.next()) {
                MovimentoMagazzino om = new MovimentoMagazzino();
                om.setId_articolo(res.getInt("id"));
                Articolo a = new Articolo();
                a.setId(res.getInt("id"));
                a.setCodice_articolo(res.getString("codice_articolo"));
                a.setDescrizione(res.getString("descrizione"));
                a.setNome_gruppo(res.getString("nome_gruppo"));
                a.setCodice_um(res.getString("codice_um"));
                om.setA(a);
                om.setCosto_di_acquisto(new Money(res.getDouble("costo_acquisto")));
                om.setData_movimento(res.getString("data_movimento"));
                om.setQ_da_fatturare(new Quantita(res.getDouble("q_fat")));
                om.setRs_anagrafica(res.getString("ragione_sociale"));
                om.setCodice_anagrafica("F" + res.getString("codice"));
                om.setId_riga_nc_in(res.getInt("id_riga_nc_in"));
                om.setId_registro_nc_out(res.getInt("id_registro_nc_out"));
                om.setId_registro_in(res.getInt("id_registro_in"));
                om.setId_registro_f_in(res.getInt("id_registro_f_in"));
                if (om.getId_registro_in() != 0) {
                    if (res.getString("num_doc") != null && !res.getString("num_doc").equals("")) {
                        om.setString_ddt_for("[DDT " + res.getString("num_doc") + "/" + res.getInt("anno_prot") + "] del " + this.fda.gira_data(res.getString("data_doc")) + "]");
                    }
                } else {
                    om.setString_ddt_for("");
                }
                if (om.getQ_da_fatturare().isZero()) continue;
                this.vettoreOM.add(om);
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        }
        catch (Exception e) {
            this.vettoreOM = new ArrayList();
            MyTrace.log.severe("Seleziona Oggetto in magazzino non riuscito");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.2", null);
        }
        return this.vettoreOM.size();
    }

    public int caricamentoPERDDI(String where, String order_by) {
        this.vettoreOM = new ArrayList();
        String query = "SELECT v_mmag_articoli_estesa.codice_articolo as ca,v_mmag_articoli_estesa.*, SUM(mmag_movimenti.q_magazzino) as q_mag,  mmag_movimenti.*, registro.*, anag_anagrafica.ragione_sociale, anag_anagrafica.codice  FROM v_mmag_articoli_estesa  LEFT JOIN mmag_movimenti on v_mmag_articoli_estesa.id=mmag_movimenti.id_articolo  LEFT JOIN registro ON mmag_movimenti.id_registro_in=registro.idregistro  LEFT JOIN anag_anagrafica on registro.id_anagrafica=anag_anagrafica.idAnagrafica ";
        query = query + " WHERE id_registro_in!=0 " + where;
        query = query + " GROUP BY v_mmag_articoli_estesa.id, mmag_movimenti.id_registro_in ";
        query = query + "UNION ";
        query = query + "(SELECT v_mmag_articoli_estesa.codice_articolo as ca,v_mmag_articoli_estesa.*, SUM(mmag_movimenti.q_magazzino) as q_mag,  mmag_movimenti.*, registro.*, anag_anagrafica.ragione_sociale, anag_anagrafica.codice  FROM v_mmag_articoli_estesa  LEFT JOIN mmag_movimenti on v_mmag_articoli_estesa.id=mmag_movimenti.id_articolo  LEFT JOIN registro ON mmag_movimenti.id_registro_f_in=registro.idregistro  LEFT JOIN anag_anagrafica on registro.id_anagrafica=anag_anagrafica.idAnagrafica ";
        query = query + " WHERE id_registro_f_in!=0 " + where;
        query = query + " GROUP BY v_mmag_articoli_estesa.id, mmag_movimenti.id_registro_f_in ) " + order_by;
        try {
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
            while (res.next()) {
                MovimentoMagazzino om = new MovimentoMagazzino();
                om.setId_articolo(res.getInt("id"));
                Articolo a = new Articolo();
                a.setId(res.getInt("id"));
                a.setCodice_articolo(res.getString("codice_articolo"));
                a.setDescrizione(res.getString("descrizione"));
                a.setNome_gruppo(res.getString("nome_gruppo"));
                a.setCodice_um(res.getString("codice_um"));
                a.setId_conto_c(res.getInt("id_conto_costi"));
                a.setId_conto_r(res.getInt("id_conto_ricavi"));
                a.setId_conto_stock(res.getInt("id_conto_stock"));
                a.setId_aliquota_vendite(res.getInt("id_aliquota_vendite"));
                a.setId_aliquota(res.getInt("id_aliquota"));
                om.setA(a);
                om.setCosto_di_acquisto(new Money(res.getDouble("costo_acquisto")));
                om.setData_movimento(res.getString("data_movimento"));
                om.setQ_magazzino(new Quantita(res.getDouble("q_mag")));
                om.setRs_anagrafica(res.getString("ragione_sociale"));
                om.setCodice_anagrafica("F" + res.getString("codice"));
                om.setId_riga_nc_in(res.getInt("id_riga_nc_in"));
                om.setId_registro_nc_out(res.getInt("id_registro_nc_out"));
                om.setId_registro_in(res.getInt("id_registro_in"));
                om.setId_registro_f_in(res.getInt("id_registro_f_in"));
                if (om.getId_registro_in() != 0) {
                    if (res.getString("num_doc") != null && !res.getString("num_doc").equals("")) {
                        om.setString_ddt_for("[DDT " + res.getString("num_doc") + "/" + res.getInt("anno_prot") + "] del " + this.fda.gira_data(res.getString("data_doc")) + "]");
                    }
                } else if (om.getId_registro_f_in() != 0) {
                    if (res.getString("num_doc") != null && !res.getString("num_doc").equals("")) {
                        om.setString_ddt_for("[FP " + res.getString("num_doc") + "/" + res.getInt("anno_prot") + "] del " + this.fda.gira_data(res.getString("data_doc")) + "]");
                    }
                } else {
                    om.setString_ddt_for("");
                }
                if (!om.getQ_magazzino().gt(new Quantita(BigDecimal.ZERO))) continue;
                this.vettoreOM.add(om);
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        }
        catch (Exception e) {
            this.vettoreOM = new ArrayList();
            MyTrace.log.severe("Seleziona Oggetto in magazzino non riuscito");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.2", null);
        }
        return this.vettoreOM.size();
    }

    public int caricamentoGiacenza(String where, String order_by) {
        this.vettoreOM = new ArrayList();
        String query = "SELECT v_mmag_articoli_estesa.*, SUM(mmag_movimenti.q_magazzino) as q_mag,  mmag_movimenti.*, registro.*, anag_anagrafica.ragione_sociale, anag_anagrafica.codice  FROM v_mmag_articoli_estesa  LEFT JOIN mmag_movimenti on v_mmag_articoli_estesa.id=mmag_movimenti.id_articolo  LEFT JOIN registro ON mmag_movimenti.id_registro_in=registro.idregistro  LEFT JOIN anag_anagrafica on registro.id_anagrafica=anag_anagrafica.idAnagrafica ";
        query = query + " " + where;
        query = query + " GROUP BY v_mmag_articoli_estesa.id " + order_by;
        try {
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
            while (res.next()) {
                MovimentoMagazzino om = new MovimentoMagazzino();
                om.setId_articolo(res.getInt("id"));
                Articolo a = new Articolo();
                a.setId(res.getInt("id"));
                a.setCodice_articolo(res.getString("codice_articolo"));
                a.setDescrizione(res.getString("descrizione"));
                a.setNome_gruppo(res.getString("nome_gruppo"));
                a.setCodice_um(res.getString("codice_um"));
                a.setId_conto_c(res.getInt("id_conto_costi"));
                a.setId_conto_r(res.getInt("id_conto_ricavi"));
                a.setId_conto_stock(res.getInt("id_conto_stock"));
                a.setId_aliquota_vendite(res.getInt("id_aliquota_vendite"));
                a.setId_aliquota(res.getInt("id_aliquota"));
                om.setA(a);
                om.setCosto_di_acquisto(new Money(res.getDouble("costo_acquisto")));
                om.setData_movimento(res.getString("data_movimento"));
                om.setQ_magazzino(new Quantita(res.getDouble("q_mag")));
                om.setId_riga_nc_in(res.getInt("id_riga_nc_in"));
                om.setId_registro_nc_out(res.getInt("id_registro_nc_out"));
                if (!om.getQ_magazzino().gt(new Quantita(BigDecimal.ZERO))) continue;
                this.vettoreOM.add(om);
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        }
        catch (Exception e) {
            this.vettoreOM = new ArrayList();
            MyTrace.log.severe("Seleziona Oggetto in magazzino non riuscito");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.2", null);
        }
        return this.vettoreOM.size();
    }

    public InsiemeMovimentiMagazzino fifo() {
        InsiemeMovimentiMagazzino ritorno = new InsiemeMovimentiMagazzino();
        for (MovimentoMagazzino om : this.vettoreOM) {
            if (om.getId() == 0) {
                if (om.getId_registro_in() == 0 && !om.getQ_magazzino().isZero()) {
                    InsiemeMovimentiMagazzino insieme_om = new InsiemeMovimentiMagazzino();
                    String where = " AND mmag_movimenti.id_articolo=" + om.getId_articolo() + " ";
                    String o = "  ";
                    o = o + " ORDER BY data_movimento ASC ";
                    insieme_om.caricamentoPERDDI(where, o);
                    Iterator<MovimentoMagazzino> i_temp = insieme_om.vettoreOM.iterator();
                    while (i_temp.hasNext() && !om.getQ_magazzino().isZero()) {
                        MovimentoMagazzino om_new = new MovimentoMagazzino();
                        MovimentoMagazzino first = i_temp.next();
                        MyTrace.log.severe(" FIRST QUANTITA MAG=" + first.getQ_magazzino() + " OM Q MAAGAZZINO= " + om.getQ_magazzino().negate());
                        if (first.getQ_magazzino().gteq(om.getQ_magazzino().negate())) {
                            om_new.setId_registro_in(first.getId_registro_in());
                            om_new.setId_registro_f_in(first.getId_registro_f_in());
                            om_new.setQ_magazzino(om.getQ_magazzino());
                            om_new.setA(om.getA());
                            om_new.setId_articolo(om.getId_articolo());
                            om_new.setId_riga_doc_out(om.getId_riga_doc_out());
                            om_new.setId_riga_f_out(om.getId_riga_f_out());
                            om_new.setId_produzione(om.getId_produzione());
                            om_new.setCosto_di_acquisto(first.getCosto_di_acquisto());
                            om_new.setData_movimento(om.getData_movimento());
                            om_new.setId_causale_movimento(om.getId_causale_movimento());
                            om_new.setCodice_causale(om.getCodice_causale());
                            om_new.setDescrizione_causale(om.getDescrizione_causale());
                            om_new.setQ_da_fatturare_out(om.getQ_da_fatturare_out());
                            om.setQ_magazzino(new Quantita(BigDecimal.ZERO));
                        } else {
                            om.setQ_magazzino(om.getQ_magazzino().plus(first.getQ_magazzino()));
                            om_new.setId_registro_in(first.getId_registro_in());
                            om_new.setId_registro_f_in(first.getId_registro_f_in());
                            om_new.setQ_magazzino(first.getQ_magazzino().negate());
                            if (!om.getQ_da_fatturare().isZero()) {
                                om_new.setQ_da_fatturare_out(om_new.getQ_magazzino().negate());
                            }
                            om_new.setA(om.getA());
                            om_new.setId_articolo(om.getId_articolo());
                            om_new.setId_riga_doc_out(om.getId_riga_doc_out());
                            om_new.setId_riga_f_out(om.getId_riga_f_out());
                            om_new.setId_produzione(om.getId_produzione());
                            om_new.setCosto_di_acquisto(first.getCosto_di_acquisto());
                            om_new.setData_movimento(om.getData_movimento());
                            om_new.setId_causale_movimento(om.getId_causale_movimento());
                            om_new.setCodice_causale(om.getCodice_causale());
                            om_new.setDescrizione_causale(om.getDescrizione_causale());
                        }
                        MyTrace.log.severe(" om_new OM " + om_new.getA().getCodice_articolo() + " QUANTITA MAG=" + om_new.getQ_magazzino() + " Q DA FASTTURARE= " + om_new.getQ_da_fatturare_out());
                        ritorno.vettoreOM.add(om_new);
                    }
                    continue;
                }
                ritorno.vettoreOM.add(om);
                continue;
            }
            ritorno.vettoreOM.add(om);
        }
        return ritorno;
    }
}

