/*
 * Decompiled with CFR 0.152.
 */
package magazzino.materiale_richiesto;

import gestionale.configurazioni.Configurazioni;
import java.sql.ResultSet;
import java.util.ArrayList;
import magazzino.articoli.Articolo;
import magazzino.materiale_richiesto.MaterialeRichiesto;
import utils.Funzioni;
import utils.Money;
import utils.MyTrace;
import utils.Performance;
import utils.Quantita;

public class InsiemeMaterialeRichiesto {
    public ArrayList<MaterialeRichiesto> vettoreOM = new ArrayList();
    int colCount;
    public String[] headers;

    public int caricamentoMR(String where, String order_by) {
        Performance perf = new Performance("CARICAMENTO INSIEME OGGETTI MAGAZZINO");
        String q = "SELECT mmag_materiale_richiesto.*, v_mmag_articoli_estesa.*  FROM mmag_materiale_richiesto LEFT JOIN v_mmag_articoli_estesa ON mmag_materiale_richiesto.id_articolo=v_mmag_articoli_estesa.id ";
        q = q + " " + where;
        q = q + " " + order_by;
        this.vettoreOM = new ArrayList();
        try {
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(q);
            while (res.next()) {
                MaterialeRichiesto m = new MaterialeRichiesto();
                m.setId(res.getInt("idmmag_materiale_richiesto"));
                m.setId_ro(res.getInt("id_ro"));
                m.setId_articolo(res.getInt("id_articolo"));
                m.setA(new Articolo());
                m.getA().setId(res.getInt("id"));
                m.getA().setCodice_articolo(res.getString("codice_articolo"));
                m.getA().setId_gruppo(res.getInt("id_gruppo"));
                m.getA().setDescrizione(res.getString("descrizione"));
                m.getA().setId_um(res.getInt("id_unita_di_misura"));
                m.getA().setCod_barre(res.getString("codice_a_barre"));
                m.getA().setUltimo_costo_acquisto(new Money(res.getDouble("ultimo_costo_di_acquisto")));
                m.getA().setNome_gruppo(res.getString("nome_gruppo"));
                m.getA().setCodice_um(res.getString("codice_um"));
                m.setQuantita(new Quantita(res.getDouble("quantita")));
                m.setPos(res.getInt("pos"));
                m.setPrezzo_unitario(new Money(res.getDouble("p_unitario")));
                m.setPrezzo_totale(new Money(res.getDouble("p_totale")));
                this.vettoreOM.add(m);
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        }
        catch (Exception e) {
            this.vettoreOM = new ArrayList();
            MyTrace.log.severe("Seleziona mmag_materiale_richiesto non riuscito");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.2", null);
        }
        perf.fine();
        return this.vettoreOM.size();
    }

    public int caricamentoGiacenzaNoZeri(String where, String order_by) {
        this.vettoreOM = new ArrayList();
        String query = "Select SUM(mmag_materiale_richiesto.quantita) as quantita,mmag_materiale_richiesto.id_articolo,mmag_materiale_richiesto.p_unitario,v_mmag_articoli_estesa.codice_articolo,v_mmag_articoli_estesa.codice_um, v_mmag_articoli_estesa.descrizione, v_mmag_articoli_estesa.id_gruppo, v_mmag_articoli_estesa.nome_gruppo from mmag_materiale_richiesto LEFT JOIN v_mmag_articoli_estesa ON mmag_materiale_richiesto.id_articolo=v_mmag_articoli_estesa.id ";
        query = query + " " + where;
        query = query + " GROUP BY id_articolo " + order_by;
        try {
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
            while (res.next()) {
                MaterialeRichiesto m = new MaterialeRichiesto();
                m.setId_articolo(res.getInt("id_articolo"));
                m.setA(new Articolo());
                m.getA().setId(res.getInt("id"));
                m.getA().setCodice_articolo(res.getString("codice_articolo"));
                m.getA().setId_gruppo(res.getInt("id_gruppo"));
                m.getA().setDescrizione(res.getString("descrizione"));
                m.getA().setNome_gruppo(res.getString("nome_gruppo"));
                m.getA().setCodice_um(res.getString("codice_um"));
                m.setQuantita(new Quantita(res.getDouble("quantita")));
                if (m.getQuantita().isZero()) continue;
                this.vettoreOM.add(m);
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        }
        catch (Exception e) {
            this.vettoreOM = new ArrayList();
            MyTrace.log.severe("Seleziona Oggetto in magazzino non riuscito");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.2", null);
        }
        return this.vettoreOM.size();
    }
}

