/*
 * Decompiled with CFR 0.152.
 */
package magazzino.listini;

import gestionale.MyDesktopWindow;
import gestionale.configurazioni.ConfigurazioneFinestre;
import gestionale.configurazioni.Configurazioni;
import gestionale.configurazioni.MyProprietaFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import magazzino.articoli.Articolo;
import magazzino.articoli.MyArticoli;
import magazzino.listini.Fattore;
import magazzino.listini.FattoriTableModel;
import magazzino.listini.InsiemeFattori;
import magazzino.listini.InsiemeListini;
import magazzino.listini.InsiemePrezziListino;
import magazzino.listini.ListiniFixedModel;
import magazzino.listini.ListiniTableModel;
import magazzino.listini.Listino;
import magazzino.listini.PrezziVTableModel;
import magazzino.listini.PrezzoListino;
import utils.DateField;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.GenericTableRenderer;
import utils.Money;
import utils.MyComboBoxModel;
import utils.MyTrace;
import utils.RicercaCellEditor;
import utils.RicercaCellRenderer;
import utils.TextInsertEditor;
import utils.TimeFormatter;
import utils.ToolTipHeader;

public class MyListiniVendita
extends JInternalFrame
implements ListSelectionListener {
    String civetta_permessi;
    public static int size_diritti = 2;
    public static String[] array_diritti = new String[]{"Listini_Visualizza", "Listini_Modifica"};
    Funzioni f = new Funzioni();
    InsiemeListini insieme_l;
    ListiniTableModel ltm;
    JTable jTableListini;
    TableRowSorter<ListiniTableModel> sorter;
    RowFilter<ListiniTableModel, Object> rf = null;
    ArrayList<RowFilter<ListiniTableModel, Object>> andFilters = new ArrayList();
    ListiniFixedModel lfm;
    JTable fixedTable;
    JToolBar jToolBarMod;
    JScrollPane scroll;
    private JScrollPane fixedScroll;
    private boolean in_modifica = false;
    private boolean non_tutte_le_righe = false;
    private Listino l_selezione;
    private String modo;
    private boolean in_new = false;
    private boolean in_filter;
    public JInternalFrame chiamante;
    MyComboBoxModel cbm;
    PrezziVTableModel ptm;
    FattoriTableModel ftm;
    public boolean aiuto_riga = false;
    DateField data_um;
    TimeFormatter mf = null;
    FunzioniDate fda = new FunzioniDate();
    int riga_selezionata = 1000;
    int riga_selezionata_f = 1000;
    private JButton jButtonAddRigaFattore;
    private JButton jButtonAddRigaRow1;
    private JButton jButtonElimina;
    private JButton jButtonEliminaRiga;
    private JButton jButtonEliminaRigaf;
    private JButton jButtonFirst;
    private JButton jButtonForm;
    private JButton jButtonLB;
    private JButton jButtonLast;
    private JButton jButtonModifica;
    private JButton jButtonNext;
    private JButton jButtonNuovo;
    private JButton jButtonPrevious;
    private JButton jButtonRefresh;
    private JButton jButtonStampa;
    private JButton jButtongenera;
    private JComboBox jComboListinodiRiferimento;
    private JLabel jLabel1;
    private JLabel jLabelDescrizione1;
    private JLabel jLabelListinoDiRiferimento;
    private JLabel jLabelNome;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanelDettaglio;
    private JPanel jPanelElenco;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator3;
    private JTabbedPane jTabbedPane1;
    private JTabbedPane jTabbedPane2;
    public JTable jTableF;
    public JTable jTablePl;
    private JTextField jTextDescrizione;
    private JTextField jTextNome;
    private JToolBar jToolBar1;
    private JToolBar jToolBar2;
    private JToolBar jToolBar3;
    private JPanel p;

    public MyListiniVendita() {
        if (!MyDesktopWindow.profilo.controllaPermesso("Listini_Visualizza")) {
            Configurazioni.eccezione.gestisci("7.1", null);
            this.dispose();
        }
        this.ltm = new ListiniTableModel();
        this.insieme_l = new InsiemeListini();
        this.jTableListini = new JTable(this.ltm);
        this.jTableListini.setSelectionMode(0);
        this.sorter = new TableRowSorter<ListiniTableModel>(this.ltm);
        for (int i = 0; i < this.ltm.getColumnCount(); ++i) {
            RowFilter rf_local = RowFilter.regexFilter("(?i)", i);
            this.andFilters.add(i, rf_local);
        }
        this.lfm = new ListiniFixedModel();
        this.lfm.setFIXED_NUM(0);
        this.fixedTable = new JTable(this.lfm);
        this.fixedTable.setAutoResizeMode(4);
        InsiemeListini insieme_l = new InsiemeListini();
        String where = " WHERE mmag_listini.acquisto_vendita ='v' ";
        insieme_l.caricamento(where, "");
        this.cbm = new MyComboBoxModel(insieme_l.getVector());
        this.ptm = new PrezziVTableModel();
        this.ftm = new FattoriTableModel();
        this.initComponents();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.mf = new TimeFormatter();
        this.data_um = new DateField(this.mf);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel1.add((Component)this.data_um, gridBagConstraints);
        this.crea_toolbar();
        this.aggiungi_tabelle();
        this.filtra();
        ListSelectionModel listSelectionModel = this.jTableListini.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        this.formatta();
        this.visualizzazione();
        this.setLocation(ConfigurazioneFinestre.GetPoint(this.getClass().getName(), new Point(200, 0)));
        this.setSize(ConfigurazioneFinestre.GetDimension(this.getClass().getName(), new Dimension(660, 500)));
    }

    private void controlla_diritti() {
        if (!MyDesktopWindow.profilo.controllaPermesso("Listini_Modifica")) {
            this.jButtonModifica.setEnabled(false);
            this.jButtonNuovo.setEnabled(false);
            this.jButtonElimina.setEnabled(false);
        }
    }

    private void crea_toolbar() {
        this.jToolBarMod = new JToolBar();
        JButton jButtonSalva = new JButton();
        JButton jButtonAnnulla = new JButton();
        jButtonSalva.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-save-as.png")));
        jButtonSalva.setText("Salva");
        jButtonSalva.setFocusable(true);
        jButtonSalva.setVerticalTextPosition(3);
        jButtonSalva.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyListiniVendita.this.jButtonSalvaActionPerformed(evt);
            }
        });
        this.jToolBarMod.add(jButtonSalva);
        jButtonAnnulla.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-undo.png")));
        jButtonAnnulla.setText("Annulla");
        jButtonAnnulla.setFocusable(true);
        jButtonAnnulla.setVerticalTextPosition(3);
        jButtonAnnulla.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyListiniVendita.this.jButtonAnnullaActionPerformed(evt);
            }
        });
        this.jToolBarMod.add(jButtonAnnulla);
    }

    private void aggiungi_tabelle() {
        this.scroll = new JScrollPane(this.jTableListini){

            @Override
            public void setColumnHeaderView(Component view) {
            }
        };
        this.scroll.setHorizontalScrollBarPolicy(31);
        this.fixedScroll = new JScrollPane(this.fixedTable);
        this.fixedScroll.setVerticalScrollBarPolicy(22);
        this.fixedScroll.setPreferredSize(new Dimension(400, 25));
        JScrollBar bar = this.fixedScroll.getVerticalScrollBar();
        JScrollBar dummyBar = new JScrollBar(){

            @Override
            public void paint(Graphics g) {
            }
        };
        dummyBar.setPreferredSize(bar.getPreferredSize());
        this.fixedScroll.setVerticalScrollBar(dummyBar);
        final JScrollBar bar1 = this.scroll.getHorizontalScrollBar();
        JScrollBar bar2 = this.fixedScroll.getHorizontalScrollBar();
        bar2.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                bar1.setValue(e.getValue());
            }
        });
        this.jTableListini.setModel(this.ltm);
        this.jTableListini.setAutoCreateRowSorter(true);
        this.jTableListini.setRowSorter(this.sorter);
        this.jTableListini.setFillsViewportHeight(true);
        this.p.add((Component)this.scroll, "Center");
        this.p.add((Component)this.fixedScroll, "North");
    }

    public void visualizzazione() {
        if (this.l_selezione.getNome().equals("BASE")) {
            this.jTextNome.setEnabled(false);
            this.jComboListinodiRiferimento.setEnabled(false);
            this.jTextDescrizione.setEnabled(false);
            this.jButtonLB.setEnabled(this.in_modifica);
            this.jTablePl.setEnabled(this.in_modifica);
            this.jTableF.setEnabled(false);
            this.jButtonAddRigaRow1.setEnabled(false);
            this.jButtonEliminaRiga.setEnabled(false);
            this.jButtonAddRigaFattore.setEnabled(false);
            this.jButtonEliminaRigaf.setEnabled(false);
            this.jButtongenera.setEnabled(false);
            this.data_um.setEnabled(this.in_modifica);
        } else {
            this.jTextNome.setEnabled(this.in_modifica);
            this.jComboListinodiRiferimento.setEnabled(this.in_modifica);
            this.jTableF.setEnabled(this.in_modifica);
            this.jTextDescrizione.setEnabled(this.in_modifica);
            this.jButtonLB.setEnabled(false);
            this.jButtonAddRigaFattore.setEnabled(this.in_modifica);
            this.jButtonEliminaRigaf.setEnabled(this.in_modifica);
            this.jTablePl.setEnabled(this.in_modifica);
            this.jButtonAddRigaRow1.setEnabled(this.in_modifica);
            this.jButtonEliminaRiga.setEnabled(this.in_modifica);
            this.jButtongenera.setEnabled(this.in_modifica);
            this.data_um.setEnabled(this.in_modifica);
        }
        if (this.in_modifica) {
            this.getContentPane().remove(this.jToolBar1);
            this.getContentPane().add((Component)this.jToolBarMod, "North");
            this.jTabbedPane1.setEnabledAt(0, false);
        } else {
            this.getContentPane().remove(this.jToolBarMod);
            this.getContentPane().add((Component)this.jToolBar1, "North");
            this.jTabbedPane1.setEnabledAt(0, true);
        }
        this.getContentPane().validate();
        this.getContentPane().repaint();
    }

    public void formatta() {
        this.jTableListini.getSelectionModel().setSelectionInterval(0, 0);
        this.jTableListini.setDefaultRenderer(Object.class, new GenericTableRenderer());
        this.fixedTable.setRowHeight(30);
        this.fixedTable.setDefaultEditor(String.class, new TextEditor());
        this.fixedTable.setDefaultRenderer(Object.class, new RicercaCellRenderer());
        this.header_tebella();
    }

    public void formatta_dettagli() {
        this.jTablePl.setRowHeight(27);
        this.jTablePl.setDefaultEditor(Object.class, new TextPrezziEditor());
        this.jTablePl.setDefaultRenderer(Object.class, new RicercaCellRenderer());
        ListSelectionModel listSelectionModel = this.jTablePl.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MyListiniVendita.this.riga_selezionata = MyListiniVendita.this.jTablePl.getSelectedRow();
            }
        });
        this.jTableF.setRowHeight(27);
        this.jTableF.setDefaultEditor(Object.class, new TextInsertEditor());
        this.jTableF.setDefaultRenderer(Object.class, new RicercaCellRenderer());
        ListSelectionModel listSelectionModel2 = this.jTableF.getSelectionModel();
        listSelectionModel2.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MyListiniVendita.this.riga_selezionata_f = MyListiniVendita.this.jTableF.getSelectedRow();
            }
        });
    }

    public void header_tebella() {
        try {
            String[] toolTipStr = new String[]{"Nome Listino", "Fattore di Derivazione", "Nome Listino di Riferimento"};
            ToolTipHeader header1 = new ToolTipHeader(this.jTableListini.getColumnModel());
            ToolTipHeader header2 = new ToolTipHeader(this.fixedTable.getColumnModel());
            header1.setToolTipStrings(toolTipStr);
            header2.setToolTipStrings(toolTipStr);
            this.fixedTable.setTableHeader(header2);
            this.jTableListini.setTableHeader(header1);
            header1.setResizingAllowed(false);
            header2.setResizingAllowed(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void azzera() {
        this.data_um.setText(this.fda.dataCorrenteIt());
        this.jTextDescrizione.setText("");
        this.jTextNome.setText("");
        this.ptm = new PrezziVTableModel();
        this.jTablePl.setModel(this.ptm);
        this.ftm = new FattoriTableModel();
        this.jTableF.setModel(this.ftm);
        this.formatta_dettagli();
    }

    public void filtra() {
        this.insieme_l = new InsiemeListini();
        String order_by = "";
        String where = " WHERE mmag_listini.acquisto_vendita ='v' ";
        if (Configurazioni.righe_ricerca != 0) {
            order_by = order_by + " LIMIT 0," + Configurazioni.righe_ricerca;
        }
        this.insieme_l.caricamento(where, order_by);
        this.ltm.setDataListini(this.insieme_l.vettoreListini);
        if (Configurazioni.righe_ricerca != 0 && this.insieme_l.vettoreListini.size() >= Configurazioni.righe_ricerca) {
            this.non_tutte_le_righe = true;
        }
    }

    public void seleziona(int row) {
        this.l_selezione = new Listino();
        this.l_selezione = this.insieme_l.vettoreListini.get(row);
        this.l_selezione.seleziona_dettagli();
        this.riempi_campi();
    }

    public void riempi_campi() {
        this.jTextDescrizione.setText(this.l_selezione.getDescrizione());
        this.jTextNome.setText(this.l_selezione.getNome());
        if (this.l_selezione.getData_aggiornamentoIt() != null && !this.l_selezione.getData_aggiornamentoIt().equals("00-00-0000")) {
            this.data_um.setText(this.l_selezione.getData_aggiornamentoIt());
        }
        Vector temp = new Vector();
        temp = this.f.crea_vettore_listini(1);
        this.jComboListinodiRiferimento.setSelectedItem(this.f.crea_nome_listini(this.l_selezione.getId_listino_rif()));
        this.ptm.setData(this.l_selezione.getInsieme_pl().vettorePL);
        this.jTablePl.setModel(this.ptm);
        this.ftm.setData(this.l_selezione.getInsiemeF().vettoreF);
        this.jTableF.setModel(this.ftm);
        this.formatta_dettagli();
    }

    private void costruisci() {
        this.l_selezione.setDescrizione(this.jTextDescrizione.getText());
        this.l_selezione.setNome(this.jTextNome.getText());
        this.l_selezione.setData_aggiornamento(this.fda.gira_data(this.data_um.getText()));
        Listino l_sel = (Listino)((MyComboBoxModel)this.jComboListinodiRiferimento.getModel()).getCompleteElementAt(this.jComboListinodiRiferimento.getSelectedIndex());
        this.l_selezione.setId_listino_rif(l_sel.getId());
    }

    private boolean check() {
        if (this.jTextNome.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Inserire il Nome del listno");
            return false;
        }
        return true;
    }

    public void aiuto_articolo(int row, int col) {
        if (col == 0 && !this.aiuto_riga) {
            MyArticoli oggetto = new MyArticoli();
            oggetto.chiamante = this;
            oggetto.row_chiamante = row;
            this.getDesktopPane().add(oggetto);
            oggetto.setLocation(200, 100);
            oggetto.setVisible(true);
            oggetto.moveToFront();
            this.aiuto_riga = true;
        }
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.jButtonNuovo = new JButton();
        this.jButtonModifica = new JButton();
        this.jButtonElimina = new JButton();
        this.jButtonForm = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButtonFirst = new JButton();
        this.jButtonPrevious = new JButton();
        this.jButtonNext = new JButton();
        this.jButtonLast = new JButton();
        this.jButtonRefresh = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.jButtonStampa = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelElenco = new JPanel();
        this.p = new JPanel();
        this.jPanelDettaglio = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabelListinoDiRiferimento = new JLabel();
        this.jComboListinodiRiferimento = new JComboBox(this.cbm);
        this.jLabelDescrizione1 = new JLabel();
        this.jLabelNome = new JLabel();
        this.jTextDescrizione = new JTextField();
        this.jTextNome = new JTextField();
        this.jLabel1 = new JLabel();
        this.jTabbedPane2 = new JTabbedPane();
        this.jPanel4 = new JPanel();
        this.jScrollPane5 = new JScrollPane();
        this.jTableF = new JTable(this.ftm);
        this.jToolBar3 = new JToolBar();
        this.jButtonAddRigaFattore = new JButton();
        this.jButtonEliminaRigaf = new JButton();
        this.jPanel3 = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.jTablePl = new JTable(this.ptm);
        this.jToolBar2 = new JToolBar();
        this.jButtonAddRigaRow1 = new JButton();
        this.jButtonEliminaRiga = new JButton();
        this.jButtonLB = new JButton();
        this.jButtongenera = new JButton();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Magazzino \\ Listini");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                MyListiniVendita.this.posizione_finestra(evt);
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                MyListiniVendita.this.finestra_ridimensionata(evt);
            }
        });
        this.jToolBar1.setRollover(true);
        this.jButtonNuovo.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-new.png")));
        this.jButtonNuovo.setText("Nuovo");
        this.jButtonNuovo.setFocusable(false);
        this.jButtonNuovo.setVerticalTextPosition(3);
        this.jButtonNuovo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyListiniVendita.this.jButtonNuovoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonNuovo);
        this.jButtonModifica.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/accessories-text-editor.png")));
        this.jButtonModifica.setText("Modifica");
        this.jButtonModifica.setFocusable(false);
        this.jButtonModifica.setHorizontalAlignment(11);
        this.jButtonModifica.setVerticalTextPosition(3);
        this.jButtonModifica.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyListiniVendita.this.jButtonModificaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonModifica);
        this.jButtonElimina.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/user-trash.png")));
        this.jButtonElimina.setText("Elimina");
        this.jButtonElimina.setFocusable(false);
        this.jButtonElimina.setHorizontalAlignment(11);
        this.jButtonElimina.setVerticalTextPosition(3);
        this.jButtonElimina.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyListiniVendita.this.jButtonEliminaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonElimina);
        this.jButtonForm.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/preferences-system.png")));
        this.jButtonForm.setText("Propriet\u00e0");
        this.jButtonForm.setFocusable(false);
        this.jButtonForm.setHorizontalAlignment(11);
        this.jButtonForm.setVerticalTextPosition(3);
        this.jButtonForm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyListiniVendita.this.jButtonFormActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonForm);
        this.jToolBar1.add(this.jSeparator1);
        this.jButtonFirst.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-first.png")));
        this.jButtonFirst.setFocusable(false);
        this.jButtonFirst.setHorizontalTextPosition(0);
        this.jButtonFirst.setVerticalTextPosition(3);
        this.jButtonFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyListiniVendita.this.jButtonFirstActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonFirst);
        this.jButtonPrevious.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-previous.png")));
        this.jButtonPrevious.setFocusable(false);
        this.jButtonPrevious.setHorizontalTextPosition(0);
        this.jButtonPrevious.setVerticalTextPosition(3);
        this.jButtonPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyListiniVendita.this.jButtonPreviousActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonPrevious);
        this.jButtonNext.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-next.png")));
        this.jButtonNext.setFocusable(false);
        this.jButtonNext.setHorizontalTextPosition(0);
        this.jButtonNext.setVerticalTextPosition(3);
        this.jButtonNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyListiniVendita.this.jButtonNextActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonNext);
        this.jButtonLast.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-last.png")));
        this.jButtonLast.setFocusable(false);
        this.jButtonLast.setHorizontalTextPosition(0);
        this.jButtonLast.setVerticalTextPosition(3);
        this.jButtonLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyListiniVendita.this.jButtonLastActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonLast);
        this.jButtonRefresh.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/view-refresh.png")));
        this.jButtonRefresh.setFocusable(false);
        this.jButtonRefresh.setHorizontalTextPosition(0);
        this.jButtonRefresh.setVerticalTextPosition(3);
        this.jButtonRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyListiniVendita.this.jButtonRefreshActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonRefresh);
        this.jToolBar1.add(this.jSeparator3);
        this.jButtonStampa.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-print.png")));
        this.jButtonStampa.setFocusable(false);
        this.jButtonStampa.setHorizontalTextPosition(0);
        this.jButtonStampa.setVerticalTextPosition(3);
        this.jToolBar1.add(this.jButtonStampa);
        this.getContentPane().add((Component)this.jToolBar1, "North");
        this.jPanelElenco.setLayout(new BorderLayout());
        this.p.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.p.setLayout(new BorderLayout());
        this.jPanelElenco.add((Component)this.p, "Center");
        this.jTabbedPane1.addTab("Elenco", this.jPanelElenco);
        this.jPanelDettaglio.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabelListinoDiRiferimento.setText("Listino di Riferimento");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        this.jPanel1.add((Component)this.jLabelListinoDiRiferimento, gridBagConstraints);
        this.jComboListinodiRiferimento.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        this.jPanel1.add((Component)this.jComboListinodiRiferimento, gridBagConstraints);
        this.jLabelDescrizione1.setText("Descrizione");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel1.add((Component)this.jLabelDescrizione1, gridBagConstraints);
        this.jLabelNome.setText("Nome");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel1.add((Component)this.jLabelNome, gridBagConstraints);
        this.jTextDescrizione.setMinimumSize(new Dimension(200, 27));
        this.jTextDescrizione.setPreferredSize(new Dimension(200, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.jPanel1.add((Component)this.jTextDescrizione, gridBagConstraints);
        this.jTextNome.setMinimumSize(new Dimension(80, 27));
        this.jTextNome.setPreferredSize(new Dimension(80, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel1.add((Component)this.jTextNome, gridBagConstraints);
        this.jLabel1.setText("Data Ultimo aggiornamento");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.jPanelDettaglio.add((Component)this.jPanel1, "North");
        this.jPanel4.setLayout(new BorderLayout());
        this.jTableF.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane5.setViewportView(this.jTableF);
        this.jPanel4.add((Component)this.jScrollPane5, "Center");
        this.jToolBar3.setRollover(true);
        this.jButtonAddRigaFattore.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/list-add.png")));
        this.jButtonAddRigaFattore.setText("Aggiungi Riga");
        this.jButtonAddRigaFattore.setFocusable(false);
        this.jButtonAddRigaFattore.setVerticalTextPosition(3);
        this.jButtonAddRigaFattore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyListiniVendita.this.jButtonAddRigaFattoreActionPerformed(evt);
            }
        });
        this.jToolBar3.add(this.jButtonAddRigaFattore);
        this.jButtonEliminaRigaf.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/list-remove.png")));
        this.jButtonEliminaRigaf.setFocusable(false);
        this.jButtonEliminaRigaf.setHorizontalAlignment(11);
        this.jButtonEliminaRigaf.setLabel("Elimina Riga");
        this.jButtonEliminaRigaf.setVerticalTextPosition(3);
        this.jButtonEliminaRigaf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyListiniVendita.this.jButtonEliminaRigafActionPerformed(evt);
            }
        });
        this.jToolBar3.add(this.jButtonEliminaRigaf);
        this.jPanel4.add((Component)this.jToolBar3, "North");
        this.jTabbedPane2.addTab("Fattori di derivazione", this.jPanel4);
        this.jPanel3.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel3.setPreferredSize(new Dimension(600, 200));
        this.jPanel3.setLayout(new BorderLayout());
        this.jTablePl.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane4.setViewportView(this.jTablePl);
        this.jPanel3.add((Component)this.jScrollPane4, "Center");
        this.jToolBar2.setRollover(true);
        this.jButtonAddRigaRow1.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/list-add.png")));
        this.jButtonAddRigaRow1.setText("Aggiungi Riga");
        this.jButtonAddRigaRow1.setFocusable(false);
        this.jButtonAddRigaRow1.setVerticalTextPosition(3);
        this.jButtonAddRigaRow1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyListiniVendita.this.jButtonAddRigaRow1jButtonAddOpzioneActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.jButtonAddRigaRow1);
        this.jButtonEliminaRiga.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/list-remove.png")));
        this.jButtonEliminaRiga.setFocusable(false);
        this.jButtonEliminaRiga.setHorizontalAlignment(11);
        this.jButtonEliminaRiga.setLabel("Elimina Riga");
        this.jButtonEliminaRiga.setVerticalTextPosition(3);
        this.jButtonEliminaRiga.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyListiniVendita.this.jButtonEliminaRigaActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.jButtonEliminaRiga);
        this.jButtonLB.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/accessories-text-editor.png")));
        this.jButtonLB.setText("Aggiorna Listino Base con Ultimo costo di Acquisto");
        this.jButtonLB.setFocusable(false);
        this.jButtonLB.setHorizontalAlignment(11);
        this.jButtonLB.setVerticalTextPosition(3);
        this.jButtonLB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyListiniVendita.this.jButtonLBActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.jButtonLB);
        this.jButtongenera.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/address-book-new.png")));
        this.jButtongenera.setText("Genera/Aggiorna tutto il listino");
        this.jButtongenera.setFocusable(false);
        this.jButtongenera.setHorizontalAlignment(11);
        this.jButtongenera.setVerticalTextPosition(3);
        this.jButtongenera.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyListiniVendita.this.jButtongeneraActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.jButtongenera);
        this.jPanel3.add((Component)this.jToolBar2, "North");
        this.jTabbedPane2.addTab("Listino", this.jPanel3);
        this.jPanelDettaglio.add((Component)this.jTabbedPane2, "Center");
        this.jTabbedPane1.addTab("Dettaglio", this.jPanelDettaglio);
        this.getContentPane().add((Component)this.jTabbedPane1, "Center");
        this.pack();
    }

    private void jButtonSalvaActionPerformed(ActionEvent evt) {
        if (this.in_new) {
            if (this.check()) {
                this.costruisci();
                this.l_selezione.inserisciListino(true);
                this.in_new = false;
                this.in_modifica = false;
                this.filtra();
                this.visualizzazione();
                this.jTabbedPane1.setSelectedIndex(0);
            }
        } else if (this.check()) {
            this.costruisci();
            this.l_selezione.modificaListino(true);
            this.in_modifica = false;
            this.filtra();
            this.visualizzazione();
            this.jTabbedPane1.setSelectedIndex(0);
        }
    }

    private void jButtonAnnullaActionPerformed(ActionEvent evt) {
        this.in_modifica = false;
        this.visualizzazione();
        this.jTabbedPane1.setSelectedIndex(0);
    }

    private void jButtonNuovoActionPerformed(ActionEvent evt) {
        this.in_new = true;
        this.jTableListini.getSelectionModel().clearSelection();
        this.l_selezione = new Listino();
        this.azzera();
        this.in_modifica = true;
        this.jTabbedPane1.setSelectedIndex(1);
        this.visualizzazione();
    }

    private void jButtonModificaActionPerformed(ActionEvent evt) {
        this.in_modifica = true;
        this.data_um.setText(this.fda.dataCorrenteIt());
        this.visualizzazione();
        if (this.jTabbedPane1.getSelectedIndex() == 0) {
            this.jTabbedPane1.setSelectedIndex(1);
        }
    }

    private void jButtonEliminaActionPerformed(ActionEvent evt) {
        if (this.l_selezione.getNome().equals("BASE")) {
            JOptionPane.showMessageDialog(this, "Il listino BASE non pu\u00f2 essere ne eliminato ne modificato");
        } else {
            this.jTabbedPane1.setSelectedIndex(1);
            int res = JOptionPane.showConfirmDialog(this, "Sei sicuro di voler eleiminare questi Listini?");
            if (res == 0) {
                this.l_selezione.elimina(true);
                this.in_modifica = false;
                this.filtra();
            }
            this.visualizzazione();
            this.jTabbedPane1.setSelectedIndex(0);
        }
    }

    private void jButtonFormActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        MyProprietaFrame oggetto = new MyProprietaFrame();
        this.getDesktopPane().add(oggetto);
        oggetto.setLocation(200, 0);
        oggetto.setVisible(true);
        oggetto.moveToFront();
        this.setCursor(new Cursor(0));
    }

    private void jButtonFirstActionPerformed(ActionEvent evt) {
        if (this.ltm.getRowCount() != 0) {
            this.jTableListini.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void jButtonPreviousActionPerformed(ActionEvent evt) {
        try {
            if (this.jTableListini.getSelectedRow() > 0 && this.ltm.getRowCount() != 0) {
                this.jTableListini.getSelectionModel().setSelectionInterval(this.jTableListini.getSelectedRow() - 1, this.jTableListini.getSelectedRow() - 1);
            }
        }
        catch (Exception err) {
            MyTrace.log.severe("RAGGIUNTO PRIMO");
            err.printStackTrace();
        }
    }

    private void jButtonNextActionPerformed(ActionEvent evt) {
        try {
            if (this.ltm.getRowCount() != 0) {
                this.jTableListini.getSelectionModel().setSelectionInterval(this.jTableListini.getSelectedRow() + 1, this.jTableListini.getSelectedRow() + 1);
            }
        }
        catch (Exception err) {
            MyTrace.log.severe("RAGGIUNTO ULTIMO");
            err.printStackTrace();
        }
    }

    private void jButtonLastActionPerformed(ActionEvent evt) {
        if (this.ltm.getRowCount() != 0) {
            this.jTableListini.getSelectionModel().setSelectionInterval(this.ltm.getRowCount() - 1, this.ltm.getRowCount() - 1);
        }
    }

    private void posizione_finestra(ComponentEvent evt) {
        ConfigurazioneFinestre.SetPoint(this.getClass().getName(), this.getLocation());
    }

    private void finestra_ridimensionata(ComponentEvent evt) {
        ConfigurazioneFinestre.SetDimension(this.getClass().getName(), this.getSize());
    }

    private void jButtonRefreshActionPerformed(ActionEvent evt) {
        this.filtra();
        this.formatta();
        this.visualizzazione();
    }

    private void jButtonAddRigaRow1jButtonAddOpzioneActionPerformed(ActionEvent evt) {
        if (this.jTablePl.getCellEditor() != null) {
            this.jTablePl.getCellEditor().stopCellEditing();
        }
        PrezzoListino temp = new PrezzoListino();
        temp.setA(new Articolo());
        temp.setCodice_art_fornitore("");
        if (!this.in_new) {
            temp.setId_listino(this.l_selezione.getId());
        }
        if (this.l_selezione.getInsieme_pl() == null || this.l_selezione.getInsieme_pl().vettorePL.size() == 0) {
            this.l_selezione.setInsieme_pl(new InsiemePrezziListino());
        }
        this.l_selezione.getInsieme_pl().vettorePL.add(temp);
        this.ptm.setData(this.l_selezione.getInsieme_pl().vettorePL);
    }

    private void jButtonEliminaRigaActionPerformed(ActionEvent evt) {
        int res = JOptionPane.showConfirmDialog(this, "Sei sicuro di voler eleiminare la riga numero" + this.riga_selezionata + " selezionata?");
        if (res == 0) {
            PrezzoListino p_da_el = this.l_selezione.getInsieme_pl().vettorePL.get(this.riga_selezionata);
            if (this.l_selezione.getInsieme_pl_da_el() == null) {
                this.l_selezione.setInsieme_pl_da_el(new InsiemePrezziListino());
            }
            this.l_selezione.getInsieme_pl_da_el().vettorePL.add(p_da_el);
            this.l_selezione.getInsieme_pl().vettorePL.remove(this.riga_selezionata);
            this.ptm.setData(this.l_selezione.getInsieme_pl().vettorePL);
            this.jTablePl.setModel(this.ptm);
        }
    }

    private void jButtonLBActionPerformed(ActionEvent evt) {
        for (PrezzoListino pl : this.l_selezione.getInsieme_pl().vettorePL) {
            pl.setPrezzo_listino(pl.getA().getUltimo_costo_acquisto());
        }
        this.ptm.setData(this.l_selezione.getInsieme_pl().vettorePL);
    }

    private void jButtonAddRigaFattoreActionPerformed(ActionEvent evt) {
        if (this.jTableF.getCellEditor() != null) {
            this.jTableF.getCellEditor().stopCellEditing();
        }
        Fattore temp = new Fattore();
        temp.setA(new Money(BigDecimal.ZERO));
        temp.setDa(new Money(BigDecimal.ZERO));
        temp.setFattore(1.0);
        if (!this.in_new) {
            temp.setId_listino(this.l_selezione.getId());
        }
        if (this.l_selezione.getInsiemeF() == null || this.l_selezione.getInsiemeF().vettoreF.size() == 0) {
            this.l_selezione.setInsieme_pl(new InsiemePrezziListino());
        }
        this.l_selezione.getInsiemeF().vettoreF.add(temp);
        this.ftm.setData(this.l_selezione.getInsiemeF().vettoreF);
    }

    private void jButtonEliminaRigafActionPerformed(ActionEvent evt) {
        int res = JOptionPane.showConfirmDialog(this, "Sei sicuro di voler eleiminare la riga numero" + this.riga_selezionata_f + " selezionata?");
        if (res == 0) {
            Fattore f_da_el = this.l_selezione.getInsiemeF().vettoreF.get(this.riga_selezionata_f);
            if (this.l_selezione.getInsieme_f_da_el() == null) {
                this.l_selezione.setInsieme_f_da_el(new InsiemeFattori());
            }
            this.l_selezione.getInsieme_f_da_el().vettoreF.add(f_da_el);
            this.l_selezione.getInsiemeF().vettoreF.remove(this.riga_selezionata_f);
            this.ftm.setData(this.l_selezione.getInsiemeF().vettoreF);
            this.jTableF.setModel(this.ftm);
        }
    }

    private void jButtongeneraActionPerformed(ActionEvent evt) {
        Listino listino_base = this.insieme_l.vettoreListini.get(0);
        listino_base.seleziona_dettagli();
        for (PrezzoListino plb : listino_base.getInsieme_pl().vettorePL) {
            PrezzoListino pl_vero = new PrezzoListino();
            boolean intervallo_trovato = false;
            double fattore_da_applicare = 0.0;
            if (this.l_selezione.getInsiemeF() != null && !this.l_selezione.getInsiemeF().vettoreF.isEmpty()) {
                Iterator<Fattore> j = this.l_selezione.getInsiemeF().vettoreF.iterator();
                while (j.hasNext() && !intervallo_trovato) {
                    Fattore f = j.next();
                    if (!plb.getPrezzo_listino().gteq(f.getDa()) || !plb.getPrezzo_listino().lteq(f.getA())) continue;
                    intervallo_trovato = true;
                    fattore_da_applicare = f.getFattore();
                }
            }
            if (!intervallo_trovato) {
                JOptionPane.showMessageDialog(this, "Ricontrollare gli intervalli di prezzo e i fattori!");
                continue;
            }
            boolean trovato = false;
            if (this.l_selezione.getInsieme_pl() == null || this.l_selezione.getInsieme_pl().vettorePL.isEmpty()) continue;
            for (PrezzoListino pll : this.l_selezione.getInsieme_pl().vettorePL) {
                if (pll.getId_articolo() != plb.getId_articolo()) continue;
                trovato = true;
                pl_vero = pll;
            }
            pl_vero.setPrezzo_listino(plb.getPrezzo_listino().times(fattore_da_applicare));
            if (trovato) continue;
            pl_vero.setId_articolo(plb.getId_articolo());
            pl_vero.setId_listino(this.l_selezione.getId());
            pl_vero.setA(plb.getA());
            this.l_selezione.getInsieme_pl().vettorePL.add(pl_vero);
        }
        this.ptm.setData(this.l_selezione.getInsieme_pl().vettorePL);
        this.jTablePl.setModel(this.ptm);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int viewRow = this.jTableListini.getSelectedRow();
        int modelRow = 1000000000;
        if (this.in_filter) {
            if (viewRow >= 0) {
                modelRow = this.jTableListini.convertRowIndexToModel(viewRow);
            }
        } else {
            modelRow = viewRow;
        }
        if (modelRow <= this.ltm.getRowCount() - 1 && modelRow >= 0) {
            this.seleziona(modelRow);
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            JTable jtb = (JTable)e.getSource();
            int viewRow = jtb.getSelectedRow();
            int modelRow = 1000000000;
            if (this.in_filter) {
                if (viewRow >= 0) {
                    modelRow = this.jTableListini.convertRowIndexToModel(viewRow);
                }
            } else {
                modelRow = viewRow;
            }
            if (modelRow <= this.ltm.getRowCount() - 1 && modelRow >= 0) {
                Listino l = new Listino();
                l = this.insieme_l.vettoreListini.get(modelRow);
            }
        }
    }

    public class TextPrezziEditor
    extends TextInsertEditor {
        @Override
        public void chiama_aiuto(String col_row) {
            String[] a = col_row.split("_");
            int col = Integer.parseInt(a[0]);
            int row = Integer.parseInt(a[1]);
            System.out.println("chiamaaiuto " + col + " " + row);
            MyListiniVendita.this.aiuto_articolo(MyListiniVendita.this.jTablePl.getSelectedRow(), col);
            this.getCellEditorValue();
        }
    }

    public class TextRigaEditor
    extends TextInsertEditor {
        @Override
        public void chiama_aiuto(String col_row) {
        }
    }

    public class TextEditor
    extends RicercaCellEditor {
        RowFilter<ListiniTableModel, Object> rf_local = null;

        @Override
        public void newFilter(int col) {
            if (!MyListiniVendita.this.non_tutte_le_righe) {
                try {
                    this.rf_local = RowFilter.regexFilter("(?i)" + this.tf.getText(), col);
                    MyListiniVendita.this.andFilters.set(col, this.rf_local);
                }
                catch (PatternSyntaxException e) {
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                    return;
                }
                MyListiniVendita.this.rf = RowFilter.andFilter(MyListiniVendita.this.andFilters);
                MyListiniVendita.this.sorter.setRowFilter(MyListiniVendita.this.rf);
                MyListiniVendita.this.formatta();
            } else {
                String where = " WHERE 1 AND abilita='1'";
                if (col == 0) {
                    where = where + " AND nome LIKE '%" + this.tf.getText() + "%'";
                }
                if (col == 1) {
                    where = where + " AND fattore_di_derivazione LIKE '%" + this.tf.getText() + "%'";
                }
                if (col == 2) {
                    // empty if block
                }
                MyListiniVendita.this.insieme_l.caricamento(where, "");
                MyListiniVendita.this.ltm.setDataListini(MyListiniVendita.this.insieme_l.vettoreListini);
                MyListiniVendita.this.formatta();
            }
        }
    }
}

