/*
 * Decompiled with CFR 0.152.
 */
package magazzino.fOUT;

import gestionale.documenti.Documento;
import gestionale.documenti.RigaDocumento;
import gestionale.primanota.InsiemePNRiga;
import gestionale.primanota.PNRiga;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Vector;
import magazzino.articoli.Articolo;
import magazzino.movimenti.InsiemeMovimentiMagazzino;
import magazzino.movimenti.MovimentoMagazzino;
import utils.Money;
import utils.MyTrace;

public class FOut
extends Documento {
    InsiemeMovimentiMagazzino insieme_movimenti = new InsiemeMovimentiMagazzino();

    public InsiemeMovimentiMagazzino getInsieme_movimenti() {
        return this.insieme_movimenti;
    }

    public void setInsieme_movimenti(InsiemeMovimentiMagazzino insieme_movimenti) {
        this.insieme_movimenti = insieme_movimenti;
    }

    @Override
    public void seleziona_dettagli() {
        super.seleziona_dettagli();
        for (RigaDocumento rd : this.getInsieme_r().vettoreR) {
            rd.setInsieme_om(new InsiemeMovimentiMagazzino());
            String w = " WHERE id_riga_f_out=" + rd.getId_riga() + " ";
            rd.getInsieme_om().caricamento_vista(w, "");
            rd.setArticolo(new Articolo());
            w = " WHERE codice_articolo= '" + rd.getCodice_articolo() + "' ";
            rd.getArticolo().seleziona(w);
        }
    }

    @Override
    public void costruisci_righe_gestione() {
        PNRiga pnr;
        boolean trovato;
        int id_conto_om;
        if (this.getR().getInsieme_righe() == null) {
            this.getR().setInsieme_righe(new InsiemePNRiga());
        }
        Money imponibile_materiali = new Money(BigDecimal.ZERO);
        Vector<Integer> v_id_conti_stock = new Vector<Integer>();
        Vector<Integer> v_id_conti_costi = new Vector<Integer>();
        Vector<Integer> v_id_conti_ricavi = new Vector<Integer>();
        for (RigaDocumento rdoc : this.getInsieme_r().vettoreR) {
            int id_conto_ricavi;
            for (MovimentoMagazzino om : rdoc.getInsieme_om().vettoreOM) {
                int id_conto_stock;
                if (om.getQ_magazzino().isZero() || v_id_conti_stock.contains(id_conto_stock = om.getA().getId_conto_stock())) continue;
                v_id_conti_stock.add(id_conto_stock);
            }
            if (rdoc.getArticolo() == null) continue;
            int id_conto_costi = rdoc.getArticolo().getId_conto_c();
            if (!v_id_conti_costi.contains(id_conto_costi)) {
                v_id_conti_costi.add(id_conto_costi);
            }
            if (!v_id_conti_ricavi.contains(id_conto_ricavi = rdoc.getArticolo().getId_conto_r())) {
                v_id_conti_ricavi.add(id_conto_ricavi);
            }
            v_id_conti_ricavi.add(this.getR().getAnagrafica().getId_conto_f_da_emettere());
        }
        MyTrace.log.info("MyDDI: HO " + v_id_conti_stock.size() + " TIPI DI conti stock ");
        Iterator ip = v_id_conti_stock.iterator();
        while (ip.hasNext()) {
            int id_cs_corrente = (Integer)ip.next();
            Money imponibile_materiali_conto = new Money(BigDecimal.ZERO);
            for (RigaDocumento rdoc : this.getInsieme_r().vettoreR) {
                for (MovimentoMagazzino om : rdoc.getInsieme_om().vettoreOM) {
                    if (om.getQ_magazzino().isZero() || (id_conto_om = om.getA().getId_conto_stock()) != id_cs_corrente) continue;
                    imponibile_materiali_conto = imponibile_materiali_conto.plus(om.getCosto_di_acquisto().multiply(om.getQ_magazzino().negate()));
                }
            }
            trovato = false;
            if (this.getR().getInsieme_righe() != null) {
                for (PNRiga pnr_temp : this.getR().getInsieme_righe().vettoreRPN) {
                    if (pnr_temp.getBloccato() != 1 || pnr_temp.getId_conto() != id_cs_corrente) continue;
                    trovato = true;
                    MyTrace.log.info("MyDDI: Ho trovato la riga  BLOCCATA con questa conto => Aggiorno i valori");
                    pnr_temp.setImporto(imponibile_materiali_conto);
                }
            }
            if (!trovato && !imponibile_materiali_conto.isZero()) {
                MyTrace.log.info("MyDDI: Non ho trovato la riga  BLOCCATA con questa conto => Costruisco una nuopva riga ");
                if (this.getR().getInsieme_righe() == null) {
                    this.getR().setInsieme_righe(new InsiemePNRiga());
                }
                pnr = new PNRiga();
                this.getR().getInsieme_righe().vettoreRPN.add(pnr);
                pnr.setBloccato(1);
                pnr.setId_conto(id_cs_corrente);
                pnr.setInizio_competenza(this.getR().getData_doc());
                pnr.setFine_competenza(this.getR().getData_doc());
                pnr.setSegno(2);
                pnr.setId_registro(this.getR().getIdregistro());
                pnr.setR(this.getR());
                pnr.setImporto(imponibile_materiali_conto);
            }
            imponibile_materiali = imponibile_materiali.plus(imponibile_materiali_conto);
        }
        ip = v_id_conti_costi.iterator();
        while (ip.hasNext()) {
            int id_c_corrente = (Integer)ip.next();
            Money imponibile_materiali_conto = new Money(BigDecimal.ZERO);
            for (RigaDocumento rdoc : this.getInsieme_r().vettoreR) {
                for (MovimentoMagazzino om : rdoc.getInsieme_om().vettoreOM) {
                    if (om.getQ_magazzino().isZero() || (id_conto_om = om.getA().getId_conto_c()) != id_c_corrente) continue;
                    imponibile_materiali_conto = imponibile_materiali_conto.plus(om.getCosto_di_acquisto().multiply(om.getQ_magazzino().negate()));
                }
            }
            trovato = false;
            if (this.getR().getInsieme_righe() != null) {
                for (PNRiga pnr_temp : this.getR().getInsieme_righe().vettoreRPN) {
                    if (pnr_temp.getBloccato() != 1 || pnr_temp.getId_conto() != id_c_corrente) continue;
                    trovato = true;
                    MyTrace.log.info("MyDDI: Ho trovato la riga  BLOCCATA con questa conto => Aggiorno i valori");
                    pnr_temp.setImporto(imponibile_materiali_conto);
                }
            }
            if (!trovato && !imponibile_materiali_conto.isZero()) {
                MyTrace.log.info("MyDDI: Non ho trovato la riga  BLOCCATA con questa conto => Costruisco una nuopva riga ");
                if (this.getR().getInsieme_righe() == null) {
                    this.getR().setInsieme_righe(new InsiemePNRiga());
                }
                pnr = new PNRiga();
                this.getR().getInsieme_righe().vettoreRPN.add(pnr);
                pnr.setBloccato(1);
                pnr.setId_conto(id_c_corrente);
                pnr.setInizio_competenza(this.getR().getData_doc());
                pnr.setFine_competenza(this.getR().getData_doc());
                pnr.setSegno(1);
                pnr.setId_registro(this.getR().getIdregistro());
                pnr.setR(this.getR());
                pnr.setImporto(imponibile_materiali_conto);
            }
            imponibile_materiali = imponibile_materiali.plus(imponibile_materiali_conto);
        }
        ip = v_id_conti_ricavi.iterator();
        while (ip.hasNext()) {
            int id_c_corrente = (Integer)ip.next();
            Money imponibile_materiali_conto = new Money(BigDecimal.ZERO);
            for (RigaDocumento rdoc : this.getInsieme_r().vettoreR) {
                if (!rdoc.getQuantita().isZero()) {
                    int id_conto_om2;
                    boolean ok_ricavi = false;
                    if (rdoc.getInsieme_om() == null || rdoc.getInsieme_om().vettoreOM.isEmpty()) {
                        ok_ricavi = true;
                    } else {
                        for (MovimentoMagazzino mm : rdoc.getInsieme_om().vettoreOM) {
                            if (mm.getQ_magazzino().isZero()) continue;
                            ok_ricavi = true;
                        }
                    }
                    if (ok_ricavi && (id_conto_om2 = rdoc.getArticolo().getId_conto_r()) == id_c_corrente) {
                        imponibile_materiali_conto = imponibile_materiali_conto.plus(rdoc.getPrezzo_unitario().multiply(rdoc.getQuantita()));
                    }
                }
                if (imponibile_materiali_conto.isZero()) continue;
                boolean trovato2 = false;
                if (this.getR().getInsieme_righe() != null) {
                    for (PNRiga pnr_temp : this.getR().getInsieme_righe().vettoreRPN) {
                        if (pnr_temp.getBloccato() != 1 || pnr_temp.getId_conto() != id_c_corrente) continue;
                        trovato2 = true;
                        MyTrace.log.info("MyDDI: Ho trovato la riga  BLOCCATA con questa conto => Aggiorno i valori");
                        pnr_temp.setImporto(imponibile_materiali_conto);
                    }
                }
                if (!trovato2 && !imponibile_materiali_conto.isZero()) {
                    MyTrace.log.info("MyDDI: Non ho trovato la riga  BLOCCATA con questa conto => Costruisco una nuopva riga ");
                    if (this.getR().getInsieme_righe() == null) {
                        this.getR().setInsieme_righe(new InsiemePNRiga());
                    }
                    PNRiga pnr2 = new PNRiga();
                    this.getR().getInsieme_righe().vettoreRPN.add(pnr2);
                    pnr2.setBloccato(1);
                    pnr2.setId_conto(id_c_corrente);
                    pnr2.setInizio_competenza(this.getR().getData_doc());
                    pnr2.setFine_competenza(this.getR().getData_doc());
                    pnr2.setSegno(2);
                    pnr2.setId_registro(this.getR().getIdregistro());
                    pnr2.setR(this.getR());
                    pnr2.setImporto(imponibile_materiali_conto);
                }
                imponibile_materiali = imponibile_materiali.plus(imponibile_materiali_conto);
            }
        }
        Money imponibile_materiali_fe = new Money(BigDecimal.ZERO);
        int id_conto_fatture = this.getR().getAnagrafica().getId_conto_f_da_emettere();
        for (RigaDocumento rdoc : this.getInsieme_r().vettoreR) {
            boolean ok_fe = false;
            for (MovimentoMagazzino mm : rdoc.getInsieme_om().vettoreOM) {
                if (mm.getQ_da_fatturare_out().isZero()) continue;
                ok_fe = true;
            }
            if (!ok_fe) continue;
            imponibile_materiali_fe = imponibile_materiali_fe.plus(rdoc.getPrezzo_unitario().multiply(rdoc.getQuantita()));
        }
        if (!imponibile_materiali_fe.isZero()) {
            boolean trovato3 = false;
            if (this.getR().getInsieme_righe() != null) {
                for (PNRiga pnr_temp : this.getR().getInsieme_righe().vettoreRPN) {
                    if (pnr_temp.getBloccato() != 1 || pnr_temp.getId_conto() != id_conto_fatture) continue;
                    trovato3 = true;
                    MyTrace.log.info("MyDDI: Ho trovato la riga  BLOCCATA con questa conto => Aggiorno i valori");
                    pnr_temp.setImporto(imponibile_materiali_fe);
                }
            }
            if (!trovato3) {
                MyTrace.log.info("MyDDI: Non ho trovato la riga  BLOCCATA con questa conto => Costruisco una nuopva riga ");
                if (this.getR().getInsieme_righe() == null) {
                    this.getR().setInsieme_righe(new InsiemePNRiga());
                }
                PNRiga pnr3 = new PNRiga();
                this.getR().getInsieme_righe().vettoreRPN.add(pnr3);
                pnr3.setBloccato(1);
                pnr3.setId_conto(id_conto_fatture);
                pnr3.setInizio_competenza(this.getR().getData_doc());
                pnr3.setFine_competenza(this.getR().getData_doc());
                pnr3.setSegno(2);
                pnr3.setId_registro(this.getR().getIdregistro());
                pnr3.setR(this.getR());
                pnr3.setImporto(imponibile_materiali_fe);
            }
            imponibile_materiali = imponibile_materiali.plus(imponibile_materiali_fe);
        }
    }

    public Object getColValueDDTOut(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                retVal = "" + this.getR().getData_docIt();
                break;
            }
            case 1: {
                retVal = "" + this.getR().getNum_doc() + "/" + this.getR().getAnno_doc();
                break;
            }
            case 2: {
                retVal = "" + this.getR().getNum_reg() + "/" + this.getR().getAnno_reg();
                break;
            }
            case 3: {
                if (this.getR().getTipo_cf().equals("F") || this.getR().getTipo_cf().equals("C")) {
                    retVal = "" + this.getR().getTipo_cf() + this.getR().getCodice_cf();
                    break;
                }
                retVal = "";
                break;
            }
            case 4: {
                if (this.getR().getTipo_cf().equals("F") || this.getR().getTipo_cf().equals("C")) {
                    retVal = "" + this.getR().getRagione_sociale_cf();
                    break;
                }
                retVal = "";
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }
}

