/*
 * Decompiled with CFR 0.152.
 */
package magazzino.articoli;

import gestionale.MyDesktopWindow;
import gestionale.configurazioni.Configurazioni;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import magazzino.distinte_base.Componente;
import magazzino.distinte_base.InsiemeComponenti;
import magazzino.listini.InsiemePrezziListino;
import magazzino.listini.PrezzoListino;
import magazzino.movimenti.InsiemeMovimentiMagazzino;
import magazzino.movimenti.MovimentoMagazzino;
import utils.Funzioni;
import utils.Money;
import utils.MyTrace;
import utils.Quantita;

public class Articolo {
    private String codice_articolo = "";
    private String descrizione = "";
    private String note;
    private String cod_barre;
    private String nome_gruppo;
    private String codice_um = "";
    private String descrizione_gruppo;
    private String codice_aliquota_acquisti;
    private String codice_aliquota_vendite;
    private String codice_conto_stock;
    private String codice_conto_c;
    private String codice_conto_r;
    private String desc_conto_stock;
    private String desc_conto_c;
    private String desc_conto_r;
    private int id;
    private int id_gruppo;
    private int id_um;
    private int id_aliquota;
    private int id_aliquota_vendite;
    private int id_conto_stock;
    private int decimali_prezzo;
    private int decimali_quantita;
    private int id_conto_c;
    private int id_conto_r;
    private Money ultimo_costo_acquisto = new Money(BigDecimal.ZERO);
    private Quantita q_iniziale = new Quantita(BigDecimal.ZERO);
    private InsiemePrezziListino insieme_pl;
    private InsiemeComponenti insieme_componenti;
    private InsiemeComponenti insieme_componenti_da_eliminare;
    private InsiemeMovimentiMagazzino insieme_m;
    private PrezzoListino pl;
    private Funzioni f = new Funzioni();

    public String getCod_barre() {
        return this.cod_barre;
    }

    public void setCod_barre(String cod_barre) {
        this.cod_barre = cod_barre;
    }

    public String getCodice_articolo() {
        return this.codice_articolo;
    }

    public void setCodice_articolo(String codice_articolo) {
        this.codice_articolo = codice_articolo;
    }

    public String getDescrizione() {
        return this.descrizione;
    }

    public void setDescrizione(String descrizione) {
        this.descrizione = descrizione;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId_gruppo() {
        return this.id_gruppo;
    }

    public void setId_gruppo(int id_gruppo) {
        this.id_gruppo = id_gruppo;
    }

    public int getId_um() {
        return this.id_um;
    }

    public void setId_um(int id_um) {
        this.id_um = id_um;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public Money getUltimo_costo_acquisto() {
        return this.ultimo_costo_acquisto;
    }

    public void setUltimo_costo_acquisto(Money ultimo_costo_acquisto) {
        this.ultimo_costo_acquisto = ultimo_costo_acquisto;
    }

    public String getNome_gruppo() {
        return this.nome_gruppo;
    }

    public void setNome_gruppo(String nome_gruppo) {
        this.nome_gruppo = nome_gruppo;
    }

    public String getCodice_um() {
        return this.codice_um;
    }

    public void setCodice_um(String codice_um) {
        this.codice_um = codice_um;
    }

    public int getId_aliquota() {
        return this.id_aliquota;
    }

    public void setId_aliquota(int id_aliquota) {
        this.id_aliquota = id_aliquota;
    }

    public InsiemePrezziListino getInsieme_pl() {
        return this.insieme_pl;
    }

    public void setInsieme_pl(InsiemePrezziListino insieme_pl) {
        this.insieme_pl = insieme_pl;
    }

    public int getId_aliquota_vendite() {
        return this.id_aliquota_vendite;
    }

    public void setId_aliquota_vendite(int id_aliquota_vendite) {
        this.id_aliquota_vendite = id_aliquota_vendite;
    }

    public PrezzoListino getPl() {
        return this.pl;
    }

    public void setPl(PrezzoListino pl) {
        this.pl = pl;
    }

    public String getDescrizione_gruppo() {
        return this.descrizione_gruppo;
    }

    public void setDescrizione_gruppo(String descrizione_gruppo) {
        this.descrizione_gruppo = descrizione_gruppo;
    }

    public int getId_conto_stock() {
        return this.id_conto_stock;
    }

    public void setId_conto_stock(int id_conto_stock) {
        this.id_conto_stock = id_conto_stock;
    }

    public String getCodice_aliquota_acquisti() {
        return this.codice_aliquota_acquisti;
    }

    public void setCodice_aliquota_acquisti(String codice_aliquota_acquisti) {
        this.codice_aliquota_acquisti = codice_aliquota_acquisti;
    }

    public String getCodice_aliquota_vendite() {
        return this.codice_aliquota_vendite;
    }

    public void setCodice_aliquota_vendite(String codice_aliquota_vendite) {
        this.codice_aliquota_vendite = codice_aliquota_vendite;
    }

    public int getDecimali_prezzo() {
        return this.decimali_prezzo;
    }

    public void setDecimali_prezzo(int decimali_prezzo) {
        this.decimali_prezzo = decimali_prezzo;
    }

    public int getDecimali_quantita() {
        return this.decimali_quantita;
    }

    public void setDecimali_quantita(int decimali_quantita) {
        this.decimali_quantita = decimali_quantita;
    }

    public InsiemeComponenti getInsieme_componenti() {
        return this.insieme_componenti;
    }

    public void setInsieme_componenti(InsiemeComponenti insieme_componenti) {
        this.insieme_componenti = insieme_componenti;
    }

    public InsiemeComponenti getInsieme_componenti_da_eliminare() {
        return this.insieme_componenti_da_eliminare;
    }

    public void setInsieme_componenti_da_eliminare(InsiemeComponenti insieme_componenti_da_eliminare) {
        this.insieme_componenti_da_eliminare = insieme_componenti_da_eliminare;
    }

    public String getCodice_conto_stock() {
        return this.codice_conto_stock;
    }

    public void setCodice_conto_stock(String codice_conto_stock) {
        this.codice_conto_stock = codice_conto_stock;
    }

    public String getDesc_conto_stock() {
        return this.desc_conto_stock;
    }

    public void setDesc_conto_stock(String desc_conto_stock) {
        this.desc_conto_stock = desc_conto_stock;
    }

    public String getCodice_conto_c() {
        return this.codice_conto_c;
    }

    public void setCodice_conto_c(String codice_conto_c) {
        this.codice_conto_c = codice_conto_c;
    }

    public String getCodice_conto_r() {
        return this.codice_conto_r;
    }

    public void setCodice_conto_r(String codice_conto_r) {
        this.codice_conto_r = codice_conto_r;
    }

    public String getDesc_conto_c() {
        return this.desc_conto_c;
    }

    public void setDesc_conto_c(String desc_conto_c) {
        this.desc_conto_c = desc_conto_c;
    }

    public String getDesc_conto_r() {
        return this.desc_conto_r;
    }

    public void setDesc_conto_r(String desc_conto_r) {
        this.desc_conto_r = desc_conto_r;
    }

    public int getId_conto_c() {
        return this.id_conto_c;
    }

    public void setId_conto_c(int id_conto_c) {
        this.id_conto_c = id_conto_c;
    }

    public int getId_conto_r() {
        return this.id_conto_r;
    }

    public void setId_conto_r(int id_conto_r) {
        this.id_conto_r = id_conto_r;
    }

    public InsiemeMovimentiMagazzino getInsieme_m() {
        return this.insieme_m;
    }

    public void setInsieme_m(InsiemeMovimentiMagazzino insieme_m) {
        this.insieme_m = insieme_m;
    }

    public Quantita getQ_iniziale() {
        return this.q_iniziale;
    }

    public void setQ_iniziale(Quantita q_iniziale) {
        this.q_iniziale = q_iniziale;
    }

    public boolean inserisciArticolo(boolean da_solo) {
        String query_ins;
        boolean r_ins;
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(r_ins = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_ins = "INSERT INTO mmag_articoli(codice_articolo,id_gruppo,descrizione,id_unita_di_misura,codice_a_barre,ultimo_costo_di_acquisto,id_aliquota,id_aliquota_vendite,decimali_quantita,decimali_prezzo,note) VALUES ('" + this.getCodice_articolo().replaceAll("'", "''") + "'," + "" + this.getId_gruppo() + "," + "'" + this.getDescrizione().replaceAll("'", "''") + "'," + "" + this.getId_um() + "," + "'" + this.getCod_barre() + "'," + "" + this.getUltimo_costo_acquisto() + "," + "" + this.getId_aliquota() + "," + "" + this.getId_aliquota_vendite() + "," + "" + this.getDecimali_quantita() + "," + "" + this.getDecimali_prezzo() + "," + "'" + this.getNote().replaceAll("'", "''") + "')"))) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Inserimento aRTICOLO non riuscito");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        this.setId(Configurazioni.getIstanza().connessione.id_inserito("mmag_articoli"));
        boolean res = true;
        if (this.getPl() != null) {
            this.getPl().setId_articolo(this.getId());
            this.getPl().setId_listino(1);
            res = this.getPl().inserisciPL(false);
        }
        if (!res) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Inserimento aRTICOLO non riuscito per prezzo di listino");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        boolean res_g = true;
        if (!this.getQ_iniziale().isZero()) {
            MovimentoMagazzino mm = new MovimentoMagazzino();
            mm.setId_articolo(this.getId());
            mm.setData_movimento("0000-00-00");
            mm.setId_causale_movimento(1);
            mm.setQ_magazzino(this.getQ_iniziale());
            if (this.getPl() != null) {
                mm.setCosto_di_acquisto(this.getPl().getPrezzo_listino());
            }
            res_g = mm.inserisci(false);
        }
        if (!res_g) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Inserimento aRTICOLO non riuscito per movimento iniziale");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mmag_articoli','" + this.getId() + "',NOW(),'INS','" + query_ins.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Inserimento aRTICOLO non riuscito per trace");
            Configurazioni.eccezione.gestisci("2.3", null);
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    public boolean modificaArticolo(boolean da_solo) {
        String query_mod;
        boolean r_mod;
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod = "UPDATE mmag_articoli  SET codice_articolo='" + this.getCodice_articolo() + "'," + " id_gruppo='" + this.getId_gruppo() + "', " + " descrizione='" + this.getDescrizione().replaceAll("'", "''") + "', " + " id_unita_di_misura='" + this.getId_um() + "',  " + " codice_a_barre='" + this.getCod_barre() + "', " + " ultimo_costo_di_acquisto='" + this.getUltimo_costo_acquisto() + "', " + " id_aliquota='" + this.getId_aliquota() + "', " + " id_aliquota_vendite='" + this.getId_aliquota_vendite() + "', " + " decimali_quantita=" + this.getId_aliquota() + ", " + " decimali_prezzo=" + this.getId_aliquota_vendite() + ", " + " note='" + this.getNote().replaceAll("'", "''") + "' " + " WHERE id='" + this.getId() + "'"))) {
            MyTrace.log.severe("Modifica Articolo non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        boolean res = true;
        if (this.getPl() != null) {
            this.getPl().setId_articolo(this.getId());
            this.getPl().setId_listino(1);
            res = this.getPl().modificaPL(false);
        }
        if (!res) {
            MyTrace.log.severe("Modifica Articolo non riuscita:non posso aggiornare il prezzo base di listino");
            Configurazioni.eccezione.gestisci("3.2", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        boolean res_db_el = true;
        if (this.getInsieme_componenti_da_eliminare() != null && !this.getInsieme_componenti_da_eliminare().vettoreComponenti.isEmpty()) {
            for (Componente c : this.getInsieme_componenti_da_eliminare().vettoreComponenti) {
                res_db_el = c.elimina(false);
            }
        }
        if (!res_db_el) {
            MyTrace.log.severe("Modifica Articolo non riuscita:non posso eliminare il componenete della distinta base");
            Configurazioni.eccezione.gestisci("3.2", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        boolean res_db = true;
        if (this.getInsieme_componenti() != null && !this.getInsieme_componenti().vettoreComponenti.isEmpty()) {
            for (Componente c : this.getInsieme_componenti().vettoreComponenti) {
                c.setId_articolo_out(this.getId());
                if (c.getIdComponente() == 0) {
                    res_db = c.inserisci(false);
                    continue;
                }
                res_db = c.modifica(false);
            }
        }
        if (!res_db) {
            MyTrace.log.severe("Modifica Articolo non riuscita:non posso eliminare il componenete della distinta base");
            Configurazioni.eccezione.gestisci("3.2", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        boolean res_g = true;
        MovimentoMagazzino mm = new MovimentoMagazzino();
        String where = " WHERE id_articolo=" + this.getId() + " AND id_causale_movimento=1 ";
        mm.seleziona(where);
        mm.setQ_magazzino(this.getQ_iniziale());
        if (this.getPl() != null) {
            mm.setCosto_di_acquisto(this.getPl().getPrezzo_listino());
        }
        if (!(res_g = mm.modifica(false))) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("modifica aRTICOLO non riuscito per movimento iniziale");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mmag_articoli','" + this.getId() + "',NOW(),'MOD','" + query_mod.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Modifica Articolo non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.3", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    public void seleziona(String where) {
        String query_seleziona = "SELECT v_mmag_articoli_estesa.*, mmag_gruppi.id_conto_stock,  mmag_gruppi.id_conto_costi,  mmag_gruppi.id_conto_ricavi,  listino_base.id as id_prezzo,  listino_base.prezzo as prezzo_base,  conf_aliquote_iva.codice as codice_aliquota  from v_mmag_articoli_estesa  LEFT JOIN conf_aliquote_iva ON v_mmag_articoli_estesa.id_aliquota=conf_aliquote_iva.idAliquota   LEFT JOIN mmag_gruppi on v_mmag_articoli_estesa.id_gruppo=mmag_gruppi.id  LEFT JOIN (select  mmag_listino.id,mmag_listino.prezzo,mmag_listino.id_articolo FROM mmag_listino WHERE id_listino=1) as listino_base ON v_mmag_articoli_estesa.id=listino_base.id_articolo ";
        query_seleziona = query_seleziona + where;
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query_seleziona);
        try {
            ResultSetMetaData meta = res.getMetaData();
            while (res.next()) {
                this.setCod_barre(res.getString("codice_a_barre"));
                this.setCodice_articolo(res.getString("codice_articolo"));
                this.setId_gruppo(res.getInt("id_gruppo"));
                this.setId(res.getInt("id"));
                this.setDescrizione(res.getString("descrizione"));
                this.setNome_gruppo(res.getString("nome_gruppo"));
                this.setId_um(res.getInt("id_unita_di_misura"));
                this.setCodice_um(res.getString("codice_um"));
                this.setId_aliquota(res.getInt("id_aliquota"));
                this.setId_aliquota_vendite(res.getInt("id_aliquota_vendite"));
                this.setUltimo_costo_acquisto(new Money(res.getDouble("ultimo_costo_di_acquisto")));
                this.setNote(res.getString("note"));
                this.setCodice_aliquota_acquisti(res.getString("codice_aliquota"));
                this.setDecimali_quantita(res.getInt("decimali_quantita"));
                this.setDecimali_prezzo(res.getInt("decimali_prezzo"));
                this.setId_conto_c(res.getInt("id_conto_costi"));
                this.setId_conto_stock(res.getInt("id_conto_stock"));
                this.setId_conto_r(res.getInt("id_conto_ricavi"));
                this.setPl(new PrezzoListino());
                this.getPl().setId(res.getInt("id_prezzo"));
                this.getPl().setPrezzo_listino(new Money(res.getDouble("prezzo_base"), this.getDecimali_prezzo()));
                this.getPl().setId_articolo(res.getInt("id"));
                this.getPl().setId_listino(1);
            }
        }
        catch (Exception e) {
            MyTrace.log.severe("Seleziona Articolo non riuscito ");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.1", null);
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
    }

    public void seleziona_prezzi() {
        String w = " WHERE mmag_listino.id_articolo=" + this.getId();
        this.setInsieme_pl(new InsiemePrezziListino());
        this.insieme_pl.caricamento(w, "");
        if (this.getInsieme_pl().vettorePL.isEmpty()) {
            PrezzoListino pl = new PrezzoListino();
            pl.setA(this);
            pl.setPrezzo_listino(new Money(BigDecimal.ZERO));
            this.setPl(pl);
        } else {
            for (PrezzoListino pl : this.getInsieme_pl().vettorePL) {
                if (pl.getId_listino() != 1) continue;
                this.setPl(pl);
            }
        }
    }

    public void seleziona_dettagli() {
        String w = " WHERE id_articolo_out=" + this.getId();
        this.setInsieme_componenti(new InsiemeComponenti());
        this.getInsieme_componenti().caricamento(w, "");
        MovimentoMagazzino mm = new MovimentoMagazzino();
        String where = " WHERE id_articolo=" + this.getId() + " AND id_causale_movimento=1 ";
        mm.seleziona(where);
        this.setQ_iniziale(mm.getQ_magazzino());
    }

    public void seleziona_movimenti_magazzino() {
        this.setInsieme_m(new InsiemeMovimentiMagazzino());
        String where = "WHERE v_mmag_movimenti.id_articolo= " + this.getId() + " ";
        String o = " ORDER BY v_mmag_movimenti.data_movimento ";
        this.getInsieme_m().caricamento_vista(where, o);
    }

    public boolean elimina(int id) {
        String q_start = "START TRANSACTION;";
        boolean r_start = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_start);
        String query_del = "DELETE FROM mmag_articoli WHERE id='" + this.getId() + "'";
        boolean r_del = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_del);
        if (!r_start || !r_del) {
            MyTrace.log.severe("Elimina Articolo non riuscita");
            Configurazioni.eccezione.gestisci("3.5", null);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','mmag_articoli','" + this.getId() + "',NOW(),'DEL','" + query_del.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Elimina Articolo non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.6", null);
            return false;
        }
        Configurazioni.getIstanza().connessione.commit();
        return true;
    }

    Object getColValue(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                retVal = "" + this.getCodice_articolo();
                break;
            }
            case 1: {
                retVal = "" + this.getDescrizione();
                break;
            }
            case 2: {
                retVal = this.getNome_gruppo();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }
}

