/*
 * Decompiled with CFR 0.152.
 */
package gestionale.scadenziario;

import gestionale.configurazioni.Configurazioni;
import gestionale.personalizzazione.stampe.IntestazioneScadenziario;
import gestionale.personalizzazione.stampe.PiedePaginaGenericoIntestato;
import gestionale.scadenziario.Scadenza;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.Vector;
import utils.BannerWorking;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;
import utils.stampe.GestoreStampe;
import utils.stampe.OggettoToPrint;

public class StampaScadenze
implements Runnable {
    Funzioni f;
    FunzioniDate fda;
    GestoreStampe stampa;
    Money totale_scadenze_dare = new Money(BigDecimal.ZERO);
    Money totale_scadenze_avere = new Money(BigDecimal.ZERO);
    Money totale_importi = new Money(BigDecimal.ZERO);
    Money totale_saldato = new Money(BigDecimal.ZERO);
    Color colore = new Color(220, 220, 220);
    Thread thread;
    private Vector v_scadenze;
    private String cliente_fornitore;
    private String dataDA;
    private String dataA;

    public StampaScadenze(String cliente_fornitore, Vector v_scadenze, String dataDA, String dataA) {
        this.f = new Funzioni();
        this.fda = new FunzioniDate();
        this.stampa = new GestoreStampe();
        this.stampa.aggiungi_pj();
        this.stampa.setPiedePaginaGenericoIntestato((OggettoToPrint)new PiedePaginaGenericoIntestato("Scadenziario"));
        this.stampa.setIntPP((OggettoToPrint)new IntestazioneScadenziario());
        this.stampa.setInt((OggettoToPrint)new IntestazioneScadenziario());
        this.cliente_fornitore = cliente_fornitore;
        this.dataA = dataA;
        this.dataDA = dataDA;
        this.v_scadenze = v_scadenze;
    }

    public void avvia() {
        this.thread = new Thread(this);
        MyTrace.log.info("avvio Procedura su Thread");
        this.thread.start();
    }

    @Override
    public void run() {
        BannerWorking attesa = new BannerWorking("ELABORAZIONE SU THREAD STAMPA PRIMANOTA");
        attesa.start();
        this.elabora2();
        attesa.stop();
    }

    public boolean elabora2() {
        Configurazioni.getIstanza();
        int y_inizio = Configurazioni.inizio_stampe;
        try {
            MyTrace.log.info(" XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX STAMPA SCADENZE XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
            long tempo_di_visualizzazione = System.currentTimeMillis();
            this.totale_importi = new Money(BigDecimal.ZERO);
            this.totale_scadenze_dare = new Money(BigDecimal.ZERO);
            this.totale_scadenze_avere = new Money(BigDecimal.ZERO);
            this.totale_saldato = new Money(BigDecimal.ZERO);
            int y = y_inizio;
            this.intestazione_tabella_conti(this.cliente_fornitore, this.stampa, 20, y, this.dataDA, this.dataA);
            y = y_inizio + 50;
            for (Scadenza s : this.v_scadenze) {
                if (s.isSel_per_stampa()) {
                    this.totale_importi = this.totale_importi.plus(s.getImporto());
                    if (s.getPagato() == 0) {
                        if (s.getSegno() == 1) {
                            this.totale_scadenze_dare = this.totale_scadenze_dare.plus(s.getImporto());
                        } else {
                            this.totale_scadenze_avere = this.totale_scadenze_avere.plus(s.getImporto());
                        }
                    }
                    this.totale_saldato = this.totale_saldato.plus(s.getImporto_saldato());
                }
                if (y > 720) {
                    this.stampa.paginanuova();
                    this.stampa.setPiedePaginaGenericoIntestato((OggettoToPrint)new PiedePaginaGenericoIntestato("Scadenziario"));
                    y = y_inizio;
                    this.intestazione_tabella_conti(this.cliente_fornitore, this.stampa, 20, y, this.dataDA, this.dataA);
                    y = y_inizio + 50;
                }
                if (!s.isSel_per_stampa()) continue;
                this.stampa.appendRect(20, y, 555, 20, this.colore);
                this.stampa.setFont(this.stampa.Font_Calibri_7);
                this.stampa.appendTextOvunque(s.getNum_reg() + "/" + this.fda.anno(s.getData_registrazione()), 25, y + 8);
                this.stampa.appendStringaOvunqueFormattazioneDestra(s.getNum_doc() + "/" + this.fda.anno(s.getData_doc()), 60, y + 8, 40);
                this.stampa.appendTextOvunque(this.fda.gira_data(s.getData_doc()), 115, y + 8);
                int l_descrizione_cc = s.getDescrizione_cc().length();
                if (l_descrizione_cc > 47) {
                    String str_descrizione_cc = s.getDescrizione_cc().substring(0, 47);
                    this.stampa.appendTextOvunque(str_descrizione_cc, 170, y + 8);
                } else {
                    this.stampa.appendTextOvunque(s.getDescrizione_cc(), 170, y + 8);
                }
                this.stampa.appendStringaOvunqueFormattazioneDestra(this.f.formattaNumero("" + s.getImporto_doc()), 275, y + 8, 30);
                if (s.getSegno() == 1) {
                    this.stampa.appendStringaOvunqueFormattazioneDestra(this.f.formattaNumero("" + s.getImporto()), 325, y + 8, 30);
                }
                if (s.getSegno() == 2) {
                    this.stampa.appendStringaOvunqueFormattazioneDestra(this.f.formattaNumero("" + s.getImporto()), 365, y + 8, 30);
                }
                this.stampa.appendStringaOvunqueFormattazioneDestra(this.f.formattaNumero("" + s.getImporto_saldato()), 400, y + 8, 30);
                this.stampa.appendStringaOvunqueFormattazioneDestra(this.f.formattaNumero("" + s.getImporto().minus(s.getImporto_saldato())), 440, y + 8, 30);
                this.stampa.appendTextOvunque(s.getData_scadenza_it(), 475, y + 8);
                int l_descrizione_rag_soc = s.getA_ragione_sociale().length();
                if (l_descrizione_rag_soc > 31) {
                    String str_descrizione_r_s = s.getA_ragione_sociale().substring(0, 31);
                    this.stampa.appendTextOvunque(s.getTipo_a_cf() + s.getA_codice_cf() + " - " + str_descrizione_r_s, 25, y + 16);
                } else {
                    this.stampa.appendTextOvunque(s.getTipo_a_cf() + s.getA_codice_cf() + " - " + s.getA_ragione_sociale(), 25, y + 16);
                }
                this.stampa.appendTextOvunque(s.getModo_pagamento(), 175, y + 16);
                if (s.getPagato() == 1) {
                    this.stampa.appendTextOvunque(this.fda.gira_data(s.getData_doc_saldo()), 525, y + 16);
                }
                if (s.getPagato() == 0) {
                    if (s.getImporto_saldato().isZero()) {
                        this.stampa.appendTextOvunque("Non Pagato", 525, y + 13, Color.RED);
                    } else {
                        this.stampa.appendTextOvunque("Saldato in parte", 525, y + 13, Color.ORANGE);
                    }
                }
                y += 20;
            }
            this.stampa.appendRoundRect(20, y += 4, 555, 45, 10, 10);
            this.stampa.appendStringaOvunqueFormattazioneDestra("TOTALE", 275, y + 10, 30);
            this.stampa.appendStringaOvunqueFormattazioneDestra("IMPORTI", 275, y + 20, 30);
            this.stampa.appendStringaOvunqueFormattazioneDestra("" + this.f.formattaNumero("" + this.totale_importi), 275, y + 35, 30);
            this.stampa.appendStringaOvunqueFormattazioneDestra("TOTALE", 325, y + 10, 30);
            this.stampa.appendStringaOvunqueFormattazioneDestra("DARE", 325, y + 20, 30);
            this.stampa.appendStringaOvunqueFormattazioneDestra("" + this.f.formattaNumero("" + this.totale_scadenze_dare), 325, y + 35, 30);
            this.stampa.appendStringaOvunqueFormattazioneDestra("TOTALE", 365, y + 10, 30);
            this.stampa.appendStringaOvunqueFormattazioneDestra("AVERE", 365, y + 20, 30);
            this.stampa.appendStringaOvunqueFormattazioneDestra("" + this.f.formattaNumero("" + this.totale_scadenze_avere), 365, y + 35, 30);
            this.stampa.appendStringaOvunqueFormattazioneDestra("TOTALE", 400, y + 10, 30);
            this.stampa.appendStringaOvunqueFormattazioneDestra("SALDATO", 400, y + 20, 30);
            this.stampa.appendStringaOvunqueFormattazioneDestra("" + this.f.formattaNumero("" + this.totale_saldato), 400, y + 35, 30);
            this.stampa.appendStringaOvunqueFormattazioneDestra("TOTALE", 440, y + 10, 30);
            this.stampa.appendStringaOvunqueFormattazioneDestra("DA SALDARE", 440, y + 20, 30);
            this.stampa.appendStringaOvunqueFormattazioneDestra("" + this.f.formattaNumero("" + this.totale_scadenze_dare.minus(this.totale_scadenze_avere).minus(this.totale_saldato)), 440, y + 35, 30);
            String data_now = this.fda.dataCorrente().replaceAll("-", "");
            String ora_now = this.fda.OraCorrente().replaceAll(":", "");
            this.stampa.getSeg().getMy_pj_corrente().getPj().setJobName(data_now + ora_now + "_Scadenze_verso_" + this.cliente_fornitore + "_dal_" + this.dataDA + "_al_" + this.dataA);
            MyTrace.log.info(" PERFORMANCE: Tempo di Elaborazione =" + (System.currentTimeMillis() - tempo_di_visualizzazione) + " millisecondi");
            this.stampa.print();
            MyTrace.log.info(" XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX STAMPA SCADENZE XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
            MyTrace.log.info(" PERFORMANCE: Tempo Totale compresa la stampa =" + (System.currentTimeMillis() - tempo_di_visualizzazione) + " millisecondi");
            return true;
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE: Stampa Partite Clienti/Fornitori non riuscito");
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
            return false;
        }
    }

    public void intestazione_tabella_conti(String c_f, GestoreStampe stampa, int x, int y, String dataDA, String dataA) {
        stampa.setFont(stampa.Font_Calibri_8);
        stampa.appendRoundRect(x, y, 555, 47, 10, 10);
        stampa.appendTextOvunque("NUM.", 22, y + 10);
        stampa.appendTextOvunque("REG.", 22, y + 20);
        stampa.appendTextOvunque("NUMERO", 55, y + 10);
        stampa.appendTextOvunque("DOCUMENTO", 55, y + 20);
        stampa.appendTextOvunque("DATA", 115, y + 10);
        stampa.appendTextOvunque("DOCUMENTO", 115, y + 20);
        stampa.appendTextOvunque("DESCRIZIONE", 165, y + 10);
        stampa.appendTextOvunque("CAUSALE", 165, y + 20);
        stampa.appendStringaOvunqueFormattazioneDestra("IMPORTO", 275, y + 10, 30);
        stampa.appendStringaOvunqueFormattazioneDestra("DOCUMENTO", 275, y + 20, 30);
        stampa.appendStringaOvunqueFormattazioneDestra("DARE", 325, y + 10, 30);
        stampa.appendStringaOvunqueFormattazioneDestra("AVERE", 365, y + 10, 30);
        stampa.appendStringaOvunqueFormattazioneDestra("SALDATO", 400, y + 10, 30);
        stampa.appendStringaOvunqueFormattazioneDestra("DA", 440, y + 10, 30);
        stampa.appendStringaOvunqueFormattazioneDestra("SALDARE", 440, y + 20, 30);
        stampa.appendTextOvunque("DATA", 475, y + 10);
        stampa.appendTextOvunque("SCADENZA", 475, y + 20);
        stampa.appendTextOvunque("STATO", 525, y + 10);
        stampa.appendTextOvunque("PAGAMENTO", 525, y + 20);
        if (c_f.equals("C") || c_f.equals("Clienti")) {
            stampa.appendTextOvunque("CODICE E RAGIONE SOCIALE CLIENTE", 25, y + 40);
            stampa.setFont(stampa.Font_Arial_12_B);
            stampa.appendTextOvunque("Scadenze verso Clienti dal " + dataDA + " al " + dataA, 30, y - 5);
            stampa.setFont(stampa.Font_Calibri_8);
        }
        if (c_f.equals("F") || c_f.equals("Fornitori")) {
            stampa.appendTextOvunque("CODICE E RAGIONE SOCIALE FORNITORE", 25, y + 40);
            stampa.setFont(stampa.Font_Arial_12_B);
            stampa.appendTextOvunque("Scadenze verso Fornitori dal " + dataDA + " al " + dataA, 30, y - 5);
            stampa.setFont(stampa.Font_Calibri_8);
        }
        stampa.appendTextOvunque("TRATTAMENTO ECONOMICO", 165, y + 40);
        y += 50;
    }
}

