/*
 * Decompiled with CFR 0.152.
 */
package gestionale.scadenziario;

import gestionale.scadenziario.Scadenza;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.table.AbstractTableModel;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;

public class ScadenzeCheSaldoTableModel
extends AbstractTableModel {
    Vector cache;
    int colCount;
    String[] headers;
    String tipo_cf;
    boolean modificabile;
    Money totale = new Money(BigDecimal.ZERO);
    Funzioni f = new Funzioni();
    FunzioniDate fda = new FunzioniDate();

    public ScadenzeCheSaldoTableModel(String tipo_cf) {
        this.cache = new Vector();
        this.tipo_cf = tipo_cf;
        this.modificabile = true;
    }

    public ScadenzeCheSaldoTableModel() {
        this.cache = new Vector();
        this.modificabile = true;
    }

    public String getTipo_cf() {
        return this.tipo_cf;
    }

    public void setTipo_cf(String tipo_cf) {
        this.tipo_cf = tipo_cf;
    }

    public boolean isModificabile() {
        return this.modificabile;
    }

    public void setModificabile(boolean modificabile) {
        this.modificabile = modificabile;
    }

    @Override
    public String getColumnName(int i) {
        String retVal = "";
        switch (i) {
            case 1: {
                retVal = "Codice C/F";
                break;
            }
            case 0: {
                retVal = "Data Scadenza";
                break;
            }
            case 2: {
                retVal = "Ragione Sociale";
                break;
            }
            case 3: {
                retVal = "Segno";
                break;
            }
            case 4: {
                retVal = "Da Saldare";
                break;
            }
            case 5: {
                retVal = "Tot che saldo";
                break;
            }
            case 6: {
                retVal = "Elimina Riga";
                break;
            }
            default: {
                retVal = this.headers[i];
            }
        }
        return retVal;
    }

    @Override
    public int getRowCount() {
        return this.cache.size();
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public Object getValueAt(int row, int col) {
        try {
            Scadenza s = new Scadenza();
            if (!this.cache.isEmpty()) {
                s = (Scadenza)this.cache.elementAt(row);
                return s.getColValueDaSaldare(col);
            }
            return "";
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE:  eccezione getColValueDaSaldare con col=" + col);
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
            return "";
        }
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Scadenza s = new Scadenza();
        s = (Scadenza)this.cache.elementAt(row);
        if (col == 5) {
            s.setTot_che_saldo(new Money(value.toString()));
            s.setImporto_saldato(s.getImporto_saldato_old().plus(s.getTot_che_saldo()));
        }
        this.fireTableRowsUpdated(row, row);
    }

    public Class getColumnClass(int c) {
        try {
            return this.getValueAt(0, c).getClass();
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE:  eccezione getColumnClass con c=" + c);
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
            return JLabel.class;
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 5 || col == 6;
    }

    public void setDataScadenzaRiga(Vector vettoreP) {
        try {
            this.cache = new Vector();
            Iterator i = vettoreP.iterator();
            while (i.hasNext()) {
                this.cache.addElement(i.next());
            }
            this.fireTableChanged(null);
        }
        catch (Exception err) {
            MyTrace.log.severe("ECCEZIONE indice fuori campo massimo");
            err.printStackTrace();
            Funzioni.inviaBugPerEmail(err);
            Funzioni.LogStackTrace(err);
        }
    }
}

