/*
 * Decompiled with CFR 0.152.
 */
package gestionale.scadenziario;

import gestionale.scadenziario.Scadenza;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;

public class ScadenzeAperteTableModel
extends AbstractTableModel {
    Vector cache;
    int colCount;
    String[] headers;
    String tipo_cf;
    boolean modificabile;
    Money totale = new Money(BigDecimal.ZERO);
    Funzioni f = new Funzioni();
    FunzioniDate fda = new FunzioniDate();

    public ScadenzeAperteTableModel(String tipo_cf) {
        this.cache = new Vector();
        this.tipo_cf = tipo_cf;
        this.modificabile = true;
    }

    public ScadenzeAperteTableModel() {
        this.cache = new Vector();
        this.modificabile = true;
    }

    public String getTipo_cf() {
        return this.tipo_cf;
    }

    public void setTipo_cf(String tipo_cf) {
        this.tipo_cf = tipo_cf;
    }

    public boolean isModificabile() {
        return this.modificabile;
    }

    public void setModificabile(boolean modificabile) {
        this.modificabile = modificabile;
    }

    @Override
    public String getColumnName(int i) {
        String retVal = "";
        switch (i) {
            case 0: {
                retVal = "Sel";
                break;
            }
            case 1: {
                retVal = "Data Scadenza";
                break;
            }
            case 2: {
                retVal = "Codice C/F";
                break;
            }
            case 3: {
                retVal = "Ragione Sociale";
                break;
            }
            case 4: {
                retVal = " Num. Doc.";
                break;
            }
            case 5: {
                retVal = "Segno";
                break;
            }
            case 6: {
                retVal = "Da Saldare";
                break;
            }
            default: {
                retVal = this.headers[i];
            }
        }
        return retVal;
    }

    @Override
    public int getRowCount() {
        return this.cache.size();
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public Object getValueAt(int row, int col) {
        try {
            Scadenza s = new Scadenza();
            if (!this.cache.isEmpty()) {
                s = (Scadenza)this.cache.elementAt(row);
                return s.getColValueAperte(col);
            }
            return "";
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE:  eccezione getValueAt con roe=" + row + " col=" + col);
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
            return "";
        }
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Scadenza s = new Scadenza();
        s = (Scadenza)this.cache.elementAt(row);
        if (col == 0) {
            if ((Boolean)value == Boolean.TRUE) {
                s.setSel(true);
            } else {
                s.setSel(false);
            }
        }
        this.fireTableRowsUpdated(row, row);
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 0;
    }

    public void setDataScadenzaRiga(Vector vettoreP) {
        try {
            this.cache = new Vector();
            Iterator i = vettoreP.iterator();
            while (i.hasNext()) {
                this.cache.addElement(i.next());
            }
            this.fireTableChanged(null);
        }
        catch (Exception err) {
            MyTrace.log.severe("ECCEZIONE indice fuori campo massimo");
            err.printStackTrace();
            Funzioni.inviaBugPerEmail(err);
            Funzioni.LogStackTrace(err);
        }
    }
}

