/*
 * Decompiled with CFR 0.152.
 */
package gestionale.scadenziario;

import anagrafiche.clienti_fornitori.Anagrafica;
import gestionale.MyDesktopWindow;
import gestionale.configurazioni.Configurazioni;
import gestionale.primanota.InsiemePartite;
import gestionale.primanota.Registrazione;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;

public class Scadenza {
    private int id;
    private int id_partita_c;
    private int id_registro;
    private int pagato;
    private int id_anag_cf;
    private int segno;
    private int id_partita_s;
    private String data_scadenza;
    private String note;
    private String modo_pagamento;
    private String tipo_a_cf;
    private String tipo_partita;
    private String a_ragione_sociale;
    private String a_codice_cf;
    private String descrizione_cc;
    private String num_doc;
    private String num_reg;
    private String data_doc;
    private String data_reg;
    private Money importo = new Money(BigDecimal.ZERO);
    private Money percentuale_imponibile = new Money(BigDecimal.ZERO);
    private Money percentuale_imposta = new Money(BigDecimal.ZERO);
    private Money importo_saldato = new Money(BigDecimal.ZERO);
    private Money importo_doc = new Money(BigDecimal.ZERO);
    private Money importo_saldato_old = new Money(BigDecimal.ZERO);
    private Money tot_che_saldo = new Money(BigDecimal.ZERO);
    private Anagrafica anag_cf;
    private FunzioniDate fda = new FunzioniDate();
    private Funzioni ff = new Funzioni();
    private boolean sel;
    private boolean da_eliminare = false;
    private boolean sel_per_stampa = true;
    private InsiemePartite i_partite_saldo;
    private Registrazione r;
    private String codice_cc;
    private String data_reg_saldo;
    private String data_doc_saldo;

    public String getData_scadenza() {
        return this.data_scadenza;
    }

    public void setData_scadenza(String data_scadenza) {
        this.data_scadenza = data_scadenza;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public int getId_partita_c() {
        return this.id_partita_c;
    }

    public void setId_partita_c(int id_partita_c) {
        this.id_partita_c = id_partita_c;
    }

    public int getId_registro() {
        return this.id_registro;
    }

    public String getModo_pagamento() {
        return this.modo_pagamento;
    }

    public void setModo_pagamento(String modo_pagamento) {
        this.modo_pagamento = modo_pagamento;
    }

    public void setId_registro(int id_registro) {
        this.id_registro = id_registro;
    }

    public Money getImporto() {
        return this.importo;
    }

    public void setImporto(Money importo) {
        this.importo = importo;
    }

    public Money getImporto_saldato() {
        return this.importo_saldato;
    }

    public void setImporto_saldato(Money importo_saldato) {
        this.importo_saldato = importo_saldato;
    }

    public Money getPercentuale_imponibile() {
        return this.percentuale_imponibile;
    }

    public void setPercentuale_imponibile(Money percentuale_imponibile) {
        this.percentuale_imponibile = percentuale_imponibile;
    }

    public Money getPercentuale_imposta() {
        return this.percentuale_imposta;
    }

    public void setPercentuale_imposta(Money percentuale_imposta) {
        this.percentuale_imposta = percentuale_imposta;
    }

    public int getPagato() {
        return this.pagato;
    }

    public void setPagato(int pagato) {
        this.pagato = pagato;
    }

    public String getData_scadenza_it() {
        return this.fda.gira_data(this.data_scadenza);
    }

    public int getSegno() {
        return this.segno;
    }

    public void setSegno(int segno) {
        this.segno = segno;
    }

    public String getTipo_partita() {
        return this.tipo_partita;
    }

    public void setTipo_partita(String tipo_partita) {
        this.tipo_partita = tipo_partita;
    }

    public Money getTot_che_saldo() {
        return this.tot_che_saldo;
    }

    public void setTot_che_saldo(Money tot_che_saldo) {
        this.tot_che_saldo = tot_che_saldo;
    }

    public boolean isDa_eliminare() {
        return this.da_eliminare;
    }

    public void setDa_eliminare(boolean da_eliminare) {
        this.da_eliminare = da_eliminare;
    }

    public boolean isSel() {
        return this.sel;
    }

    public void setSel(boolean sel) {
        this.sel = sel;
    }

    public Money getImporto_saldato_old() {
        return this.importo_saldato_old;
    }

    public void setImporto_saldato_old(Money importo_saldato_old) {
        this.importo_saldato_old = importo_saldato_old;
    }

    public InsiemePartite getI_partite_saldo() {
        return this.i_partite_saldo;
    }

    public void setI_partite_saldo(InsiemePartite i_partite_saldo) {
        this.i_partite_saldo = i_partite_saldo;
    }

    public String getCodice_cc() {
        return this.codice_cc;
    }

    public void setCodice_cc(String codice_cc) {
        this.codice_cc = codice_cc;
    }

    public String getData_doc() {
        return this.data_doc;
    }

    public void setData_doc(String data_doc) {
        this.data_doc = data_doc;
    }

    public String getData_registrazione() {
        return this.data_reg;
    }

    public void setData_registrazione(String data_reg) {
        this.data_reg = data_reg;
    }

    public String getDescrizione_cc() {
        return this.descrizione_cc;
    }

    public void setDescrizione_cc(String descrizione_cc) {
        this.descrizione_cc = descrizione_cc;
    }

    public Money getImporto_doc() {
        return this.importo_doc;
    }

    public void setImporto_doc(Money importo_doc) {
        this.importo_doc = importo_doc;
    }

    public String getNum_doc() {
        return this.num_doc;
    }

    public void setNum_doc(String num_doc) {
        this.num_doc = num_doc;
    }

    public String getNum_reg() {
        return this.num_reg;
    }

    public void setNum_reg(String num_reg) {
        this.num_reg = num_reg;
    }

    public Registrazione getR() {
        return this.r;
    }

    public void setR(Registrazione r) {
        this.r = r;
    }

    public boolean isSel_per_stampa() {
        return this.sel_per_stampa;
    }

    public void setSel_per_stampa(boolean sel_per_stampa) {
        this.sel_per_stampa = sel_per_stampa;
    }

    public String getA_codice_cf() {
        return this.a_codice_cf;
    }

    public void setA_codice_cf(String a_codice_cf) {
        this.a_codice_cf = a_codice_cf;
    }

    public String getA_ragione_sociale() {
        return this.a_ragione_sociale;
    }

    public void setA_ragione_sociale(String a_ragione_sociale) {
        this.a_ragione_sociale = a_ragione_sociale;
    }

    public Anagrafica getAnag_cf() {
        return this.anag_cf;
    }

    public void setAnag_cf(Anagrafica anag_cf) {
        this.anag_cf = anag_cf;
    }

    public int getId_anag_cf() {
        return this.id_anag_cf;
    }

    public void setId_anag_cf(int id_anag_cf) {
        this.id_anag_cf = id_anag_cf;
    }

    public String getTipo_a_cf() {
        return this.tipo_a_cf;
    }

    public void setTipo_a_cf(String tipo_a_cf) {
        this.tipo_a_cf = tipo_a_cf;
    }

    public String getData_reg_saldo() {
        return this.data_reg_saldo;
    }

    public void setData_reg_saldo(String data_reg_saldo) {
        this.data_reg_saldo = data_reg_saldo;
    }

    public String getData_doc_saldo() {
        return this.data_doc_saldo;
    }

    public void setData_doc_saldo(String data_doc_saldo) {
        this.data_doc_saldo = data_doc_saldo;
    }

    public int getId_partita_s() {
        return this.id_partita_s;
    }

    public void setId_partita_s(int id_partita_s) {
        this.id_partita_s = id_partita_s;
    }

    public boolean inserisciScadenza(boolean da_solo) {
        String query_ins;
        boolean r_ins;
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(r_ins = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_ins = "INSERT INTO scadenziario(data_scadenza,id_registro,importo,note,percentuale_imponibile,percentuale_imposta,pagato,importo_saldato,id_partita_c) VALUES ('" + this.getData_scadenza() + "'," + this.getId_registro() + ",'" + this.getImporto() + "'," + "'" + this.getNote().replaceAll("'", "''") + "'," + "'" + this.getPercentuale_imponibile() + "','" + this.getPercentuale_imposta() + "','" + this.getPagato() + "'," + "'" + this.getImporto_saldato() + "','" + this.getId_partita_c() + "')"))) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Inserimento Scadenza non riuscito");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        this.setId(Configurazioni.getIstanza().connessione.id_inserito("scadenziario"));
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','scadenziario','" + this.getId() + "',NOW(),'INS','" + query_ins.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Inserimento scadenza non riuscito per trace");
            Configurazioni.eccezione.gestisci("2.3", null);
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    public boolean modificaScadenza(boolean da_solo) {
        String query_mod;
        boolean r_mod;
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod = "UPDATE scadenziario  SET data_scadenza='" + this.getData_scadenza() + "', " + "note='" + this.getNote().replaceAll("'", "''") + "'," + "importo='" + this.getImporto() + "'," + "percentuale_imponibile='" + this.getPercentuale_imponibile() + "'," + "percentuale_imposta='" + this.getPercentuale_imposta() + "'," + "importo_saldato='" + this.getImporto_saldato() + "'," + "pagato='" + this.getPagato() + "'" + " WHERE idscadenziario='" + this.getId() + "'"))) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Modifica Scadenziario non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','scadenziario','" + this.getId() + "',NOW(),'MOD','" + query_mod.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Modifica Scadenze non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.3", null);
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    public boolean saldaScadenza(boolean da_solo) {
        String q_rif;
        boolean r_rif;
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(r_rif = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_rif = "INSERT into scadenze_partite_rif(id_scadenza,id_partita_saldo) VALUES (" + this.getId() + "," + this.getId_partita_s() + ") "))) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Inserimento scadenza_partite_rif  non riuscito");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        this.calcola_importo_saldato();
        if (this.getImporto().eq(this.getImporto_saldato())) {
            this.setPagato(1);
        } else {
            this.setPagato(0);
        }
        String query_mod = "UPDATE  scadenziario  SET  pagato='" + this.getPagato() + "'," + " importo_saldato=" + this.getImporto_saldato() + " " + " WHERE idscadenziario='" + this.getId() + "'";
        boolean r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod);
        if (!r_mod) {
            MyTrace.log.severe("Modifica  scadenziario  non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','scadenziario','" + this.getId() + "',NOW(),'MOD','" + query_mod.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Modifica  scadenziario non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.3", null);
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    private void calcola_importo_saldato() {
        String query = "SELECT scadenze_partite_rif.id_scadenza, group_concat(id_partita_saldo separator ','), SUM(partite.importo) as saldato,scadenziario.importo_saldato,scadenziario.pagato FROM scadenze_partite_rif  left join partite on scadenze_partite_rif.id_partita_saldo=partite.idpartite  left join scadenziario on scadenze_partite_rif.id_scadenza=scadenziario.idscadenziario  WHERE id_scadenza=" + this.getId() + " " + " group by id_scadenza";
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
        this.setImporto_saldato(new Money(BigDecimal.ZERO));
        try {
            while (res.next()) {
                this.setImporto_saldato(new Money(res.getDouble("saldato")));
            }
        }
        catch (SQLException ex) {
            MyTrace.log.severe("Data registrazione saldo non ottenuta " + ex);
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
    }

    public boolean dissaldaScadenza(boolean da_solo) {
        String q_rif;
        boolean r_rif;
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(r_rif = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_rif = "DELETE FROM scadenze_partite_rif  WHERE id_scadenza=" + this.getId() + " AND id_partita_saldo=" + this.getId_partita_s() + " "))) {
            MyTrace.log.severe("Modifica  scadenza  non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        this.calcola_importo_saldato();
        String query_mod = "UPDATE  scadenziario  SET  pagato=0, importo_saldato=" + this.getImporto_saldato() + " " + " WHERE idscadenziario=" + this.getId() + " ";
        boolean r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod);
        if (!r_mod) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Inserimento partita non riuscito");
            Configurazioni.eccezione.gestisci("2.2", null);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','scadenziario','" + this.getId() + "',NOW(),'MOD','" + query_mod.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Modifica  scadenziario non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.3", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    public void seleziona_partite_di_saldo() {
        String where = " where scadenze_partite_rif.id_scadenza=" + this.getId();
        this.setI_partite_saldo(new InsiemePartite());
        this.getI_partite_saldo().caricamento_semplice(where, "");
    }

    public void seleziona_scadenza_saldata(String where) {
        String query_cerca_data = "select scadenze_partite_rif.*,  scadenziario.data_scadenza, scadenziario.importo_saldato, scadenziario.importo, scadenziario.id_partita_c, anag_anagrafica.idanagrafica,  anag_anagrafica.codice as codice_cf,  anag_anagrafica.tipo_anag,  anag_anagrafica.ragione_sociale,  partita_scadenza.segno as segno_scadenza, partita_di_saldo.importo as importo_partita_saldo,  registro_saldo.data_reg , registro_saldo.data_doc  from scadenze_partite_rif left join partite as partita_di_saldo on scadenze_partite_rif.id_partita_saldo=partita_di_saldo.idpartite  left join registro as registro_saldo on partita_di_saldo.id_registro=registro_saldo.idregistro  left join scadenziario on scadenziario.idScadenziario=scadenze_partite_rif.id_scadenza  left join registro as registro_scadenza on scadenziario.id_registro=registro_scadenza.idregistro  left join anag_anagrafica on registro_scadenza.id_anagrafica=anag_anagrafica.idanagrafica  left join partite as partita_scadenza on scadenziario.id_partita_c=partita_scadenza.idpartite ";
        query_cerca_data = query_cerca_data + " " + where;
        ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query_cerca_data);
        try {
            while (res.next()) {
                this.setId(res.getInt("id_scadenza"));
                this.setData_scadenza(res.getString("data_scadenza"));
                this.setId_anag_cf(res.getInt("idanagrafica"));
                this.setA_ragione_sociale(res.getString("ragione_sociale"));
                this.setA_codice_cf(res.getString("codice_cf"));
                this.setTipo_a_cf(res.getString("tipo_anag"));
                this.setData_reg_saldo(res.getString("data_reg"));
                this.setData_doc_saldo(res.getString("data_doc"));
                this.setSegno(res.getInt("segno_scadenza"));
                this.setImporto(new Money(res.getDouble("importo")));
                this.setImporto_saldato(new Money(res.getDouble("importo_saldato")));
                this.setImporto_saldato_old(new Money(res.getDouble("importo_saldato")));
                this.setTot_che_saldo(new Money(res.getDouble("importo_partita_saldo")));
                this.setId_partita_s(res.getInt("id_partita_saldo"));
                this.setId_partita_c(res.getInt("id_partita_c"));
            }
        }
        catch (SQLException ex) {
            MyTrace.log.severe("Data registrazione saldo non ottenuta " + ex);
        }
        Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
    }

    public void seleziona_dettagliRegistro() {
        this.setR(new Registrazione());
        this.getR().setIdregistro(this.getId_registro());
        this.getR().seleziona(this.getId_registro());
    }

    public boolean eliminaScadenza(boolean da_solo) {
        String query_del;
        boolean r_del;
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(r_del = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_del = "DELETE from scadenziario WHERE idscadenziario='" + this.getId() + "'"))) {
            Configurazioni.getIstanza().connessione.rollback();
            MyTrace.log.severe("Elimina  Scadenza non riuscita");
            Configurazioni.eccezione.gestisci("3.5", null);
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','scadenziario','" + this.getId() + "',NOW(),'DEL','" + query_del.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Elimina  scadenza non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.6", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    Object getColValue(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                retVal = this.getData_scadenza_it();
                break;
            }
            case 1: {
                retVal = this.ff.formattaNumero("" + this.getPercentuale_imponibile());
                break;
            }
            case 2: {
                retVal = this.ff.formattaNumero("" + this.getPercentuale_imposta());
                break;
            }
            case 3: {
                retVal = "" + this.getImporto();
                break;
            }
            case 4: {
                retVal = "" + this.getImporto_saldato();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }

    Object getColValueAperte(int col) {
        String retVal = "";
        try {
            switch (col) {
                case 0: {
                    if (this.isSel()) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
                case 1: {
                    retVal = this.getData_scadenza_it();
                    break;
                }
                case 2: {
                    retVal = this.getTipo_a_cf() + this.getA_codice_cf();
                    break;
                }
                case 3: {
                    retVal = this.getA_ragione_sociale();
                    break;
                }
                case 4: {
                    retVal = this.getNum_doc();
                    break;
                }
                case 5: {
                    retVal = this.ff.string_segno(this.getSegno(), 0);
                    break;
                }
                case 6: {
                    retVal = "" + this.getImporto().minus(this.getImporto_saldato());
                    break;
                }
                case 7: {
                    retVal = "" + this.getTot_che_saldo();
                    break;
                }
                default: {
                    retVal = "";
                    break;
                }
            }
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE:  eccezione getColValueAperte con col=" + col);
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
        return retVal;
    }

    Object getColValueDaSaldare(int col) {
        String retVal = "";
        try {
            switch (col) {
                case 6: {
                    if (this.isSel()) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
                case 0: {
                    retVal = this.getData_scadenza_it();
                    break;
                }
                case 1: {
                    if (this.getTipo_a_cf().equals("F") || this.getTipo_a_cf().equals("C")) {
                        retVal = this.getTipo_a_cf() + this.getA_codice_cf();
                        break;
                    }
                    retVal = "";
                    break;
                }
                case 2: {
                    retVal = this.getA_ragione_sociale();
                    break;
                }
                case 3: {
                    retVal = this.ff.string_segno(this.getSegno(), 0);
                    break;
                }
                case 4: {
                    retVal = "" + this.getImporto().minus(this.getImporto_saldato());
                    break;
                }
                case 5: {
                    retVal = "" + this.getTot_che_saldo();
                    break;
                }
                default: {
                    retVal = "";
                    break;
                }
            }
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE:  eccezione getColValueDaSaldare con col=" + col);
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
        return retVal;
    }

    public Object getColValueFiltrate(int col) {
        String retVal = "";
        String codice = "";
        String ragioneSociale = "";
        switch (col) {
            case 0: {
                retVal = "" + this.getNum_reg();
                break;
            }
            case 1: {
                retVal = "" + this.getNum_doc();
                break;
            }
            case 2: {
                retVal = "" + this.fda.gira_data(this.getData_doc());
                break;
            }
            case 3: {
                retVal = this.getDescrizione_cc();
                break;
            }
            case 4: {
                if (this.getSegno() == 1) {
                    retVal = this.ff.formattaNumero("" + this.getImporto());
                    break;
                }
                retVal = "";
                break;
            }
            case 5: {
                if (this.getSegno() == 2) {
                    retVal = this.ff.formattaNumero("" + this.getImporto());
                    break;
                }
                retVal = "";
                break;
            }
            case 6: {
                retVal = this.ff.formattaNumero("" + this.getImporto_doc());
                break;
            }
            case 7: {
                retVal = "" + this.getImporto_saldato();
                break;
            }
            case 8: {
                retVal = "" + this.getData_scadenza_it();
                break;
            }
            case 9: {
                if (!this.getTipo_a_cf().equals("C") && !this.getTipo_a_cf().equals("F")) break;
                retVal = this.getTipo_a_cf() + this.getA_codice_cf() + " - " + this.getA_ragione_sociale();
                break;
            }
            case 10: {
                if (this.getPagato() == 1) {
                    retVal = this.fda.gira_data("" + this.getData_doc_saldo());
                }
                if (this.getPagato() != 0) break;
                if (this.getImporto_saldato().isZero()) {
                    retVal = "";
                    break;
                }
                retVal = "Saldato in parte";
                break;
            }
            case 11: {
                return this.isSel_per_stampa();
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }

    void verificaMoney() {
        try {
            if (this.importo.validateState() != 0) {
                MyTrace.log.info("ANOMALIA IN SCADENZA DEL =" + this.data_scadenza + " CON importo =" + this.importo.toString());
            }
            if (this.importo_doc.validateState() != 0) {
                MyTrace.log.info("ANOMALIA IN SCADENZA DEL =" + this.data_scadenza + " CON importo_doc =" + this.importo_doc.toString());
            }
            if (this.importo_saldato.validateState() != 0) {
                MyTrace.log.info("ANOMALIA IN SCADENZA DEL =" + this.data_scadenza + " CON importo_saldato =" + this.importo_saldato.toString());
            }
            if (this.percentuale_imponibile.validateState() != 0) {
                MyTrace.log.info("ANOMALIA IN SCADENZA DEL =" + this.data_scadenza + " CON percentuale_imponibile =" + this.percentuale_imponibile.toString());
            }
            if (this.percentuale_imposta.validateState() != 0) {
                MyTrace.log.info("ANOMALIA IN SCADENZA DEL =" + this.data_scadenza + " CON percentuale_imposta =" + this.percentuale_imposta.toString());
            }
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE:  eccezione verificaMoney() errore nella verifica della scadenza");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE: verificaMoney() errore di avvio o di linkaggio nella verifica della scadenza");
            err.printStackTrace();
        }
    }
}

