/*
 * Decompiled with CFR 0.152.
 */
package gestionale.scadenziario;

import gestionale.configurazioni.Configurazioni;
import gestionale.scadenziario.ConfigurazioneSollecito;
import gestionale.scadenziario.Scadenza;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Vector;
import utils.Funzioni;
import utils.Money;
import utils.MyTrace;
import utils.Performance;

public class InsiemeConfigurazioniSollecito {
    public Vector vettoreCS;
    int colCount;
    public String[] headers;
    public Money totale_importo = new Money(BigDecimal.ZERO);
    public Money totale_scadenze = new Money(BigDecimal.ZERO);

    public InsiemeConfigurazioniSollecito() {
        this.vettoreCS = new Vector();
    }

    public int caricamento(String where, String order_by) {
        Performance perf = new Performance("CARICA SCADENZIARIO");
        this.vettoreCS = new Vector();
        String query = "SELECT * FROM conf_sollecito";
        query = query + " " + where;
        query = query + " " + order_by;
        try {
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
            while (res.next()) {
                ConfigurazioneSollecito s = new ConfigurazioneSollecito();
                s.setIdconf_sollecito(res.getInt("idconf_sollecito"));
                s.setNome_sollecito(res.getString("nome_sollecito"));
                s.setTesto_sollecito(res.getString("testo_sollecito"));
                this.vettoreCS.addElement(s);
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        }
        catch (Exception e) {
            this.vettoreCS = new Vector();
            MyTrace.log.severe("Seleziona Testo sollecito non riuscito");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.2", null);
        }
        System.out.println("La dimenzione \u00e8 " + this.vettoreCS.size());
        perf.fine();
        return this.vettoreCS.size();
    }

    public int caricamento_filtrato(String where, String order_by) {
        this.vettoreCS = new Vector();
        this.totale_importo = new Money(BigDecimal.ZERO);
        this.totale_scadenze = new Money(BigDecimal.ZERO);
        String query = "select scadenziario.*,  registro.*,  conf_causale_contabile.*, anag_anagrafica.idanagrafica,  anag_anagrafica.codice as codice_cf,  anag_anagrafica.ragione_sociale  from scadenziario  left join registro on scadenziario.id_registro=registro.idregistro  left join anag_anagrafica on registro.id_anagrafica=anag_anagrafica.idanagrafica  left join conf_causale_contabile on registro.id_causale_contabile= conf_causale_contabile.idcausale_contabile ";
        query = query + " " + where;
        query = query + " " + order_by;
        try {
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
            while (res.next()) {
                Scadenza s = new Scadenza();
                s.setId(res.getInt("idscadenziario"));
                s.setId_registro(res.getInt("id_registro"));
                s.setData_scadenza(res.getString("data_scadenza"));
                s.setImporto(new Money(res.getDouble("importo")));
                s.setPercentuale_imponibile(new Money(res.getDouble("percentuale_imponibile")));
                s.setPercentuale_imposta(new Money(res.getDouble("percentuale_imposta")));
                s.setImporto_saldato(new Money(res.getDouble("importo_saldato")));
                s.setId_partita_c(res.getInt("id_partita_c"));
                s.setNote(res.getString("note"));
                s.setPagato(res.getInt("pagato"));
                s.setTipo_a_cf(res.getString("tipo_cf"));
                s.setDescrizione_cc(res.getString("descrizione"));
                s.setNum_doc(res.getString("num_doc"));
                s.setNum_reg(res.getString("num_reg"));
                s.setData_doc(res.getString("data_doc"));
                s.setImporto_doc(new Money(res.getDouble("importo_doc")));
                s.setSel_per_stampa(false);
                if (s.getPagato() == 0) {
                    this.totale_importo = this.totale_importo.plus(new Money(s.getImporto_doc()));
                    this.totale_scadenze = this.totale_scadenze.plus(new Money(s.getImporto()));
                }
                s.setId_anag_cf(res.getInt("idanagrafica"));
                s.setA_codice_cf(res.getString("codice_cf"));
                s.setA_ragione_sociale(res.getString("ragione_sociale"));
                s.verificaMoney();
                this.vettoreCS.addElement(s);
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        }
        catch (Exception e) {
            this.vettoreCS = new Vector();
            MyTrace.log.severe("Seleziona scadenze non riuscito");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.2", null);
        }
        return this.vettoreCS.size();
    }
}

