/*
 * Decompiled with CFR 0.152.
 */
package gestionale.primanota;

import gestionale.configurazioni.Configurazioni;
import gestionale.personalizzazione.stampe.IntestazioneInterrogazioneConti;
import gestionale.personalizzazione.stampe.PiedePaginaGenericoIntestato;
import gestionale.primanota.InsiemeInterrogazioneConti;
import gestionale.primanota.PNRiga;
import gestionale.primanota.Registrazione;
import java.awt.Color;
import utils.BannerWorking;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.MyTrace;
import utils.stampe.GestoreStampe;
import utils.stampe.OggettoToPrint;

public class StampaInterrogazioneConti
implements Runnable {
    FunzioniDate fda;
    Funzioni f;
    InsiemeInterrogazioneConti insieme_c;
    Thread thread;
    String codice_conto;
    String data_docDA;
    String data_docA;
    String data_regDA;
    String data_regA;
    String causale_contabile;
    String descrizione_conto;
    Color colore = new Color(220, 220, 220);

    public StampaInterrogazioneConti(InsiemeInterrogazioneConti insieme_c, String codice_conto, String data_docDA, String data_docA, String data_regDA, String data_regA, String causale_contabile, String descrizione_conto) {
        this.fda = new FunzioniDate();
        this.f = new Funzioni();
        this.insieme_c = insieme_c;
        this.causale_contabile = causale_contabile;
        this.codice_conto = codice_conto;
        this.data_docA = data_docA;
        this.data_docDA = data_docDA;
        this.data_regA = data_regA;
        this.data_regDA = data_regDA;
        this.descrizione_conto = descrizione_conto;
    }

    public void avvia() {
        this.thread = new Thread(this);
        MyTrace.log.info("avvio Procedura su Thread");
        this.thread.start();
    }

    public boolean elabora() {
        Configurazioni.getIstanza();
        int y_inizio = Configurazioni.inizio_stampe;
        MyTrace.log.info(" XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX STAMPA INTERROGAZINE CONTI INIZIO XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        long tempo_di_visualizzazione = System.currentTimeMillis();
        int id_precedente = 0;
        GestoreStampe stampa = new GestoreStampe();
        stampa.aggiungi_pj();
        double tot_dare = 0.0;
        double tot_avere = 0.0;
        stampa.setInt((OggettoToPrint)new IntestazioneInterrogazioneConti());
        stampa.setIntPP((OggettoToPrint)new IntestazioneInterrogazioneConti());
        stampa.setPiedePaginaGenericoIntestato((OggettoToPrint)new PiedePaginaGenericoIntestato("Conti"));
        int y = y_inizio - 10;
        this.intestazione_tabella_conti(stampa, 20, y, this.data_docDA, this.data_docA, this.codice_conto, this.descrizione_conto);
        y = y_inizio + 50;
        for (PNRiga pnr : this.insieme_c.vettoreP) {
            int id_registro = pnr.getId_registro();
            if (id_registro == id_precedente) continue;
            id_precedente = id_registro;
            if (y > 720) {
                stampa.paginanuova();
                y = y_inizio - 10;
                this.intestazione_tabella_conti(stampa, 20, y, this.data_docDA, this.data_docA, this.codice_conto, this.descrizione_conto);
                y = y_inizio + 50;
            }
            stampa.appendRect(20, y, 555, 20, this.colore);
            stampa.setFont(stampa.Font_Calibri_7);
            stampa.appendTextOvunque(pnr.getData_doc_it(), 23, y + 8);
            stampa.appendTestoDimensionePosizione(pnr.getDescrizione(), 70, y + 8, 150);
            if (pnr.getSegno() == 1) {
                stampa.appendStringaOvunqueFormattazioneDestra("" + pnr.getImporto(), 235, y + 8, 45);
                tot_dare += pnr.getImporto().getDoubleValue();
            }
            if (pnr.getSegno() == 2) {
                stampa.appendStringaOvunqueFormattazioneDestra("" + pnr.getImporto(), 280, y + 8, 45);
                tot_avere += pnr.getImporto().getDoubleValue();
            }
            stampa.appendTextOvunque(pnr.getDescrizione_cc(), 345, y + 8);
            Registrazione r = new Registrazione();
            r.seleziona(pnr.getId_registro());
            stampa.appendStringaOvunqueFormattazioneDestra("" + r.getNum_reg() + "/" + r.getAnno_reg(), 445, y + 8, 45);
            if (pnr.getDocumento() != null && !pnr.getDocumento().equals("") && !pnr.getDocumento().equals("null")) {
                stampa.appendTextOvunque("" + pnr.getDocumento() + "/" + this.fda.anno(pnr.getData_doc()), 490, y + 8);
            }
            y += 20;
        }
        double totale_saldo = tot_dare - tot_avere;
        stampa.setFont(stampa.Font_Arial_8_B);
        stampa.appendStringaOvunqueFormattazioneDestra(this.f.formattaNumero("" + tot_dare), 235, y + 20, 45);
        stampa.appendStringaOvunqueFormattazioneDestra(this.f.formattaNumero("" + tot_avere), 280, y + 20, 45);
        stampa.appendTextOvunque("SALDO: " + this.f.formattaNumero("" + totale_saldo), 350, y + 20);
        stampa.appendLine(20, y + 5, 550, y + 5, Color.green);
        stampa.appendLine(20, y + 30, 550, y + 30, Color.green);
        String data_now = this.fda.dataCorrente();
        String ora_now = this.fda.OraCorrente();
        stampa.getSeg().getMy_pj_corrente().getPj().setJobName(data_now.replaceAll("-", "") + ora_now.replaceAll(":", "") + "_Estratto_Conto_" + this.codice_conto.replaceAll(" ", "") + "_" + this.descrizione_conto.replaceAll("/", "").replaceAll(" ", "") + "_dal_" + this.data_docDA + "_al_" + this.data_docA);
        MyTrace.log.info(" PERFORMANCE: Tempo di Elaborazione =" + (System.currentTimeMillis() - tempo_di_visualizzazione) + " millisecondi");
        stampa.print();
        MyTrace.log.info(" XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX STAMPA INTERROGAZIONE CONTI FINE XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        MyTrace.log.info(" PERFORMANCE: Tempo Totale compresa la stampa =" + (System.currentTimeMillis() - tempo_di_visualizzazione) + " millisecondi");
        return true;
    }

    public void intestazione_tabella_conti(GestoreStampe stampa, int x, int y, String data_docDA, String data_docA, String codice, String descrizione) {
        stampa.appendRoundRect(x, y, 555, 50, 10, 10);
        String stringa_intestazione = descrizione;
        stampa.setFont(stampa.Font_Calibri_11_B);
        stampa.appendTextOvunque("Estratto del Conto " + codice, x + 70, y + 15);
        stampa.setFont(stampa.Font_Calibri_8);
        stampa.appendTextOvunque(stringa_intestazione, x + 220, y + 15);
        stampa.setFont(stampa.Font_Calibri_9_B);
        stampa.appendTextOvunque("Dal " + data_docDA + " Al " + data_docA, x + 420, y + 15);
        stampa.appendRoundRect(x + 415, y + 3, 125, 18, 10, 10);
        stampa.appendTextOvunque("DATA", x + 4, y + 35);
        stampa.appendTextOvunque("DESCR. MOVIMENTO", x + 55, y + 35);
        stampa.appendTextOvunque("DARE", x + 235, y + 35);
        stampa.appendTextOvunque("AVERE", x + 280, y + 35);
        stampa.appendTextOvunque("CAUSALE CONTABILE", x + 325, y + 35);
        stampa.appendTextOvunque("Nr. REG.", x + 445, y + 35);
        stampa.appendTextOvunque("Nr. DOC.", x + 490, y + 35);
        y += 50;
    }

    @Override
    public void run() {
        BannerWorking attesa = new BannerWorking("ELABORAZIONE SU THREAD INTERROGAZIONE CONTI");
        attesa.start();
        this.elabora();
        attesa.stop();
    }
}

