/*
 * Decompiled with CFR 0.152.
 */
package gestionale.primanota;

import gestionale.primanota.Registrazione;
import gestionale.primanota.RegistrazioniTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import utils.Funzioni;
import utils.MyTrace;

public class RegistrazioniTableRenderer
extends DefaultTableCellRenderer {
    private static final Color SELECTED_COLOR = new Color(61, 128, 223);
    private static final Color ALTERNATE_COLOR = new Color(232, 242, 254);
    private static final Color NON_ATTIVE_COLOR = new Color(245, 0, 0);
    private static final Color FV_COLOR = new Color(0, 153, 0);
    private static final Color FA_COLOR = new Color(0, 0, 205);
    private static final Color NCC_COLOR = new Color(204, 0, 204);
    private static final Color NCF_COLOR = new Color(0, 204, 204);
    private boolean in_filter = false;

    public RegistrazioniTableRenderer(boolean in_f) {
        this.in_filter = in_f;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        int modelRow = 1000000000;
        if (this.in_filter) {
            try {
                modelRow = table.convertRowIndexToModel(row);
            }
            catch (Exception err) {
                MyTrace.log.severe("valueChanged() viewrow >=0  ECCEZIONE");
                err.printStackTrace();
                Funzioni.inviaBugPerEmail(err);
                Funzioni.LogStackTrace(err);
            }
        } else {
            modelRow = row;
        }
        Registrazione r = (Registrazione)((RegistrazioniTableModel)table.getModel()).cache.elementAt(modelRow);
        int tipo = r.getId_tipo_modello();
        if (value.getClass() != Boolean.class) {
            JLabel testLabel = new JLabel(value.toString());
            testLabel.setOpaque(true);
            testLabel.setFont(new Font("Tahoma", 0, 12));
            testLabel.setForeground(new Color(0, 0, 102));
            if (tipo == 1 || tipo == 12 || tipo == 13) {
                testLabel.setForeground(FV_COLOR);
            }
            if (tipo == 3) {
                testLabel.setForeground(FA_COLOR);
            }
            if (tipo == 2 || tipo == 14 || tipo == 15) {
                testLabel.setForeground(NCC_COLOR);
            }
            if (tipo == 4) {
                testLabel.setForeground(NCF_COLOR);
            }
            Border paddingBorder = BorderFactory.createEmptyBorder(10, 5, 10, 10);
            testLabel.setBorder(BorderFactory.createCompoundBorder(testLabel.getBorder(), paddingBorder));
            if (col == 6) {
                testLabel.setHorizontalAlignment(4);
            }
            if (isSelected) {
                testLabel.setForeground(Color.WHITE);
                testLabel.setBackground(SELECTED_COLOR);
            } else if (modelRow % 2 == 0) {
                testLabel.setBackground(ALTERNATE_COLOR);
            } else {
                testLabel.setBackground(table.getBackground());
            }
            return testLabel;
        }
        JCheckBox testbox = new JCheckBox();
        if (((Boolean)value).booleanValue()) {
            testbox.setSelected(true);
        }
        testbox.setOpaque(true);
        testbox.setFont(new Font("Tahoma", 0, 12));
        testbox.setForeground(new Color(0, 0, 102));
        Border paddingBorder = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        testbox.setBorder(BorderFactory.createCompoundBorder(testbox.getBorder(), paddingBorder));
        if (isSelected) {
            testbox.setForeground(Color.WHITE);
            testbox.setBackground(SELECTED_COLOR);
        } else {
            testbox.setForeground(table.getForeground());
            if (modelRow % 2 == 0) {
                testbox.setBackground(ALTERNATE_COLOR);
            } else {
                testbox.setBackground(table.getBackground());
            }
        }
        return testbox;
    }
}

