/*
 * Decompiled with CFR 0.152.
 */
package gestionale.primanota;

import gestionale.primanota.PNRiga;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.table.AbstractTableModel;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;

public class PNRigaTableModel
extends AbstractTableModel {
    Vector cache;
    int colCount;
    String[] headers;
    Funzioni f = new Funzioni();
    FunzioniDate fda = new FunzioniDate();

    public PNRigaTableModel() {
        this.cache = new Vector();
    }

    @Override
    public String getColumnName(int i) {
        String retVal = "";
        switch (i) {
            case 0: {
                retVal = "Conto";
                break;
            }
            case 1: {
                retVal = "Descrizione Conto";
                break;
            }
            case 2: {
                retVal = "Segno";
                break;
            }
            case 3: {
                retVal = "Importo";
                break;
            }
            case 4: {
                retVal = "Note";
                break;
            }
            case 5: {
                retVal = "Voce Analisi";
                break;
            }
            case 6: {
                retVal = "Regola";
                break;
            }
            case 7: {
                retVal = "Inizio Competenza";
                break;
            }
            case 8: {
                retVal = "Fine Competenza";
                break;
            }
            default: {
                retVal = this.headers[i];
            }
        }
        return retVal;
    }

    @Override
    public int getRowCount() {
        return this.cache.size();
    }

    @Override
    public int getColumnCount() {
        return 9;
    }

    @Override
    public Object getValueAt(int row, int col) {
        PNRiga pn_riga = new PNRiga();
        if (!this.cache.isEmpty()) {
            pn_riga = (PNRiga)this.cache.elementAt(row);
            return pn_riga.getColValue(col);
        }
        return "";
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        try {
            PNRiga pn_r = new PNRiga();
            pn_r = (PNRiga)this.cache.elementAt(row);
            if (col == 0) {
                pn_r.setId_conto(this.f.id_conto5(value.toString()));
            }
            if (col == 2) {
                pn_r.setSegno(this.f.int_segno(value.toString()));
            }
            if (col == 3) {
                pn_r.setImporto(new Money(value.toString()));
            }
            if (col == 4) {
                pn_r.setNote(value.toString());
            }
            if (col == 5) {
                try {
                    pn_r.setId_vda(this.f.id_vda_da_descrizione("" + value.toString()));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (col == 6) {
                try {
                    pn_r.setId_regola(this.f.id_regola_da_nome("" + value.toString()));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (col == 7) {
                pn_r.setInizio_competenza(this.fda.gira_data(value.toString()));
            }
            if (col == 8) {
                pn_r.setFine_competenza(this.fda.gira_data(value.toString()));
            }
            this.fireTableRowsUpdated(row, row);
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE:  eccezione setValueAt()");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE: setValueAt() ");
            err.printStackTrace();
        }
    }

    public Class getColumnClass(int c) {
        if (c == 2) {
            return JCheckBox.class;
        }
        if (c == 7 || c == 8) {
            return Date.class;
        }
        System.out.println("colonna" + c);
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 0 || col == 2 || col == 3 || col == 4 || col == 5 || col == 6 || col == 7 || col == 8;
    }

    public void setDataPNRiga(Vector vettorePNR) {
        this.cache = new Vector();
        Iterator i = vettorePNR.iterator();
        while (i.hasNext()) {
            this.cache.addElement(i.next());
        }
        this.fireTableChanged(null);
    }
}

