/*
 * Decompiled with CFR 0.152.
 */
package gestionale.primanota;

import gestionale.MyDesktopWindow;
import gestionale.configurazioni.Configurazioni;
import gestionale.iva.Aliquota;
import gestionale.piano_dei_conti.Conto5;
import gestionale.primanota.Registrazione;
import java.math.BigDecimal;
import java.sql.ResultSet;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;

public class PNIva {
    private int id;
    private int id_registro;
    private int segno;
    private int id_aliquota;
    private int id_conto;
    private int mese;
    private int anno;
    private int protocollo_iva;
    private int id_registro_iva;
    private int bloccato = 0;
    private Money imposta = new Money(BigDecimal.ZERO);
    private Money imponibile = new Money(BigDecimal.ZERO);
    private Money imposta_ind = new Money(BigDecimal.ZERO);
    private Money importo_riga = new Money(BigDecimal.ZERO);
    private double imponibileD;
    private double impostaD;
    private String note = "";
    private Aliquota a;
    private Registrazione r;
    private Conto5 c;
    private Funzioni f = new Funzioni();
    private FunzioniDate fda = new FunzioniDate();

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getSegno() {
        return this.segno;
    }

    public void setSegno(int segno) {
        this.segno = segno;
    }

    public int getId_aliquota() {
        return this.id_aliquota;
    }

    public void setId_aliquota(int id_aliquota) {
        this.id_aliquota = id_aliquota;
        this.a = new Aliquota();
        if (id_aliquota != 0) {
            String w = " WHERE idAliquota=" + id_aliquota + " ";
            this.a.seleziona(w);
        } else {
            this.a.setDescrizione("");
            this.a.setAliquota(0.0);
            this.a.setCodice("");
            this.a.setIndetraibilita(0.0);
        }
        if (this.getImporto_riga() != null) {
            this.setImporto_riga(this.getImporto_riga());
        }
    }

    public Aliquota getA() {
        return this.a;
    }

    public int getId_conto() {
        return this.id_conto;
    }

    public void setId_conto(int id_conto) {
        this.id_conto = id_conto;
        this.c = new Conto5();
        if (id_conto != 0) {
            this.c.seleziona(id_conto);
        } else {
            this.c.setDescrizione("");
            this.c.setConto("");
        }
        this.setC(this.c);
    }

    public Conto5 getC() {
        return this.c;
    }

    public void setC(Conto5 c) {
        this.c = c;
    }

    public int getAnno() {
        try {
            return Integer.valueOf(this.fda.anno(this.getR().getData_doc()));
        }
        catch (Exception err) {
            MyTrace.log.severe("main() errore di configurazione del look and feel");
            err.printStackTrace();
            Funzioni.inviaBugPerEmail(err);
            Funzioni.LogStackTrace(err);
            return 0;
        }
    }

    public void setAnno(int anno) {
        this.anno = anno;
    }

    public void setMese(int mese) {
        this.mese = mese;
    }

    public int getId_registro() {
        return this.id_registro;
    }

    public void setId_registro(int id_registro) {
        this.id_registro = id_registro;
    }

    public Money getImporto_riga() {
        return this.importo_riga;
    }

    public void setImporto_riga(Money importo_riga) {
        this.importo_riga = importo_riga;
        double divisore = (100.0 + this.a.getAliquota()) / 100.0;
        importo_riga.div(divisore);
        this.setImponibile(importo_riga.div(divisore));
        this.setImposta(importo_riga.div((100.0 + this.a.getAliquota()) / 100.0).times(this.a.getAliquota() / 100.0));
        this.setImposta_ind(importo_riga.div((100.0 + this.a.getAliquota()) / 100.0).times(this.a.getIndetraibilita() / 100.0 * (this.a.getAliquota() / 100.0)));
    }

    public Money getImponibile() {
        return this.imponibile;
    }

    public void setImponibile(Money imponibile) {
        this.imponibile = imponibile;
        this.imponibileD = imponibile.getDoubleValue();
    }

    public Money getImposta() {
        return this.imposta;
    }

    public void setImposta(Money imposta) {
        this.imposta = imposta;
        this.impostaD = imposta.getDoubleValue();
    }

    public Money getImposta_ind() {
        return this.imposta_ind;
    }

    public void setImposta_ind(Money imposta_ind) {
        this.imposta_ind = imposta_ind;
    }

    public int getMese() {
        return Integer.valueOf(this.fda.mese(this.getR().getData_doc()));
    }

    public String getStringMese() {
        return "";
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public Registrazione getR() {
        return this.r;
    }

    public void setR(Registrazione r) {
        this.r = r;
    }

    public int getId_registro_iva() {
        return this.id_registro_iva;
    }

    public void setId_registro_iva(int id_registro_iva) {
        this.id_registro_iva = id_registro_iva;
    }

    public int getProtocollo_iva() {
        return this.protocollo_iva;
    }

    public void setProtocollo_iva(int protocollo_iva) {
        this.protocollo_iva = protocollo_iva;
    }

    public int getBloccato() {
        return this.bloccato;
    }

    public void setBloccato(int bloccato) {
        this.bloccato = bloccato;
    }

    public boolean inserisciPNIva(boolean da_solo) {
        if (!this.getImposta().isZero() || !this.getImponibile().isZero()) {
            String q_trace;
            boolean r_trace;
            if (da_solo) {
                Configurazioni.getIstanza().connessione.start_transaction();
            }
            String query_ins = "INSERT INTO registro_iva(id_registro,id_aliquota,imponibile,imposta,imposta_ind,mese,anno,id_conto_iva,segno,note,protocollo_iva,id_conf_registri_iva,bloccato) VALUES ('" + this.getId_registro() + "', " + "'" + this.getId_aliquota() + "', " + "'" + this.getImponibile() + "', " + "'" + this.getImposta() + "', " + "'" + this.getImposta_ind() + "', " + "'" + this.getMese() + "', " + "'" + this.getAnno() + "', " + "'" + this.getId_conto() + "'," + "'" + this.getSegno() + "'," + "'" + this.getNote().replaceAll("'", "''") + "'," + "'" + this.getProtocollo_iva() + "'," + "'" + this.getId_registro_iva() + "'," + "'" + this.getBloccato() + "')";
            MyTrace.log.info("QUERY:" + query_ins);
            boolean r_ins = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_ins);
            if (!r_ins) {
                MyTrace.log.severe("Inserimento iva non riuscito");
                Configurazioni.eccezione.gestisci("2.2", null);
                Configurazioni.getIstanza().connessione.rollback();
                return false;
            }
            this.setId(Configurazioni.getIstanza().connessione.id_inserito("registro_iva"));
            String q_prot = "SELECT protocollo_iva from registro_iva where idregistro_iva=" + this.getId();
            ResultSet res_num = Configurazioni.getIstanza().connessione.eseguiQuery(q_prot);
            int numero = 0;
            try {
                while (res_num.next()) {
                    numero = res_num.getInt("protocollo_iva");
                }
            }
            catch (Exception e) {
                Funzioni.inviaBugPerEmail(e);
                Funzioni.LogStackTrace(e);
                e.printStackTrace();
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res_num);
            if (numero != this.getProtocollo_iva()) {
                this.setProtocollo_iva(numero);
            }
            if (!(r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','registro_iva','" + this.getId() + "',NOW(),'INS','" + query_ins.replaceAll("'", "''") + "')"))) {
                MyTrace.log.severe("Inserimento  iva non riuscito per trace");
                Configurazioni.eccezione.gestisci("2.3", null);
                Configurazioni.getIstanza().connessione.rollback();
                return false;
            }
            if (da_solo) {
                Configurazioni.getIstanza().connessione.commit();
            }
            return true;
        }
        return true;
    }

    public boolean modificaPNIva(boolean da_solo) {
        String query_mod;
        boolean r_mod;
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod = "UPDATE  registro_iva  SET  id_aliquota='" + this.getId_aliquota() + "'," + " imponibile='" + this.getImponibile() + "'," + " imposta='" + this.getImposta() + "'," + " imposta_ind='" + this.getImposta_ind() + "'," + " mese='" + this.getMese() + "'," + " anno='" + this.getAnno() + "'," + " id_conto_iva='" + this.getC().getId() + "', " + " segno='" + this.getSegno() + "'," + " note='" + this.getNote().replaceAll("'", "''") + "' " + " WHERE idRegistro_iva='" + this.getId() + "'"))) {
            MyTrace.log.severe("Modifica  iva  non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','registro_iva','" + this.getId() + "',NOW(),'MOD','" + query_mod.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Modifica  iva non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.3", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    public boolean eliminaPNIva(boolean da_solo) {
        String query_del;
        boolean r_del;
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(r_del = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_del = "DELETE from registro_iva WHERE idregistro_iva=" + this.getId() + " "))) {
            MyTrace.log.severe("Elimina  iva  non riuscita");
            Configurazioni.eccezione.gestisci("3.5", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','registro_iva','" + this.getId() + "',NOW(),'DEL','" + query_del.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Elimina  iva  non riuscita per trace");
            Configurazioni.eccezione.gestisci("3.6", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    public Object getColValue(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                if (this.a != null) {
                    retVal = this.a.getCodice();
                    break;
                }
                retVal = "";
                break;
            }
            case 1: {
                if (this.a != null) {
                    retVal = this.a.getDescrizione();
                    break;
                }
                retVal = "";
                break;
            }
            case 2: {
                if (this.a != null) {
                    retVal = this.getImponibile().toString();
                    break;
                }
                retVal = "";
                break;
            }
            case 3: {
                if (this.a != null) {
                    retVal = "" + Double.toString(this.a.getAliquota());
                    break;
                }
                retVal = "";
                break;
            }
            case 4: {
                if (this.a != null) {
                    retVal = "" + this.getImposta();
                    break;
                }
                retVal = "";
                break;
            }
            case 5: {
                if (this.a != null) {
                    retVal = "" + Double.toString(this.a.getIndetraibilita());
                    break;
                }
                retVal = "";
                break;
            }
            case 6: {
                if (this.a != null) {
                    retVal = "" + this.getImposta_ind();
                    break;
                }
                retVal = "";
                break;
            }
            case 7: {
                retVal = "" + this.getStringMese();
                break;
            }
            case 8: {
                retVal = "" + this.getAnno();
                break;
            }
            case 9: {
                if (this.c != null) {
                    retVal = this.c.getConto();
                    break;
                }
                retVal = "";
                break;
            }
            case 10: {
                retVal = this.f.string_segno(this.getSegno(), 0);
                break;
            }
            case 11: {
                retVal = this.getNote();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }
}

