/*
 * Decompiled with CFR 0.152.
 */
package gestionale.primanota;

import anagrafiche.banche.MyBanche;
import controlling.regole.MyRegole;
import controlling.regole.Regola;
import controlling.voci_di_analisi.MyVociDiAnalisi;
import controlling.voci_di_analisi.VoceDiAnalisi;
import gestionale.MyDesktopWindow;
import gestionale.causali_contabili.CausaleContabile;
import gestionale.causali_contabili.CausaleContabileIva;
import gestionale.causali_contabili.CausaleContabileRiga;
import gestionale.causali_contabili.MyCausaliContabili;
import gestionale.configurazioni.ConfigurazioneFinestre;
import gestionale.configurazioni.Configurazioni;
import gestionale.configurazioni.MyProprietaFrame;
import gestionale.conti_correnti.ContoCorrente;
import gestionale.iva.MyConfiguraAliquotaIVA;
import gestionale.iva.RegistriIVA;
import gestionale.piano_dei_conti.Conto5;
import gestionale.piano_dei_conti.MyConto5;
import gestionale.primanota.InsiemePNIva;
import gestionale.primanota.InsiemePNRiga;
import gestionale.primanota.InsiemePartite;
import gestionale.primanota.InsiemeRegistrazioni;
import gestionale.primanota.MyInterrogazioneConti;
import gestionale.primanota.MyInterrogazionePartite;
import gestionale.primanota.MyStampaPrimaNota;
import gestionale.primanota.MyStoricoFattura;
import gestionale.primanota.PNIva;
import gestionale.primanota.PNIvaTableModel;
import gestionale.primanota.PNRiga;
import gestionale.primanota.PNRigaTableModel;
import gestionale.primanota.Partita;
import gestionale.primanota.PartiteTableModel;
import gestionale.primanota.Registrazione;
import gestionale.primanota.RegistrazioneFixedModel;
import gestionale.primanota.RegistrazioniTableModel;
import gestionale.primanota.RegistrazioniTableRenderer;
import gestionale.primanota.Riepilogo;
import gestionale.primanota.RiepilogoTableModel;
import gestionale.primanota.RiepilogoTableRenderer;
import gestionale.scadenziario.InsiemeScadenze;
import gestionale.scadenziario.MyScadenzeAperte;
import gestionale.scadenziario.ScadenzeTableModel;
import gestionale.trattamento_economico.MyTrattamentoEconomico;
import gestionale.trattamento_economico.TrattamentoEconomico;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import utils.AvvioSuThread;
import utils.ClientiFornitoriField;
import utils.ComboInsertEditor;
import utils.DataCellRenderer;
import utils.DateField;
import utils.DateInsertEditor;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;
import utils.Performance;
import utils.RicercaCellComboRenderer;
import utils.RicercaCellEditor;
import utils.RicercaCellRenderer;
import utils.TextInsertEditor;
import utils.TimeFormatter;
import utils.ToolTipHeader;

public class MyRegistrazioni
extends JInternalFrame
implements ListSelectionListener {
    String civetta_permessi;
    public static int size_diritti = 2;
    public static String[] array_diritti = new String[]{"PRIME_NOTA_VISUALIZZA", "PRIMA_NOTA_MODIFICA"};
    JToolBar jToolBarMod;
    RegistrazioniTableModel rtm;
    public InsiemeRegistrazioni insieme_r;
    JScrollPane scroll;
    public JTable jTableRegistro;
    RegistrazioneFixedModel rfm;
    JScrollPane fixedScroll;
    JTable fixedTable;
    private TableRowSorter<RegistrazioniTableModel> sorter;
    RowFilter<RegistrazioniTableModel, Object> rf = null;
    ArrayList<RowFilter<RegistrazioniTableModel, Object>> andFilters = new ArrayList();
    DateField data_reg;
    DateField data_doc;
    boolean in_filter = false;
    boolean in_modifica = false;
    boolean in_new = false;
    boolean non_tutte_le_righe = false;
    public boolean f_causali_open = false;
    public boolean f_te_open = false;
    public boolean f_ba_open = false;
    public boolean aiuto_riga_analisi = false;
    public boolean aiuto_riga_c = false;
    public Registrazione r_selezione;
    Funzioni f = new Funzioni();
    FunzioniDate fda = new FunzioniDate();
    public JInternalFrame chiamante;
    public int row_chiamante;
    PNIvaTableModel pni_tm;
    public boolean aiuto_iva_a = false;
    public boolean aiuto_sc_open = false;
    public boolean f_partite_open = false;
    PNRigaTableModel pnr_tm;
    public PartiteTableModel pa_tm;
    RiepilogoTableModel riepilogo_tm;
    Vector vettore_riepilogo;
    ScadenzeTableModel stm;
    public ClientiFornitoriField jTextCF;
    int riga_selezionata_nella_tabella = -1;
    private JButton jButtonAddIVARow;
    private JButton jButtonAddPartitaDaChiudere;
    private JButton jButtonAddRigaRow;
    private JButton jButtonClean;
    private JButton jButtonDettaglio;
    private JButton jButtonElimina;
    private JToggleButton jButtonFiltra;
    private JButton jButtonFirst;
    private JButton jButtonForm;
    private JButton jButtonLast;
    private JButton jButtonModifica;
    private JButton jButtonNext;
    private JButton jButtonNuovo;
    private JButton jButtonPrevious;
    private JButton jButtonRefresh;
    private JButton jButtonStampa;
    private JCheckBox jCheckTutti;
    private JComboBox jComboIVAP;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel28;
    private JLabel jLabel29;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabelBA;
    private JLabel jLabelCF;
    private JLabel jLabelCausale;
    private JLabel jLabelDescCF;
    private JLabel jLabelDescCausale;
    private JLabel jLabelImporto;
    private JLabel jLabelNote;
    private JLabel jLabelRI;
    private JLabel jLabelTe;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JPanel jPanelDettaglio;
    private JPanel jPanelElenco;
    private JPanel jPanelIva;
    private JPanel jPanelPartite;
    private JPanel jPanelRighe;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane6;
    private JScrollPane jScrollPane7;
    private JScrollPane jScrollPane8;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JTabbedPane jTabbedPane1;
    private JTabbedPane jTabbedPane2;
    public JTable jTablePNIva;
    public JTable jTablePNRighe;
    public JTable jTablePartite;
    private JTable jTableRiepilogo;
    private JTable jTableScadenze;
    private JTextField jTextAnnoDoc;
    private JTextField jTextAnnoProt;
    private JTextField jTextAnnoReg;
    public JTextField jTextBancaAppoggio;
    public JTextField jTextCausale;
    private JTextField jTextCodifica;
    private JTextField jTextIBAN;
    private JTextField jTextImportoDoc;
    private JTextField jTextNDoc;
    private JTextField jTextNReg;
    private JTextArea jTextNote;
    private JTextField jTextProtIVA;
    private JTextField jTextRegIVA;
    public JTextField jTextTE;
    private JToolBar jToolBar1;
    private JPanel p;

    public MyRegistrazioni() {
        Performance perf = new Performance("ISTANZA PRIMANOTA (MyRegistrazioni)");
        if (!MyDesktopWindow.profilo.controllaPermesso("PRIME_NOTA_VISUALIZZA")) {
            Configurazioni.eccezione.gestisci("7.1", null);
            this.dispose();
        }
        this.rtm = new RegistrazioniTableModel();
        for (int i = 0; i < this.rtm.getColumnCount(); ++i) {
            RowFilter rf_local = RowFilter.regexFilter("(?i)", i);
            this.andFilters.add(i, rf_local);
        }
        this.insieme_r = new InsiemeRegistrazioni();
        this.jTableRegistro = new JTable(this.rtm);
        this.jTableRegistro.setSelectionMode(0);
        this.sorter = new TableRowSorter<RegistrazioniTableModel>(this.rtm);
        this.rfm = new RegistrazioneFixedModel();
        this.rfm.setFIXED_NUM(0);
        this.fixedTable = new JTable(this.rfm);
        this.fixedTable.setAutoResizeMode(4);
        this.pni_tm = new PNIvaTableModel();
        this.pnr_tm = new PNRigaTableModel();
        this.pa_tm = new PartiteTableModel("");
        this.stm = new ScadenzeTableModel();
        this.initComponents();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.data_reg = new DateFieldLocal(new TimeFormatter());
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.data_reg, gridBagConstraints);
        this.data_doc = new DateFieldLocal(new TimeFormatter());
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.data_doc, gridBagConstraints);
        this.jTextCF = new ClientiFornitoriFieldLocal(this, "F");
        this.jTextCF.setPreferredSize(new Dimension(100, 27));
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel5.add((Component)this.jTextCF, gridBagConstraints);
        this.jTablePNIva.setModel(this.pni_tm);
        this.jTablePNRighe.setModel(this.pnr_tm);
        this.vettore_riepilogo = new Vector();
        this.riepilogo_tm = new RiepilogoTableModel();
        this.jTableRiepilogo.setModel(this.riepilogo_tm);
        this.crea_toolbar();
        this.aggiungi_tabelle();
        AvvioSuThread primo_avvio_separato = new AvvioSuThread(this, "primo_caricamento_apertura_form");
        this.setLocation(ConfigurazioneFinestre.GetPoint(this.getClass().getName(), new Point(200, 0)));
        this.setSize(ConfigurazioneFinestre.GetDimension(this.getClass().getName(), new Dimension(850, 850)));
        ListSelectionModel listSelectionModel = this.jTableRegistro.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        this.controlla_diritti();
        perf.fine();
    }

    public void primo_caricamento_apertura_form() {
        this.filtra();
        this.formatta();
        this.visualizzazione();
    }

    private void controlla_diritti() {
        if (!MyDesktopWindow.profilo.controllaPermesso("PRIMA_NOTA_MODIFICA")) {
            this.jButtonModifica.setEnabled(false);
            this.jButtonNuovo.setEnabled(false);
            this.jButtonElimina.setEnabled(false);
        }
    }

    private void crea_toolbar() {
        this.jToolBarMod = new JToolBar();
        JButton jButtonSalva = new JButton();
        JButton jButtonAnnulla = new JButton();
        jButtonSalva.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-save-as.png")));
        jButtonSalva.setText("Salva");
        jButtonSalva.setFocusable(true);
        jButtonSalva.setVerticalTextPosition(3);
        jButtonSalva.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyRegistrazioni.this.jButtonSalvaActionPerformed(evt);
            }
        });
        this.jToolBarMod.add(jButtonSalva);
        jButtonAnnulla.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-undo.png")));
        jButtonAnnulla.setText("Annulla");
        jButtonAnnulla.setFocusable(true);
        jButtonAnnulla.setVerticalTextPosition(3);
        jButtonAnnulla.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyRegistrazioni.this.jButtonAnnullaActionPerformed(evt);
            }
        });
        this.jToolBarMod.add(jButtonAnnulla);
    }

    private void aggiungi_tabelle() {
        this.scroll = new JScrollPane(this.jTableRegistro){

            @Override
            public void setColumnHeaderView(Component view) {
            }
        };
        this.scroll.setHorizontalScrollBarPolicy(31);
        this.fixedScroll = new JScrollPane(this.fixedTable);
        this.fixedScroll.setVerticalScrollBarPolicy(22);
        this.fixedScroll.setPreferredSize(new Dimension(400, 25));
        JScrollBar bar = this.fixedScroll.getVerticalScrollBar();
        JScrollBar dummyBar = new JScrollBar(){

            @Override
            public void paint(Graphics g) {
            }
        };
        dummyBar.setPreferredSize(bar.getPreferredSize());
        this.fixedScroll.setVerticalScrollBar(dummyBar);
        final JScrollBar bar1 = this.scroll.getHorizontalScrollBar();
        JScrollBar bar2 = this.fixedScroll.getHorizontalScrollBar();
        bar2.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                bar1.setValue(e.getValue());
            }
        });
        this.jTableRegistro.setModel(this.rtm);
        this.jTableRegistro.setAutoCreateRowSorter(true);
        this.jTableRegistro.setRowSorter(this.sorter);
        this.jTableRegistro.setFillsViewportHeight(true);
        this.jTablePartite.setModel(this.pa_tm);
        this.p.add((Component)this.scroll, "Center");
        this.p.add((Component)this.fixedScroll, "North");
    }

    private void azzera() {
        this.jTextCausale.setText("");
        this.jLabelDescCausale.setText("** Non Definito **");
        this.jTextCF.setText("");
        this.jLabelCF.setText("Cliente / Fornitore");
        this.jLabelDescCF.setText("** Non Definito **");
        this.jTextImportoDoc.setText("");
        this.jTextAnnoReg.setText("");
        this.jTextNReg.setText("");
        this.data_reg.setText(this.fda.dataCorrenteIt());
        this.jTextNDoc.setText("");
        this.jTextAnnoDoc.setText("");
        this.data_doc.setText(this.fda.dataCorrenteIt());
        this.jTextRegIVA.setText("");
        this.jLabelRI.setText("** Non Definito **");
        this.jTextProtIVA.setText("");
        this.jTextCodifica.setText("");
        this.jTextAnnoProt.setText("");
        this.jComboIVAP.setSelectedIndex(0);
        this.jTextTE.setText("");
        this.jLabelTe.setText("** Non Definito **");
        this.jTextIBAN.setText("");
        this.jTextBancaAppoggio.setText("");
        this.jTextNote.setText("");
        this.pni_tm = new PNIvaTableModel();
        this.jTablePNIva.setModel(this.pni_tm);
        this.pnr_tm = new PNRigaTableModel();
        this.jTablePNRighe.setModel(this.pnr_tm);
        this.riepilogo_tm = new RiepilogoTableModel();
        this.jTableRiepilogo.setModel(this.riepilogo_tm);
        this.pa_tm = new PartiteTableModel("");
        this.jTablePartite.setModel(this.pa_tm);
        this.stm = new ScadenzeTableModel();
        this.jTableScadenze.setModel(this.stm);
        this.jTabbedPane2.setSelectedIndex(0);
        this.jCheckTutti.setSelected(false);
    }

    public void visualizzazione() {
        if (this.r_selezione == null) {
            this.jTabbedPane1.setEnabledAt(1, false);
        } else {
            this.jTabbedPane1.setEnabledAt(1, true);
        }
        if (this.r_selezione != null && this.r_selezione.getIdregistro() != 0 && this.r_selezione.getCc().getTm().getIns_diretto() == 0) {
            this.jTextCausale.setEnabled(false);
            this.jTextCF.setEnabled(false);
            this.jTextImportoDoc.setEnabled(false);
            this.jTextNDoc.setEnabled(false);
            this.jTextAnnoDoc.setEnabled(false);
            this.jTextAnnoProt.setEnabled(false);
            this.jTextNote.setEnabled(false);
            this.jTextRegIVA.setEnabled(false);
            this.jTextTE.setEnabled(false);
            this.jTextIBAN.setEnabled(false);
            this.jTextBancaAppoggio.setEnabled(false);
            this.data_doc.setEnabled(false);
            this.data_reg.setEnabled(false);
            this.jTablePNIva.setEnabled(false);
            this.jTablePNRighe.setEnabled(true);
            this.jButtonAddIVARow.setEnabled(false);
            this.jButtonAddRigaRow.setEnabled(true);
        } else {
            this.jTextCausale.setEnabled(this.in_new);
            this.jTextCF.setEnabled(this.in_modifica);
            this.jTextImportoDoc.setEnabled(this.in_modifica);
            this.jTextNDoc.setEnabled(this.in_modifica);
            this.jTextAnnoProt.setEnabled(this.in_modifica);
            this.jTextNote.setEnabled(this.in_modifica);
            this.jTextRegIVA.setEnabled(this.in_modifica);
            this.jTextTE.setEnabled(this.in_modifica);
            this.jTextIBAN.setEnabled(this.in_modifica);
            this.jTextBancaAppoggio.setEnabled(this.in_modifica);
            this.data_doc.setEnabled(this.in_modifica);
            this.data_reg.setEnabled(this.in_modifica);
            this.jTablePNIva.setEnabled(this.in_modifica);
            this.jTablePNRighe.setEnabled(this.in_modifica);
            this.jTablePartite.setEnabled(this.in_modifica);
            this.jButtonAddIVARow.setEnabled(this.in_modifica);
            this.jButtonAddRigaRow.setEnabled(this.in_modifica);
            this.jButtonAddPartitaDaChiudere.setEnabled(this.in_modifica);
            this.jCheckTutti.setEnabled(this.in_modifica);
        }
        if (this.in_modifica) {
            this.getContentPane().remove(this.jToolBar1);
            this.getContentPane().add((Component)this.jToolBarMod, "North");
            this.jTabbedPane1.setEnabledAt(0, false);
        } else {
            this.getContentPane().remove(this.jToolBarMod);
            this.getContentPane().add((Component)this.jToolBar1, "North");
            this.jTabbedPane1.setEnabledAt(0, true);
        }
        this.getContentPane().validate();
        this.getContentPane().repaint();
    }

    public void formatta_elenco() {
        this.jTableRegistro.setDefaultRenderer(Object.class, new RegistrazioniTableRenderer(this.in_filter));
        this.fixedTable.setRowHeight(30);
        this.fixedTable.setDefaultEditor(String.class, new TextEditor());
        this.fixedTable.setDefaultRenderer(Object.class, new RicercaCellRenderer());
        JTableHeader h = this.fixedTable.getTableHeader();
        h.setResizingAllowed(false);
        this.header_tebella();
        TableColumn c = this.fixedTable.getColumn("Data Doc");
        c.setPreferredWidth(90);
        c.setMaxWidth(90);
        c = this.jTableRegistro.getColumn("Data Doc");
        c.setPreferredWidth(90);
        c.setMaxWidth(90);
        c = this.fixedTable.getColumn("N\u00b0 Doc");
        c.setPreferredWidth(75);
        c.setMaxWidth(75);
        c = this.jTableRegistro.getColumn("N\u00b0 Doc");
        c.setPreferredWidth(75);
        c.setMaxWidth(75);
        c = this.fixedTable.getColumn("Codice CC");
        c.setPreferredWidth(100);
        c.setMaxWidth(100);
        c = this.jTableRegistro.getColumn("Codice CC");
        c.setPreferredWidth(100);
        c.setMaxWidth(100);
        c = this.fixedTable.getColumn("N\u00b0 Reg");
        c.setPreferredWidth(75);
        c.setMaxWidth(75);
        c = this.jTableRegistro.getColumn("N\u00b0 Reg");
        c.setPreferredWidth(75);
        c.setMaxWidth(75);
        c = this.fixedTable.getColumn("Data Reg");
        c.setPreferredWidth(90);
        c.setMaxWidth(90);
        c = this.jTableRegistro.getColumn("Data Reg");
        c.setPreferredWidth(90);
        c.setMaxWidth(90);
        c = this.fixedTable.getColumn("Importo");
        c.setPreferredWidth(90);
        c.setMaxWidth(90);
        c = this.jTableRegistro.getColumn("Importo");
        c.setPreferredWidth(90);
        c.setMaxWidth(90);
        c = this.fixedTable.getColumn("Cod. Cli/For");
        c.setPreferredWidth(90);
        c.setMaxWidth(90);
        c = this.jTableRegistro.getColumn("Cod. Cli/For");
        c.setPreferredWidth(90);
        c.setMaxWidth(90);
    }

    public void formatta_dettagli() {
        this.jTablePNIva.setRowHeight(27);
        this.jTablePNIva.setDefaultEditor(Object.class, new TextIVAEditor());
        this.jTablePNIva.setDefaultEditor(JCheckBox.class, new ComboInsertEditor(new String[]{"Dare", "Avere"}));
        this.jTablePNIva.setDefaultRenderer(Object.class, new RicercaCellRenderer());
        this.jTablePNIva.setDefaultRenderer(JCheckBox.class, new RicercaCellComboRenderer(new String[]{"Dare", "Avere"}));
        this.jTablePNRighe.setRowHeight(27);
        this.jTablePNRighe.setDefaultEditor(Object.class, new TextRigaEditor());
        this.jTablePNRighe.setDefaultEditor(JCheckBox.class, new ComboInsertEditor(new String[]{"Dare", "Avere"}));
        this.jTablePNRighe.setDefaultRenderer(Object.class, new RicercaCellRenderer());
        this.jTablePNRighe.setDefaultRenderer(JCheckBox.class, new RicercaCellComboRenderer(new String[]{"Dare", "Avere"}));
        this.jTablePNRighe.setDefaultEditor(Date.class, new DateInsertEditor());
        this.jTablePNRighe.setDefaultRenderer(Date.class, new DataCellRenderer());
        this.jTablePartite.setRowHeight(27);
        this.jTablePartite.setDefaultEditor(Object.class, new TextPartitaEditor());
        this.jTablePartite.setDefaultEditor(JCheckBox.class, new ComboInsertEditor(new String[]{"Dare", "Avere"}));
        this.jTablePartite.setDefaultRenderer(Object.class, new RicercaCellRenderer());
        this.jTablePartite.setDefaultRenderer(JCheckBox.class, new RicercaCellComboRenderer(new String[]{"Dare", "Avere"}));
        this.jTableRiepilogo.setDefaultRenderer(Object.class, new RiepilogoTableRenderer());
        this.jTableScadenze.setDefaultRenderer(Object.class, new RiepilogoTableRenderer());
    }

    public void formatta() {
        this.formatta_elenco();
        this.formatta_dettagli();
    }

    public void header_tebella() {
        try {
            String[] toolTipStr = new String[]{"Data Documento", "Numero Documento", "Codice Causale Contabile", "Numero Registrazione", "Data Registrazione", "Protocollo iva/registro iva", "Importo", "Codice Cliente/Fornitore", "Ragione Sociale Cliente/Fornitore"};
            ToolTipHeader header1 = new ToolTipHeader(this.jTableRegistro.getColumnModel());
            ToolTipHeader header2 = new ToolTipHeader(this.fixedTable.getColumnModel());
            header1.setToolTipStrings(toolTipStr);
            header2.setToolTipStrings(toolTipStr);
            this.fixedTable.setTableHeader(header2);
            this.jTableRegistro.setTableHeader(header1);
            header1.setResizingAllowed(false);
            header2.setResizingAllowed(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void filtra() {
        String where = "";
        String order_by = "  ORDER BY data_doc DESC ";
        if (Configurazioni.righe_ricerca != 0) {
            order_by = order_by + " LIMIT 0," + Configurazioni.righe_ricerca;
        }
        this.insieme_r.caricamento_veloce(where, order_by);
        this.rtm.setDataRegistro(this.insieme_r.vettoreRegistrazioni);
        if (Configurazioni.righe_ricerca != 0 && this.insieme_r.vettoreRegistrazioni.size() >= Configurazioni.righe_ricerca) {
            this.non_tutte_le_righe = true;
        }
    }

    public void filtra_uno(int id) {
        String where = " WHERE idregistro=" + id;
        this.insieme_r.caricamento_veloce(where, "");
        this.rtm.setDataRegistro(this.insieme_r.vettoreRegistrazioni);
        this.formatta();
    }

    public void seleziona(int row) {
        Performance perf = new Performance("SELEZIONATA RIGA");
        this.azzera();
        this.r_selezione = (Registrazione)this.insieme_r.vettoreRegistrazioni.elementAt(row);
        this.r_selezione.selezionaDati();
        this.riempi_campi();
        perf.fine();
    }

    public void riempi_campi() {
        if (this.r_selezione.getCc().getId() != 0) {
            this.jTextCausale.setText("" + this.r_selezione.getCc().getCodice());
            this.jLabelDescCausale.setText(this.r_selezione.getCc().getDescrizione());
            this.jTextCodifica.setText("" + this.r_selezione.getCc().getTm().getContatore().getCodifica());
            this.jTextRegIVA.setText(this.r_selezione.getRi().getCodice());
            this.jLabelRI.setText(this.r_selezione.getRi().getDescrizione());
            this.imposta_form(this.r_selezione.getCc());
        }
        if (this.r_selezione.getTipo_cf() != null && (this.r_selezione.getTipo_cf().equals("F") || this.r_selezione.getTipo_cf().equals("C"))) {
            this.jTextCF.tipo = this.r_selezione.getTipo_cf();
            this.jTextCF.setText(this.r_selezione.getTipo_cf() + this.r_selezione.getAnagrafica().getCodice());
            this.jLabelDescCF.setText(this.r_selezione.getAnagrafica().getRagione_sociale());
            this.jLabelDescCF.setFont(new Font("Tahoma", 1, 11));
        }
        if (this.r_selezione.getImporto_doc().isZero()) {
            this.jTextImportoDoc.setText("");
        } else {
            this.jTextImportoDoc.setText(this.f.formattaNumero("" + this.r_selezione.getImporto_doc()));
        }
        this.jTextNReg.setText("" + this.r_selezione.getNum_reg());
        this.jTextAnnoReg.setText("" + this.r_selezione.getAnno_reg());
        this.data_reg.setText(this.r_selezione.getData_regIt());
        this.data_doc.setText(this.r_selezione.getData_docIt());
        this.jTextNDoc.setText("" + this.r_selezione.getNum_doc());
        this.jTextAnnoDoc.setText("" + this.r_selezione.getAnno_doc());
        this.jTextNote.setText(this.r_selezione.getNote());
        this.jTextProtIVA.setText("" + this.r_selezione.getProtocollo_iva());
        this.jTextAnnoProt.setText("" + this.r_selezione.getAnno_prot());
        this.jTextIBAN.setText(this.r_selezione.getIban_cf());
        this.jTextBancaAppoggio.setText(this.f.descrizione_banca(this.r_selezione.getId_banca_appoggio()));
        if (this.r_selezione.getTe() != null) {
            this.jTextTE.setText(this.r_selezione.getTe().getCodice());
            this.jLabelTe.setText(this.r_selezione.getTe().getDescrizione());
        }
        if (this.r_selezione.getInsieme_iva() != null && !this.r_selezione.getInsieme_iva().vettoreIVAPN.isEmpty()) {
            this.pni_tm.setDataPNIva(this.r_selezione.getInsieme_iva().vettoreIVAPN);
        }
        this.jTablePNIva.setModel(this.pni_tm);
        if (this.r_selezione.getInsieme_p() != null && !this.r_selezione.getInsieme_p().vettoreP.isEmpty()) {
            this.pa_tm = new PartiteTableModel(this.r_selezione.getCc().getTm().getPartita_cf());
            this.pa_tm.setDataPartitaRiga(this.r_selezione.getInsieme_p().vettoreP);
        }
        this.jTablePartite.setModel(this.pa_tm);
        if (this.r_selezione.getInsieme_righe() != null && !this.r_selezione.getInsieme_righe().vettoreRPN.isEmpty()) {
            this.pnr_tm.setDataPNRiga(this.r_selezione.getInsieme_righe().vettoreRPN);
        }
        this.jTablePNRighe.setModel(this.pnr_tm);
        if (this.r_selezione.getInsieme_s() != null && !this.r_selezione.getInsieme_s().vettoreS.isEmpty()) {
            this.stm.setDataScadenza(this.r_selezione.getInsieme_s().vettoreS);
        }
        this.jTableScadenze.setModel(this.stm);
        this.stm.setDataScadenza(this.r_selezione.getInsieme_s().vettoreS);
        this.jTableScadenze.setModel(this.stm);
        this.visualizzazione();
    }

    private void costruisci() {
        Partita p;
        this.r_selezione.setNum_reg(Integer.valueOf(this.jTextNReg.getText()));
        this.r_selezione.setData_reg(this.fda.gira_data(this.data_reg.getText()));
        this.r_selezione.setNum_doc(this.jTextNDoc.getText());
        this.r_selezione.setData_doc(this.fda.gira_data(this.data_doc.getText()));
        this.r_selezione.setTe(new TrattamentoEconomico());
        this.r_selezione.setId_trattamento_economico(this.f.id_trattamento_economico(this.jTextTE.getText()));
        if (this.r_selezione.getId_trattamento_economico() != 0) {
            String w = " where idtrattamento_economico=" + this.r_selezione.getId_trattamento_economico() + " ";
            this.r_selezione.getTe().seleziona(w);
            this.r_selezione.getTe().seleziona_dettagli();
        }
        if (!this.jTextAnnoProt.getText().equals("")) {
            this.r_selezione.setAnno_prot(Integer.valueOf(this.jTextAnnoProt.getText()));
        }
        this.r_selezione.setId_causale_contabile_e_basta(this.r_selezione.getCc().getId());
        if (this.r_selezione.getCc().getTm() == null) {
            this.r_selezione.getCc().seleziona_dettagli();
        }
        this.r_selezione.setId_anagrafica(this.r_selezione.getAnagrafica().getIdanag());
        this.r_selezione.setImporto_doc(new Money(this.jTextImportoDoc.getText()));
        this.r_selezione.setNote(this.jTextNote.getText());
        this.r_selezione.setId_registro_iva(this.f.id_registro_iva(this.jTextRegIVA.getText()));
        this.r_selezione.setIban_cf(this.jTextIBAN.getText());
        this.r_selezione.setId_banca_appoggio(this.f.id_banca_da_descrizione(this.jTextBancaAppoggio.getText()));
        if (!this.jTextProtIVA.getText().equals("")) {
            this.r_selezione.setProtocollo_iva(Integer.parseInt(this.jTextProtIVA.getText()));
        }
        if (this.jComboIVAP.getSelectedIndex() == 0) {
            this.r_selezione.setIva_proporzionale(1);
        } else {
            this.r_selezione.setIva_proporzionale(0);
        }
        if (this.r_selezione.getInsieme_iva() != null && !this.r_selezione.getInsieme_iva().vettoreIVAPN.isEmpty()) {
            for (PNIva pniva : this.r_selezione.getInsieme_iva().vettoreIVAPN) {
                pniva.setR(this.r_selezione);
                pniva.setProtocollo_iva(this.r_selezione.getProtocollo_iva());
                pniva.setId_registro_iva(this.r_selezione.getId_registro_iva());
            }
        }
        if (this.r_selezione.getInsieme_righe() != null && !this.r_selezione.getInsieme_righe().vettoreRPN.isEmpty()) {
            for (PNRiga pnr : this.r_selezione.getInsieme_righe().vettoreRPN) {
                pnr.setR(this.r_selezione);
                if (pnr.getId_conto() == 0) {
                    pnr.setId_conto(this.r_selezione.getAnagrafica().getId_contropartita_abituale());
                }
                if (pnr.getFine_competenza() == null || pnr.getFine_competenza().equals("0000-00-00")) {
                    pnr.setFine_competenza(this.r_selezione.getData_doc());
                }
                if (pnr.getInizio_competenza() != null && !pnr.getInizio_competenza().equals("0000-00-00")) continue;
                pnr.setInizio_competenza(this.r_selezione.getData_doc());
            }
        }
        if (this.r_selezione.getInsieme_p() == null || this.r_selezione.getInsieme_p().vettoreP.isEmpty()) {
            MyTrace.log.info("HO L'INSIEME PARTITE NULLO");
            if (this.r_selezione.getCc().getTm().getCrea_partite() == 1) {
                MyTrace.log.info("LA CAUSALE CONTABILE MI DICE DI CREARE LE PARTITE => LA CREO CON L'IMPORTO DEL DOCUMENTO");
                p = new Partita();
                p.setId_registro(this.r_selezione.getIdregistro());
                p.setSegno(this.r_selezione.getCc().getTm().getSegno());
                p.setImporto(this.r_selezione.getImporto_doc());
                p.setTipo_partita(this.r_selezione.getCc().getTm().getTipo_partita());
                p.setFittizia(true);
                if (this.r_selezione.getCc().getTm().getPartita_cf().equals("C")) {
                    p.setTipo_cf("C");
                    if (!this.r_selezione.getTipo_cf().equals("N")) {
                        p.setId_anagrafica(this.r_selezione.getAnagrafica().getIdanag());
                    }
                }
                if (this.r_selezione.getCc().getTm().getPartita_cf().equals("F")) {
                    p.setTipo_cf("F");
                    if (!this.r_selezione.getTipo_cf().equals("N")) {
                        p.setId_anagrafica(this.r_selezione.getAnagrafica().getIdanag());
                    }
                }
                this.r_selezione.setInsieme_p(new InsiemePartite());
                this.r_selezione.getInsieme_p().vettoreP.add(p);
                this.pa_tm = new PartiteTableModel(this.r_selezione.getCc().getTm().getPartita_cf());
                this.pa_tm.setDataPartitaRiga(this.r_selezione.getInsieme_p().vettoreP);
                this.jTablePartite.setModel(this.pa_tm);
            }
        } else {
            MyTrace.log.info("HO L'INSIEME PARTITE non NULLO");
            if (this.r_selezione.getCc().getTm().getCrea_partite() == 1) {
                MyTrace.log.info("LA CAUSALE CONTABILE MI DICE DI CREARE LE PARTITE");
                if (!this.r_selezione.getCc().getTm().getTipo_partita().equals("S")) {
                    p = (Partita)this.r_selezione.getInsieme_p().vettoreP.elementAt(0);
                    p.setImporto(this.r_selezione.getImporto_doc());
                    if (this.r_selezione.getCc().getTm().getPartita_cf().equals("C")) {
                        p.setTipo_cf("C");
                        if (!this.r_selezione.getTipo_cf().equals("N")) {
                            p.setId_anagrafica(this.r_selezione.getAnagrafica().getIdanag());
                        }
                    }
                    if (this.r_selezione.getCc().getTm().getPartita_cf().equals("F")) {
                        p.setTipo_cf("F");
                        if (!this.r_selezione.getTipo_cf().equals("N")) {
                            p.setId_anagrafica(this.r_selezione.getAnagrafica().getIdanag());
                        }
                    }
                    this.pa_tm = new PartiteTableModel(this.r_selezione.getCc().getTm().getPartita_cf());
                    this.pa_tm.setDataPartitaRiga(this.r_selezione.getInsieme_p().vettoreP);
                    this.jTablePartite.setModel(this.pa_tm);
                }
            }
        }
        if (this.vettore_riepilogo.isEmpty()) {
            this.costruisci_riepilogo();
        }
        if (this.r_selezione.getCc().getTm().getCrea_partite() == 1 && this.r_selezione.getCc().getTm().getTipo_partita().equals("C")) {
            this.costruisci_scadenze();
        }
    }

    public void costruisci_riepilogo() {
        Iterator i;
        Riepilogo r_temp;
        this.vettore_riepilogo = new Vector();
        if (this.r_selezione.getInsieme_p() != null) {
            for (Partita p : this.r_selezione.getInsieme_p().vettoreP) {
                r_temp = new Riepilogo();
                if ((p.getTipo_cf().equals("C") || p.getTipo_cf().equals("F")) && p.getAnagrafica() != null) {
                    r_temp.setConto(p.getAnagrafica().getConto_appartenenza_codice());
                    r_temp.setCodice_cf(p.getTipo_cf() + p.getAnagrafica().getCodice());
                    r_temp.setDescrizione_conto(p.getAnagrafica().getRagione_sociale());
                }
                r_temp.setCodice_aliquota("");
                if (p.getSegno() == 1) {
                    r_temp.setDare(p.getImporto());
                    r_temp.setAvere(new Money(BigDecimal.ZERO));
                } else {
                    r_temp.setDare(new Money(BigDecimal.ZERO));
                    r_temp.setAvere(p.getImporto());
                }
                r_temp.setImponibile(new Money(BigDecimal.ZERO));
                this.vettore_riepilogo.add(r_temp);
            }
        }
        if (this.r_selezione.getInsieme_iva() != null && !this.r_selezione.getInsieme_iva().vettoreIVAPN.isEmpty()) {
            i = this.r_selezione.getInsieme_iva().vettoreIVAPN.iterator();
            while (i.hasNext()) {
                PNIva pni = new PNIva();
                pni = (PNIva)i.next();
                r_temp = new Riepilogo();
                r_temp.setConto(pni.getC().getConto());
                r_temp.setCodice_cf("");
                r_temp.setDescrizione_conto(pni.getC().getDescrizione());
                r_temp.setCodice_aliquota(pni.getA().getCodice());
                if (pni.getSegno() == 1) {
                    r_temp.setDare(pni.getImposta().minus(pni.getImposta_ind()));
                    r_temp.setAvere(new Money(BigDecimal.ZERO));
                } else {
                    r_temp.setDare(new Money(BigDecimal.ZERO));
                    r_temp.setAvere(pni.getImposta().minus(pni.getImposta_ind()));
                }
                r_temp.setImponibile(pni.getImponibile());
                this.vettore_riepilogo.add(r_temp);
            }
        }
        if (this.r_selezione.getInsieme_righe() != null && !this.r_selezione.getInsieme_righe().vettoreRPN.isEmpty()) {
            i = this.r_selezione.getInsieme_righe().vettoreRPN.iterator();
            while (i.hasNext()) {
                PNRiga pnr = new PNRiga();
                pnr = (PNRiga)i.next();
                r_temp = new Riepilogo();
                r_temp.setConto(pnr.getCd_conto());
                r_temp.setCodice_cf("");
                r_temp.setDescrizione_conto(pnr.getDescrizione_conto());
                r_temp.setCodice_aliquota("");
                if (pnr.getSegno() == 1) {
                    r_temp.setDare(pnr.getImporto());
                    r_temp.setAvere(new Money(BigDecimal.ZERO));
                } else {
                    r_temp.setDare(new Money(BigDecimal.ZERO));
                    r_temp.setAvere(pnr.getImporto());
                }
                r_temp.setImponibile(new Money(BigDecimal.ZERO));
                this.vettore_riepilogo.add(r_temp);
            }
        }
        Riepilogo r_tot = new Riepilogo();
        r_tot.setConto("");
        r_tot.setCodice_cf("");
        r_tot.setDescrizione_conto("Totale");
        r_tot.setCodice_aliquota("");
        Iterator i2 = this.vettore_riepilogo.iterator();
        Money dare = new Money(BigDecimal.ZERO);
        Money avere = new Money(BigDecimal.ZERO);
        Money imponibile = new Money(BigDecimal.ZERO);
        while (i2.hasNext()) {
            Riepilogo r_temp2 = (Riepilogo)i2.next();
            dare = dare.plus(r_temp2.getDare());
            avere = avere.plus(r_temp2.getAvere());
            imponibile = r_temp2.getImponibile();
        }
        r_tot.setDare(dare);
        r_tot.setAvere(avere);
        r_tot.setImponibile(imponibile);
        this.vettore_riepilogo.add(r_tot);
        this.riepilogo_tm.setDataRiepilogo(this.vettore_riepilogo);
    }

    private int costruisci_scadenze() {
        this.stm = new ScadenzeTableModel();
        int res = 0;
        if (!this.r_selezione.costruisci_scadenze(this.in_new, this.fda.gira_data(this.data_doc.getText()), this.jComboIVAP.getSelectedItem().toString().equals("Si"), this.jTextNote.getText())) {
            res = JOptionPane.showConfirmDialog(this, this.r_selezione.getMessage());
        }
        this.stm.setDataScadenza(this.r_selezione.getInsieme_s().vettoreS);
        this.jTableScadenze.setModel(this.stm);
        return res;
    }

    private boolean check() {
        if (this.jTextCausale.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Inserire la Causale Contabile");
            return false;
        }
        if (this.r_selezione.getTipo_cf() != null && !this.r_selezione.getTipo_cf().equals("N") && this.jTextCF.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Inserire il Cliente / Fornitore");
            return false;
        }
        if (this.jTextImportoDoc.getText().equals("0.0") || this.jTextImportoDoc.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Inserire l'importo del documento");
            return false;
        }
        if (this.data_doc.isEnabled() && (this.data_doc.getText().equals("00-00-0000") || this.data_doc.getText().equals("  -  -    "))) {
            JOptionPane.showMessageDialog(this, "Inserire data documento");
            return false;
        }
        if (this.r_selezione.getCc().getTm().getTipo_partita().equals("C") && (this.jTextTE.getText().equals("") || this.f.id_trattamento_economico(this.jTextTE.getText()) == 0)) {
            if (this.r_selezione.getTe() == null) {
                JOptionPane.showMessageDialog(this, "Inserire il trattamento economico");
            }
            return false;
        }
        return true;
    }

    public void aiuto_iva(int row, int col) {
        if (col == 0 && !this.aiuto_iva_a) {
            MyConfiguraAliquotaIVA oggetto = new MyConfiguraAliquotaIVA();
            oggetto.chiamante = this;
            this.getDesktopPane().add(oggetto);
            oggetto.setLocation(200, 100);
            oggetto.setVisible(true);
            oggetto.moveToFront();
            oggetto.row_chiamante = row;
            this.aiuto_iva_a = true;
        }
    }

    public void aiuto_riga(int row, int col) {
        JInternalFrame oggetto;
        if (col == 0 && !this.aiuto_riga_c) {
            oggetto = new MyConto5();
            ((MyConto5)oggetto).chiamante = this;
            this.getDesktopPane().add(oggetto);
            oggetto.setLocation(200, 100);
            oggetto.setVisible(true);
            oggetto.moveToFront();
            this.aiuto_riga_c = true;
        }
        if (col == 5 && !this.aiuto_riga_analisi) {
            oggetto = new MyVociDiAnalisi();
            ((MyVociDiAnalisi)oggetto).chiamante = this;
            this.getDesktopPane().add(oggetto);
            oggetto.setLocation(200, 100);
            oggetto.setVisible(true);
            oggetto.moveToFront();
            this.aiuto_riga_analisi = true;
        }
        if (col == 6 && !this.aiuto_riga_analisi) {
            oggetto = new MyRegole();
            ((MyRegole)oggetto).chiamante = this;
            this.getDesktopPane().add(oggetto);
            oggetto.setLocation(200, 100);
            oggetto.setVisible(true);
            oggetto.moveToFront();
            this.aiuto_riga_analisi = true;
        }
    }

    public void stop_edit() {
        if (this.jTablePNRighe.getCellEditor() != null) {
            this.jTablePNRighe.getCellEditor().stopCellEditing();
        }
        if (this.jTablePNIva.getCellEditor() != null) {
            this.jTablePNIva.getCellEditor().stopCellEditing();
        }
        if (this.jTablePartite.getCellEditor() != null) {
            this.jTablePartite.getCellEditor().stopCellEditing();
        }
    }

    public void focus_riga(int row, int col) {
    }

    public void aiuto_partita(int row, int col) {
        if (col == 3 && this.r_selezione.getCc().getRiferimento().equals("N") && !this.aiuto_sc_open) {
            MyScadenzeAperte oggetto = new MyScadenzeAperte(this.jTablePartite.getModel().getValueAt(row, 0).toString());
            oggetto.chiamante = this;
            oggetto.row_chiamante = row;
            this.getDesktopPane().add(oggetto);
            oggetto.setLocation(200, 100);
            oggetto.setVisible(true);
            oggetto.moveToFront();
            this.aiuto_sc_open = true;
        }
    }

    private void imposta_form(CausaleContabile cc) {
        if (cc.getTm().getVisualizza_partite() == 0) {
            this.jPanelPartite.setVisible(false);
        } else {
            this.jPanelPartite.setVisible(true);
        }
        if (cc.getTm().getCrea_iva() == 0) {
            this.jPanelIva.setVisible(false);
        } else {
            this.jPanelIva.setVisible(true);
        }
        if (cc.getRiferimento().equals("N")) {
            this.jTextCF.setVisible(false);
            this.jLabelCF.setVisible(false);
            this.jLabelDescCF.setVisible(false);
            this.r_selezione.setTipo_cf("N");
            this.jTextTE.setEditable(false);
            this.jTextTE.setEnabled(false);
            this.jTabbedPane2.setEnabledAt(3, false);
        } else {
            this.jTextCF.setVisible(true);
            this.jLabelCF.setVisible(true);
            this.jLabelDescCF.setVisible(true);
            this.jLabelCF.setText(this.f.riferimento(cc.getRiferimento()));
            this.r_selezione.setTipo_cf(cc.getRiferimento());
            this.jTextTE.setEditable(true);
            this.jTextTE.setEnabled(true);
            this.jTabbedPane2.setEnabledAt(3, true);
        }
    }

    public void aggiornamento() {
        MyTrace.log.info("Aggiornamento() START ");
        if (this.data_reg.getText().equals("") || this.data_reg.getText().equals("  -  -    ")) {
            this.data_reg.setText(this.fda.dataCorrenteIt());
        }
        String anno_reg = this.fda.anno(this.fda.gira_data(this.data_reg.getText()));
        int num_reg = this.f.ultima_registrazione(Integer.parseInt(anno_reg)) + 1;
        MyTrace.log.info("DATI: registrazione  num_reg=" + num_reg + "  anno_corrente=" + this.fda.annoCorrente() + "data_corrente=" + this.fda.dataCorrente());
        if (!this.jTextAnnoReg.getText().equals(anno_reg)) {
            MyTrace.log.info("E'cambiato l'anno registrazione");
            boolean ok = true;
            if (this.jTextAnnoReg.getText().equals("") || this.jTextNReg.getText().equals("")) {
                MyTrace.log.info("Prima era nullo => posso settare il nuovo numero di registrazione");
                ok = true;
            } else {
                MyTrace.log.info("Controllo se era l'ultima registrazione per quell'anno");
                int ultima_registrazione_fatta = this.f.ultima_registrazione(Integer.parseInt(this.jTextAnnoReg.getText()));
                MyTrace.log.info("ultima_registrazione_fatta_nell'anno=" + ultima_registrazione_fatta + "   numero di registrazione=" + this.jTextNReg.getText());
                if (Integer.parseInt(this.jTextNReg.getText()) >= ultima_registrazione_fatta) {
                    MyTrace.log.info("Era l'ultima registrazione per quell'anno  => posso settare il nuovo n um,ero di registrazione ");
                    ok = true;
                } else {
                    MyTrace.log.info("NON era l'ultima registrazione per quell'anno  => NON posso settare il nuovo n um,ero di registrazione ");
                    ok = false;
                }
            }
            if (ok) {
                this.jTextNReg.setText("" + num_reg);
                this.jTextAnnoReg.setText(anno_reg);
            }
        }
        if (!this.jTextCausale.getText().equals("")) {
            String anno_doc;
            CausaleContabile cc = new CausaleContabile();
            cc.seleziona(this.jTextCausale.getText());
            cc.seleziona_dettagli();
            if (cc.getTm().getDocumento() == 2) {
                this.jTextNDoc.setEnabled(true);
            } else {
                JOptionPane.showMessageDialog(this, "non puoi inserire questo documento dalla prima nota!!!");
            }
            if (this.data_doc.getText().equals("") || this.data_doc.getText().equals("  -  -    ")) {
                this.data_doc.setText(this.fda.dataCorrenteIt());
            }
            String anno_prot = anno_doc = this.fda.anno(this.fda.gira_data(this.data_doc.getText()));
            if (cc.getTm().getProtocollo_gestito() == 1) {
                int num_prot = cc.getTm().getContatore().ultimo_protocollo_iva(Integer.parseInt(anno_prot), cc.getId_registro_iva()) + 1;
                MyTrace.log.info("DATI:IVA num_prot=" + num_prot);
                if (!anno_doc.equals(this.jTextAnnoDoc.getText())) {
                    boolean ok_prot = true;
                    if (this.jTextAnnoDoc.getText().equals("") || this.jTextProtIVA.getText().equals("") || this.in_new) {
                        MyTrace.log.info("Prima era nullo => posso settare il nuovo numero di protocollo");
                        ok_prot = true;
                    } else {
                        MyTrace.log.info("Controllo se era l'ultimo protocollo per quell'anno");
                        int ultima_protoc_fatto = cc.getTm().getContatore().ultimo_protocollo_iva(Integer.parseInt(anno_doc), cc.getId_registro_iva());
                        MyTrace.log.info("DATI:IVA ultima_protoc_fatto=" + ultima_protoc_fatto);
                        if (Integer.parseInt(this.jTextProtIVA.getText()) >= ultima_protoc_fatto) {
                            MyTrace.log.info("Era l'ultimo prot per quell'anno  => posso settare il nuovo numero di protocollo ");
                            ok_prot = true;
                        } else {
                            MyTrace.log.info("NON era l'ultimo prot per quell'anno  => NON posso settare il nuovo numero di protocollo ");
                            ok_prot = false;
                        }
                    }
                    if (ok_prot) {
                        this.jTextAnnoDoc.setText("" + anno_doc);
                        this.jTextAnnoProt.setText(anno_doc);
                        this.jTextProtIVA.setText("" + num_prot);
                        MyTrace.log.info("DATI: OK_PROT anno_doc=" + anno_doc + " num_prot=" + num_prot);
                    } else {
                        JOptionPane.showMessageDialog(this, "ATTENZIONE, non posso modificare il protocollo anche se hai cambiato l'anno del documento!!!!");
                    }
                }
            }
            this.r_selezione.setId_causale_contabile(cc.getId());
            this.r_selezione.setCc(cc);
        }
        MyTrace.log.info("Aggiornamento() END ");
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.jButtonNuovo = new JButton();
        this.jButtonModifica = new JButton();
        this.jButtonElimina = new JButton();
        this.jButtonForm = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButtonFirst = new JButton();
        this.jButtonPrevious = new JButton();
        this.jButtonNext = new JButton();
        this.jButtonLast = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jButtonRefresh = new JButton();
        this.jButtonFiltra = new JToggleButton();
        this.jButtonClean = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.jButtonDettaglio = new JButton();
        this.jButtonStampa = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jScrollPane6 = new JScrollPane();
        this.jPanelElenco = new JPanel();
        this.p = new JPanel();
        this.jPanel11 = new JPanel();
        this.jLabel21 = new JLabel();
        this.jLabel22 = new JLabel();
        this.jLabel23 = new JLabel();
        this.jLabel24 = new JLabel();
        this.jLabel25 = new JLabel();
        this.jLabel26 = new JLabel();
        this.jLabel27 = new JLabel();
        this.jLabel28 = new JLabel();
        this.jScrollPane7 = new JScrollPane();
        this.jPanelDettaglio = new JPanel();
        this.jPanel2 = new JPanel();
        this.jTabbedPane2 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jTextNReg = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jTextNote = new JTextArea();
        this.jLabelNote = new JLabel();
        this.jTextAnnoReg = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jTextNDoc = new JTextField();
        this.jLabel6 = new JLabel();
        this.jTextAnnoDoc = new JTextField();
        this.jLabel7 = new JLabel();
        this.jTextAnnoProt = new JTextField();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jTextRegIVA = new JTextField();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jTextTE = new JTextField();
        this.jTextIBAN = new JTextField();
        this.jLabel15 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jTextBancaAppoggio = new JTextField();
        this.jLabelRI = new JLabel();
        this.jLabel19 = new JLabel();
        this.jTextProtIVA = new JTextField();
        this.jLabelBA = new JLabel();
        this.jTextCodifica = new JTextField();
        this.jLabel29 = new JLabel();
        this.jComboIVAP = new JComboBox();
        this.jLabelTe = new JLabel();
        this.jPanel4 = new JPanel();
        this.jPanelRighe = new JPanel();
        this.jLabel18 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.jTablePNRighe = new JTable(this.pnr_tm);
        this.jPanel7 = new JPanel();
        this.jButtonAddRigaRow = new JButton();
        this.jPanelPartite = new JPanel();
        this.jLabel20 = new JLabel();
        this.jScrollPane5 = new JScrollPane();
        this.jTablePartite = new JTable(this.pa_tm);
        this.jPanel9 = new JPanel();
        this.jPanel10 = new JPanel();
        this.jButtonAddPartitaDaChiudere = new JButton();
        this.jCheckTutti = new JCheckBox();
        this.jPanelIva = new JPanel();
        this.jLabel17 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jTablePNIva = new JTable(this.pni_tm);
        this.jPanel6 = new JPanel();
        this.jButtonAddIVARow = new JButton();
        this.jPanel8 = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.jTableRiepilogo = new JTable();
        this.jPanel12 = new JPanel();
        this.jScrollPane8 = new JScrollPane();
        this.jTableScadenze = new JTable(this.stm);
        this.jPanel5 = new JPanel();
        this.jLabelCausale = new JLabel();
        this.jTextCausale = new JTextField();
        this.jLabelCF = new JLabel();
        this.jLabelImporto = new JLabel();
        this.jTextImportoDoc = new JTextField();
        this.jLabelDescCausale = new JLabel();
        this.jLabelDescCF = new JLabel();
        this.setClosable(true);
        this.setDefaultCloseOperation(2);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Contabilit\u00e0 \\ PRIMA NOTA");
        this.setPreferredSize(new Dimension(822, 700));
        this.addInternalFrameListener(new InternalFrameListener(){

            @Override
            public void internalFrameActivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
                MyRegistrazioni.this.finestra_chiusa(evt);
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent evt) {
                MyRegistrazioni.this.formInternalFrameClosing(evt);
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent evt) {
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                MyRegistrazioni.this.posizione_finestra(evt);
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                MyRegistrazioni.this.finestra_ridimensionata(evt);
            }
        });
        this.jToolBar1.setRollover(true);
        this.jButtonNuovo.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-new.png")));
        this.jButtonNuovo.setText("Nuovo");
        this.jButtonNuovo.setFocusable(false);
        this.jButtonNuovo.setVerticalTextPosition(3);
        this.jButtonNuovo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyRegistrazioni.this.jButtonNuovoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonNuovo);
        this.jButtonModifica.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/accessories-text-editor.png")));
        this.jButtonModifica.setText("Modifica");
        this.jButtonModifica.setFocusable(false);
        this.jButtonModifica.setHorizontalAlignment(11);
        this.jButtonModifica.setVerticalTextPosition(3);
        this.jButtonModifica.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyRegistrazioni.this.jButtonModificaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonModifica);
        this.jButtonElimina.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/user-trash.png")));
        this.jButtonElimina.setText("Elimina");
        this.jButtonElimina.setEnabled(false);
        this.jButtonElimina.setFocusable(false);
        this.jButtonElimina.setHorizontalAlignment(11);
        this.jButtonElimina.setVerticalTextPosition(3);
        this.jButtonElimina.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyRegistrazioni.this.jButtonEliminaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonElimina);
        this.jButtonForm.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/preferences-system.png")));
        this.jButtonForm.setText("Propriet\u00e0");
        this.jButtonForm.setFocusable(false);
        this.jButtonForm.setHorizontalAlignment(11);
        this.jButtonForm.setVerticalTextPosition(3);
        this.jButtonForm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyRegistrazioni.this.jButtonFormActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonForm);
        this.jToolBar1.add(this.jSeparator1);
        this.jButtonFirst.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-first.png")));
        this.jButtonFirst.setFocusable(false);
        this.jButtonFirst.setHorizontalTextPosition(0);
        this.jButtonFirst.setVerticalTextPosition(3);
        this.jButtonFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyRegistrazioni.this.jButtonFirstActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonFirst);
        this.jButtonPrevious.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-previous.png")));
        this.jButtonPrevious.setFocusable(false);
        this.jButtonPrevious.setHorizontalTextPosition(0);
        this.jButtonPrevious.setVerticalTextPosition(3);
        this.jButtonPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyRegistrazioni.this.jButtonPreviousActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonPrevious);
        this.jButtonNext.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-next.png")));
        this.jButtonNext.setFocusable(false);
        this.jButtonNext.setHorizontalTextPosition(0);
        this.jButtonNext.setVerticalTextPosition(3);
        this.jButtonNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyRegistrazioni.this.jButtonNextActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonNext);
        this.jButtonLast.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/go-last.png")));
        this.jButtonLast.setFocusable(false);
        this.jButtonLast.setHorizontalTextPosition(0);
        this.jButtonLast.setVerticalTextPosition(3);
        this.jButtonLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyRegistrazioni.this.jButtonLastActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonLast);
        this.jToolBar1.add(this.jSeparator2);
        this.jButtonRefresh.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/view-refresh.png")));
        this.jButtonRefresh.setFocusable(false);
        this.jButtonRefresh.setHorizontalTextPosition(0);
        this.jButtonRefresh.setVerticalTextPosition(3);
        this.jButtonRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyRegistrazioni.this.jButtonRefreshActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonRefresh);
        this.jButtonFiltra.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-find.png")));
        this.jButtonFiltra.setFocusable(false);
        this.jButtonFiltra.setHorizontalTextPosition(0);
        this.jButtonFiltra.setVerticalTextPosition(3);
        this.jButtonFiltra.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyRegistrazioni.this.jButtonFiltraActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonFiltra);
        this.jButtonClean.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/edit-clear.png")));
        this.jButtonClean.setFocusable(false);
        this.jButtonClean.setHorizontalTextPosition(0);
        this.jButtonClean.setVerticalTextPosition(3);
        this.jButtonClean.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyRegistrazioni.this.jButtonCleanActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonClean);
        this.jToolBar1.add(this.jSeparator3);
        this.jButtonDettaglio.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-open.png")));
        this.jButtonDettaglio.setToolTipText("Visualizza Storico Fattura");
        this.jButtonDettaglio.setFocusable(false);
        this.jButtonDettaglio.setHorizontalTextPosition(0);
        this.jButtonDettaglio.setVerticalTextPosition(3);
        this.jButtonDettaglio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyRegistrazioni.this.jButtonDettaglioActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonDettaglio);
        this.jButtonStampa.setIcon(new ImageIcon(this.getClass().getResource("/gestionale/images/document-print.png")));
        this.jButtonStampa.setToolTipText("stampa");
        this.jButtonStampa.setFocusable(false);
        this.jButtonStampa.setHorizontalTextPosition(0);
        this.jButtonStampa.setVerticalTextPosition(3);
        this.jButtonStampa.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyRegistrazioni.this.jButtonStampaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonStampa);
        this.getContentPane().add((Component)this.jToolBar1, "North");
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MyRegistrazioni.this.jTabbedPane1StateChanged(evt);
            }
        });
        this.jPanelElenco.setLayout(new BorderLayout());
        this.p.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.p.setLayout(new BorderLayout());
        this.jPanelElenco.add((Component)this.p, "Center");
        this.jPanel11.setLayout(new GridBagLayout());
        this.jLabel21.setBackground(new Color(0, 153, 0));
        this.jLabel21.setText("    ");
        this.jLabel21.setOpaque(true);
        this.jPanel11.add((Component)this.jLabel21, new GridBagConstraints());
        this.jLabel22.setFont(new Font("Tahoma", 1, 11));
        this.jLabel22.setText("Fatture di Vendita");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel11.add((Component)this.jLabel22, gridBagConstraints);
        this.jLabel23.setBackground(new Color(0, 0, 205));
        this.jLabel23.setText("    ");
        this.jLabel23.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.jPanel11.add((Component)this.jLabel23, gridBagConstraints);
        this.jLabel24.setFont(new Font("Tahoma", 1, 11));
        this.jLabel24.setText("Fatture Acquisto");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel11.add((Component)this.jLabel24, gridBagConstraints);
        this.jLabel25.setBackground(new Color(204, 0, 204));
        this.jLabel25.setText("    ");
        this.jLabel25.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 30, 0, 0);
        this.jPanel11.add((Component)this.jLabel25, gridBagConstraints);
        this.jLabel26.setFont(new Font("Tahoma", 1, 11));
        this.jLabel26.setText("Note di Credito a Cliente");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel11.add((Component)this.jLabel26, gridBagConstraints);
        this.jLabel27.setBackground(new Color(0, 204, 204));
        this.jLabel27.setText("    ");
        this.jLabel27.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(10, 30, 0, 0);
        this.jPanel11.add((Component)this.jLabel27, gridBagConstraints);
        this.jLabel28.setFont(new Font("Tahoma", 1, 11));
        this.jLabel28.setText("Note di Credito da Fornitore");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel11.add((Component)this.jLabel28, gridBagConstraints);
        this.jPanelElenco.add((Component)this.jPanel11, "South");
        this.jScrollPane6.setViewportView(this.jPanelElenco);
        this.jTabbedPane1.addTab("Elenco", this.jScrollPane6);
        this.jPanelDettaglio.setBackground(new Color(255, 255, 255));
        this.jPanelDettaglio.setAutoscrolls(true);
        this.jPanelDettaglio.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new BorderLayout());
        this.jTabbedPane2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MyRegistrazioni.this.jTabbedPane2StateChanged(evt);
            }
        });
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel3.setLayout(new GridBagLayout());
        this.jTextNReg.setEditable(false);
        this.jTextNReg.setFont(new Font("Tahoma", 1, 12));
        this.jTextNReg.setEnabled(false);
        this.jTextNReg.setMinimumSize(new Dimension(80, 27));
        this.jTextNReg.setPreferredSize(new Dimension(80, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextNReg, gridBagConstraints);
        this.jTextNote.setColumns(60);
        this.jTextNote.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextNote);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabelNote.setText("Note");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelNote, gridBagConstraints);
        this.jTextAnnoReg.setEditable(false);
        this.jTextAnnoReg.setEnabled(false);
        this.jTextAnnoReg.setMaximumSize(new Dimension(80, 30));
        this.jTextAnnoReg.setMinimumSize(new Dimension(60, 27));
        this.jTextAnnoReg.setPreferredSize(new Dimension(60, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel3.add((Component)this.jTextAnnoReg, gridBagConstraints);
        this.jLabel2.setText("/");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel3.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel1.setBackground(new Color(153, 153, 153));
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText("Dati Principali");
        this.jLabel1.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel3.setText("Data Registrazione");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setText("Registrazione N\u00b0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel5.setText("Documento N\u00b0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabel5, gridBagConstraints);
        this.jTextNDoc.setMinimumSize(new Dimension(80, 27));
        this.jTextNDoc.setNextFocusableComponent(this.jTextAnnoDoc);
        this.jTextNDoc.setPreferredSize(new Dimension(80, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextNDoc, gridBagConstraints);
        this.jLabel6.setText("/");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel3.add((Component)this.jLabel6, gridBagConstraints);
        this.jTextAnnoDoc.setEditable(false);
        this.jTextAnnoDoc.setMaximumSize(new Dimension(80, 27));
        this.jTextAnnoDoc.setMinimumSize(new Dimension(60, 27));
        this.jTextAnnoDoc.setNextFocusableComponent(this.jTextTE);
        this.jTextAnnoDoc.setPreferredSize(new Dimension(60, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel3.add((Component)this.jTextAnnoDoc, gridBagConstraints);
        this.jLabel7.setText("Data Documento");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabel7, gridBagConstraints);
        this.jTextAnnoProt.setEditable(false);
        this.jTextAnnoProt.setMaximumSize(new Dimension(80, 27));
        this.jTextAnnoProt.setMinimumSize(new Dimension(60, 27));
        this.jTextAnnoProt.setPreferredSize(new Dimension(60, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextAnnoProt, gridBagConstraints);
        this.jLabel10.setBackground(new Color(153, 153, 153));
        this.jLabel10.setFont(new Font("Tahoma", 1, 11));
        this.jLabel10.setText("Dati Rilevazione IVA");
        this.jLabel10.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabel10, gridBagConstraints);
        this.jLabel11.setText("Registro IVA");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabel11, gridBagConstraints);
        this.jTextRegIVA.setEditable(false);
        this.jTextRegIVA.setMinimumSize(new Dimension(80, 27));
        this.jTextRegIVA.setPreferredSize(new Dimension(80, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextRegIVA, gridBagConstraints);
        this.jLabel12.setBackground(new Color(153, 153, 153));
        this.jLabel12.setFont(new Font("Tahoma", 1, 11));
        this.jLabel12.setText("Altro..");
        this.jLabel12.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabel12, gridBagConstraints);
        this.jLabel13.setBackground(new Color(153, 153, 153));
        this.jLabel13.setFont(new Font("Tahoma", 1, 11));
        this.jLabel13.setText("Pagamento");
        this.jLabel13.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabel13, gridBagConstraints);
        this.jLabel14.setText("TrattamentoEconomico");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabel14, gridBagConstraints);
        this.jTextTE.setMinimumSize(new Dimension(80, 27));
        this.jTextTE.setPreferredSize(new Dimension(80, 27));
        this.jTextTE.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MyRegistrazioni.this.jTextTEFocusLost(evt);
            }
        });
        this.jTextTE.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MyRegistrazioni.this.jTextTEKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextTE, gridBagConstraints);
        this.jTextIBAN.setMaximumSize(new Dimension(250, 30));
        this.jTextIBAN.setMinimumSize(new Dimension(250, 27));
        this.jTextIBAN.setPreferredSize(new Dimension(250, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextIBAN, gridBagConstraints);
        this.jLabel15.setText("Coordinate Bancarie Cliente/Fornitore");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabel15, gridBagConstraints);
        this.jLabel16.setText("Banca Appoggio");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabel16, gridBagConstraints);
        this.jTextBancaAppoggio.setMaximumSize(new Dimension(150, 30));
        this.jTextBancaAppoggio.setMinimumSize(new Dimension(150, 27));
        this.jTextBancaAppoggio.setPreferredSize(new Dimension(150, 27));
        this.jTextBancaAppoggio.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MyRegistrazioni.this.jTextBancaAppoggioKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextBancaAppoggio, gridBagConstraints);
        this.jLabelRI.setText("** Non definito **");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        this.jPanel3.add((Component)this.jLabelRI, gridBagConstraints);
        this.jLabel19.setText("Protocollo IVA");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabel19, gridBagConstraints);
        this.jTextProtIVA.setEnabled(false);
        this.jTextProtIVA.setMinimumSize(new Dimension(80, 27));
        this.jTextProtIVA.setPreferredSize(new Dimension(80, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextProtIVA, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabelBA, gridBagConstraints);
        this.jTextCodifica.setEnabled(false);
        this.jTextCodifica.setMinimumSize(new Dimension(80, 27));
        this.jTextCodifica.setPreferredSize(new Dimension(80, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jTextCodifica, gridBagConstraints);
        this.jLabel29.setText("IVA Proporzionale");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel3.add((Component)this.jLabel29, gridBagConstraints);
        this.jComboIVAP.setModel(new DefaultComboBoxModel<String>(new String[]{"Si", "No"}));
        this.jComboIVAP.setPreferredSize(new Dimension(56, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel3.add((Component)this.jComboIVAP, gridBagConstraints);
        this.jLabelTe.setText("** Non Definito **");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.jLabelTe, gridBagConstraints);
        this.jPanel1.add((Component)this.jPanel3, "North");
        this.jTabbedPane2.addTab("Generale", this.jPanel1);
        this.jPanel4.setLayout(new BorderLayout());
        this.jPanelRighe.setBackground(new Color(255, 255, 255));
        this.jPanelRighe.setPreferredSize(new Dimension(800, 200));
        this.jPanelRighe.setVerifyInputWhenFocusTarget(false);
        this.jPanelRighe.setLayout(new BorderLayout());
        this.jLabel18.setBackground(new Color(153, 153, 153));
        this.jLabel18.setFont(new Font("Tahoma", 1, 12));
        this.jLabel18.setText("Sezione Righe");
        this.jLabel18.setOpaque(true);
        this.jPanelRighe.add((Component)this.jLabel18, "North");
        this.jScrollPane3.setBackground(new Color(255, 255, 255));
        this.jScrollPane3.setMaximumSize(new Dimension(452, 200));
        this.jScrollPane3.setMinimumSize(new Dimension(400, 22));
        this.jScrollPane3.setPreferredSize(new Dimension(800, 200));
        this.jTablePNRighe.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane3.setViewportView(this.jTablePNRighe);
        this.jPanelRighe.add((Component)this.jScrollPane3, "Center");
        this.jPanel7.setLayout(new BorderLayout());
        this.jButtonAddRigaRow.setText("+");
        this.jButtonAddRigaRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyRegistrazioni.this.jButtonAddRigaRowActionPerformed(evt);
            }
        });
        this.jPanel7.add((Component)this.jButtonAddRigaRow, "East");
        this.jPanelRighe.add((Component)this.jPanel7, "South");
        this.jPanel4.add((Component)this.jPanelRighe, "Center");
        this.jPanelPartite.setBackground(new Color(255, 255, 255));
        this.jPanelPartite.setLayout(new BorderLayout());
        this.jLabel20.setBackground(new Color(153, 153, 153));
        this.jLabel20.setFont(new Font("Tahoma", 1, 12));
        this.jLabel20.setText("Sezione Partite Clienti/Fornitori");
        this.jLabel20.setOpaque(true);
        this.jPanelPartite.add((Component)this.jLabel20, "North");
        this.jScrollPane5.setBackground(new Color(255, 255, 255));
        this.jScrollPane5.setMaximumSize(new Dimension(452, 200));
        this.jScrollPane5.setMinimumSize(new Dimension(400, 22));
        this.jScrollPane5.setPreferredSize(new Dimension(800, 200));
        this.jTablePartite.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jTablePartite.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MyRegistrazioni.this.jTablePartiteFocusLost(evt);
            }
        });
        this.jScrollPane5.setViewportView(this.jTablePartite);
        this.jPanelPartite.add((Component)this.jScrollPane5, "Center");
        this.jPanel9.setLayout(new BorderLayout());
        this.jPanel10.setLayout(new GridBagLayout());
        this.jButtonAddPartitaDaChiudere.setText("Scegli");
        this.jButtonAddPartitaDaChiudere.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyRegistrazioni.this.jButtonAddPartitaDaChiudereActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        this.jPanel10.add((Component)this.jButtonAddPartitaDaChiudere, gridBagConstraints);
        this.jCheckTutti.setText("Seleziona Partite di Clienti e Fornitori");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel10.add((Component)this.jCheckTutti, gridBagConstraints);
        this.jPanel9.add((Component)this.jPanel10, "East");
        this.jPanelPartite.add((Component)this.jPanel9, "South");
        this.jPanel4.add((Component)this.jPanelPartite, "North");
        this.jPanelIva.setBackground(new Color(255, 255, 255));
        this.jPanelIva.setLayout(new BorderLayout());
        this.jLabel17.setBackground(new Color(153, 153, 153));
        this.jLabel17.setFont(new Font("Tahoma", 1, 12));
        this.jLabel17.setText("Sezione IVA");
        this.jLabel17.setOpaque(true);
        this.jPanelIva.add((Component)this.jLabel17, "North");
        this.jScrollPane2.setMaximumSize(new Dimension(452, 200));
        this.jScrollPane2.setMinimumSize(new Dimension(400, 23));
        this.jScrollPane2.setPreferredSize(new Dimension(800, 200));
        this.jTablePNIva.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jTablePNIva.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MyRegistrazioni.this.jTablePNIvaFocusLost(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTablePNIva);
        this.jPanelIva.add((Component)this.jScrollPane2, "Center");
        this.jPanel6.setLayout(new BorderLayout());
        this.jButtonAddIVARow.setText("+");
        this.jButtonAddIVARow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyRegistrazioni.this.jButtonAddIVARowActionPerformed(evt);
            }
        });
        this.jPanel6.add((Component)this.jButtonAddIVARow, "East");
        this.jPanelIva.add((Component)this.jPanel6, "South");
        this.jPanel4.add((Component)this.jPanelIva, "South");
        this.jTabbedPane2.addTab("Righe", this.jPanel4);
        this.jPanel8.setLayout(new BorderLayout());
        this.jTableRiepilogo.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane4.setViewportView(this.jTableRiepilogo);
        this.jPanel8.add((Component)this.jScrollPane4, "Center");
        this.jTabbedPane2.addTab("Riepilogo", this.jPanel8);
        this.jPanel12.setLayout(new BorderLayout());
        this.jTableScadenze.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane8.setViewportView(this.jTableScadenze);
        this.jPanel12.add((Component)this.jScrollPane8, "Center");
        this.jTabbedPane2.addTab("Scadenze", this.jPanel12);
        this.jPanel2.add((Component)this.jTabbedPane2, "Center");
        this.jPanel5.setLayout(new GridBagLayout());
        this.jLabelCausale.setText("Causale");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel5.add((Component)this.jLabelCausale, gridBagConstraints);
        this.jTextCausale.setToolTipText("Causale Contabile");
        this.jTextCausale.setMinimumSize(new Dimension(80, 27));
        this.jTextCausale.setPreferredSize(new Dimension(80, 27));
        this.jTextCausale.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                MyRegistrazioni.this.jTextCausaleFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                MyRegistrazioni.this.jTextCausaleFocusLost(evt);
            }
        });
        this.jTextCausale.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MyRegistrazioni.this.jTextCausaleKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        this.jPanel5.add((Component)this.jTextCausale, gridBagConstraints);
        this.jLabelCF.setText("Cliente/Fornitore");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel5.add((Component)this.jLabelCF, gridBagConstraints);
        this.jLabelImporto.setText("Importo Documento");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel5.add((Component)this.jLabelImporto, gridBagConstraints);
        this.jTextImportoDoc.setMinimumSize(new Dimension(100, 27));
        this.jTextImportoDoc.setNextFocusableComponent(this.jTextNDoc);
        this.jTextImportoDoc.setPreferredSize(new Dimension(100, 27));
        this.jTextImportoDoc.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                MyRegistrazioni.this.jTextImportoDocFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                MyRegistrazioni.this.jTextImportoDocFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        this.jPanel5.add((Component)this.jTextImportoDoc, gridBagConstraints);
        this.jLabelDescCausale.setText("** Non definito **");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        this.jPanel5.add((Component)this.jLabelDescCausale, gridBagConstraints);
        this.jLabelDescCF.setFont(new Font("Tahoma", 1, 11));
        this.jLabelDescCF.setText("** Non Definito **");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        this.jPanel5.add((Component)this.jLabelDescCF, gridBagConstraints);
        this.jPanel2.add((Component)this.jPanel5, "North");
        this.jPanelDettaglio.add((Component)this.jPanel2, "Center");
        this.jScrollPane7.setViewportView(this.jPanelDettaglio);
        this.jTabbedPane1.addTab("Dettaglio", this.jScrollPane7);
        this.getContentPane().add((Component)this.jTabbedPane1, "Center");
        this.pack();
    }

    private void jButtonSalvaActionPerformed(ActionEvent evt) {
        MyTrace.log.info("PRIMANOTA SALVA RICHIESTO");
        this.stop_edit();
        if (this.in_new) {
            if (this.check()) {
                this.costruisci();
                boolean check2 = this.r_selezione.inserisciRegistrazione(true);
                if (check2) {
                    this.in_new = false;
                    this.in_modifica = false;
                    this.filtra();
                    this.formatta();
                    this.visualizzazione();
                    this.jTabbedPane1.setSelectedIndex(0);
                } else {
                    JOptionPane.showMessageDialog(this, "Si \u00e8 verificato un errore al momento dell'inserimento dei dati nel database,\nRicontrollare i campi riempiti e non.\nSe il problema persiste contattare Kronos");
                }
            }
        } else if (this.check()) {
            this.costruisci();
            boolean check2 = this.r_selezione.modificaRegistrazione(true);
            if (check2) {
                this.in_modifica = false;
                this.filtra();
                this.formatta();
                this.visualizzazione();
                this.jTabbedPane1.setSelectedIndex(0);
            } else {
                JOptionPane.showMessageDialog(this, "Si \u00e8 verificato un errore al momento della modifica dei dati nel database,\nRicontrollare i campi riempiti e non.\nSe il problema persiste contattare Kronos");
            }
        }
        MyTrace.log.info("PRIMANOTA SALVA EFFETTUATO");
    }

    private void jButtonAnnullaActionPerformed(ActionEvent evt) {
        MyTrace.log.info("PRIMANOTA ANNULLA RICHIESTO");
        int res = JOptionPane.showConfirmDialog(this, "Abbandonare le modifiche?");
        if (res == 0) {
            this.in_modifica = false;
            if (this.in_new) {
                this.r_selezione = new Registrazione();
                this.in_new = false;
            }
            this.visualizzazione();
            this.jTabbedPane1.setSelectedIndex(0);
        }
        MyTrace.log.info("PRIMANOTA ANNULLA EFFETTUATO");
    }

    private void jTextCFKeyPressed(KeyEvent evt) {
    }

    private void jTextCFFocusLost(FocusEvent evt) {
    }

    private void jButtonNuovoActionPerformed(ActionEvent evt) {
        MyTrace.log.info("PRIMANOTA NUOVO RICHIESTO ***************************************************************************");
        this.in_new = true;
        this.jTableRegistro.getSelectionModel().clearSelection();
        this.azzera();
        this.r_selezione = new Registrazione();
        this.r_selezione.setInsieme_s(new InsiemeScadenze());
        CausaleContabile cc = new CausaleContabile();
        this.r_selezione.setCc(cc);
        this.aggiornamento();
        this.in_modifica = true;
        this.jTabbedPane1.setSelectedIndex(1);
        this.visualizzazione();
        MyTrace.log.info("PRIMANOTA NUOVO APERTO*****************************************************************************");
    }

    private void jButtonModificaActionPerformed(ActionEvent evt) {
        MyTrace.log.info("PRIMANOTA MODIFICA RICHIESTO*****************************************************************************");
        if (this.r_selezione != null && this.r_selezione.getIdregistro() != 0) {
            if (this.r_selezione.getCc().getTm().getIns_diretto() == 1 && !Configurazioni.hm.containsValue(this.r_selezione.getCc().getCodice())) {
                this.in_modifica = true;
                this.visualizzazione();
                if (this.jTabbedPane1.getSelectedIndex() == 0) {
                    this.jTabbedPane1.setSelectedIndex(1);
                }
            } else {
                JOptionPane.showMessageDialog(this, "Non puoi modificare da qui questa registrazione!!! ");
            }
        }
        MyTrace.log.info("PRIMANOTA MODIFICA APERTO*****************************************************************************");
    }

    private void jButtonEliminaActionPerformed(ActionEvent evt) {
    }

    private void jButtonFormActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        MyProprietaFrame oggetto = new MyProprietaFrame();
        this.getDesktopPane().add(oggetto);
        oggetto.setLocation(200, 0);
        oggetto.setVisible(true);
        oggetto.moveToFront();
        this.setCursor(new Cursor(0));
    }

    private void jButtonFirstActionPerformed(ActionEvent evt) {
        if (this.rtm.getRowCount() != 0) {
            this.jTableRegistro.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void jButtonPreviousActionPerformed(ActionEvent evt) {
        try {
            if (this.jTableRegistro.getSelectedRow() > 0 && this.rtm.getRowCount() != 0) {
                this.jTableRegistro.getSelectionModel().setSelectionInterval(this.jTableRegistro.getSelectedRow() - 1, this.jTableRegistro.getSelectedRow() - 1);
            }
        }
        catch (Exception err) {
            MyTrace.log.severe("RAGGIUNTO PRIMO");
            err.printStackTrace();
        }
    }

    private void jButtonNextActionPerformed(ActionEvent evt) {
        try {
            if (this.rtm.getRowCount() != 0) {
                this.jTableRegistro.getSelectionModel().setSelectionInterval(this.jTableRegistro.getSelectedRow() + 1, this.jTableRegistro.getSelectedRow() + 1);
            }
        }
        catch (Exception err) {
            MyTrace.log.severe("RAGGIUNTO ULTIMO");
            err.printStackTrace();
        }
    }

    private void jButtonLastActionPerformed(ActionEvent evt) {
        if (this.rtm.getRowCount() != 0) {
            this.jTableRegistro.getSelectionModel().setSelectionInterval(this.rtm.getRowCount() - 1, this.rtm.getRowCount() - 1);
        }
    }

    private void jButtonRefreshActionPerformed(ActionEvent evt) {
        AvvioSuThread ridisegno_separato = new AvvioSuThread(this, "primo_caricamento_apertura_form");
    }

    private void jButtonFiltraActionPerformed(ActionEvent evt) {
        if (!this.in_filter) {
            MyTrace.log.info("FILTRO INSERITO");
            this.in_filter = true;
            String[] a_ric = new String[]{"", "", "", "", "", "", "", "", "", ""};
            this.rfm.addRow(a_ric);
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 65));
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
            this.fixedTable.setCellSelectionEnabled(true);
            this.fixedTable.changeSelection(0, 0, false, false);
            this.fixedTable.requestFocus();
        } else {
            MyTrace.log.info("FILTRO DISINSERITO");
            this.in_filter = false;
            this.rfm.deleteRow();
            this.rfm = new RegistrazioneFixedModel();
            this.fixedTable.setModel(this.rfm);
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 25));
            this.sorter.setRowFilter(null);
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
        }
        this.formatta();
    }

    private void jButtonCleanActionPerformed(ActionEvent evt) {
        if (this.in_filter) {
            this.in_filter = true;
            this.sorter.setRowFilter(null);
            String[] a_ric = new String[]{"", "", "", "", "", "", "", "", ""};
            this.rfm = new RegistrazioneFixedModel();
            this.fixedTable.setModel(this.rfm);
            this.rfm.addRow(a_ric);
            this.andFilters = new ArrayList();
            for (int i = 0; i < this.rtm.getColumnCount(); ++i) {
                RowFilter rf_local = RowFilter.regexFilter("(?i)", i);
                this.andFilters.add(i, rf_local);
            }
            this.fixedScroll.setViewportView(this.fixedTable);
            this.fixedScroll.setPreferredSize(new Dimension(400, 65));
            this.p.add((Component)this.fixedScroll, "North");
            this.p.repaint();
            this.repaint();
        }
        this.formatta();
    }

    private void jTextCausaleKeyPressed(KeyEvent evt) {
        MyTrace.log.info("CAUSALE");
        int keyCode = evt.getKeyCode();
        if (keyCode == 115 && !this.f_causali_open) {
            MyCausaliContabili oggetto = new MyCausaliContabili();
            oggetto.chiamante = this;
            this.getDesktopPane().add(oggetto);
            oggetto.setVisible(true);
            oggetto.moveToFront();
            this.f_causali_open = true;
        }
    }

    private void jTextCausaleFocusLost(FocusEvent evt) {
        MyTrace.log.info("CAUSALE FOCUS LOST  START **************************************************************+");
        try {
            CausaleContabile cc = new CausaleContabile();
            cc.seleziona(((JTextField)evt.getSource()).getText());
            cc.seleziona_dettagli();
            if (cc.getId() != 0) {
                if (cc.getTm().getIns_diretto() == 0 || Configurazioni.hm.containsValue(cc.getCodice())) {
                    JOptionPane.showMessageDialog(this, "Non puoi inserire questo tipo di documento dalla prima nota");
                    this.jTextCausale.setText("");
                } else {
                    this.imposta_form(cc);
                    if (cc.getTm().getPartita_cf().equals("C")) {
                        this.jTextCF.tipo = "C";
                        this.pa_tm = new PartiteTableModel("C");
                        this.jTablePartite.setModel(this.pa_tm);
                    } else if (cc.getTm().getPartita_cf().equals("F")) {
                        this.jTextCF.tipo = "F";
                        this.pa_tm = new PartiteTableModel("F");
                        this.jTablePartite.setModel(this.pa_tm);
                    }
                    this.jLabelDescCausale.setText(cc.getDescrizione());
                    this.jTextRegIVA.setText(cc.getReg_iva().getCodice());
                    this.jLabelRI.setText(cc.getReg_iva().getDescrizione());
                    this.aggiornamento();
                    if (cc.getTm().getTipo_partita().equals("C")) {
                        this.jPanel12.setEnabled(true);
                    } else {
                        this.jPanel12.setEnabled(false);
                    }
                    this.r_selezione.setCc(cc);
                    if (cc.getInsieme_iva() != null && cc.getInsieme_iva().vettoreCCIva.size() != 0) {
                        this.r_selezione.setInsieme_iva(new InsiemePNIva());
                        for (CausaleContabileIva cci : cc.getInsieme_iva().vettoreCCIva) {
                            PNIva pniva = new PNIva();
                            pniva.setId_aliquota(cci.getId_aliquota());
                            pniva.setId_conto(cci.getId_conto());
                            pniva.setSegno(cci.getSegno());
                            this.r_selezione.getInsieme_iva().vettoreIVAPN.add(pniva);
                        }
                        this.pni_tm.setDataPNIva(this.r_selezione.getInsieme_iva().vettoreIVAPN);
                    }
                    if (cc.getInsieme_righe() != null && cc.getInsieme_righe().vettoreCCRighe.size() != 0) {
                        this.r_selezione.setInsieme_righe(new InsiemePNRiga());
                        for (CausaleContabileRiga ccr : cc.getInsieme_righe().vettoreCCRighe) {
                            PNRiga pnr = new PNRiga();
                            pnr.setId_conto(ccr.getC().getId());
                            pnr.setSegno(ccr.getSegno());
                            this.r_selezione.getInsieme_righe().vettoreRPN.add(pnr);
                        }
                        this.pnr_tm.setDataPNRiga(this.r_selezione.getInsieme_righe().vettoreRPN);
                    }
                }
            } else if (!this.jTextCausale.getText().equals("")) {
                JOptionPane.showMessageDialog(this, "Questa causale contabile non esiste!!!");
                this.jTextCausale.setText("");
            }
        }
        catch (Exception err) {
            MyTrace.log.severe("jTextCausaleFocusLost() ECCEZIONE GRAVE");
            err.printStackTrace();
            Funzioni.inviaBugPerEmail(err);
            Funzioni.LogStackTrace(err);
        }
        MyTrace.log.info("CAUSALE FOCUS LOST  END **************************************************************+");
    }

    private void jButtonAddIVARowActionPerformed(ActionEvent evt) {
        this.stop_edit();
        PNIva temp = new PNIva();
        temp.setId_aliquota(0);
        if (!this.in_new) {
            temp.setId_registro(this.r_selezione.getIdregistro());
        }
        if (this.r_selezione.getCc() != null) {
            if (this.r_selezione.getCc().getTm().getSegno() == 1) {
                temp.setSegno(2);
            } else {
                temp.setSegno(1);
            }
        } else {
            temp.setSegno(1);
        }
        temp.setImporto_riga(new Money(BigDecimal.ZERO));
        temp.setR(this.r_selezione);
        RegistriIVA ri = new RegistriIVA();
        System.out.println("ID REGISTRO IVA=" + this.r_selezione.getId_registro_iva());
        ri.seleziona(this.r_selezione.getId_registro_iva());
        Conto5 c = new Conto5();
        c.seleziona(this.r_selezione.getCc().getCodice_conto_iva());
        System.out.println("ID REGISTRO IVA=" + this.r_selezione.getId_registro_iva());
        temp.setC(c);
        temp.setId_conto(c.getId());
        if (this.r_selezione.getInsieme_iva() == null || this.r_selezione.getInsieme_iva().vettoreIVAPN.size() == 0) {
            temp.setImporto_riga(this.r_selezione.getImporto_doc());
            this.r_selezione.setInsieme_iva(new InsiemePNIva());
        }
        this.r_selezione.getInsieme_iva().vettoreIVAPN.add(temp);
        this.pni_tm.setDataPNIva(this.r_selezione.getInsieme_iva().vettoreIVAPN);
    }

    private void jButtonAddRigaRowActionPerformed(ActionEvent evt) {
        this.stop_edit();
        PNRiga temp = new PNRiga();
        if (this.r_selezione.getCc() != null) {
            if (this.r_selezione.getCc().getTm().getSegno() == 1) {
                temp.setSegno(2);
            } else {
                temp.setSegno(1);
            }
        } else {
            temp.setSegno(1);
        }
        temp.setR(this.r_selezione);
        if (!this.in_new) {
            temp.setId_registro(this.r_selezione.getIdregistro());
        }
        if (this.r_selezione.getTipo_cf().equals("F") || this.r_selezione.getTipo_cf().equals("C")) {
            temp.setId_conto(this.r_selezione.getAnagrafica().getId_contropartita_abituale());
        }
        temp.setInizio_competenza(this.r_selezione.getData_doc());
        temp.setFine_competenza(this.r_selezione.getData_doc());
        if (this.r_selezione.getInsieme_righe() == null || this.r_selezione.getInsieme_righe().vettoreRPN.isEmpty()) {
            this.r_selezione.setInsieme_righe(new InsiemePNRiga());
        }
        this.r_selezione.getInsieme_righe().vettoreRPN.add(temp);
        this.pnr_tm.setDataPNRiga(this.r_selezione.getInsieme_righe().vettoreRPN);
    }

    private void jTextTEKeyPressed(KeyEvent evt) {
        int keyCode = evt.getKeyCode();
        if (keyCode == 115 && !this.f_te_open) {
            MyTrattamentoEconomico oggetto = new MyTrattamentoEconomico();
            oggetto.chiamante = this;
            this.getDesktopPane().add(oggetto);
            oggetto.setVisible(true);
            oggetto.moveToFront();
            this.f_te_open = true;
        }
    }

    private void jTextBancaAppoggioKeyPressed(KeyEvent evt) {
        int keyCode = evt.getKeyCode();
        if (keyCode == 115 && !this.f_ba_open) {
            MyBanche oggetto = new MyBanche();
            oggetto.chiamante = this;
            this.getDesktopPane().add(oggetto);
            oggetto.setVisible(true);
            oggetto.moveToFront();
            this.f_ba_open = true;
        }
    }

    private void jTabbedPane2StateChanged(ChangeEvent evt) {
        this.stop_edit();
        boolean status = true;
        if (this.jTabbedPane2.getSelectedIndex() != 0 && this.in_new) {
            if (this.check()) {
                this.costruisci();
            } else {
                this.jTabbedPane2.setSelectedIndex(0);
                status = false;
            }
        }
        if (status && (this.jTabbedPane2.getSelectedIndex() == 2 || this.jTabbedPane2.getSelectedIndex() == 3)) {
            this.costruisci_riepilogo();
        }
        if (status && this.jTabbedPane2.getSelectedIndex() == 3 && this.in_modifica) {
            this.costruisci_scadenze();
        }
    }

    private void jTextImportoDocFocusLost(FocusEvent evt) {
        if (!((JTextField)evt.getSource()).getText().equals("")) {
            ((JTextField)evt.getSource()).setText(this.f.formattaNumero(((JTextField)evt.getSource()).getText()));
        }
    }

    private void jButtonAddPartitaDaChiudereActionPerformed(ActionEvent evt) {
        this.stop_edit();
        if (!this.f_partite_open) {
            MyScadenzeAperte oggetto = !this.jCheckTutti.isSelected() ? new MyScadenzeAperte(this.r_selezione.getCc().getTm().getPartita_cf()) : new MyScadenzeAperte("T");
            oggetto.chiamante = this;
            oggetto.riempi_campi();
            this.getDesktopPane().add(oggetto);
            oggetto.setVisible(true);
            oggetto.moveToFront();
            this.f_partite_open = true;
        }
    }

    private void jButtonStampaActionPerformed(ActionEvent evt) {
        this.stop_edit();
        MyStampaPrimaNota oggetto = new MyStampaPrimaNota();
        this.getDesktopPane().add(oggetto);
        oggetto.setVisible(true);
        oggetto.moveToFront();
    }

    private void jTextTEFocusLost(FocusEvent evt) {
        int id_te;
        if (this.r_selezione.getTe() == null) {
            this.r_selezione.setTe(new TrattamentoEconomico());
        }
        if ((id_te = this.f.id_trattamento_economico(this.jTextTE.getText())) != 0) {
            this.r_selezione.setId_trattamento_economico(id_te);
            String w = " where idtrattamento_economico=" + id_te + " ";
            this.r_selezione.getTe().seleziona(w);
            this.r_selezione.getTe().seleziona_dettagli();
            this.jLabelTe.setText(this.r_selezione.getTe().getDescrizione());
        } else if (this.r_selezione.getCc().getTm().getTipo_partita().equals("C")) {
            JOptionPane.showMessageDialog(this, "Inserire il trattamento economico");
        }
    }

    private void jButtonDettaglioActionPerformed(ActionEvent evt) {
        if (this.r_selezione.getCc().getTm().getCrea_partite() == 1 && this.r_selezione.getCc().getTm().getTipo_partita().equals("C")) {
            MyTrace.log.info("DETTAGLIO0 => Nreg=" + this.r_selezione.getNum_reg());
            MyStoricoFattura oggetto = new MyStoricoFattura(this.r_selezione);
            this.getDesktopPane().add(oggetto);
            oggetto.setVisible(true);
            oggetto.moveToFront();
        }
    }

    private void posizione_finestra(ComponentEvent evt) {
        ConfigurazioneFinestre.SetPoint(this.getClass().getName(), this.getLocation());
    }

    private void finestra_ridimensionata(ComponentEvent evt) {
        ConfigurazioneFinestre.SetDimension(this.getClass().getName(), this.getSize());
    }

    private void finestra_chiusa(InternalFrameEvent evt) {
        try {
            if (this.chiamante.getClass() == MyInterrogazioneConti.class) {
                ((MyInterrogazioneConti)this.chiamante).f_pn_open = false;
            }
            if (this.chiamante.getClass() == MyInterrogazionePartite.class) {
                ((MyInterrogazionePartite)this.chiamante).f_reg_open = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void jTablePartiteFocusLost(FocusEvent evt) {
    }

    private void jTablePNIvaFocusLost(FocusEvent evt) {
        System.out.println("TABLE FOCUS LOST");
    }

    private void jTabbedPane1StateChanged(ChangeEvent evt) {
        this.stop_edit();
    }

    private void jTextCausaleFocusGained(FocusEvent evt) {
        this.stop_edit();
    }

    private void jTextImportoDocFocusGained(FocusEvent evt) {
        this.stop_edit();
    }

    private void formInternalFrameClosing(InternalFrameEvent evt) {
        try {
            if (this.chiamante.getClass() == MyInterrogazioneConti.class) {
                ((MyInterrogazioneConti)this.chiamante).f_pn_open = false;
            }
            if (this.chiamante.getClass() == MyInterrogazionePartite.class) {
                ((MyInterrogazionePartite)this.chiamante).f_reg_open = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MyRegistrazioni().setVisible(true);
            }
        });
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int viewRow = this.jTableRegistro.getSelectedRow();
        if (this.riga_selezionata_nella_tabella != viewRow) {
            this.riga_selezionata_nella_tabella = viewRow;
            long tempo_di_visualizzazione = System.currentTimeMillis();
            try {
                int modelRow = 1000000000;
                if (this.in_filter) {
                    if (viewRow >= 0) {
                        try {
                            modelRow = this.jTableRegistro.convertRowIndexToModel(viewRow);
                        }
                        catch (Exception err) {
                            MyTrace.log.severe("valueChanged() viewrow >=0  ECCEZIONE");
                            err.printStackTrace();
                            Funzioni.inviaBugPerEmail(err);
                            Funzioni.LogStackTrace(err);
                        }
                    }
                } else {
                    modelRow = viewRow;
                }
                if (modelRow <= this.rtm.getRowCount() - 1 && modelRow >= 0) {
                    this.seleziona(modelRow);
                }
            }
            catch (Exception err) {
                MyTrace.log.severe("valueChanged(ListSelectionEvent) errore presunto negli indici");
                err.printStackTrace();
                Funzioni.inviaBugPerEmail(err);
                Funzioni.LogStackTrace(err);
            }
            MyTrace.log.fine("PERFORMANCE: Selezionata Riga in=" + (System.currentTimeMillis() - tempo_di_visualizzazione) + " millisecondi");
        }
    }

    class ClientiFornitoriFieldLocal
    extends ClientiFornitoriField {
        public ClientiFornitoriFieldLocal(JInternalFrame frame, String t) {
            super(frame, t);
        }

        @Override
        public void focusLost(FocusEvent evt) {
            this.completaAutomaticamente();
            try {
                if (this.getAnagrafica().getIdanag() != 0) {
                    MyRegistrazioni.this.r_selezione.setAnagrafica(this.getAnagrafica());
                    MyRegistrazioni.this.jLabelDescCF.setText(this.getAnagrafica().getRagione_sociale());
                    TrattamentoEconomico te = new TrattamentoEconomico();
                    te.setId(this.getAnagrafica().getId_trattamento_economico());
                    if (this.getAnagrafica().getId_trattamento_economico() != 0) {
                        String w = " where idtrattamento_economico=" + this.getAnagrafica().getId_trattamento_economico() + " ";
                        te.seleziona(w);
                        te.seleziona_dettagli();
                        MyRegistrazioni.this.jTextTE.setText(te.getCodice());
                        MyRegistrazioni.this.jLabelTe.setText(te.getDescrizione());
                        MyRegistrazioni.this.r_selezione.setTe(te);
                    }
                    if (!this.getAnagrafica().getInsieme_cc().vettoreCC.isEmpty()) {
                        MyRegistrazioni.this.jTextIBAN.setText(((ContoCorrente)this.getAnagrafica().getInsieme_cc().vettoreCC.elementAt(0)).getIban());
                    }
                }
            }
            catch (Exception ex) {
                MyTrace.log.severe("ERRORE:  eccezione jTextCFFocusLost()");
                ex.printStackTrace();
                Funzioni.inviaBugPerEmail(ex);
                Funzioni.LogStackTrace(ex);
            }
            catch (Error err) {
                MyTrace.log.severe("ERRORE: jTextCFFocusLost() ");
                err.printStackTrace();
            }
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            if (MyRegistrazioni.this.r_selezione.getTipo_cf() == null) {
                JOptionPane.showMessageDialog(this, "Devi prima scegliere la Causale Contabile!");
                ((JTextField)evt.getSource()).setText("");
            } else {
                int keyCode = evt.getKeyCode();
                if (keyCode == 115) {
                    this.apri_anagrafica();
                }
            }
        }
    }

    class DateFieldLocal
    extends DateField {
        public DateFieldLocal(JFormattedTextField.AbstractFormatter formatter) {
            super(formatter);
        }

        @Override
        public void focusLost(FocusEvent e) {
            MyTrace.log.info("DateFieldLocal FOCUS LOST  START **************************************************************+");
            this.setText(this.getText().replaceAll(" ", ""));
            MyRegistrazioni.this.aggiornamento();
            MyTrace.log.info("DateFieldLocal FOCUS LOST  END **************************************************************+");
        }
    }

    public class TextPartitaEditor
    extends TextInsertEditor {
        @Override
        public void chiama_aiuto(String col_row) {
            String[] a = col_row.split("_");
            int col = Integer.parseInt(a[0]);
            int row = Integer.parseInt(a[1]);
            System.out.println("chiamaaiuto " + col + " " + row);
            MyRegistrazioni.this.aiuto_partita(MyRegistrazioni.this.jTablePartite.getSelectedRow(), col);
            this.getCellEditorValue();
        }
    }

    public class TextRigaEditor
    extends TextInsertEditor {
        @Override
        public void chiama_aiuto(String col_row) {
            String[] a = col_row.split("_");
            int col = Integer.parseInt(a[0]);
            int row = Integer.parseInt(a[1]);
            MyRegistrazioni.this.aiuto_riga(MyRegistrazioni.this.jTablePNRighe.getSelectedRow(), col);
            this.getCellEditorValue();
        }

        @Override
        public void azione_focus_lost(String col_row) {
            try {
                String[] a = col_row.split("_");
                int col = Integer.parseInt(a[0]);
                int row = Integer.parseInt(a[1]);
                String[] b = null;
                if (col == 0) {
                    try {
                        b = MyRegistrazioni.this.f.descrizione_conto_da_alias(this.tf.getText());
                        if (b != null && !b[0].equals("")) {
                            MyTrace.log.info("FOCUS LOST ho scritto un alias:>   " + col + " " + row + "   testo: " + this.tf.getText() + "   " + b[0] + "  " + b[1]);
                        } else {
                            b[1] = MyRegistrazioni.this.f.descrizione_conto(this.tf.getText());
                            b[0] = this.tf.getText();
                        }
                        MyRegistrazioni.this.jTablePNRighe.setValueAt(b[1], row, col);
                        MyRegistrazioni.this.jTablePNRighe.setValueAt(b[0], row, col + 1);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (col == 5) {
                    VoceDiAnalisi vda = new VoceDiAnalisi();
                    String where = " WHERE descrizione_voce='" + this.tf.getText() + "' ";
                    vda.seleziona(where);
                    Regola r = new Regola();
                    String w = " WHERE ctrl_regole.idregole=" + vda.getId_regola_predefinita() + " ";
                    r.seleziona(w);
                    MyRegistrazioni.this.jTablePNRighe.setValueAt(r.getNome(), row, col + 1);
                }
            }
            catch (Exception ex) {
                MyTrace.log.severe("ERRORE:  eccezione azione_focus_lost() ");
                ex.printStackTrace();
                Funzioni.inviaBugPerEmail(ex);
                Funzioni.LogStackTrace(ex);
            }
            catch (Error err) {
                MyTrace.log.severe("ERRORE: azione_focus_lost() errore di avvio o di linkaggio");
                err.printStackTrace();
            }
        }
    }

    public class TextIVAEditor
    extends TextInsertEditor {
        @Override
        public void chiama_aiuto(String col_row) {
            String[] a = col_row.split("_");
            int col = Integer.parseInt(a[0]);
            int row = Integer.parseInt(a[1]);
            MyRegistrazioni.this.aiuto_iva(MyRegistrazioni.this.jTablePNIva.getSelectedRow(), col);
            this.getCellEditorValue();
        }

        @Override
        public void azione_focus_lost(String col_row) {
            String[] a = col_row.split("_");
            int col = Integer.parseInt(a[0]);
            int row = Integer.parseInt(a[1]);
            if (col != 0) {
                MyRegistrazioni.this.jTablePNIva.editCellAt(row, col - 1);
            } else {
                MyRegistrazioni.this.jTablePNIva.editCellAt(row, col + 1);
            }
        }
    }

    public class TextEditor
    extends RicercaCellEditor {
        RowFilter<RegistrazioniTableModel, Object> rf_local = null;

        @Override
        public void newFilter(int col) {
            Performance perf = new Performance("newFilter su colonna=" + col);
            MyRegistrazioni.this.r_selezione = new Registrazione();
            if (!MyRegistrazioni.this.non_tutte_le_righe) {
                try {
                    this.rf_local = RowFilter.regexFilter("(?i)" + this.tf.getText(), col);
                    MyRegistrazioni.this.andFilters.set(col, this.rf_local);
                }
                catch (PatternSyntaxException e) {
                    Funzioni.inviaBugPerEmail(e);
                    Funzioni.LogStackTrace(e);
                    return;
                }
                MyRegistrazioni.this.rf = RowFilter.andFilter(MyRegistrazioni.this.andFilters);
                MyRegistrazioni.this.sorter.setRowFilter(MyRegistrazioni.this.rf);
                MyRegistrazioni.this.formatta();
            } else {
                String where = "   WHERE 1 ";
                if (col == 0) {
                    where = where + " AND data_doc LIKE '%" + MyRegistrazioni.this.fda.gira_data_filtro(this.tf.getText()) + "%'";
                }
                if (col == 1) {
                    where = where + " AND num_doc LIKE '%" + this.tf.getText() + "%' or data_doc LIKE '" + this.tf.getText() + "%'";
                }
                if (col == 2) {
                    where = where + " AND conf_causale_contabile.codice LIKE '%" + this.tf.getText() + "%'";
                }
                if (col == 3) {
                    where = where + " AND  num_reg LIKE '%" + this.tf.getText() + "%' or anno_reg LIKE '%" + this.tf.getText() + "%'";
                }
                if (col == 4) {
                    where = where + "  AND data_reg LIKE '%" + this.tf.getText() + "%'";
                    try {
                        where = where + "  or data_reg LIKE '%" + MyRegistrazioni.this.f.gira_stringa_data(this.tf.getText()) + "%'";
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (col == 5) {
                    where = where + "  AND (protocollo_iva LIKE '%" + this.tf.getText() + "%' OR conf_registri_iva.codice LIKE '%" + this.tf.getText() + "%' )";
                }
                if (col == 5) {
                    where = where + "  AND importo_doc LIKE '%" + this.tf.getText() + "%'";
                }
                if (col == 6) {
                    where = where + " AND anag_anagrafica.codice LIKE '%" + this.tf.getText() + "%'";
                }
                if (col == 7) {
                    where = where + " AND anag_anagrafica.ragione_sociale LIKE '%" + this.tf.getText() + "%' ";
                }
                String order_by = " ORDER BY data_doc ASC ";
                MyRegistrazioni.this.insieme_r.caricamento_veloce(where, order_by);
                MyRegistrazioni.this.rtm.setDataRegistro(MyRegistrazioni.this.insieme_r.vettoreRegistrazioni);
                MyRegistrazioni.this.formatta();
            }
            perf.fine();
        }
    }
}

