/*
 * Decompiled with CFR 0.152.
 */
package gestionale.ore_impiego_personale;

import gestionale.ore_impiego_personale.OrePersonale;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.table.AbstractTableModel;
import utils.Funzioni;
import utils.Quantita;

public class OrePersonaleTableModel
extends AbstractTableModel {
    ArrayList<OrePersonale> cache;
    int colCount;
    String[] headers;
    boolean modo_ric = false;
    Funzioni f = new Funzioni();

    public OrePersonaleTableModel() {
        this.cache = new ArrayList();
    }

    public void setModo_ric(boolean modo_ric) {
        this.modo_ric = modo_ric;
    }

    @Override
    public String getColumnName(int i) {
        String retVal = "";
        switch (i) {
            case 0: {
                retVal = "Cognome_Nome";
                break;
            }
            case 1: {
                retVal = "Ore";
                break;
            }
            case 2: {
                retVal = "Tipo";
                break;
            }
            default: {
                retVal = this.headers[i];
            }
        }
        return retVal;
    }

    @Override
    public int getRowCount() {
        return this.cache.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Object getValueAt(int row, int col) {
        OrePersonale op = new OrePersonale();
        if (!this.cache.isEmpty()) {
            op = this.cache.get(row);
            return op.getColValue(col);
        }
        return "";
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        OrePersonale op = this.cache.get(row);
        if (col == 0) {
            String stringa = value.toString();
            int index = stringa.indexOf("_");
            String nome = stringa.substring(index + 1, stringa.length());
            String cognome = stringa.substring(0, index);
            op.setCognome(cognome);
            op.setNome(nome);
            op.setId_anag_personale(this.f.id_dipendente_da_nome(cognome, nome));
        }
        if (col == 1) {
            op.setNumero_ore(new Quantita(value.toString()));
        }
        if (col == 2) {
            if (value.toString().equals("ORE")) {
                op.setTipo_ore(0);
            }
            if (value.toString().equals("TRASFERTA")) {
                op.setTipo_ore(1);
            }
            if (value.toString().equals("ORE EXTRA")) {
                op.setTipo_ore(2);
            }
            if (value.toString().equals("TRASFERTA EXTRA")) {
                op.setTipo_ore(3);
            }
            if (value.toString().equals("CASSA INTEGRAZIONE")) {
                op.setTipo_ore(4);
            }
        }
        this.fireTableRowsUpdated(row, row);
    }

    public Class getColumnClass(int c) {
        if (c != 2) {
            return this.getValueAt(0, c).getClass();
        }
        return JComboBox.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public void addRow(OrePersonale g) {
        this.cache.add(0, g);
        this.fireTableDataChanged();
    }

    public void setDataOP(ArrayList<OrePersonale> vettoreOP) {
        this.cache = new ArrayList();
        Iterator<OrePersonale> i = vettoreOP.iterator();
        while (i.hasNext()) {
            this.cache.add(i.next());
        }
        this.fireTableChanged(null);
    }
}

