/*
 * Decompiled with CFR 0.152.
 */
package gestionale.ore_impiego_personale;

import gestionale.MyDesktopWindow;
import gestionale.configurazioni.Configurazioni;
import gestionale.ore_costo_personale.OreCostoPersonale;
import java.math.BigDecimal;
import utils.Funzioni;
import utils.FunzioniDate;
import utils.Money;
import utils.MyTrace;
import utils.Quantita;

public class OrePersonale {
    int id;
    int id_anag_personale;
    int id_commessa;
    int tipo_ore;
    Quantita numero_ore = new Quantita(BigDecimal.ZERO);
    String data;
    String nome;
    String cognome;
    String desc_commessa;
    String string_num_commessa;
    OreCostoPersonale ocp = new OreCostoPersonale();
    private Funzioni f = new Funzioni();
    private FunzioniDate fda = new FunzioniDate();

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId_anag_personale() {
        return this.id_anag_personale;
    }

    public void setId_anag_personale(int id_anag_personale) {
        this.id_anag_personale = id_anag_personale;
    }

    public int getId_commessa() {
        return this.id_commessa;
    }

    public void setId_commessa(int id_commessa) {
        this.id_commessa = id_commessa;
    }

    public Quantita getNumero_ore() {
        return this.numero_ore;
    }

    public void setNumero_ore(Quantita numero_ore) {
        this.numero_ore = numero_ore;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getData_it() {
        return this.fda.gira_data(this.data);
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getCognome() {
        return this.cognome;
    }

    public void setCognome(String cognome) {
        this.cognome = cognome;
    }

    public String getDesc_commessa() {
        return this.desc_commessa;
    }

    public void setDesc_commessa(String desc_commessa) {
        this.desc_commessa = desc_commessa;
    }

    public String getString_num_commessa() {
        return this.string_num_commessa;
    }

    public void setString_num_commessa(String string_num_commessa) {
        this.string_num_commessa = string_num_commessa;
    }

    public OreCostoPersonale getOcp() {
        return this.ocp;
    }

    public void setOcp(OreCostoPersonale ocp) {
        this.ocp = ocp;
    }

    public int getTipo_ore() {
        return this.tipo_ore;
    }

    public void setTipo_ore(int tipo_ore) {
        this.tipo_ore = tipo_ore;
    }

    public String getString_tipo_ore() {
        String retVal = "";
        switch (this.getTipo_ore()) {
            case 0: {
                retVal = "ORE";
                break;
            }
            case 1: {
                retVal = "TRASFERTA";
                break;
            }
            case 2: {
                retVal = "ORE EXTRA";
                break;
            }
            case 3: {
                retVal = "TRASFERTA EXTRA";
                break;
            }
            case 4: {
                retVal = "CASSA INTEGRAZIONE";
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }

    public boolean inserisci(boolean da_solo) {
        String query_ins;
        boolean r_ins;
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(r_ins = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_ins = "INSERT INTO ore_impiego_personale (id_anag_dipendenti,numero_ore,id_commessa,data,tipo_ore) VALUES (" + this.getId_anag_personale() + "," + "" + this.getNumero_ore() + "," + "" + this.getId_commessa() + "," + "'" + this.getData() + "'," + "" + this.getTipo_ore() + " " + ")"))) {
            MyTrace.log.severe("Inserimento OraDipendente non riuscito");
            Configurazioni.eccezione.gestisci("2.2", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        this.setId(Configurazioni.getIstanza().connessione.id_inserito("ore_impiego_personale"));
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','ore_impiego_personale','" + this.getId() + "',NOW(),'INS','" + query_ins.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Inserimento OraDipendente non riuscito per trace");
            Configurazioni.eccezione.gestisci("2.3", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    public boolean modifica(boolean da_solo) {
        String query_mod;
        boolean r_mod;
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod = "UPDATE ore_impiego_personale  SET  id_anag_dipendenti=" + this.getId_anag_personale() + "," + " numero_ore = " + this.getNumero_ore() + "," + " tipo_ore = " + this.getTipo_ore() + " " + " WHERE idOre_impiego_personale=" + this.getId() + " "))) {
            MyTrace.log.severe("Modifica OraDipendente non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','ore_impiego_personale','" + this.getId() + "',NOW(),'MOD','" + query_mod.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Modifica OraDipendente non riuscita per trace");
            Configurazioni.getIstanza().connessione.rollback();
            Configurazioni.eccezione.gestisci("3.3", null);
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    public boolean elimina(boolean da_solo) {
        String query_mod;
        boolean r_mod;
        if (da_solo) {
            Configurazioni.getIstanza().connessione.start_transaction();
        }
        if (!(r_mod = Configurazioni.getIstanza().connessione.eseguiAggiornamento(query_mod = "DELETE FROM ore_impiego_personale  WHERE idOre_impiego_personale=" + this.getId() + " "))) {
            MyTrace.log.severe("Eliminazione OraDipendente non riuscita");
            Configurazioni.eccezione.gestisci("3.2", null);
            Configurazioni.getIstanza().connessione.rollback();
            return false;
        }
        String q_trace = "INSERT INTO sys_trace(id_operatore,nome_tabella,id_soggetto,data,azione,query) VALUES('" + MyDesktopWindow.profilo.id + "','ore_impiego_personale','" + this.getId() + "',NOW(),'MOD','" + query_mod.replaceAll("'", "''") + "')";
        boolean r_trace = Configurazioni.getIstanza().connessione.eseguiAggiornamento(q_trace);
        if (!r_trace) {
            MyTrace.log.severe("Eliminazione OraDipendente non riuscita per trace");
            Configurazioni.getIstanza().connessione.rollback();
            Configurazioni.eccezione.gestisci("3.3", null);
            return false;
        }
        if (da_solo) {
            Configurazioni.getIstanza().connessione.commit();
        }
        return true;
    }

    Object getColValue(int col) {
        String retVal = "";
        switch (col) {
            case 0: {
                retVal = "" + this.getCognome() + "_" + this.getNome();
                break;
            }
            case 1: {
                retVal = "" + this.getNumero_ore();
                break;
            }
            case 2: {
                retVal = "" + this.getString_tipo_ore();
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }

    Object getColValueReport(int col) {
        String retVal = "";
        Money costo = new Money(BigDecimal.ZERO);
        switch (this.getTipo_ore()) {
            case 0: {
                costo = this.getOcp().getC_orario();
                break;
            }
            case 1: {
                costo = this.getOcp().getC_trasferta();
                break;
            }
            case 2: {
                costo = this.getOcp().getC_ore_extra();
                break;
            }
            case 3: {
                costo = this.getOcp().getC_trasferta_extra();
                break;
            }
            case 4: {
                costo = this.getOcp().getC_ci();
                break;
            }
            default: {
                retVal = "";
            }
        }
        switch (col) {
            case 0: {
                retVal = "" + this.getData_it();
                break;
            }
            case 1: {
                retVal = "" + this.getString_num_commessa() + " [" + this.getDesc_commessa() + "]";
                break;
            }
            case 2: {
                retVal = "" + this.getCognome() + "_" + this.getNome();
                break;
            }
            case 3: {
                retVal = "" + this.getNumero_ore();
                break;
            }
            case 4: {
                retVal = "" + this.getString_tipo_ore();
                break;
            }
            case 5: {
                retVal = "" + costo;
                break;
            }
            case 6: {
                retVal = "" + costo.multiply(this.getNumero_ore());
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }
}

