/*
 * Decompiled with CFR 0.152.
 */
package gestionale.ore_impiego_personale;

import gestionale.configurazioni.Configurazioni;
import gestionale.ore_costo_personale.OreCostoPersonale;
import gestionale.ore_impiego_personale.OrePersonale;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import utils.Funzioni;
import utils.Money;
import utils.MyTrace;
import utils.Quantita;

public class InsiemeOrePersonale {
    public ArrayList<OrePersonale> vettoreOrePersonale;
    int colCount;
    public String[] headers;
    Money tot_costi = new Money(BigDecimal.ZERO);

    public InsiemeOrePersonale() {
        this.vettoreOrePersonale = new ArrayList();
    }

    public Money getTot_costi() {
        return this.tot_costi;
    }

    public void setTot_costi(Money tot_costi) {
        this.tot_costi = tot_costi;
    }

    public int caricamento(String where, String order_by) {
        String query = "SELECT ore_impiego_personale.*, anag_dipendenti.nome,  anag_dipendenti.cognome,  commesse.descrizione_breve,commesse.numero_commessa,commesse.anno  FROM ore_impiego_personale LEFT JOIN anag_dipendenti ON ore_impiego_personale.id_anag_dipendenti=anag_dipendenti.idanag_dipendenti  LEFT JOIN commesse ON ore_impiego_personale.id_commessa=commesse.idCommessa  ";
        query = query + " " + where;
        query = query + " " + order_by;
        this.vettoreOrePersonale = new ArrayList();
        try {
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
            while (res.next()) {
                OrePersonale op = new OrePersonale();
                op.setId(res.getInt("idOre_impiego_personale"));
                op.setId_commessa(res.getInt("id_commessa"));
                op.setData(res.getString("data"));
                op.setNumero_ore(new Quantita(res.getDouble("numero_ore")));
                op.setTipo_ore(res.getInt("tipo_ore"));
                op.setId_anag_personale(res.getInt("id_anag_dipendenti"));
                op.setNome(res.getString("nome"));
                op.setCognome(res.getString("cognome"));
                this.vettoreOrePersonale.add(op);
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        }
        catch (Exception e) {
            this.vettoreOrePersonale = new ArrayList();
            MyTrace.log.severe("Seleziona OrePersonale non riuscito");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.2", null);
        }
        return this.vettoreOrePersonale.size();
    }

    public int caricamentoConCosti(String where, String order_by) {
        this.tot_costi = new Money(BigDecimal.ZERO);
        String query = "SELECT ore_impiego_personale.*, anag_dipendenti.nome,  anag_dipendenti.cognome,  commesse.descrizione_breve,commesse.numero_commessa,commesse.anno,  ore_costo_personale.*  FROM ore_impiego_personale LEFT JOIN anag_dipendenti ON ore_impiego_personale.id_anag_dipendenti=anag_dipendenti.idanag_dipendenti  LEFT JOIN commesse ON ore_impiego_personale.id_commessa=commesse.idCommessa   LEFT JOIN ore_costo_personale ON (ore_costo_personale.id_anag_dipendenti=anag_dipendenti.idanag_dipendenti AND ore_impiego_personale.data between ore_costo_personale.data_da and ore_costo_personale.data_a) ";
        query = query + " " + where;
        query = query + " " + order_by;
        this.vettoreOrePersonale = new ArrayList();
        try {
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
            while (res.next()) {
                OrePersonale op = new OrePersonale();
                op.setId(res.getInt("idOre_impiego_personale"));
                op.setId_commessa(res.getInt("id_commessa"));
                op.setDesc_commessa(res.getString("descrizione_breve"));
                op.setString_num_commessa(res.getInt("numero_commessa") + "/" + res.getInt("anno"));
                op.setData(res.getString("data"));
                op.setNumero_ore(new Quantita(res.getDouble("numero_ore")));
                op.setTipo_ore(res.getInt("tipo_ore"));
                op.setId_anag_personale(res.getInt("id_anag_dipendenti"));
                op.setNome(res.getString("nome"));
                op.setCognome(res.getString("cognome"));
                op.setOcp(new OreCostoPersonale());
                op.getOcp().setC_orario(new Money(res.getDouble("c_orario")));
                op.getOcp().setC_ci(new Money(res.getDouble("c_ci")));
                op.getOcp().setC_ore_extra(new Money(res.getDouble("c_ore_extra")));
                op.getOcp().setC_trasferta(new Money(res.getDouble("c_trasferta")));
                op.getOcp().setC_trasferta_extra(new Money(res.getDouble("c_trasferta_extra")));
                Money costo = new Money(BigDecimal.ZERO);
                switch (op.getTipo_ore()) {
                    case 0: {
                        costo = op.getOcp().getC_orario();
                        break;
                    }
                    case 1: {
                        costo = op.getOcp().getC_trasferta();
                        break;
                    }
                    case 2: {
                        costo = op.getOcp().getC_ore_extra();
                        break;
                    }
                    case 3: {
                        costo = op.getOcp().getC_trasferta_extra();
                        break;
                    }
                    case 4: {
                        costo = op.getOcp().getC_ci();
                        break;
                    }
                    default: {
                        costo = new Money(BigDecimal.ZERO);
                    }
                }
                this.tot_costi.plusplus(costo.multiply(op.getNumero_ore()));
                this.vettoreOrePersonale.add(op);
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        }
        catch (Exception e) {
            this.vettoreOrePersonale = new ArrayList();
            MyTrace.log.severe("Seleziona OrePersonale non riuscito");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.2", null);
        }
        return this.vettoreOrePersonale.size();
    }
}

