/*
 * Decompiled with CFR 0.152.
 */
package gestionale.ore_impiego_mezzi;

import gestionale.configurazioni.Configurazioni;
import gestionale.ore_costo_mezzi.OreCostoMezzi;
import gestionale.ore_impiego_mezzi.OreMezzi;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import utils.Funzioni;
import utils.Money;
import utils.MyTrace;
import utils.Quantita;

public class InsiemeOreMezzi {
    public ArrayList<OreMezzi> vettoreOreMezzi;
    int colCount;
    public String[] headers;
    Money tot_costi = new Money(BigDecimal.ZERO);

    public InsiemeOreMezzi() {
        this.vettoreOreMezzi = new ArrayList();
    }

    public Money getTot_costi() {
        return this.tot_costi;
    }

    public void setTot_costi(Money tot_costi) {
        this.tot_costi = tot_costi;
    }

    public int caricamento(String where, String order_by) {
        String query = "SELECT ore_impiego_mezzi.*, mtra_mezzi.*  FROM ore_impiego_mezzi  LEFT JOIN mtra_mezzi ON ore_impiego_mezzi.id_anag_mezzi=mtra_mezzi.id_macchina ";
        query = query + " " + where;
        query = query + " " + order_by;
        this.vettoreOreMezzi = new ArrayList();
        try {
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
            while (res.next()) {
                OreMezzi op = new OreMezzi();
                op.setId(res.getInt("idOre_impiego_mezzi"));
                op.setId_commessa(res.getInt("id_commessa"));
                op.setData(res.getString("data"));
                op.setNumero_ore(new Quantita(res.getDouble("numero_ore")));
                op.setId_anag_mezzi(res.getInt("id_anag_mezzi"));
                op.setDenominazione(res.getString("descrizione"));
                op.setTarga(res.getString("targa"));
                this.vettoreOreMezzi.add(op);
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        }
        catch (Exception e) {
            this.vettoreOreMezzi = new ArrayList();
            MyTrace.log.severe("Seleziona OreMezzi non riuscito");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.2", null);
        }
        return this.vettoreOreMezzi.size();
    }

    public int caricamentoConCosti(String where, String order_by) {
        this.tot_costi = new Money(BigDecimal.ZERO);
        String query = "SELECT ore_impiego_mezzi.*, mtra_mezzi.descrizione,  mtra_mezzi.targa,  commesse.descrizione_breve,commesse.numero_commessa,commesse.anno,  ore_costo_mezzi.*  FROM ore_impiego_mezzi  LEFT JOIN mtra_mezzi ON ore_impiego_mezzi.id_anag_mezzi=mtra_mezzi.id_macchina  LEFT JOIN commesse ON ore_impiego_mezzi.id_commessa=commesse.idCommessa   LEFT JOIN ore_costo_mezzi ON (ore_costo_mezzi.id_mezzo=mtra_mezzi.id_macchina  AND ore_impiego_mezzi.data between ore_costo_mezzi.data_da and ore_costo_mezzi.data_a) ";
        query = query + " " + where;
        query = query + " " + order_by;
        this.vettoreOreMezzi = new ArrayList();
        try {
            ResultSet res = Configurazioni.getIstanza().connessione.eseguiQuery(query);
            while (res.next()) {
                OreMezzi op = new OreMezzi();
                op.setId(res.getInt("idOre_impiego_mezzi"));
                op.setId_commessa(res.getInt("id_commessa"));
                op.setDesc_commessa(res.getString("descrizione_breve"));
                op.setString_num_commessa(res.getInt("numero_commessa") + "/" + res.getInt("anno"));
                op.setData(res.getString("data"));
                op.setNumero_ore(new Quantita(res.getDouble("numero_ore")));
                op.setId_anag_mezzi(res.getInt("id_mezzo"));
                op.setDesc_mezzo(res.getString("descrizione"));
                op.setTarga(res.getString("targa"));
                op.setOcm(new OreCostoMezzi());
                op.getOcm().setC_orario(new Money(res.getDouble("c_orario")));
                Money costo = new Money(BigDecimal.ZERO);
                costo = op.getOcm().getC_orario();
                this.tot_costi.plusplus(costo.multiply(op.getNumero_ore()));
                this.vettoreOreMezzi.add(op);
            }
            Configurazioni.getIstanza().connessione.ChiudiResultSet(res);
        }
        catch (Exception e) {
            this.vettoreOreMezzi = new ArrayList();
            MyTrace.log.severe("Seleziona OrePersonale non riuscito");
            Funzioni.inviaBugPerEmail(e);
            Funzioni.LogStackTrace(e);
            Configurazioni.eccezione.gestisci("4.2", null);
        }
        return this.vettoreOreMezzi.size();
    }
}

