/*
 * Decompiled with CFR 0.152.
 */
package gestionale.login;

import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import gestionale.Main;
import gestionale.MyDesktopWindow;
import gestionale.configurazioni.ConfigurazioneIni;
import gestionale.configurazioni.Configurazioni;
import gestionale.configurazioni.Eccezioni;
import gestionale.configurazioni.ProfiloUtente;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import utils.AvvioSuThread;
import utils.Funzioni;
import utils.FunzioniDiritti;
import utils.GestioneLicenze;
import utils.InviaEmail;
import utils.MyTrace;
import utils.SysSessioneUtente;

public class MyLogin
extends JFrame {
    Configurazioni config;
    Eccezioni eccezione = new Eccezioni();
    JFrame f_chiamante;
    SysSessioneUtente HB;
    public Main main = null;
    private final Funzioni funz;
    private JButton jButtonAnnulla;
    private JButton jButtonLogin;
    private JLabel jLabelLogin;
    private JLabel jLabelP;
    private JLabel jLabelUIN;
    private JPasswordField jPassword;
    private JTextField jTextUsername;

    public MyLogin(JFrame c) {
        MyTrace.log.info("START FINESTRA LOGIN");
        this.funz = new Funzioni();
        this.f_chiamante = c;
        this.config = Configurazioni.getIstanza();
        if (this.config == null) {
            MyTrace.log.severe("ERRORE:  config nullo!!");
            this.config.main.uscita();
        }
        this.config.fd = new FunzioniDiritti();
        this.initComponents();
        this.getRootPane().setDefaultButton(this.jButtonLogin);
        try {
            UIManager.setLookAndFeel((LookAndFeel)new Plastic3DLookAndFeel());
        }
        catch (Exception err) {
            MyTrace.log.severe("MyLogin() errore di configurazione del look and feel");
            Funzioni.inviaBugPerEmail(err);
            Funzioni.LogStackTrace(err);
            err.printStackTrace();
        }
        try {
            this.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("icons/icona_24x20.png")).getImage());
        }
        catch (Exception err) {
            MyTrace.log.severe("ERRORE: non trovo l'icona \n" + err.toString());
        }
        this.HB = new SysSessioneUtente();
        MyTrace.log.info("FINESTRA LOGIN ISTANZIATA");
    }

    @Override
    public void setVisible(boolean bol) {
        super.setVisible(bol);
    }

    private void initComponents() {
        this.jLabelLogin = new JLabel();
        this.jLabelUIN = new JLabel();
        this.jTextUsername = new JTextField();
        this.jLabelP = new JLabel();
        this.jPassword = new JPasswordField();
        this.jButtonAnnulla = new JButton();
        this.jButtonLogin = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("Login");
        this.setMinimumSize(new Dimension(350, 300));
        this.setResizable(false);
        this.setUndecorated(true);
        this.getContentPane().setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabelLogin.setFont(new Font("Verdana", 1, 14));
        this.jLabelLogin.setForeground(new Color(0, 0, 102));
        this.jLabelLogin.setText("Accesso al sistema");
        this.getContentPane().add((Component)this.jLabelLogin, new AbsoluteConstraints(120, 10, 160, 40));
        this.jLabelUIN.setFont(new Font("Verdana", 1, 12));
        this.jLabelUIN.setForeground(new Color(0, 0, 102));
        this.jLabelUIN.setText("Username");
        this.getContentPane().add((Component)this.jLabelUIN, new AbsoluteConstraints(22, 105, -1, -1));
        this.jTextUsername.setFont(new Font("Verdana", 0, 18));
        this.jTextUsername.setPreferredSize(new Dimension(200, 30));
        this.getContentPane().add((Component)this.jTextUsername, new AbsoluteConstraints(100, 100, -1, -1));
        this.jLabelP.setFont(new Font("Verdana", 1, 12));
        this.jLabelP.setForeground(new Color(0, 0, 102));
        this.jLabelP.setText("Password");
        this.getContentPane().add((Component)this.jLabelP, new AbsoluteConstraints(24, 146, -1, -1));
        this.jPassword.setFont(new Font("Verdana", 0, 18));
        this.jPassword.setPreferredSize(new Dimension(200, 30));
        this.getContentPane().add((Component)this.jPassword, new AbsoluteConstraints(100, 140, -1, -1));
        this.jButtonAnnulla.setFont(new Font("Verdana", 3, 11));
        this.jButtonAnnulla.setForeground(new Color(0, 0, 102));
        this.jButtonAnnulla.setText("Annulla");
        this.jButtonAnnulla.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyLogin.this.jButtonAnnullaActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.jButtonAnnulla, new AbsoluteConstraints(300, 260, 80, -1));
        this.jButtonLogin.setFont(new Font("Verdana", 3, 11));
        this.jButtonLogin.setForeground(new Color(0, 0, 102));
        this.jButtonLogin.setText("Accedi");
        this.jButtonLogin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MyLogin.this.jButtonLoginActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.jButtonLogin, new AbsoluteConstraints(100, 190, 200, 30));
        this.pack();
    }

    private void jButtonAnnullaActionPerformed(ActionEvent evt) {
        MyTrace.log.info("LOGIN: !!!!!!!!!!!!! Richiesta Uscita dall'applicazione !!!!!!!!!!!!!!!!!!");
        this.config.fd.CopiaPermessiDalDatabase(null);
        this.main.uscita();
        Runtime.getRuntime().runFinalization();
        MyTrace.log.info("LOGIN: !!!!!!!!!!!!! FINE APPLICAZIONE !!!!!!!!!!!!!!!!!!");
    }

    private void jButtonLoginActionPerformed(ActionEvent evt) {
        try {
            MyTrace.log.fine("#################    LOGIN CLICCATO OK    ##################");
            Thread.currentThread().setName("<<THREAD::PRINCIPALE_GESTIONE_EVENTI>>");
            String username = "";
            String password = String.valueOf(this.jPassword.getPassword());
            Configurazioni.operatore = username = this.jTextUsername.getText();
            boolean login_ok = false;
            if (username.equals("") || password.equals("")) {
                MyDesktopWindow.statusBar.setMessage("INSERIRE CREDENZIALI APPROPRIATE");
            } else {
                MyDesktopWindow.statusBar.setMessage("Registrazione utente in corso!");
                ProfiloUtente profilo = new ProfiloUtente(username, password.toString());
                MyTrace.log.fine("LOGIN (fase 3)profilo utente caricato");
                if (profilo.controllaCredenzialiSeOK()) {
                    MyDesktopWindow.statusBar.setMessage("Username e password corretti");
                    MyTrace.log.info("Username e Password corretti (nel DB MASTER)");
                    try {
                        long ret = this.HB.startsessione(username);
                        if (ret == 0L) {
                            MyTrace.log.severe("LOGIN:  IMPOSSIBILE CONNETTERSI SESSIONE UTENTE GIA' PRESENTE");
                            MyTrace.log.severe("LOGIN:  " + this.HB.messaggio);
                            JOptionPane.showMessageDialog(this, this.HB.messaggio);
                            MyDesktopWindow.statusBar.setMessage("IMPOSSIBILE CONNETTERSI SESSIONE UTENTE GIA' PRESENTE");
                            if (new String(ConfigurazioneIni.hm.get("login.controllo_unicita")).compareTo("1") == 0) {
                                MyTrace.log.severe("LOGIN: USCITA");
                                return;
                            }
                        } else {
                            MyTrace.log.info("LOGIN:  CONNESSO con id sessione=" + ret);
                        }
                    }
                    catch (Exception e) {
                        MyTrace.log.severe("LOGIN: ECCEZIONE sul controllo unicit\u00e0 della sessione :" + e.toString());
                        Funzioni.inviaBugPerEmail(e);
                        Funzioni.LogStackTrace(e);
                    }
                    boolean result = profilo.carica_diritti_del_gruppo_utente_dal_database();
                    if (result) {
                        MyTrace.log.info("### PROFILO UTENTE " + profilo.toString() + ": Assegnazione diritti UTENTE terminata correttamente");
                        this.config.fd.CopiaPermessiDalDatabase(profilo);
                    } else {
                        MyTrace.log.info("ERRORE: Problema di Assegnazione diritti UTENTE dal Database Azienda");
                        JOptionPane.showMessageDialog(this, "PROBLEMA DI CARICAMENTO DEI DIRITTI DAL DATABASE");
                    }
                    profilo.setHB(this.HB);
                    ((MyDesktopWindow)this.f_chiamante).setProfilo(profilo);
                    ((MyDesktopWindow)this.f_chiamante).riempi_campi();
                    this.setVisible(false);
                    this.setAlwaysOnTop(true);
                    this.f_chiamante.setVisible(true);
                    this.f_chiamante.setEnabled(true);
                    ((MyDesktopWindow)this.f_chiamante).repaint();
                    MyTrace.log.info("MyLogin Concluso tutto OK");
                    MyDesktopWindow.statusBar.setMessage("*- Connesso al DATABASE '" + Configurazioni.getIstanza().connessione.nomeDB + "' CONNESSO con Utente '" + Configurazioni.operatore + "'   Azienda '" + Configurazioni.nome_azienda + "'");
                    if (Configurazioni.modalit\u00e0ConsultazioneAttiva) {
                        MyDesktopWindow.statusBar.setMessage("MODALITA' CONSULTAZIONE ! (licenza scaduta il " + this.funz.formatta_Calendar_in_data_SQL(Configurazioni.datascadenza) + ")  ");
                    } else {
                        long residuo = GestioneLicenze.verifica_giorni_rimanenti();
                        if (residuo < 10L) {
                            MyDesktopWindow.statusBar.setMessage("LA LICENZA STA PER SCADERE! (Olimpo dal " + this.funz.formatta_Calendar_in_data_SQL(Configurazioni.datascadenza) + " sar\u00e0 in modalit\u00e0 consultazione) ");
                        }
                    }
                    login_ok = true;
                } else {
                    MyDesktopWindow.statusBar.setMessage("LE CREDENZIALI FORNITE NON SONO VALIDE!");
                    MyTrace.log.fine("LOGIN FALLITO: Fornite credenziali non valide");
                }
            }
            MyTrace.log.fine("LOGIN (fase 6) uscita");
            if (!login_ok) {
                AvvioSuThread invianotifica = new AvvioSuThread(this, "invaEmailDiNotificaFallimento");
            }
        }
        catch (Exception ex) {
            MyTrace.log.severe("ERRORE:  eccezione non precisata nel login dopo la pressione del tasto");
            ex.printStackTrace();
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
        catch (Error err) {
            MyTrace.log.severe("ERRORE: nel login dopo la pressione del tasto si verifica un errore di avvio o di linkaggio non precisato");
            err.printStackTrace();
        }
    }

    public void invaEmailDiNotifica() {
        String invio_per_email_abilitato = Configurazioni.hm.get("debug.invia_email");
        if (invio_per_email_abilitato.matches("true")) {
            MyDesktopWindow cfr_ignored_0 = (MyDesktopWindow)this.f_chiamante;
            MyDesktopWindow cfr_ignored_1 = (MyDesktopWindow)this.f_chiamante;
            String utente = MyDesktopWindow.profilo.nome + " " + MyDesktopWindow.profilo.cognome;
            String azienda = Configurazioni.nome_azienda;
            InviaEmail email = new InviaEmail();
            email.nuovaEmail("info@kronositalia.com", "info@kronositalia.com", "OLIMPO: LOGIN EFFETTUATO DA " + azienda, "\nAzienda:" + azienda + "\nLOGIN effettuato da " + utente);
            email.send();
        }
    }

    public void invaEmailDiNotificaFallimento() {
        String invio_per_email_abilitato = Configurazioni.hm.get("debug.invia_email");
        if (invio_per_email_abilitato.matches("true")) {
            MyDesktopWindow cfr_ignored_0 = (MyDesktopWindow)this.f_chiamante;
            MyDesktopWindow cfr_ignored_1 = (MyDesktopWindow)this.f_chiamante;
            String utente = MyDesktopWindow.profilo.nome + " " + MyDesktopWindow.profilo.cognome;
            String azienda = Configurazioni.nome_azienda;
            InviaEmail email = new InviaEmail();
            email.nuovaEmail("info@kronositalia.com", "info@kronositalia.com", "OLIMPO: LOGIN NON EFFETTUATO DA " + azienda, "\nAzienda:" + azienda + "\nLOGIN tentato da " + utente);
            email.send();
        }
    }

    public void logout() {
        this.HB.stopsessione();
        try {
            this.config.fd.join();
        }
        catch (InterruptedException ex) {
            MyTrace.log.info("ERRORE: in uscita durante l'attesa del join FunzioniDiritti");
            Funzioni.inviaBugPerEmail(ex);
            Funzioni.LogStackTrace(ex);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

